/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.memory.LinearAddressSpace;
import org.jpc.emulator.memory.PhysicalAddressSpace;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.processor.Processor;

public class GateA20Handler
implements IOPortCapable,
HardwareComponent {
    private Processor cpu = null;
    private PhysicalAddressSpace physicalAddressSpace = null;
    private LinearAddressSpace linearAddressSpace;
    private boolean ioportRegistered = false;

    private void setGateA20State(boolean bl) {
        this.physicalAddressSpace.setGateA20State(bl);
    }

    public void ioPortWriteByte(int n, int n2) {
        this.setGateA20State((n2 & 2) != 0);
        if ((n2 & 1) != 0) {
            this.cpu.reset();
        }
    }

    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2);
    }

    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2);
    }

    public int ioPortReadByte(int n) {
        return this.physicalAddressSpace.getGateA20State() ? 2 : 0;
    }

    public int ioPortReadWord(int n) {
        return this.ioPortReadByte(n) | 0xFF00;
    }

    public int ioPortReadLong(int n) {
        return this.ioPortReadWord(n) | 0xFFFF0000;
    }

    public int[] ioPortsRequested() {
        return new int[]{146};
    }

    public boolean initialised() {
        return this.ioportRegistered && this.cpu != null && this.physicalAddressSpace != null && this.linearAddressSpace != null;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
        if (hardwareComponent instanceof PhysicalAddressSpace) {
            this.physicalAddressSpace = (PhysicalAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof LinearAddressSpace) {
            this.linearAddressSpace = (LinearAddressSpace)hardwareComponent;
        }
        if (hardwareComponent instanceof Processor && hardwareComponent.initialised()) {
            this.cpu = (Processor)hardwareComponent;
        }
    }

    public void reset() {
        this.ioportRegistered = false;
        this.physicalAddressSpace = null;
        this.linearAddressSpace = null;
        this.cpu = null;
    }
}

