/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.motherboard;

import java.util.Calendar;
import java.util.Date;
import org.jpc.emulator.AbstractHardwareComponent;
import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.Timer;
import org.jpc.emulator.TimerResponsive;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;
import org.jpc.emulator.peripheral.FloppyController;
import org.jpc.support.BlockDevice;
import org.jpc.support.Clock;
import org.jpc.support.DriveSet;

public class RTC
extends AbstractHardwareComponent
implements IOPortCapable {
    private static final int RTC_SECONDS = 0;
    private static final int RTC_SECONDS_ALARM = 1;
    private static final int RTC_MINUTES = 2;
    private static final int RTC_MINUTES_ALARM = 3;
    private static final int RTC_HOURS = 4;
    private static final int RTC_HOURS_ALARM = 5;
    private static final int RTC_ALARM_DONT_CARE = 192;
    private static final int RTC_DAY_OF_WEEK = 6;
    private static final int RTC_DAY_OF_MONTH = 7;
    private static final int RTC_MONTH = 8;
    private static final int RTC_YEAR = 9;
    private static final int RTC_REG_EQUIPMENT_BYTE = 20;
    private static final int RTC_REG_IBM_CENTURY_BYTE = 50;
    private static final int RTC_REG_IBM_PS2_CENTURY_BYTE = 55;
    private static final int RTC_REG_A = 10;
    private static final int RTC_REG_B = 11;
    private static final int RTC_REG_C = 12;
    private static final int RTC_REG_D = 13;
    private static final int REG_A_UIP = 128;
    private static final int REG_B_SET = 128;
    private static final int REG_B_PIE = 64;
    private static final int REG_B_AIE = 32;
    private static final int REG_B_UIE = 16;
    private byte[] cmosData;
    private byte cmosIndex;
    private int irq;
    private Calendar currentTime;
    private Date currentDate;
    private Timer periodicTimer;
    private long nextPeriodicTime;
    private Timer secondTimer;
    private Timer delayedSecondTimer;
    private long nextSecondTime;
    private PeriodicCallback periodicCallback;
    private SecondCallback secondCallback;
    private DelayedSecondCallback delayedSecondCallback;
    private InterruptController irqDevice;
    private Clock timeSource;
    private int ioPortBase;
    private int bootType = -1;
    private boolean ioportRegistered = false;
    private boolean drivesInited = false;
    private boolean floppiesInited = false;

    public RTC(int n, int n2) {
        this.ioPortBase = n;
        this.irq = n2;
        this.cmosData = new byte[128];
        this.cmosData[10] = 38;
        this.cmosData[11] = 2;
        this.cmosData[12] = 0;
        this.cmosData[13] = -128;
        this.periodicCallback = new PeriodicCallback();
        this.secondCallback = new SecondCallback();
        this.delayedSecondCallback = new DelayedSecondCallback();
    }

    static final long scale64(long l, int n, int n2) {
        long l2 = (0xFFFFFFFFL & l) * (long)n;
        long l3 = (l >>> 32) * (long)n;
        long l4 = 0xFFFFFFFFL & (l3 += l2 >> 32) / (long)n2;
        long l5 = 0xFFFFFFFFL & ((l3 % (long)n2 << 32) + (l2 & 0xFFFFFFFFL)) / (long)n2;
        return l4 << 32 | l5;
    }

    public void init() {
        Calendar calendar = Calendar.getInstance();
        this.setTime(calendar);
        int n = this.toBCD(calendar.get(1) / 100);
        this.cmosData[50] = (byte)n;
        this.cmosData[55] = (byte)n;
        n = 640;
        this.cmosData[21] = (byte)n;
        this.cmosData[22] = (byte)(n >>> 8);
        int n2 = 0x400000;
        n = n2 / 1024 - 1024;
        if (n > 65535) {
            n = 65535;
        }
        this.cmosData[23] = (byte)n;
        this.cmosData[24] = (byte)(n >>> 8);
        this.cmosData[48] = (byte)n;
        this.cmosData[49] = (byte)(n >>> 8);
        n = n2 > 0x1000000 ? n2 / 65536 - 256 : 0;
        if (n > 65535) {
            n = 65535;
        }
        this.cmosData[52] = (byte)n;
        this.cmosData[53] = (byte)(n >>> 8);
        switch (this.bootType) {
            case 0: {
                this.cmosData[61] = 1;
                break;
            }
            default: {
                this.cmosData[61] = 2;
                break;
            }
            case 2: {
                this.cmosData[61] = 3;
            }
        }
    }

    public void cmosInitHD(DriveSet driveSet) {
        BlockDevice blockDevice = driveSet.getHardDrive(0);
        BlockDevice blockDevice2 = driveSet.getHardDrive(1);
        this.cmosData[18] = (byte)((blockDevice != null ? 240 : 0) | (blockDevice2 != null ? 15 : 0));
        if (blockDevice != null) {
            this.cmosData[25] = 47;
            this.cmosData[27] = (byte)blockDevice.cylinders();
            this.cmosData[28] = (byte)(blockDevice.cylinders() >>> 8);
            this.cmosData[29] = (byte)blockDevice.heads();
            this.cmosData[30] = -1;
            this.cmosData[31] = -1;
            this.cmosData[32] = (byte)(0xC0 | (blockDevice.heads() > 8 ? 8 : 0));
            this.cmosData[33] = (byte)blockDevice.cylinders();
            this.cmosData[34] = (byte)(blockDevice.cylinders() >>> 8);
            this.cmosData[35] = (byte)blockDevice.sectors();
        }
        if (blockDevice2 != null) {
            this.cmosData[26] = 47;
            this.cmosData[36] = (byte)blockDevice2.cylinders();
            this.cmosData[37] = (byte)(blockDevice2.cylinders() >>> 8);
            this.cmosData[38] = (byte)blockDevice2.heads();
            this.cmosData[39] = -1;
            this.cmosData[40] = -1;
            this.cmosData[41] = (byte)(0xC0 | (blockDevice2.heads() > 8 ? 8 : 0));
            this.cmosData[42] = (byte)blockDevice2.cylinders();
            this.cmosData[43] = (byte)(blockDevice2.cylinders() >>> 8);
            this.cmosData[44] = (byte)blockDevice2.sectors();
        }
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (driveSet.getHardDrive(i) == null) continue;
            int n2 = driveSet.getHardDrive(i).cylinders() <= 1024 && driveSet.getHardDrive(i).heads() <= 16 && driveSet.getHardDrive(i).sectors() <= 63 ? 0 : 1;
            n |= n2 << i * 2;
        }
        this.cmosData[57] = (byte)n;
    }

    public void cmosInitFloppy(FloppyController floppyController) {
        int n = this.cmosGetFDType(floppyController, 0) << 4 | this.cmosGetFDType(floppyController, 1);
        this.cmosData[16] = (byte)n;
        int n2 = 0;
        n = 0;
        if (floppyController.getDriveType(0) < 3) {
            ++n2;
        }
        if (floppyController.getDriveType(1) < 3) {
            ++n2;
        }
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                n |= 1;
                break;
            }
            case 2: {
                n |= 0x41;
            }
        }
        n |= 2;
        this.cmosData[20] = (byte)(n |= 4);
    }

    private int cmosGetFDType(FloppyController floppyController, int n) {
        switch (floppyController.getDriveType(n)) {
            case 0: {
                return 4;
            }
            case 1: {
                return 5;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public int[] ioPortsRequested() {
        int n = this.ioPortBase;
        return new int[]{n, n + 1};
    }

    public int ioPortReadByte(int n) {
        return 0xFF & this.cmosIOPortRead(n);
    }

    public int ioPortReadWord(int n) {
        return 0xFF & this.ioPortReadByte(n) | 0xFF00 & this.ioPortReadByte(n + 1) << 8;
    }

    public int ioPortReadLong(int n) {
        return 0xFFFF & this.ioPortReadWord(n) | 0xFFFF0000 & this.ioPortReadWord(n + 2) << 16;
    }

    public void ioPortWriteByte(int n, int n2) {
        this.cmosIOPortWrite(n, 0xFF & n2);
    }

    public void ioPortWriteWord(int n, int n2) {
        this.ioPortWriteByte(n, n2);
        this.ioPortWriteByte(n + 1, n2 >> 8);
    }

    public void ioPortWriteLong(int n, int n2) {
        this.ioPortWriteWord(n, n2);
        this.ioPortWriteWord(n + 2, n2 >> 16);
    }

    private void periodicUpdate() {
        this.timerUpdate(this.nextPeriodicTime);
        this.cmosData[12] = (byte)(this.cmosData[12] | 0xC0);
        this.irqDevice.setIRQ(this.irq, 1);
    }

    private void secondUpdate() {
        if ((this.cmosData[10] & 0x70) != 32) {
            this.nextSecondTime += this.timeSource.getTickRate();
            this.secondTimer.setExpiry(this.nextSecondTime);
        } else {
            long l;
            this.nextSecond();
            if (0 == (this.cmosData[11] & 0x80)) {
                this.cmosData[10] = (byte)(this.cmosData[10] | 0x80);
            }
            if ((l = this.timeSource.getTickRate() * 1L / 100L) < 1L) {
                l = 1L;
            }
            this.delayedSecondTimer.setExpiry(this.nextSecondTime + l);
        }
    }

    private void delayedSecondUpdate() {
        if (0 == (this.cmosData[11] & 0x80)) {
            this.timeToMemory();
        }
        if (!(0 == (this.cmosData[11] & 0x20) || (this.cmosData[1] & 0xC0) != 192 && this.cmosData[1] != this.currentTime.get(13) || (this.cmosData[3] & 0xC0) != 192 && this.cmosData[3] != this.currentTime.get(12) || (this.cmosData[5] & 0xC0) != 192 && this.cmosData[5] != this.currentTime.get(11))) {
            this.cmosData[12] = (byte)(this.cmosData[12] | 0xA0);
            this.irqDevice.setIRQ(this.irq, 1);
        }
        if (0 != (this.cmosData[11] & 0x10)) {
            this.cmosData[12] = (byte)(this.cmosData[12] | 0x90);
            this.irqDevice.setIRQ(this.irq, 1);
        }
        this.cmosData[10] = (byte)(this.cmosData[10] & 0xFFFFFF7F);
        this.nextSecondTime += this.timeSource.getTickRate();
        this.secondTimer.setExpiry(this.nextSecondTime);
    }

    private void timerUpdate(long l) {
        int n = this.cmosData[10] & 0xF;
        if (n != 0 && 0 != (this.cmosData[11] & 0x40)) {
            if (n <= 2) {
                n += 7;
            }
            int n2 = 1 << n - 1;
            long l2 = RTC.scale64(l, 32768, (int)this.timeSource.getTickRate());
            long l3 = (l2 & (long)(~(n2 - 1))) + (long)n2;
            this.nextPeriodicTime = RTC.scale64(l3, (int)this.timeSource.getTickRate(), 32768) + 1L;
            this.periodicTimer.setExpiry(this.nextPeriodicTime);
        } else {
            this.periodicTimer.setStatus(false);
        }
    }

    private void nextSecond() {
        this.currentDate.setTime(this.currentDate.getTime() + 1000L);
        this.currentTime.setTime(this.currentDate);
    }

    private void cmosIOPortWrite(int n, int n2) {
        if ((n & 1) == 0) {
            this.cmosIndex = (byte)(n2 & 0x7F);
        } else {
            switch (this.cmosIndex) {
                case 1: 
                case 3: 
                case 5: {
                    this.cmosData[this.cmosIndex] = (byte)n2;
                    break;
                }
                case 0: 
                case 2: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    this.cmosData[this.cmosIndex] = (byte)n2;
                    if (0 != (this.cmosData[11] & 0x80)) break;
                    this.memoryToTime();
                    break;
                }
                case 10: {
                    this.cmosData[10] = (byte)(n2 & 0xFFFFFF7F | this.cmosData[10] & 0x80);
                    this.timerUpdate(this.timeSource.getTime());
                    break;
                }
                case 11: {
                    if (0 != (n2 & 0x80)) {
                        this.cmosData[10] = (byte)(this.cmosData[10] & 0xFFFFFF7F);
                        n2 &= 0xFFFFFFEF;
                    } else if (0 != (this.cmosData[11] & 0x80)) {
                        this.memoryToTime();
                    }
                    this.cmosData[11] = (byte)n2;
                    this.timerUpdate(this.timeSource.getTime());
                    break;
                }
                case 12: 
                case 13: {
                    break;
                }
                default: {
                    this.cmosData[this.cmosIndex] = (byte)n2;
                }
            }
        }
    }

    private int cmosIOPortRead(int n) {
        if ((n & 1) == 0) {
            return 255;
        }
        switch (this.cmosIndex) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return this.cmosData[this.cmosIndex];
            }
            case 10: {
                return this.cmosData[this.cmosIndex];
            }
            case 12: {
                byte by = this.cmosData[this.cmosIndex];
                this.irqDevice.setIRQ(this.irq, 0);
                this.cmosData[12] = 0;
                return by;
            }
        }
        return this.cmosData[this.cmosIndex];
    }

    private void setTime(Calendar calendar) {
        this.currentTime = Calendar.getInstance(calendar.getTimeZone());
        this.currentDate = calendar.getTime();
        this.currentTime.setTime(this.currentDate);
        this.timeToMemory();
    }

    private void memoryToTime() {
        this.currentTime.set(13, this.fromBCD(this.cmosData[0]));
        this.currentTime.set(12, this.fromBCD(this.cmosData[2]));
        this.currentTime.set(11, this.fromBCD(this.cmosData[4] & 0x7F));
        if (0 == (this.cmosData[11] & 2) && 0 != (this.cmosData[4] & 0x80)) {
            this.currentDate.setTime(this.currentDate.getTime() + 43200L);
            this.currentTime.setTime(this.currentDate);
        }
        this.currentTime.set(7, this.fromBCD(this.cmosData[6]));
        this.currentTime.set(5, this.fromBCD(this.cmosData[7]));
        this.currentTime.set(2, this.fromBCD(this.cmosData[8]) - 1);
        this.currentTime.set(1, this.fromBCD(this.cmosData[9]) + 2000);
    }

    private void timeToMemory() {
        this.cmosData[0] = (byte)this.toBCD(this.currentTime.get(13));
        this.cmosData[2] = (byte)this.toBCD(this.currentTime.get(12));
        if (0 != (this.cmosData[11] & 2)) {
            this.cmosData[4] = (byte)this.toBCD(this.currentTime.get(11));
        } else {
            this.cmosData[4] = (byte)this.toBCD(this.currentTime.get(10));
            if (this.currentTime.get(9) == 1) {
                this.cmosData[4] = (byte)(this.cmosData[4] | 0x80);
            }
        }
        this.cmosData[6] = (byte)this.toBCD(this.currentTime.get(7));
        this.cmosData[7] = (byte)this.toBCD(this.currentTime.get(5));
        this.cmosData[8] = (byte)this.toBCD(this.currentTime.get(2) + 1);
        this.cmosData[9] = (byte)this.toBCD(this.currentTime.get(1) % 100);
    }

    private int toBCD(int n) {
        if (0 != (this.cmosData[11] & 4)) {
            return n;
        }
        return n / 10 << 4 | n % 10;
    }

    private int fromBCD(int n) {
        if (0 != (this.cmosData[11] & 4)) {
            return n;
        }
        return (n >> 4) * 10 + (n & 0xF);
    }

    public boolean initialised() {
        return this.irqDevice != null && this.timeSource != null && this.ioportRegistered && this.drivesInited && this.floppiesInited && this.bootType >= 0;
    }

    public void reset() {
        this.irqDevice = null;
        this.timeSource = null;
        this.ioportRegistered = false;
        this.drivesInited = false;
        this.floppiesInited = false;
        this.bootType = -1;
        this.cmosData = new byte[128];
        this.cmosData[10] = 38;
        this.cmosData[11] = 2;
        this.cmosData[12] = 0;
        this.cmosData[13] = -128;
        this.periodicCallback = new PeriodicCallback();
        this.secondCallback = new SecondCallback();
        this.delayedSecondCallback = new DelayedSecondCallback();
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqDevice = (InterruptController)hardwareComponent;
        }
        if (hardwareComponent instanceof Clock && hardwareComponent.initialised()) {
            this.timeSource = (Clock)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
        if (hardwareComponent instanceof DriveSet && hardwareComponent.initialised()) {
            this.cmosInitHD((DriveSet)hardwareComponent);
            this.drivesInited = true;
        }
        if (hardwareComponent instanceof FloppyController && hardwareComponent.initialised()) {
            this.cmosInitFloppy((FloppyController)hardwareComponent);
            this.floppiesInited = true;
        }
        if (hardwareComponent instanceof DriveSet) {
            this.bootType = ((DriveSet)hardwareComponent).getBootType();
        }
        if (this.initialised()) {
            this.init();
            this.periodicTimer = this.timeSource.newTimer(this.periodicCallback);
            this.secondTimer = this.timeSource.newTimer(this.secondCallback);
            this.delayedSecondTimer = this.timeSource.newTimer(this.delayedSecondCallback);
            this.nextSecondTime = this.timeSource.getTime() + 99L * this.timeSource.getTickRate() / 100L;
            this.delayedSecondTimer.setExpiry(this.nextSecondTime);
        }
    }

    public String toString() {
        return "MC146818 RealTime Clock";
    }

    private class DelayedSecondCallback
    implements TimerResponsive {
        private DelayedSecondCallback() {
        }

        public void timerCallback() {
            RTC.this.delayedSecondUpdate();
        }
    }

    private class SecondCallback
    implements TimerResponsive {
        private SecondCallback() {
        }

        public void timerCallback() {
            RTC.this.secondUpdate();
        }
    }

    private class PeriodicCallback
    implements TimerResponsive {
        private PeriodicCallback() {
        }

        public void timerCallback() {
            RTC.this.periodicUpdate();
        }
    }
}

