/*
 * Decompiled with CFR 0.152.
 */
package org.jpc.emulator.peripheral;

import org.jpc.emulator.HardwareComponent;
import org.jpc.emulator.motherboard.IOPortCapable;
import org.jpc.emulator.motherboard.IOPortHandler;
import org.jpc.emulator.motherboard.InterruptController;

public class SerialPort
implements IOPortCapable,
HardwareComponent {
    private static final byte UART_LCR_DLAB = -128;
    private static final byte UART_IER_MSI = 8;
    private static final byte UART_IER_RLSI = 4;
    private static final byte UART_IER_THRI = 2;
    private static final byte UART_IER_RDI = 1;
    private static final byte UART_IIR_NO_INT = 1;
    private static final byte UART_IIR_ID = 6;
    private static final byte UART_IIR_MSI = 0;
    private static final byte UART_IIR_THRI = 2;
    private static final byte UART_IIR_RDI = 4;
    private static final byte UART_IIR_RLSI = 6;
    private static final byte UART_MCR_LOOP = 16;
    private static final byte UART_MCR_OUT2 = 8;
    private static final byte UART_MCR_OUT1 = 4;
    private static final byte UART_MCR_RTS = 2;
    private static final byte UART_MCR_DTR = 1;
    private static final byte UART_MSR_DCD = -128;
    private static final byte UART_MSR_RI = 64;
    private static final byte UART_MSR_DSR = 32;
    private static final byte UART_MSR_CTS = 16;
    private static final byte UART_MSR_DDCD = 8;
    private static final byte UART_MSR_TERI = 4;
    private static final byte UART_MSR_DDSR = 2;
    private static final byte UART_MSR_DCTS = 1;
    private static final byte UART_MSR_ANY_DELTA = 15;
    private static final byte UART_LSR_TEMT = 64;
    private static final byte UART_LSR_THRE = 32;
    private static final byte UART_LSR_BI = 16;
    private static final byte UART_LSR_FE = 8;
    private static final byte UART_LSR_PE = 4;
    private static final byte UART_LSR_OE = 2;
    private static final byte UART_LSR_DR = 1;
    private static final int[] ioPorts = new int[]{1016, 760, 1000, 744};
    private static final int[] irqLines = new int[]{4, 3, 4, 3};
    private short divider;
    private byte rbr;
    private byte ier;
    private byte iir;
    private byte lcr;
    private byte mcr;
    private byte lsr;
    private byte msr;
    private byte scr;
    private boolean thrIPending;
    private int irq;
    private int baseAddress;
    private InterruptController irqDevice;
    private boolean ioportRegistered = false;

    public SerialPort(int n) {
        if (n > 3 || n < 0) {
            System.err.println(n + " is a stupid number, assuming 0");
            n = 0;
        }
        this.irq = irqLines[n];
        this.baseAddress = ioPorts[n];
        this.lsr = (byte)96;
        this.iir = 1;
    }

    public int canReceive() {
        if (0 == (this.getLSR() & 1)) {
            return 1;
        }
        return 0;
    }

    public void recieve(byte by) {
        this.setRBR(by);
        if (0 == by) {
            this.orLSR((byte)1);
        } else {
            this.orLSR((byte)17);
        }
        this.updateIRQ();
    }

    private void updateIRQ() {
        if (0 != (this.getLSR() & 1) && 0 != (this.getIER() & 1)) {
            this.setIIR((byte)4);
        } else if (this.getTHRIPending() && 0 != (this.getIER() & 2)) {
            this.setIIR((byte)2);
        } else {
            this.setIIR((byte)1);
        }
        if (this.getIIR() != 1) {
            this.irqDevice.setIRQ(this.getIRQ(), 1);
        } else {
            this.irqDevice.setIRQ(this.getIRQ(), 0);
        }
    }

    public void ioPortWriteByte(int n, int n2) {
        this.ioportWrite(n, n2);
    }

    public void ioPortWriteWord(int n, int n2) {
    }

    public void ioPortWriteLong(int n, int n2) {
    }

    public int ioPortReadByte(int n) {
        return this.ioportRead(n);
    }

    public int ioPortReadWord(int n) {
        return 65535;
    }

    public int ioPortReadLong(int n) {
        return -1;
    }

    public int[] ioPortsRequested() {
        int n = this.getAddress();
        return new int[]{n, n + 1, n + 2, n + 3, n + 4, n + 5, n + 6, n + 7};
    }

    private void ioportWrite(int n, int n2) {
        switch (n &= 7) {
            default: {
                if (0 != (this.getLCR() & 0xFFFFFF80)) {
                    this.setDivider((short)(this.getDivider() & 0xFF00 | n2));
                    break;
                }
                this.setTHRIPending(false);
                this.andLSR((byte)-33);
                this.updateIRQ();
                System.out.print((char)(0xFF & n2));
                this.setTHRIPending(true);
                this.orLSR((byte)32);
                this.orLSR((byte)64);
                this.updateIRQ();
                break;
            }
            case 1: {
                if (0 != (this.getLCR() & 0xFFFFFF80)) {
                    this.setDivider((short)(this.getDivider() & 0xFF | n2 << 8));
                    break;
                }
                this.setIER((byte)(n2 & 0xF));
                if (0 != (this.getLSR() & 0x20)) {
                    this.setTHRIPending(true);
                }
                this.updateIRQ();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setLCR((byte)n2);
                break;
            }
            case 4: {
                this.setMCR((byte)(n2 & 0x1F));
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.setMSR((byte)n2);
                break;
            }
            case 7: {
                this.setSCR((byte)n2);
            }
        }
    }

    private int ioportRead(int n) {
        switch (n &= 7) {
            default: {
                if (0 != (this.getLCR() & 0xFFFFFF80)) {
                    return this.getDivider() & 0xFF;
                }
                this.andLSR((byte)-18);
                byte by = this.getRBR();
                this.updateIRQ();
                return by;
            }
            case 1: {
                if (0 != (this.getLCR() & 0xFFFFFF80)) {
                    return this.getDivider() >> 8 & 0xFF;
                }
                return this.getIER();
            }
            case 2: {
                byte by = this.getIIR();
                if ((by & 7) == 2) {
                    this.setTHRIPending(false);
                }
                this.updateIRQ();
                return by;
            }
            case 3: {
                return this.getLCR();
            }
            case 4: {
                return this.getMCR();
            }
            case 5: {
                return this.getLSR();
            }
            case 6: {
                if (0 != (this.getMCR() & 0x10)) {
                    int n2 = (this.getMCR() & 0xC) << 4;
                    n2 |= (this.getMCR() & 2) << 3;
                    return n2 |= (this.getMCR() & 1) << 5;
                }
                return this.getMSR();
            }
            case 7: 
        }
        return this.getSCR();
    }

    private short getDivider() {
        return this.divider;
    }

    private void setDivider(short s) {
        this.divider = s;
    }

    private byte getRBR() {
        return this.rbr;
    }

    private void setRBR(byte by) {
        this.rbr = by;
    }

    private byte getIER() {
        return this.ier;
    }

    private void setIER(byte by) {
        this.ier = by;
    }

    private byte getIIR() {
        return this.iir;
    }

    private void setIIR(byte by) {
        this.iir = by;
    }

    private byte getLCR() {
        return this.lcr;
    }

    private void setLCR(byte by) {
        this.lcr = by;
    }

    private byte getMCR() {
        return this.mcr;
    }

    private void setMCR(byte by) {
        this.mcr = by;
    }

    private byte getLSR() {
        return this.lsr;
    }

    private void setLSR(byte by) {
        this.lsr = by;
    }

    private void andLSR(byte by) {
        this.setLSR((byte)(this.getLSR() & by));
    }

    private void orLSR(byte by) {
        this.setLSR((byte)(this.getLSR() | by));
    }

    private byte getMSR() {
        return this.msr;
    }

    private void setMSR(byte by) {
        this.msr = by;
    }

    private byte getSCR() {
        return this.scr;
    }

    private void setSCR(byte by) {
        this.scr = by;
    }

    private boolean getTHRIPending() {
        return this.thrIPending;
    }

    private void setTHRIPending(boolean bl) {
        this.thrIPending = bl;
    }

    private int getIRQ() {
        return this.irq;
    }

    private int getAddress() {
        return this.baseAddress;
    }

    public void reset() {
        this.irqDevice = null;
        this.ioportRegistered = false;
        this.lsr = (byte)96;
        this.iir = 1;
    }

    public boolean initialised() {
        return this.ioportRegistered && this.irqDevice != null;
    }

    public void acceptComponent(HardwareComponent hardwareComponent) {
        if (hardwareComponent instanceof InterruptController && hardwareComponent.initialised()) {
            this.irqDevice = (InterruptController)hardwareComponent;
        }
        if (hardwareComponent instanceof IOPortHandler && hardwareComponent.initialised()) {
            ((IOPortHandler)hardwareComponent).registerIOPortCapable(this);
            this.ioportRegistered = true;
        }
    }
}

