/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.InputConnection;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ImagesViewCanvas
extends Canvas
implements Runnable {
    public static final int GUI_VIEW_BG_COLOR = 0xFFFFFF;
    public static final int GUI_VIEW_TEXT_COLOR = 0;
    public static final int GUI_VIEW_ERROR_BG_COLOR = 0xFF0000;
    public static final int GUI_VIEW_ERROR_TEXT_COLOR = 0xFFFFFF;
    public static final long GUI_VIEW_DAEMON_WAIT_TIME = 128L;
    public static final Font GUI_VIEW_TEXT_FONT = Font.getFont((int)0, (int)0, (int)8);
    public static final String GUI_VIEW_STRING_WAIT = "\u0418\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435 #";
    public static final String GUI_VIEW_STRING_ERROR = "\u041e\u0448\u0438\u0431\u043a\u0430!";
    public static final String GUI_VIEW_STRING_EMPTY = "\u041d\u0435\u0442 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0439";
    private Vector imagesVector = new Vector();
    private int currentIndex = 0;
    private boolean stopRefresh = true;
    private Image prevImage;
    private Image currImage;
    private Image nextImage;
    private Runnable exitAction;

    public ImagesViewCanvas() {
        if (System.getProperty("microedition.profiles").indexOf("MIDP-1") < 0) {
            this.setFullScreenMode(true);
        }
    }

    public Vector getImagesVector() {
        return this.imagesVector;
    }

    public void setExitAction(Runnable runnable) {
        this.exitAction = runnable;
    }

    public void paint(Graphics graphics) {
        if (this.stopRefresh) {
            this.stopRefresh = false;
            new Thread(this).start();
        }
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, n, n2);
        if (this.currImage != null) {
            graphics.drawImage(this.currImage, (n - this.currImage.getWidth()) / 2, (n2 - this.currImage.getHeight()) / 2, 20);
            graphics.setColor(0);
            graphics.setFont(GUI_VIEW_TEXT_FONT);
            String string = this.currentIndex + ". " + this.currImage.getWidth() + "x" + this.currImage.getHeight();
            graphics.drawString(string, 0, 0, 20);
        } else if (this.imagesVector.size() == 0) {
            graphics.setColor(0);
            graphics.setFont(GUI_VIEW_TEXT_FONT);
            graphics.drawString(GUI_VIEW_STRING_EMPTY, (n - GUI_VIEW_TEXT_FONT.stringWidth(GUI_VIEW_STRING_EMPTY)) / 2, (n2 - GUI_VIEW_TEXT_FONT.getHeight()) / 2, 20);
        } else {
            graphics.setColor(0);
            graphics.setFont(GUI_VIEW_TEXT_FONT);
            String string = GUI_VIEW_STRING_WAIT + this.currentIndex;
            graphics.drawString(string, (n - GUI_VIEW_TEXT_FONT.stringWidth(string)) / 2, (n2 - GUI_VIEW_TEXT_FONT.getHeight()) / 2, 20);
        }
    }

    public void run() {
        while (!this.stopRefresh) {
            if (this.currentIndex < this.imagesVector.size() && this.currImage == null) {
                this.currImage = this.imagesVector.size() == 1 && this.prevImage != null ? this.prevImage : (this.imagesVector.size() == 1 && this.nextImage != null ? this.nextImage : this.loadImage(this.currentIndex));
                this.repaint();
                continue;
            }
            if (this.currentIndex < this.imagesVector.size() && this.nextImage == null) {
                if (this.imagesVector.size() == 1 && this.currImage != null) {
                    this.nextImage = this.currImage;
                    continue;
                }
                if (this.imagesVector.size() == 2 && this.prevImage != null) {
                    this.nextImage = this.prevImage;
                    continue;
                }
                this.nextImage = this.loadImage((this.currentIndex + 1) % this.imagesVector.size());
                continue;
            }
            if (this.currentIndex < this.imagesVector.size() && this.prevImage == null) {
                if (this.imagesVector.size() == 1 && this.currImage != null) {
                    this.prevImage = this.currImage;
                    continue;
                }
                if (this.imagesVector.size() == 2 & this.nextImage != null) {
                    this.prevImage = this.nextImage;
                    continue;
                }
                this.prevImage = this.loadImage((this.currentIndex + this.imagesVector.size() - 1) % this.imagesVector.size());
                continue;
            }
            try {
                Thread.sleep(128L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image loadImage(int n) {
        String string = this.imagesVector.elementAt(n).toString();
        Image image = null;
        InputConnection inputConnection = null;
        InputStream inputStream = null;
        try {
            int n2;
            inputConnection = (InputConnection)Connector.open((String)string);
            inputStream = inputConnection.openInputStream();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream = null;
            byArray = null;
            image = Image.createImage((byte[])byArray2, (int)0, (int)byArray2.length);
        }
        catch (Exception exception) {
            image = Image.createImage((int)(GUI_VIEW_TEXT_FONT.stringWidth(GUI_VIEW_STRING_ERROR) + 10), (int)(GUI_VIEW_TEXT_FONT.getHeight() + 10));
            Graphics graphics = image.getGraphics();
            graphics.setColor(0xFF0000);
            graphics.fillRect(0, 0, image.getWidth(), image.getHeight());
            graphics.setColor(0xFFFFFF);
            graphics.drawString(GUI_VIEW_STRING_ERROR, 5, 5, 20);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputConnection != null) {
                try {
                    inputConnection.close();
                }
                catch (IOException iOException) {}
            }
        }
        return image;
    }

    public void resetViewer() {
        this.stopRefresh = true;
        this.currImage = null;
        this.nextImage = null;
        this.prevImage = null;
        this.currentIndex = 0;
    }

    public void keyPressed(int n) {
        int n2 = this.getGameAction(n);
        if (n2 == 2) {
            if (this.imagesVector.size() > 1) {
                this.nextImage = this.currImage;
                this.currImage = this.prevImage;
                this.prevImage = null;
                this.currentIndex = (this.currentIndex + this.imagesVector.size() - 1) % this.imagesVector.size();
                this.repaint();
            }
        } else if (n2 == 5) {
            if (this.imagesVector.size() > 1) {
                this.prevImage = this.currImage;
                this.currImage = this.nextImage;
                this.nextImage = null;
                this.currentIndex = (this.currentIndex + 1) % this.imagesVector.size();
                this.repaint();
            }
        } else if (n2 == 8 && this.exitAction != null) {
            this.resetViewer();
            this.exitAction.run();
        }
    }
}

