/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.Currency;
import JabpLite.CurrencyStore;
import JabpLite.JabpLite;
import JabpLite.Utilities;
import java.util.Hashtable;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;

public class AccountForm
extends Form {
    Account a;
    JabpLite parent;
    TextField tfName;
    TextField tfDescription;
    TextField tfOpen;
    ChoiceGroup cgCurrency;
    ChoiceGroup cgType;
    ChoiceGroup cgDRCR;

    public AccountForm(JabpLite jabpLite, Account account, String string) {
        super(string + " Account");
        this.parent = jabpLite;
        this.a = account;
        if (string.equals("Show") || string.equals("Delete")) {
            this.append("Name: " + this.a.name + "\n");
            this.append("Desc: " + this.a.description + "\n");
            String string2 = " DR";
            if (this.a.open >= 0) {
                string2 = " CR";
            }
            this.append("Opening Bal: " + Utilities.numberToString(Math.abs(this.a.open), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2 + "\n");
            string2 = " DR";
            if (this.a.current >= 0) {
                string2 = " CR";
            }
            this.append("Current Bal: " + Utilities.numberToString(Math.abs(this.a.current), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2 + "\n");
            string2 = " DR";
            if (this.a.today >= 0) {
                string2 = " CR";
            }
            this.append("Today Bal: " + Utilities.numberToString(Math.abs(this.a.today), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2 + "\n");
            string2 = " DR";
            if (this.a.reconciled >= 0) {
                string2 = " CR";
            }
            this.append("Reconciled Bal: " + Utilities.numberToString(Math.abs(this.a.reconciled), false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed) + string2 + "\n");
            if (!this.a.currency.equals(this.parent.homeCurrency)) {
                this.append("All amounts above in " + this.parent.homeCurrency + "\n");
            }
            this.append("Currency: " + this.a.currency + "\n");
            this.append("Type: " + this.a.type + "\n");
            Hashtable hashtable = null;
            hashtable = this.parent.transactionHt.containsKey(this.a.name) ? (Hashtable)this.parent.transactionHt.get(this.a.name) : new Hashtable();
            this.append("Entries: " + hashtable.size());
            return;
        }
        this.tfName = new TextField("Name", this.a.name, 30, 0);
        this.append((Item)this.tfName);
        this.tfDescription = new TextField("Description", this.a.description, 64, 0);
        this.append((Item)this.tfDescription);
        int n = 2;
        if (!this.parent.numericEntry) {
            n = 0;
        }
        this.tfOpen = string.equals("New") ? new TextField("Opening Balance", "", 20, n) : new TextField("Open Bal in " + this.parent.homeCurrency, "", 20, n);
        String string3 = "";
        if (this.a.open != 0) {
            string3 = Utilities.numberToString(Math.abs(this.a.open), this.parent.numericEntry, this.parent.isEuropeanNumberFormat, false);
        }
        this.tfOpen.setString(string3);
        this.append((Item)this.tfOpen);
        int n2 = 4;
        if (this.parent.oldStyleChoice) {
            n2 = 1;
        }
        this.cgDRCR = new ChoiceGroup("DR/CR", n2);
        this.cgDRCR.append("Debit", null);
        this.cgDRCR.append("Credit", null);
        if (this.a.open < 0) {
            this.cgDRCR.setSelectedIndex(0, true);
        } else {
            this.cgDRCR.setSelectedIndex(1, true);
        }
        this.append((Item)this.cgDRCR);
        this.cgCurrency = new ChoiceGroup("Currency", n2);
        CurrencyStore currencyStore = new CurrencyStore(this.parent);
        int n3 = currencyStore.getNumCurrencies();
        for (int i = 0; i < n3; ++i) {
            Currency currency = currencyStore.getCurrencyFromIndex(i);
            this.cgCurrency.append(currency.code, null);
            if (string.equals("New") && currency.code.equals(this.parent.homeCurrency)) {
                this.cgCurrency.setSelectedIndex(i, true);
            }
            if (!string.equals("Edit") || !currency.code.equals(this.a.currency)) continue;
            this.cgCurrency.setSelectedIndex(i, true);
        }
        this.append((Item)this.cgCurrency);
        currencyStore.closeCurrencyStore();
        currencyStore = null;
        this.cgType = new ChoiceGroup("Type", n2);
        this.cgType.append("Bank", null);
        this.cgType.append("Cash", null);
        this.cgType.append("Credit Card", null);
        this.cgType.append("Asset", null);
        this.cgType.append("Liability", null);
        if (this.a.type.equals("Bank")) {
            this.cgType.setSelectedIndex(0, true);
        }
        if (this.a.type.equals("Cash")) {
            this.cgType.setSelectedIndex(1, true);
        }
        if (this.a.type.equals("Credit Card")) {
            this.cgType.setSelectedIndex(2, true);
        }
        if (this.a.type.equals("Asset")) {
            this.cgType.setSelectedIndex(3, true);
        }
        if (this.a.type.equals("Liability")) {
            this.cgType.setSelectedIndex(4, true);
        }
        this.append((Item)this.cgType);
        n3 = 0;
        if (this.parent.transactionHt.containsKey(this.a.name)) {
            n3 = ((Hashtable)this.parent.transactionHt.get(this.a.name)).size();
        }
        this.append("Contains " + n3 + " transactions");
    }

    Account update(boolean bl) {
        this.a.name = this.tfName.getString();
        this.a.description = this.tfDescription.getString();
        this.a.currency = this.cgCurrency.getString(this.cgCurrency.getSelectedIndex());
        int n = this.a.open;
        this.a.open = Utilities.stringToNumber(this.tfOpen.getString(), n, this.parent.numericEntry, this.parent.isEuropeanNumberFormat);
        if (this.cgDRCR.getSelectedIndex() == 0) {
            this.a.open = -this.a.open;
        }
        if (bl && !this.a.currency.equals(this.parent.homeCurrency)) {
            CurrencyStore currencyStore = new CurrencyStore(this.parent);
            Currency currency = currencyStore.getCurrencyFromName(this.a.currency);
            this.a.open = Utilities.foreignToHome(this.a.open, currency.rate);
            currency = null;
            currencyStore.closeCurrencyStore();
            currencyStore = null;
        }
        this.a.current += this.a.open - n;
        this.a.today += this.a.open - n;
        this.a.reconciled += this.a.open - n;
        switch (this.cgType.getSelectedIndex()) {
            case 0: {
                this.a.type = "Bank";
                break;
            }
            case 1: {
                this.a.type = "Cash";
                break;
            }
            case 2: {
                this.a.type = "Credit Card";
                break;
            }
            case 3: {
                this.a.type = "Asset";
                break;
            }
            case 4: {
                this.a.type = "Liability";
            }
        }
        return this.a;
    }
}

