/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.JabpLite;
import JabpLite.LongId;
import JabpLite.Split;
import JabpLite.Transaction;
import JabpLite.TransactionForm;
import JabpLite.TransactionStore;
import JabpLite.TransactionView;
import JabpLite.Utilities;
import java.util.Calendar;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;

public class FindView
extends Canvas
implements CommandListener,
Runnable {
    Transaction t;
    Transaction t1;
    Transaction oldT;
    TransactionStore ts;
    TransactionForm tf3;
    Form touchScreenMenu;
    ChoiceGroup cgtsm;
    Alert alert;
    Calendar calendar;
    Display display;
    Font font;
    JabpLite parent;
    String oldName = "";
    String categoryString;
    boolean paintWholeScreen = true;
    int fs;
    int width;
    int height;
    int currentX;
    int currentY;
    int oldX;
    int oldY;
    int numItems;
    int numItemsPage;
    int lineHeight;
    int fontHeight;
    int fontWidth;
    int currentPos;
    int previousPos;
    int oldId;
    int startPos;
    int totalFound;
    int dateWidth;
    int numberWidth;
    int reconciledWidth;
    int descriptionWidth;
    int descriptionPosition;
    int amountPosition;
    int spacing;
    int referenceWidth;
    int referencePosition;
    int categoryWidth;
    int categoryPosition;
    int currencyRate;
    boolean fromCategoryView;
    long timePointerOnScreen;
    boolean pointerExecute;

    public FindView(JabpLite jabpLite, Display display, String string, boolean bl) {
        this.parent = jabpLite;
        this.display = display;
        this.setFullScreenMode(this.parent.showFullCanvas);
        this.categoryString = string;
        this.fromCategoryView = bl;
        this.addCommand(this.parent.showCommand);
        this.addCommand(this.parent.goToEntryCommand);
        this.addCommand(this.parent.exitCommand);
        this.addCommand(this.parent.okCommand);
        this.setCommandListener(this);
        this.calendar = Calendar.getInstance();
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.alert.setTimeout(1500);
        this.width = this.getWidth();
        this.height = this.getHeight() - this.parent.heightAdjustment;
        this.setPositions();
        this.ts = new TransactionStore(this.parent, new Account());
        this.numItems = this.parent.findHt.size();
        this.currentX = 0;
        this.currentY = this.lineHeight;
        this.currentPos = 0;
        this.startPos = 0;
        if (this.parent.isAndroid) {
            this.display.callSerially((Runnable)this);
        }
    }

    void androidDelay() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.repaint();
        this.serviceRepaints();
    }

    public void run() {
        this.androidDelay();
    }

    public void paint(Graphics graphics) {
        if (this.width != this.getWidth() || this.height != this.getHeight() - this.parent.heightAdjustment) {
            this.width = this.getWidth();
            this.height = this.getHeight() - this.parent.heightAdjustment;
            this.setPositions();
            this.paintWholeScreen = true;
        }
        graphics.setFont(this.font);
        if (this.paintWholeScreen || this.parent.isBlackberry) {
            this.showHeader(graphics);
            this.showPage(graphics);
            this.showFooter(graphics);
        } else {
            this.showLines(graphics);
        }
        this.paintWholeScreen = true;
    }

    void showPage(Graphics graphics) {
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight, this.width, this.height - this.lineHeight * 2);
        graphics.setColor(this.parent.colorFont);
        if (this.numItems == 0) {
            return;
        }
        for (int i = 0; i < this.numItemsPage && i + this.startPos <= this.numItems - 1; ++i) {
            if (i == this.currentPos) {
                graphics.setColor(this.parent.colorCursor);
                graphics.fillRect(0, this.lineHeight * i + this.lineHeight, this.width, this.lineHeight);
                graphics.setColor(this.parent.colorFont);
            }
            this.t = this.getTransactionFromIndex(i + this.startPos);
            this.buildLine(graphics, this.t, this.lineHeight * i + this.lineHeight);
        }
        this.t = this.getTransactionFromIndex(this.startPos + this.currentPos);
    }

    void showLines(Graphics graphics) {
        if (this.numItems == 0) {
            return;
        }
        graphics.setColor(this.parent.colorBackground);
        graphics.fillRect(0, this.lineHeight * this.previousPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.t = this.getTransactionFromIndex(this.previousPos + this.startPos);
        this.buildLine(graphics, this.t, this.lineHeight * this.previousPos + this.lineHeight);
        graphics.setColor(this.parent.colorCursor);
        graphics.fillRect(0, this.lineHeight * this.currentPos + this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        this.t = this.getTransactionFromIndex(this.currentPos + this.startPos);
        this.buildLine(graphics, this.t, this.lineHeight * this.currentPos + this.lineHeight);
    }

    Transaction getTransactionFromIndex(int n) {
        short s = (short)n;
        int n2 = ((LongId)this.parent.findHt.get((Object)new Short((short)s))).id;
        Transaction transaction = this.ts.getTransaction(n2);
        if (!transaction.splitFlag) {
            return transaction;
        }
        if (this.categoryString.equals("")) {
            return transaction;
        }
        int n3 = transaction.ss.size();
        for (int i = 0; i < n3; ++i) {
            Split split = transaction.ss.getSplit(i);
            if (this.fromCategoryView) {
                if (!split.category.equals(this.categoryString)) continue;
                transaction.amount = split.amount;
                transaction.category = split.category;
                return transaction;
            }
            if (split.category.toLowerCase().indexOf(this.categoryString.toLowerCase()) <= -1) continue;
            transaction.amount = split.amount;
            transaction.category = split.category;
            return transaction;
        }
        return transaction;
    }

    void showHeader(Graphics graphics) {
        int n = this.parent.lineSpacing + this.parent.fontAdjustment;
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, 0, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        graphics.drawString(this.numItems + " matching transactions", this.parent.widthAdjustment, n, 20);
    }

    void showFooter(Graphics graphics) {
        int n = this.height - this.lineHeight + this.parent.lineSpacing + this.parent.fontAdjustment;
        graphics.setColor(this.parent.colorHeading);
        graphics.fillRect(0, this.height - this.lineHeight, this.width, this.lineHeight);
        graphics.setColor(this.parent.colorFont);
        graphics.drawString("Total", this.parent.widthAdjustment, n, 20);
        String string = Utilities.numberToString(this.parent.totalFound, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        graphics.drawString(string, this.amountPosition + this.numberWidth - this.font.stringWidth(string), n, 20);
    }

    void drawUp() {
        if (this.startPos + this.currentPos > 0) {
            this.oldY = this.currentY;
            this.currentY -= this.lineHeight;
            this.previousPos = this.currentPos--;
            if (this.currentY < this.lineHeight) {
                this.currentY = this.lineHeight;
                --this.startPos;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
                ++this.currentPos;
            } else {
                this.paintWholeScreen = false;
            }
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    void drawDown() {
        if (this.startPos + this.currentPos < this.numItems - 1) {
            this.oldY = this.currentY;
            this.currentY += this.lineHeight;
            this.previousPos = this.currentPos++;
            if (this.currentY + this.lineHeight * 2 > this.height) {
                this.currentY -= this.lineHeight;
                ++this.startPos;
                --this.currentPos;
                if (this.startPos > this.numItems - 1) {
                    this.startPos = this.numItems - 1 - this.currentPos;
                }
            } else {
                this.paintWholeScreen = false;
            }
            this.repaint();
            this.serviceRepaints();
            return;
        }
    }

    String setPageDate(long l) {
        this.parent.genericDate.setTime(l + 3600000L);
        this.parent.cal.setTime(this.parent.genericDate);
        String string = "" + this.parent.cal.get(5);
        if (string.length() < 2) {
            string = "0" + string;
        }
        int n = this.parent.cal.get(2) + 1;
        String string2 = "" + n;
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        if (this.parent.dateFormat == 0) {
            return string + "/" + string2;
        }
        if (this.parent.dateFormat == 1) {
            return string2 + "/" + string;
        }
        String string3 = ("" + this.parent.cal.get(1)).substring(2, 4);
        if (this.parent.dateFormat == 2) {
            return string + "/" + string2 + "/" + string3;
        }
        if (this.parent.dateFormat == 3) {
            return string2 + "/" + string + "/" + string3;
        }
        return "";
    }

    String setReconciled(boolean bl) {
        if (bl) {
            return " r";
        }
        return "";
    }

    void buildLine(Graphics graphics, Transaction transaction, int n) {
        int n2;
        int n3;
        int n4 = n + this.parent.lineSpacing + this.parent.fontAdjustment;
        graphics.drawString(this.setPageDate(transaction.longDate), this.parent.widthAdjustment, n4, 20);
        int n5 = transaction.description.length();
        for (n3 = 0; n3 < n5; ++n3) {
            n2 = n5 - n3;
            if (this.font.stringWidth(transaction.description.substring(0, n2)) > this.descriptionWidth) continue;
            graphics.drawString(transaction.description.substring(0, n2), this.descriptionPosition, n4, 20);
            break;
        }
        if (this.referenceWidth > 0) {
            n5 = transaction.reference.length();
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = n5 - n3;
                if (this.font.stringWidth(transaction.reference.substring(0, n2)) > this.referenceWidth) continue;
                graphics.drawString(transaction.reference.substring(0, n2), this.referencePosition, n4, 20);
                break;
            }
        }
        if (this.categoryWidth > 0) {
            String string = transaction.category;
            if (transaction.transferFlag) {
                string = "[Transfer]";
            }
            if (transaction.splitFlag) {
                string = "[Split]";
            }
            n5 = string.length();
            for (n2 = 0; n2 < n5; ++n2) {
                int n6 = n5 - n2;
                if (this.font.stringWidth(string.substring(0, n6)) > this.categoryWidth) continue;
                graphics.drawString(string.substring(0, n6), this.categoryPosition, n4, 20);
                break;
            }
        }
        String string = Utilities.numberToString(transaction.amount, false, this.parent.isEuropeanNumberFormat, this.parent.isGroupingUsed);
        graphics.drawString(string, this.amountPosition + this.numberWidth - this.font.stringWidth(string), n4, 20);
        graphics.drawString(this.setReconciled(transaction.reconciled), this.width - this.reconciledWidth - this.parent.widthAdjustment, n4, 20);
    }

    void setPositions() {
        this.fs = 8;
        if (this.parent.mediumSize) {
            this.fs = 0;
        }
        if (this.parent.largeSize) {
            this.fs = 16;
        }
        this.font = Font.getFont((int)0, (int)0, (int)this.fs);
        this.fontHeight = this.font.getHeight();
        this.lineHeight = this.fontHeight + this.parent.lineSpacing * 2;
        this.numberWidth = this.parent.isGroupingUsed ? this.font.stringWidth("999,999.99") : this.font.stringWidth("999999.99");
        this.dateWidth = this.font.stringWidth("99/99");
        if (this.parent.dateFormat > 1) {
            this.dateWidth = this.font.stringWidth("99/99/99");
        }
        this.reconciledWidth = this.font.stringWidth(" r");
        this.numItemsPage = this.height / this.lineHeight - 2;
        this.referenceWidth = 0;
        this.categoryWidth = 0;
        this.spacing = 10;
        if (this.width > 500) {
            this.referenceWidth = 100;
            this.categoryWidth = 100;
            this.spacing = 20;
        }
        this.descriptionWidth = this.width - this.numberWidth - this.dateWidth - this.reconciledWidth - this.referenceWidth - this.categoryWidth - this.parent.widthAdjustment * 2 - this.spacing * 3;
        if (this.referenceWidth > 0) {
            this.descriptionWidth -= this.spacing;
        }
        if (this.categoryWidth > 0) {
            this.descriptionWidth -= this.spacing;
        }
        this.descriptionPosition = this.dateWidth + this.parent.widthAdjustment + this.spacing;
        this.referencePosition = this.descriptionPosition + this.descriptionWidth + this.spacing;
        this.categoryPosition = this.referencePosition + this.referenceWidth;
        if (this.referenceWidth > 0) {
            this.categoryPosition += this.spacing;
        }
        this.amountPosition = this.categoryPosition + this.categoryWidth;
        if (this.categoryWidth > 0) {
            this.amountPosition += this.spacing;
        }
    }

    protected void showNotify() {
        this.repaint();
    }

    protected void keyPressed(int n) {
        if (this.getGameAction(n) == 2) {
            if (this.startPos == 0) {
                this.currentPos = 0;
                this.currentY = this.lineHeight;
            } else {
                this.startPos -= this.numItemsPage;
                if (this.startPos < 0) {
                    this.startPos = 0;
                }
            }
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 5) {
            this.startPos += this.numItemsPage;
            if (this.startPos + this.currentPos > this.numItems - 1) {
                this.currentPos = Math.min(this.numItems, this.numItemsPage) - 1;
                this.startPos = this.numItems - 1 - this.currentPos;
                this.currentY = this.currentPos * this.lineHeight + this.lineHeight;
            }
            this.repaint();
            return;
        }
        if (this.getGameAction(n) == 8) {
            this.displayTouchScreenMenu();
            return;
        }
        if (this.getGameAction(n) == 1) {
            this.drawUp();
            return;
        }
        if (this.getGameAction(n) == 6) {
            this.drawDown();
            return;
        }
    }

    protected void pointerPressed(int n, int n2) {
        this.pointerExecute = false;
        this.timePointerOnScreen = System.currentTimeMillis();
        if (n2 < this.lineHeight) {
            this.keyPressed(this.getKeyCode(2));
            return;
        }
        if (n2 > this.height - this.lineHeight) {
            this.keyPressed(this.getKeyCode(5));
            return;
        }
        this.pointerExecute = true;
        int n3 = (n2 - this.lineHeight) / this.lineHeight;
        if (n3 >= this.numItems) {
            return;
        }
        this.previousPos = this.currentPos;
        this.currentPos = n3;
        this.currentY = (this.currentPos + 1) * this.lineHeight;
        this.paintWholeScreen = false;
        this.repaint();
    }

    protected void pointerReleased(int n, int n2) {
        this.timePointerOnScreen = System.currentTimeMillis() - this.timePointerOnScreen;
        if (this.timePointerOnScreen > 1000L) {
            this.displayTouchScreenMenu();
            return;
        }
        if (!this.pointerExecute) {
            return;
        }
        this.displayTouchScreenMenu();
    }

    void displayTouchScreenMenu() {
        this.touchScreenMenu = new Form("Find Menu");
        this.cgtsm = new ChoiceGroup("Choose an option", 1);
        this.cgtsm.append("Show", null);
        this.cgtsm.append("Go To Entry", null);
        this.cgtsm.append("Close", null);
        this.cgtsm.append("Exit", null);
        this.touchScreenMenu.append((Item)this.cgtsm);
        this.touchScreenMenu.addCommand(this.parent.okCommand);
        this.touchScreenMenu.addCommand(this.parent.cancelCommand);
        this.touchScreenMenu.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.touchScreenMenu);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.parent.exitCommand) {
            this.parent.findHt = null;
            this.ts.closeTransactionStore();
            this.parent.destroyApp(true);
            return;
        }
        if (displayable == this) {
            if (command == this.parent.showCommand) {
                if (this.numItems == 0) {
                    this.alert.setString("No transactions found");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                this.tf3 = new TransactionForm(this.parent);
                this.tf3.show(this.t, "Show");
                this.tf3.addCommand(this.parent.okCommand);
                this.tf3.addCommand(this.parent.exitCommand);
                this.tf3.setCommandListener(this);
                this.display.setCurrent((Displayable)this.tf3);
            }
            if (command == this.parent.goToEntryCommand) {
                this.parent.findHt = null;
                this.ts.closeTransactionStore();
                AccountStore accountStore = new AccountStore(this.parent);
                Account account = accountStore.getAccountFromName(this.t.account);
                accountStore.closeAccountStore();
                if (this.parent.tv != null) {
                    this.parent.tv.ts.closeTransactionStore();
                    this.parent.tv.rs.closeRegularStore();
                }
                this.parent.tv = new TransactionView(this.parent, this.display, account);
                this.parent.tv.repaint();
                this.parent.tv.serviceRepaints();
                this.parent.tv.goToTransaction(this.t);
                this.display.setCurrent((Displayable)this.parent.tv);
            }
            if (command == this.parent.okCommand) {
                this.parent.findHt = null;
                this.ts.closeTransactionStore();
                if (this.fromCategoryView) {
                    this.parent.cv.paintWholeScreen = true;
                    this.parent.cv.paintHeaderOnly = false;
                    this.display.setCurrent((Displayable)this.parent.cv);
                } else {
                    this.parent.av.paintWholeScreen = true;
                    this.parent.av.paintHeaderOnly = false;
                    this.display.setCurrent((Displayable)this.parent.av);
                }
            }
        }
        if (displayable == this.tf3 && command == this.parent.okCommand) {
            this.tf3 = null;
            this.display.setCurrent((Displayable)this);
            return;
        }
        if (displayable == this.touchScreenMenu) {
            if (command == this.parent.okCommand) {
                int n = this.cgtsm.getSelectedIndex();
                if (n == 0) {
                    this.commandAction(this.parent.showCommand, (Displayable)this);
                }
                if (n == 1) {
                    this.commandAction(this.parent.goToEntryCommand, (Displayable)this);
                }
                if (n == 2) {
                    this.commandAction(this.parent.okCommand, (Displayable)this);
                }
                if (n == 3) {
                    this.parent.destroyApp(true);
                }
            } else {
                this.touchScreenMenu = null;
                this.alert.setString("Cancelled");
                this.display.setCurrent(this.alert, (Displayable)this);
            }
        }
    }
}

