/*
 * Decompiled with CFR 0.152.
 */
package JabpLite;

import JabpLite.Account;
import JabpLite.AccountStore;
import JabpLite.Category;
import JabpLite.CategoryStore;
import JabpLite.Currency;
import JabpLite.CurrencyStore;
import JabpLite.IndexStore;
import JabpLite.Investment;
import JabpLite.InvestmentStore;
import JabpLite.JabpLite;
import JabpLite.KeyStore;
import JabpLite.LongId;
import JabpLite.PreferenceStore;
import JabpLite.Regular;
import JabpLite.RegularStore;
import JabpLite.Split;
import JabpLite.SplitStore;
import JabpLite.StandingOrder;
import JabpLite.StandingOrderStore;
import JabpLite.SyncStore;
import JabpLite.Transaction;
import JabpLite.TransactionStore;
import JabpLite.Utilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.DateField;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class ImportExportForm
extends Form
implements CommandListener,
Runnable {
    Display display = null;
    JabpLite parent;
    Alert alert;
    Calendar cal;
    Date todayDate;
    Date genericDate;
    long todayDays;
    String root;
    String directory;
    String[] drives;
    int numDrives;
    FileConnection fc;
    FileConnection fc1;
    RecordStore rs;
    DataInputStream dis;
    DataOutputStream dos;
    InputStream in;
    InputStreamReader isr;
    OutputStream out;
    OutputStreamWriter osw;
    Account account;
    String exportAccount;
    ChoiceGroup cgDevice;
    ChoiceGroup cgOption;
    ChoiceGroup cgAccount;
    ChoiceGroup cgDateType;
    ChoiceGroup cgIOB;
    ChoiceGroup cgIT;
    ChoiceGroup cgSS;
    ChoiceGroup cgET;
    ChoiceGroup cgDrive;
    ChoiceGroup cgDirectory;
    ChoiceGroup cgPreferences;
    ChoiceGroup cgKeys;
    ChoiceGroup cgUTF8;
    DateField df1;
    DateField df2;
    IndexStore ixs;
    Form f1;
    Form f2;
    Form f3;
    Form f4;
    Form f5;
    Form f6;
    Form showError;
    String password = "";
    String lastAccount = "";
    String textLine = "";
    int dateFormat;
    int exportFileType;
    boolean overwritePreferences = false;
    boolean passwordMode;
    boolean eofflag = false;
    boolean importKeys = false;
    boolean exportKeys = false;
    boolean isEuropeanNumberFormat = false;
    boolean isGroupingUsed = false;
    boolean syncMode = false;
    boolean oldStyleChoice = false;
    boolean useUTF8 = false;
    int runMode;
    int qifDateFormat;
    long lastExportedFromDate = 0L;
    String lastExportedAccount = "";
    boolean exportOpeningBalance = false;
    boolean includeTransfers = false;
    boolean separateSplits = false;
    boolean showNextSteps = false;
    long hoursOffset = 0L;
    String label;
    TextField tf;
    TextField txf;
    int passwordError = 0;
    List monitorConn = null;
    Command actionCommand;
    Command importCommand;
    Command exportCommand;

    public ImportExportForm(JabpLite jabpLite) {
        super("Import/Export Options");
        Object object;
        this.parent = jabpLite;
        this.display = Display.getDisplay((MIDlet)this.parent);
        this.alert = new Alert("");
        this.alert.setType(AlertType.CONFIRMATION);
        this.cal = Calendar.getInstance();
        this.genericDate = this.cal.getTime();
        if (this.parent.isAndroid) {
            this.todayDate = this.cal.getTime();
        } else {
            object = new DateField(null, 1);
            object.setDate(this.genericDate);
            this.todayDate = object.getDate();
        }
        if (this.todayDate == null) {
            this.todayDate = this.cal.getTime();
        }
        this.todayDays = Utilities.longToDays(this.todayDate.getTime());
        this.ixs = new IndexStore(this.parent);
        this.ixs.getIndices1();
        this.ixs.getIndices2();
        this.ixs.closeIndexStore();
        if (this.passwordMode) {
            this.checkPassword();
        } else {
            this.display.setCurrent((Displayable)this);
        }
        this.runMode = 5;
        object = new Thread(this);
        ((Thread)object).start();
        this.cgOption = new ChoiceGroup("Options", 1);
        this.cgOption.append("Sync to Jabp", null);
        this.cgOption.append("Import/Export QIF/OFX/CSV", null);
        this.cgOption.append("Import Data", null);
        this.cgOption.append("Export Data", null);
        this.cgOption.append("Set Directory", null);
        this.cgOption.append("Set Drive", null);
        this.append((Item)this.cgOption);
        this.actionCommand = this.parent.isAndroid ? new Command("Action", 1, 2) : new Command("Action", 2, 2);
        this.importCommand = new Command("Import", 1, 2);
        this.exportCommand = new Command("Export", 1, 2);
        this.addCommand(this.actionCommand);
        this.addCommand(this.parent.mainCommand);
        this.addCommand(this.parent.exitCommand);
        this.setCommandListener(this);
        this.monitorConn = new List("Monitor Activity", 3);
        this.monitorConn.addCommand(this.parent.exitCommand);
        this.monitorConn.setCommandListener((CommandListener)this);
    }

    public void run() {
        if (this.runMode == 1) {
            this.setDirectory();
        }
        if (this.runMode == 2) {
            this.processExport();
        }
        if (this.runMode == 3) {
            this.exportData();
        }
        if (this.runMode == 4) {
            this.processImport();
        }
        if (this.runMode == 5) {
            this.getRoot();
        }
        if (this.runMode == 7) {
            this.setDrive();
        }
        if (this.runMode == 8) {
            this.syncData();
        }
    }

    void checkPassword() {
        this.f4 = new Form("Check Password");
        this.f4.addCommand(this.parent.okCommand);
        this.f4.addCommand(this.parent.exitCommand);
        this.f4.setCommandListener((CommandListener)this);
        this.txf = new TextField("Password", "", 20, 65536);
        this.f4.append((Item)this.txf);
        this.display.setCurrent((Displayable)this.f4);
    }

    private void sendRecord(byte[] byArray) {
        try {
            this.dos.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void sndRecord(byte[] byArray) {
        try {
            this.dos.writeInt(byArray.length);
            this.dos.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void sndText(String string) {
        String string2 = string + "\r\n";
        try {
            this.osw.write(string2);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void sndNumber(int n) {
        try {
            this.dos.writeInt(n);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    void syncData() {
        Object object;
        int n;
        byte[] byArray;
        this.show("Opening files");
        try {
            this.fc = (FileConnection)Connector.open((String)("file:///" + this.root + this.directory + "Jabp.sync"));
            if (this.fc.exists()) {
                this.dis = this.fc.openDataInputStream();
            } else {
                this.eofflag = true;
            }
        }
        catch (IOException iOException) {
            this.alert.setString("Error opening Jabp.sync");
            this.display.setCurrent(this.alert, (Displayable)this);
            return;
        }
        catch (SecurityException securityException) {
            this.alert.setString("Security error opening Jabp.sync");
            this.display.setCurrent(this.alert, (Displayable)this);
            return;
        }
        AccountStore accountStore = new AccountStore(this.parent);
        CategoryStore categoryStore = new CategoryStore(this.parent);
        CurrencyStore currencyStore = new CurrencyStore(this.parent);
        InvestmentStore investmentStore = new InvestmentStore(this.parent);
        RegularStore regularStore = new RegularStore(this.parent);
        TransactionStore transactionStore = new TransactionStore(this.parent, new Account());
        StandingOrderStore standingOrderStore = new StandingOrderStore(this.parent);
        this.show("Reading Jabp.sync");
        int n2 = 0;
        int n3 = 0;
        block12: while (!this.eofflag) {
            Object object2;
            int n4;
            Object object3;
            Object object4;
            Object object5;
            long l = this.receiveLong();
            if (this.eofflag) break;
            if (++n2 / 20 * 20 == n2) {
                this.show(n2 + " records read");
            }
            int n5 = this.receiveNumber();
            byArray = this.receiveRecord();
            n = 1;
            if (n5 < 0) {
                n = 0;
                n5 = -n5;
            }
            if (n5 == 1) {
                object5 = accountStore.fromByteArray(byArray);
                object4 = new Currency();
                ((Currency)object4).code = ((Account)object5).currency;
                if (currencyStore.lookUpId((Currency)object4) == 0) {
                    ((Account)object5).currency = this.parent.homeCurrency;
                }
                if (n != 0) {
                    accountStore.saveNewAccount((Account)object5);
                } else {
                    object3 = accountStore.getAccountFromName(((Account)object5).name);
                    accountStore.deleteAccount((Account)object3);
                    n4 = accountStore.lookUpIndex((Account)object3);
                    accountStore.deleteIndex(n4);
                }
            }
            if (n5 == 2) {
                object5 = categoryStore.fromByteArray(byArray);
                if (n != 0) {
                    categoryStore.saveNewCategory((Category)object5);
                } else {
                    object4 = categoryStore.getCategoryFromName(((Category)object5).name);
                    categoryStore.deleteCategory((Category)object4);
                    int n6 = categoryStore.lookUpIndex((Category)object4);
                    categoryStore.deleteIndex(n6);
                }
            }
            if (n5 == 3) {
                object5 = currencyStore.fromByteArray(byArray);
                if (n != 0) {
                    currencyStore.saveNewCurrency((Currency)object5);
                } else {
                    object4 = currencyStore.getCurrencyFromName(((Currency)object5).code);
                    currencyStore.deleteCurrency((Currency)object4);
                    int n7 = currencyStore.lookUpIndex((Currency)object4);
                    currencyStore.deleteIndex(n7);
                }
            }
            if (n5 == 4) {
                object5 = investmentStore.fromByteArray(byArray);
                object4 = new Currency();
                ((Currency)object4).code = ((Investment)object5).currency;
                if (currencyStore.lookUpId((Currency)object4) == 0) {
                    ((Investment)object5).currency = this.parent.homeCurrency;
                }
                if (n != 0) {
                    investmentStore.saveNewInvestment((Investment)object5);
                } else {
                    object3 = investmentStore.getInvestmentFromName(((Investment)object5).name);
                    investmentStore.deleteInvestment((Investment)object3);
                    n4 = investmentStore.lookUpIndex((Investment)object3);
                    investmentStore.deleteIndex(n4);
                }
            }
            if (n5 == 5) {
                object5 = regularStore.fromByteArray(byArray);
                if (n != 0) {
                    regularStore.saveNewRegular((Regular)object5);
                } else {
                    object4 = regularStore.getRegularFromName(((Regular)object5).description);
                    regularStore.deleteRegular((Regular)object4);
                    int n8 = regularStore.lookUpIndex((Regular)object4);
                    regularStore.deleteIndex(n8);
                }
            }
            if (n5 == 6) {
                object5 = standingOrderStore.fromByteArray(byArray);
                if (n != 0) {
                    standingOrderStore.saveNewStandingOrder((StandingOrder)object5);
                } else {
                    object4 = standingOrderStore.getStandingOrderFromName(((StandingOrder)object5).description);
                    standingOrderStore.deleteStandingOrder((StandingOrder)object4);
                    standingOrderStore.deleteIndex((StandingOrder)object4);
                }
            }
            if (n5 != 7 && n5 != 8) continue;
            object5 = transactionStore.fromByteArray(byArray);
            object4 = new Account();
            ((Account)object4).name = ((Transaction)object5).account;
            transactionStore.getIndex((Account)object4);
            if (n != 0) {
                ((Transaction)object5).longDate += this.hoursOffset;
                if (transactionStore.getSizeAvailable() <= 1000) {
                    this.alert.setString("There is no space to add more records. Delete some transactions, then use Extra Options>Regenerate.");
                    this.display.setCurrent(this.alert, (Displayable)this);
                    return;
                }
                int n9 = transactionStore.saveNewTransaction((Transaction)object5);
                transactionStore.setIndex((Account)object4);
                object4 = accountStore.getAccountFromName(((Account)object4).name);
                if (n5 == 7) {
                    ((Account)object4).updateBalance((Transaction)object5, null, this.parent.todayDays);
                }
                accountStore.saveExistingAccount((Account)object4);
                if (((Transaction)object5).transferFlag) {
                    if (((Transaction)object5).transferAccount.equals("") || ((Transaction)object5).transferAccount.equals(((Transaction)object5).account)) continue;
                    object4 = accountStore.getAccountFromName(((Transaction)object5).transferAccount);
                    transactionStore.getIndex((Account)object4);
                    n4 = transactionStore.ht.size();
                    long l2 = Utilities.longToDays(((Transaction)object5).longDate);
                    for (int i = 0; i < n4; ++i) {
                        object2 = (LongId)transactionStore.ht.get(new Short((short)i));
                        if (l2 == Utilities.longToDays(((LongId)object2).lo)) {
                            Transaction transaction = transactionStore.getTransaction(((LongId)object2).id);
                            if (!transaction.transferFlag) continue;
                            if (((Transaction)object5).description.equals(transaction.description) && ((Transaction)object5).amount == -transaction.amount) {
                                ((Transaction)object5).transferAccountId = transaction.id;
                                transactionStore.saveExistingTransaction((Transaction)object5);
                                continue block12;
                            }
                        }
                        if (l2 > Utilities.longToDays(((LongId)object2).lo)) continue block12;
                    }
                    continue;
                }
                if (((Transaction)object5).splitFlag) {
                    for (n4 = 0; n4 < ((Transaction)object5).ss.size(); ++n4) {
                        Split split = ((Transaction)object5).ss.getSplit(n4);
                        Category category = categoryStore.getCategoryFromName(split.category);
                        if (n5 == 7) {
                            category.updateBalance(split, null);
                        }
                        categoryStore.saveExistingCategory(category);
                    }
                    continue;
                }
                Category category = categoryStore.getCategoryFromName(((Transaction)object5).category);
                if (n5 == 7) {
                    category.updateBalance((Transaction)object5, null);
                }
                categoryStore.saveExistingCategory(category);
                continue;
            }
            int n10 = transactionStore.ht.size();
            for (n4 = 0; n4 < n10; ++n4) {
                Transaction transaction = transactionStore.getTransactionFromIndex(n4);
                if (!transaction.description.equals(((Transaction)object5).description) || Utilities.longToDays(transaction.longDate) != Utilities.longToDays(((Transaction)object5).longDate) || !transaction.category.equals(((Transaction)object5).category) && (!transaction.transferFlag || !((Transaction)object5).transferFlag) || transaction.amount != ((Transaction)object5).amount) continue;
                if (transaction.splitFlag) {
                    for (int i = 0; i < transaction.ss.size(); ++i) {
                        Split split = transaction.ss.getSplit(i);
                        object2 = categoryStore.getCategoryFromName(split.category);
                        if (n5 == 7) {
                            ((Category)object2).updateBalance(null, split);
                        }
                        categoryStore.saveExistingCategory((Category)object2);
                    }
                } else if (!transaction.transferFlag) {
                    Category category = categoryStore.getCategoryFromName(transaction.category);
                    if (n5 == 7) {
                        category.updateBalance(null, transaction);
                    }
                    categoryStore.saveExistingCategory(category);
                }
                transactionStore.deleteTransaction(transaction);
                transactionStore.deleteIndex(transaction);
                transactionStore.setIndex((Account)object4);
                object4 = accountStore.getAccountFromName(((Account)object4).name);
                if (n5 == 7) {
                    ((Account)object4).updateBalance(null, transaction, this.parent.todayDays);
                }
                accountStore.saveExistingAccount((Account)object4);
                continue block12;
            }
        }
        try {
            if (this.fc.exists()) {
                this.dis.close();
                this.fc.delete();
            }
        }
        catch (IOException iOException) {
            this.alert.setString("Error closing Jabp.sync");
            this.display.setCurrent(this.alert, (Displayable)this);
            return;
        }
        this.show("Writing JabpLite.sync");
        try {
            this.fc = (FileConnection)Connector.open((String)("file:///" + this.root + this.directory + "JabpLite.sync"));
            if (!this.fc.exists()) {
                this.fc.create();
            }
            object = this.fc.openOutputStream(32000L);
            this.dos = new DataOutputStream((OutputStream)object);
        }
        catch (IOException iOException) {
            this.alert.setString("Error opening JabpLite.sync");
            this.display.setCurrent(this.alert, (Displayable)this);
            return;
        }
        catch (SecurityException securityException) {
            this.alert.setString("Security error opening JabpLite.sync");
            this.display.setCurrent(this.alert, (Displayable)this);
            return;
        }
        object = new SyncStore(this.parent);
        int n11 = ((SyncStore)object).getNumSyncRecords();
        if (n11 != ((SyncStore)object).ht.size()) {
            ((SyncStore)object).ht = new Hashtable();
            RecordEnumeration recordEnumeration = ((SyncStore)object).getSyncRecords();
            n = 0;
            while (recordEnumeration.hasNextElement()) {
                try {
                    n = recordEnumeration.nextRecordId();
                }
                catch (RecordStoreException recordStoreException) {
                    System.err.println((Object)((Object)recordStoreException) + " sync");
                }
                byArray = ((SyncStore)object).getSyncRecord(n);
                long l = ((SyncStore)object).getTimeCreated(byArray);
                ((SyncStore)object).addIndex(l, n);
            }
            recordEnumeration.destroy();
            recordEnumeration = null;
        }
        for (int i = 0; i < n11; ++i) {
            byArray = ((SyncStore)object).getSyncRecordFromIndex(i);
            ((SyncStore)object).deleteSyncRecordFromIndex(i);
            this.sendRecord(byArray);
            if (++n3 / 20 * 20 != n3) continue;
            this.show(n3 + " records read");
        }
        try {
            this.dos.close();
        }
        catch (IOException iOException) {
            this.alert.setString("Error closing JabpLite.sync");
            this.display.setCurrent(this.alert, (Displayable)this);
            return;
        }
        ((SyncStore)object).closeSyncStore();
        accountStore.closeAccountStore();
        categoryStore.closeCategoryStore();
        currencyStore.closeCurrencyStore();
        investmentStore.closeInvestmentStore();
        regularStore.closeRegularStore();
        standingOrderStore.closeStandingOrderStore();
        transactionStore.closeTransactionStore();
        this.show("Finished");
        Alert alert = new Alert("User Information");
        alert.setString(n2 + " imported, " + n3 + " exported");
        if (!this.showNextSteps) {
            this.append("\nNext steps:\n1. Connect phone to desktop as USB drive\n2. Run Jabp\n3. Go to File>Sync JabpLite");
            this.showNextSteps = true;
        }
        this.display.setCurrent(alert, (Displayable)this);
    }

    void importQIF(String string) {
        String string2;
        int n;
        int n2;
        block53: {
            if (string.equals("")) {
                return;
            }
            n2 = this.qifDateFormat;
            n = 0;
            this.eofflag = false;
            this.show("Importing " + string);
            try {
                this.fc = (FileConnection)Connector.open((String)("file:///" + this.root + this.directory + string + ".qif"), (int)1);
                if (!this.fc.exists()) {
                    this.show("QIF file does not exist");
                    return;
                }
                this.in = this.fc.openInputStream();
                try {
                    if (this.useUTF8) {
                        this.isr = new InputStreamReader(this.in, "UTF8");
                        break block53;
                    }
                    this.isr = new InputStreamReader(this.in);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println("UTF8 not supported");
                    this.isr = new InputStreamReader(this.in);
                }
            }
            catch (IOException iOException) {
                this.showError("importQIF", iOException.toString());
                return;
            }
            catch (SecurityException securityException) {
                this.showError("importQIF", securityException.toString());
                return;
            }
        }
        AccountStore accountStore = new AccountStore(this.parent);
        Account account = accountStore.getAccountFromName(string);
        CategoryStore categoryStore = new CategoryStore(this.parent);
        TransactionStore transactionStore = new TransactionStore(this.parent, account);
        CurrencyStore currencyStore = new CurrencyStore(this.parent);
        Currency currency = currencyStore.getCurrencyFromName(account.currency);
        currencyStore.closeCurrencyStore();
        currencyStore = null;
        do {
            string2 = this.receiveText();
            if (!this.eofflag) continue;
            return;
        } while (string2.length() <= 0);
        if (string2.indexOf("!") < 0) {
            return;
        }
        while (true) {
            Object object;
            int n3;
            if (transactionStore.getSizeAvailable() <= 1000) {
                this.alert.setType(AlertType.ERROR);
                this.alert.setTimeout(-2);
                this.alert.setString(this.outOfSpaceMessage());
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
            Transaction transaction = new Transaction();
            transaction.account = account.name;
            Split split = new Split();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            while (true) {
                Account account2;
                string2 = this.receiveText();
                if (this.eofflag) break;
                if (string2.length() == 0) continue;
                String string3 = string2.substring(0, 1);
                String string4 = string2.substring(1, string2.length());
                if (string3.equals("^")) break;
                if (string3.equals("P")) {
                    transaction.description = string4;
                }
                if (string3.equals("M")) {
                    transaction.reference = string4;
                }
                if (string3.equals("T")) {
                    transaction.amount = Utilities.stringToNumber(string4, 0, false, this.isEuropeanNumberFormat);
                }
                if (string3.equals("L")) {
                    if (string4.startsWith("[")) {
                        account2 = accountStore.getAccountFromName(string4.substring(1, string4.length() - 1));
                        transaction.transferAccount = account2.name;
                        transaction.transferFlag = true;
                    } else {
                        transaction.category = categoryStore.getCategoryFromName((String)string4).name;
                    }
                }
                if (string3.equals("D")) {
                    int n4 = 0;
                    n3 = 0;
                    object = "";
                    String string5 = "";
                    string4 = string4.replace(' ', '0');
                    string4 = string4.replace('.', '/');
                    if (n2 < 6) {
                        n4 = string4.indexOf("/");
                        n3 = this.lastIndexOf(string4, "'");
                        if (n3 == -1) {
                            n3 = this.lastIndexOf(string4, "/");
                        }
                        if (n4 == -1 || n3 == -1 || n4 == n3) {
                            System.out.println("Bad date in import file: " + string4);
                            return;
                        }
                        object = string4.substring(0, n4);
                        if (n4 == 1) {
                            object = "0" + string4.substring(0, n4);
                        }
                        string5 = string4.substring(n4 + 1, n3);
                        if (n3 - n4 == 2) {
                            string5 = "0" + string4.substring(n4 + 1, n3);
                        }
                    }
                    if (n2 < 4) {
                        string4 = (String)object + "/" + string5 + "/" + string4.substring(n3 + 1, n3 + 3);
                    }
                    if (n2 > 3 && n2 < 6) {
                        string4 = (String)object + "/" + string5 + "/" + string4.substring(n3 + 1, n3 + 5);
                    }
                    if (n2 == 6) {
                        // empty if block
                    }
                    if (n2 == 0 || n2 == 2) {
                        this.cal.set(5, this.getInt(string4.substring(0, 2)));
                        this.cal.set(2, this.getInt(string4.substring(3, 5)) - 1);
                        this.cal.set(1, this.getInt("20" + string4.substring(6, 8)));
                    }
                    if (n2 == 1 || n2 == 3) {
                        this.cal.set(2, this.getInt(string4.substring(0, 2)) - 1);
                        this.cal.set(5, this.getInt(string4.substring(3, 5)));
                        this.cal.set(1, this.getInt("20" + string4.substring(6, 8)));
                    }
                    if (n2 == 4) {
                        this.cal.set(5, this.getInt(string4.substring(0, 2)));
                        this.cal.set(2, this.getInt(string4.substring(3, 5)) - 1);
                        this.cal.set(1, this.getInt(string4.substring(6, 10)));
                    }
                    if (n2 == 5) {
                        this.cal.set(2, this.getInt(string4.substring(0, 2)) - 1);
                        this.cal.set(5, this.getInt(string4.substring(3, 5)));
                        this.cal.set(1, this.getInt(string4.substring(6, 10)));
                    }
                    if (n2 == 6) {
                        this.cal.set(1, this.getInt(string4.substring(0, 4)));
                        this.cal.set(2, this.getInt(string4.substring(5, 7)) - 1);
                        this.cal.set(5, this.getInt(string4.substring(8, 10)));
                    }
                    transaction.longDate = this.cal.getTime().getTime();
                }
                if (string3.equals("C") && !string4.equals("")) {
                    transaction.reconciled = true;
                }
                if (string3.equals("S")) {
                    if (string4.startsWith("[")) {
                        account2 = accountStore.getAccountFromName(string4.substring(1, string4.length() - 1));
                        split.category = categoryStore.getCategoryFromName((String)"SplitTransfer").name;
                    } else {
                        split.category = categoryStore.getCategoryFromName((String)string4).name;
                    }
                    bl3 = true;
                }
                if (string3.equals("E")) {
                    bl2 = true;
                }
                if (string3.equals("$")) {
                    split.amount = Utilities.stringToNumber(string4, 0, false, this.isEuropeanNumberFormat);
                    bl = true;
                }
                if (!bl3 || !bl2 || !bl) continue;
                transaction.splitFlag = true;
                if (transaction.ss == null) {
                    transaction.ss = new SplitStore();
                }
                transaction.ss.addSplit(split);
                split = new Split();
                bl = false;
                bl2 = false;
                bl3 = false;
            }
            if (this.eofflag) break;
            if (!account.currency.equals(this.parent.homeCurrency)) {
                transaction.reference = transaction.reference.equals("") ? account.currency + " " + Utilities.numberToString(Math.abs(transaction.amount), false, this.isEuropeanNumberFormat, this.isGroupingUsed) : account.currency + " " + Utilities.numberToString(Math.abs(transaction.amount), false, this.isEuropeanNumberFormat, this.isGroupingUsed) + "|" + transaction.reference;
                transaction.amount = Utilities.foreignToHome(transaction.amount, currency.rate);
                if (transaction.category.equals("Split")) {
                    int n5 = transaction.ss.size();
                    for (n3 = 0; n3 < n5; ++n3) {
                        split = transaction.ss.getSplit(n3);
                        split.amount = Utilities.foreignToHome(split.amount, currency.rate);
                        transaction.ss.setSplit(split, n3);
                    }
                }
            }
            if (transaction.description.toLowerCase().startsWith("opening balance")) {
                if (!this.exportOpeningBalance) continue;
                account.current += transaction.amount - account.open;
                account.today += transaction.amount - account.open;
                account.reconciled += transaction.amount - account.open;
                account.open = transaction.amount;
                accountStore.saveExistingAccount(account);
                continue;
            }
            if (transaction.category.equals("") && !transaction.transferFlag & !transaction.splitFlag) {
                Category category = categoryStore.getCategoryFromName("None");
                transaction.category = category.name;
            }
            if (transaction.splitFlag) {
                for (int i = 0; i < transaction.ss.size(); ++i) {
                    split = transaction.ss.getSplit(i);
                    Category category = categoryStore.getCategoryFromName(split.category);
                    category.updateBalance(split, null);
                    categoryStore.saveExistingCategory(category);
                }
            }
            if (transaction.transferFlag && transaction.description.equals("")) {
                transaction.description = transaction.transferAccount + " (transfer)";
            }
            if (transactionStore.isDuplicateTransfer(transaction) || transaction.transferFlag && !this.includeTransfers) continue;
            transaction.id = transactionStore.saveNewTransaction(transaction);
            if (++n == n / 50 * 50) {
                this.show(n + " transactions");
            }
            account.updateBalance(transaction, null, this.todayDays);
            accountStore.saveExistingAccount(account);
            if (!transaction.splitFlag && !transaction.transferFlag) {
                Category category = categoryStore.getCategoryFromName(transaction.category);
                category.updateBalance(transaction, null);
                categoryStore.saveExistingCategory(category);
            }
            if (!transaction.transferFlag) continue;
            Transaction transaction2 = new Transaction();
            transaction2 = transaction2.clone(transaction);
            transaction2.amount = -transaction.amount;
            transaction2.transferAccount = account.name;
            transaction2.transferAccountId = transaction.id;
            transaction2.transferFlag = true;
            transaction2.account = transaction.transferAccount;
            if (transaction2.description.equals("")) {
                transaction2.description = transaction2.transferAccount + " (transfer)";
            }
            Account account3 = accountStore.getAccountFromName(transaction2.account);
            object = new TransactionStore(this.parent, account3);
            transaction.transferAccountId = transaction2.id = ((TransactionStore)object).saveNewTransaction(transaction2);
            ((TransactionStore)object).closeTransactionStore();
            object = null;
            transactionStore.saveExistingTransaction(transaction);
            account3.updateBalance(transaction2, null, this.todayDays);
            accountStore.saveExistingAccount(account3);
        }
        transactionStore.closeTransactionStore();
        categoryStore.closeCategoryStore();
        accountStore.closeAccountStore();
        try {
            this.in.close();
            this.fc.close();
        }
        catch (IOException iOException) {
            this.showError("importQIF", iOException.toString());
            return;
        }
        this.show("Finished importing file");
        this.display.setCurrent((Displayable)this);
    }

    void importOFX(String string) {
        int n;
        block23: {
            if (string.equals("")) {
                return;
            }
            n = 0;
            this.eofflag = false;
            this.show("Importing " + string);
            try {
                this.fc = (FileConnection)Connector.open((String)("file:///" + this.root + this.directory + string + ".ofx"), (int)1);
                if (!this.fc.exists()) {
                    this.fc = (FileConnection)Connector.open((String)("file:///" + this.root + this.directory + string + ".ofc"), (int)1);
                    if (!this.fc.exists()) {
                        this.show("OFX/OFC file does not exist");
                        return;
                    }
                }
                this.in = this.fc.openInputStream();
                try {
                    if (this.useUTF8) {
                        this.isr = new InputStreamReader(this.in, "UTF8");
                        break block23;
                    }
                    this.isr = new InputStreamReader(this.in);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println("UTF8 not supported");
                    this.isr = new InputStreamReader(this.in);
                }
            }
            catch (IOException iOException) {
                this.showError("importOFX", iOException.toString());
                return;
            }
            catch (SecurityException securityException) {
                this.showError("importOFX", securityException.toString());
                return;
            }
        }
        AccountStore accountStore = new AccountStore(this.parent);
        Account account = accountStore.getAccountFromName(string);
        CategoryStore categoryStore = new CategoryStore(this.parent);
        TransactionStore transactionStore = new TransactionStore(this.parent, account);
        CurrencyStore currencyStore = new CurrencyStore(this.parent);
        Currency currency = currencyStore.getCurrencyFromName(account.currency);
        currencyStore.closeCurrencyStore();
        currencyStore = null;
        while (true) {
            if (transactionStore.getSizeAvailable() <= 1000) {
                this.alert.setType(AlertType.ERROR);
                this.alert.setTimeout(-2);
                this.alert.setString(this.outOfSpaceMessage());
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
            String string2 = this.receiveText();
            if (this.eofflag) break;
            if (string2.length() == 0 || string2.indexOf("<STMTTRN>") < 0) continue;
            Transaction transaction = new Transaction();
            transaction.reconciled = true;
            transaction.account = account.name;
            while (true) {
                int n2;
                int n3;
                string2 = this.receiveText();
                if (this.eofflag) break;
                if (string2.length() == 0) continue;
                if (string2.indexOf("</STMTTRN>") >= 0) break;
                if (string2.indexOf("<NAME>") >= 0) {
                    n3 = string2.indexOf("<NAME>");
                    n2 = string2.indexOf("</NAME>");
                    if (n2 < 0) {
                        n2 = string2.length();
                    }
                    transaction.description = string2.substring(n3 + 6, n2);
                }
                if (string2.indexOf("<MEMO>") >= 0) {
                    n3 = string2.indexOf("<MEMO>");
                    n2 = string2.indexOf("</MEMO>");
                    if (n2 < 0) {
                        n2 = string2.length();
                    }
                    transaction.reference = string2.substring(n3 + 6, n2);
                }
                if (string2.indexOf("<TRNAMT>") >= 0) {
                    n3 = string2.indexOf("<TRNAMT>");
                    n2 = string2.indexOf("</TRNAMT>");
                    if (n2 < 0) {
                        n2 = string2.length();
                    }
                    transaction.amount = Utilities.stringToNumber(string2.substring(n3 + 8, n2), 0, false, this.isEuropeanNumberFormat);
                }
                if (string2.indexOf("<DTPOSTED>") < 0) continue;
                n3 = string2.indexOf("<DTPOSTED>");
                String string3 = string2.substring(n3 + 10, n3 + 18);
                this.cal.set(1, this.getInt(string3.substring(0, 4)));
                this.cal.set(2, this.getInt(string3.substring(4, 6)) - 1);
                this.cal.set(5, this.getInt(string3.substring(6, 8)));
                transaction.longDate = this.cal.getTime().getTime();
            }
            if (this.eofflag) break;
            if (!account.currency.equals(this.parent.homeCurrency)) {
                transaction.reference = transaction.reference.equals("") ? account.currency + " " + Utilities.numberToString(Math.abs(transaction.amount), false, this.isEuropeanNumberFormat, this.isGroupingUsed) : account.currency + " " + Utilities.numberToString(Math.abs(transaction.amount), false, this.isEuropeanNumberFormat, this.isGroupingUsed) + "|" + transaction.reference;
                transaction.amount = Utilities.foreignToHome(transaction.amount, currency.rate);
            }
            if (transaction.category.equals("") && !transaction.transferFlag & !transaction.splitFlag) {
                Category category = categoryStore.getCategoryFromName("None");
                transaction.category = category.name;
            }
            transaction.id = transactionStore.saveNewTransaction(transaction);
            if (++n == n / 50 * 50) {
                this.show(n + " transactions");
            }
            account.updateBalance(transaction, null, this.todayDays);
            accountStore.saveExistingAccount(account);
            if (transaction.splitFlag || transaction.transferFlag) continue;
            Category category = categoryStore.getCategoryFromName(transaction.category);
            category.updateBalance(transaction, null);
            categoryStore.saveExistingCategory(category);
        }
        transactionStore.closeTransactionStore();
        categoryStore.closeCategoryStore();
        accountStore.closeAccountStore();
        try {
            this.in.close();
            this.fc.close();
        }
        catch (IOException iOException) {
            this.showError("importOFX", iOException.toString());
            return;
        }
        this.show("Finished importing file");
        this.display.setCurrent((Displayable)this);
    }

    void exportQIF(Account account, Date date, Date date2) {
        int n;
        block31: {
            n = 0;
            this.show("Exporting " + account.name);
            try {
                this.fc = (FileConnection)Connector.open((String)("file:///" + this.root + this.directory + account.name + ".qif"));
                if (this.fc.exists()) {
                    this.fc.delete();
                }
                this.fc.create();
                this.out = this.fc.openOutputStream();
                try {
                    if (this.useUTF8) {
                        this.out.write(-17);
                        this.out.write(-69);
                        this.out.write(-65);
                        this.osw = new OutputStreamWriter(this.out, "UTF8");
                        break block31;
                    }
                    this.osw = new OutputStreamWriter(this.out);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println("UTF8 not supported");
                    this.osw = new OutputStreamWriter(this.out);
                }
            }
            catch (IOException iOException) {
                this.showError("exportQIF", iOException.toString());
                return;
            }
            catch (SecurityException securityException) {
                this.showError("exportQIF", securityException.toString());
                return;
            }
        }
        TransactionStore transactionStore = new TransactionStore(this.parent, account);
        int n2 = transactionStore.getNumTransactions();
        CurrencyStore currencyStore = new CurrencyStore(this.parent);
        Currency currency = currencyStore.getCurrencyFromName(account.currency);
        currencyStore.closeCurrencyStore();
        currencyStore = null;
        String string = account.type;
        if (account.type.equals("Credit Card")) {
            string = "CCard";
        }
        if (account.type.equals("Asset")) {
            string = "Oth A";
        }
        if (account.type.equals("Liability")) {
            string = "Oth L";
        }
        this.exportLine("!Type:" + string);
        if (this.exportOpeningBalance) {
            Transaction transaction = new Transaction();
            if (n2 > 0) {
                transaction = transactionStore.getTransactionFromIndex(n2 - 1);
            } else {
                transaction.longDate = this.todayDate.getTime();
            }
            this.genericDate.setTime(transaction.longDate);
            this.exportLine("D" + this.setQIFDate(this.genericDate, this.qifDateFormat));
            this.exportLine("POpening Balance");
            if (!account.currency.equals(this.parent.homeCurrency)) {
                account.open = Utilities.homeToForeign(account.open, currency.rate);
            }
            this.exportLine("T" + Utilities.numberToString(account.open, false, this.isEuropeanNumberFormat, false));
            this.exportLine("Cx");
            this.exportLine("^");
        }
        long l = Utilities.longToDays(date.getTime());
        long l2 = Utilities.longToDays(date2.getTime());
        for (int i = n2 - 1; i >= 0; --i) {
            Object object;
            int n3;
            Transaction transaction = transactionStore.getTransactionFromIndex(i);
            long l3 = Utilities.longToDays(transaction.longDate);
            if (l3 < l || l3 > l2 || transaction.transferFlag && !this.includeTransfers) continue;
            this.genericDate.setTime(transaction.longDate);
            this.exportLine("D" + this.setQIFDate(this.genericDate, this.qifDateFormat));
            this.exportLine("P" + transaction.description);
            if (account.currency.equals(this.parent.homeCurrency)) {
                this.exportLine("T" + Utilities.numberToString(transaction.amount, false, this.isEuropeanNumberFormat, false));
            } else if (transaction.reference.startsWith(account.currency)) {
                String string2;
                n3 = transaction.reference.indexOf("|");
                object = "T";
                if (transaction.amount < 0) {
                    object = (String)object + "-";
                }
                if (n3 < 0) {
                    string2 = transaction.reference.substring(account.currency.length());
                    transaction.reference = "";
                } else {
                    string2 = transaction.reference.substring(account.currency.length(), n3);
                    transaction.reference = transaction.reference.substring(n3 + 1);
                }
                if (string2.startsWith(" ")) {
                    string2 = string2.substring(1);
                }
                this.exportLine((String)object + string2);
            }
            if (!transaction.reference.equals("")) {
                this.exportLine("M" + transaction.reference);
            }
            if (transaction.transferFlag) {
                this.exportLine("L[" + transaction.transferAccount + "]");
            } else if (transaction.splitFlag) {
                for (n3 = 0; n3 < transaction.ss.size(); ++n3) {
                    object = transaction.ss.getSplit(n3);
                    this.exportLine("S" + ((Split)object).category);
                    this.exportLine("E" + transaction.reference);
                    ((Split)object).amount = Utilities.homeToForeign(((Split)object).amount, currency.rate);
                    this.exportLine("$" + Utilities.numberToString(((Split)object).amount, false, this.isEuropeanNumberFormat, false));
                }
            } else {
                this.exportLine("L" + transaction.category);
            }
            if (transaction.reconciled) {
                this.exportLine("Cx");
            }
            this.exportLine("^");
            if (++n != n / 50 * 50) continue;
            this.show(n + " transactions");
        }
        transactionStore.closeTransactionStore();
        transactionStore = null;
        try {
            this.out.close();
            this.fc.close();
        }
        catch (IOException iOException) {
            this.showError("exportQIF", iOException.toString());
            return;
        }
        this.show("Finished exporting file");
    }

    void exportCSV(Account account, Date date, Date date2, int n, boolean bl) {
        int n2;
        int n3;
        block33: {
            this.exportFileType = n - 2;
            n3 = 0;
            n2 = 0;
            try {
                String string = "";
                if (bl) {
                    this.show("Exporting all accounts");
                    string = "Export";
                } else {
                    this.show("Exporting " + account.name);
                    string = account.name;
                }
                if (this.exportFileType == 0) {
                    string = string + ".csv";
                }
                if (this.exportFileType == 1) {
                    string = string + ".tab";
                }
                this.fc = (FileConnection)Connector.open((String)("file:///" + this.root + this.directory + string));
                if (this.fc.exists()) {
                    this.fc.delete();
                }
                this.fc.create();
                this.out = this.fc.openOutputStream();
                try {
                    if (this.useUTF8) {
                        this.out.write(-17);
                        this.out.write(-69);
                        this.out.write(-65);
                        this.osw = new OutputStreamWriter(this.out, "UTF8");
                        break block33;
                    }
                    this.osw = new OutputStreamWriter(this.out);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println("UTF8 not supported");
                    this.osw = new OutputStreamWriter(this.out);
                }
            }
            catch (IOException iOException) {
                this.showError("exportCSV", iOException.toString());
                return;
            }
            catch (SecurityException securityException) {
                this.showError("exportCSV", securityException.toString());
                return;
            }
        }
        this.writeStartLine();
        this.addString("Date", true);
        this.addString("Description", true);
        this.addString("Reference", true);
        this.addString("Category", true);
        this.addString("Amount", true);
        this.addString("Running Total", true);
        this.addString("Reconciled", true);
        this.addString("Account", false);
        this.exportLine(this.textLine);
        int n4 = 0;
        if (this.exportOpeningBalance) {
            if (bl) {
                AccountStore accountStore = new AccountStore(this.parent);
                n4 = accountStore.getNumAccounts();
                for (int i = 0; i < n4; ++i) {
                    account = accountStore.getAccountFromIndex(i);
                    n2 += account.open;
                }
                accountStore.closeAccountStore();
            } else {
                n2 = account.open;
            }
            this.writeStartLine();
            this.addString("", true);
            this.addString("Opening Balance", true);
            this.addString("", true);
            this.addString("", true);
            this.addString(Utilities.numberToString(n2, false, this.isEuropeanNumberFormat, false), true);
            this.addString(Utilities.numberToString(n2, false, this.isEuropeanNumberFormat, false), true);
            this.addString("Yes", true);
            if (bl) {
                this.addString("All Accounts", false);
            } else {
                this.addString(account.name, false);
            }
            this.exportLine(this.textLine);
        }
        long l = Utilities.longToDays(date.getTime());
        long l2 = Utilities.longToDays(date2.getTime());
        AccountStore accountStore = new AccountStore(this.parent);
        n4 = accountStore.getNumAccounts();
        for (int i = 0; i < n4; ++i) {
            if (bl) {
                account = accountStore.getAccountFromIndex(i);
            }
            TransactionStore transactionStore = new TransactionStore(this.parent, account);
            int n5 = transactionStore.getNumTransactions();
            for (int j = n5 - 1; j >= 0; --j) {
                Transaction transaction = transactionStore.getTransactionFromIndex(j);
                long l3 = Utilities.longToDays(transaction.longDate);
                if (l3 < l || l3 > l2 || transaction.transferFlag && !this.includeTransfers) continue;
                if (this.separateSplits && transaction.splitFlag) {
                    for (int k = 0; k < transaction.ss.size(); ++k) {
                        Split split = transaction.ss.getSplit(k);
                        this.writeStartLine();
                        this.genericDate.setTime(transaction.longDate);
                        this.addString(this.setQIFDate(this.genericDate, this.qifDateFormat), true);
                        this.addString(transaction.description, true);
                        this.addString(transaction.reference, true);
                        this.addString(split.category, true);
                        this.addString(Utilities.numberToString(split.amount, false, this.isEuropeanNumberFormat, false), true);
                        this.addString(Utilities.numberToString(n2 += split.amount, false, this.isEuropeanNumberFormat, false), true);
                        if (transaction.reconciled) {
                            this.addString("Yes", true);
                        } else {
                            this.addString("No", true);
                        }
                        this.addString(account.name, false);
                        this.exportLine(this.textLine);
                    }
                } else {
                    this.writeStartLine();
                    this.genericDate.setTime(transaction.longDate);
                    this.addString(this.setQIFDate(this.genericDate, this.qifDateFormat), true);
                    this.addString(transaction.description, true);
                    this.addString(transaction.reference, true);
                    if (transaction.transferFlag) {
                        this.addString("[" + transaction.transferAccount + "]", true);
                    } else if (transaction.splitFlag) {
                        this.addString("(Split)", true);
                    } else {
                        this.addString(transaction.category, true);
                    }
                    this.addString(Utilities.numberToString(transaction.amount, false, this.isEuropeanNumberFormat, false), true);
                    this.addString(Utilities.numberToString(n2 += transaction.amount, false, this.isEuropeanNumberFormat, false), true);
                    if (transaction.reconciled) {
                        this.addString("Yes", true);
                    } else {
                        this.addString("No", true);
                    }
                    this.addString(account.name, false);
                    this.exportLine(this.textLine);
                }
                if (++n3 != n3 / 50 * 50) continue;
                this.show(n3 + " transactions");
            }
            transactionStore.closeTransactionStore();
            transactionStore = null;
            if (!bl) break;
        }
        accountStore.closeAccountStore();
        accountStore = null;
        try {
            this.out.close();
            this.fc.close();
        }
        catch (IOException iOException) {
            this.showError("exportCSV", iOException.toString());
            return;
        }
        this.show("Finished exporting file");
    }

    void addString(String string, boolean bl) {
        this.textLine = this.textLine + string;
        if (this.exportFileType == 0) {
            this.textLine = bl ? this.textLine + "\",\"" : this.textLine + "\"";
        } else if (bl) {
            this.textLine = this.textLine + "\t";
        }
    }

    void writeStartLine() {
        this.textLine = "";
        if (this.exportFileType == 0) {
            this.textLine = this.textLine + "\"";
        }
    }

    int lastIndexOf(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        for (int i = n - n2; i > 0; --i) {
            if (!string.substring(i, i + string2.length()).equals(string2)) continue;
            return i;
        }
        return -1;
    }

    int getInt(String string) {
        Integer n = new Integer(0);
        n = Integer.valueOf(string);
        return n;
    }

    void exportLine(String string) {
        this.sndText(string);
    }

    void getDrives() {
        Enumeration enumeration = null;
        try {
            enumeration = FileSystemRegistry.listRoots();
        }
        catch (SecurityException securityException) {
            this.alert.setTimeout(3000);
            this.alert.setString("Cannot access files");
            this.display.setCurrent(this.alert, (Displayable)this);
        }
        this.drives = new String[10];
        int n = -1;
        while (enumeration.hasMoreElements()) {
            this.drives[++n] = (String)enumeration.nextElement();
        }
        this.numDrives = n + 1;
    }

    void getRoot() {
        block11: {
            try {
                this.rs = RecordStore.openRecordStore((String)"Directory", (boolean)true, (int)1, (boolean)true);
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " dir0");
                return;
            }
            try {
                if (this.rs.getNumRecords() == 0) {
                    this.getDrives();
                    this.root = this.drives[this.numDrives - 1];
                    for (int i = 0; i < this.numDrives; ++i) {
                        int n = this.numDrives - 1 - i;
                        String string = this.drives[n].toUpperCase();
                        if (string.startsWith("D:/")) {
                            this.root = string;
                        }
                        if (!string.startsWith("E:/")) continue;
                        this.root = string;
                    }
                    if (!this.root.endsWith("/")) {
                        this.root = this.root + "/";
                    }
                    this.directory = "";
                    Enumeration enumeration = null;
                    try {
                        this.fc = (FileConnection)Connector.open((String)("file:///" + this.root), (int)1);
                        enumeration = this.fc.list();
                        this.fc.close();
                    }
                    catch (IOException iOException) {
                        this.showError("getRoot", iOException.toString());
                        return;
                    }
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        if (!string.endsWith("/") || string.indexOf("DCIM") > -1) continue;
                        this.directory = string;
                        break block11;
                    }
                    break block11;
                }
                byte[] byArray = this.rs.getRecord(1);
                this.fromByteArray(byArray);
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " dir1");
            }
        }
    }

    void fromByteArray(byte[] byArray) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            this.root = dataInputStream.readUTF();
            this.directory = dataInputStream.readUTF();
            this.qifDateFormat = dataInputStream.readInt();
            this.useUTF8 = dataInputStream.readBoolean();
            this.lastExportedFromDate = dataInputStream.readLong();
            this.lastExportedAccount = dataInputStream.readUTF();
            this.exportOpeningBalance = dataInputStream.readBoolean();
            dataInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException + " dir3");
        }
    }

    byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeUTF(this.root);
            dataOutputStream.writeUTF(this.directory);
            dataOutputStream.writeInt(this.qifDateFormat);
            dataOutputStream.writeBoolean(this.useUTF8);
            dataOutputStream.writeLong(this.lastExportedFromDate);
            dataOutputStream.writeUTF(this.lastExportedAccount);
            dataOutputStream.writeBoolean(this.exportOpeningBalance);
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return byteArrayOutputStream.toByteArray();
    }

    void saveDirectory() {
        if (this.rs != null) {
            try {
                byte[] byArray = this.toByteArray();
                if (this.rs.getNumRecords() > 0) {
                    this.rs.setRecord(1, byArray, 0, byArray.length);
                } else {
                    this.rs.addRecord(byArray, 0, byArray.length);
                }
                this.rs.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " dir4");
            }
        }
    }

    String setQIFDate(Date date, int n) {
        String string = "/";
        if (n == 2 || n == 3) {
            string = ".";
        }
        this.cal.setTime(date);
        String string2 = "" + this.cal.get(5);
        if (string2.length() < 2) {
            string2 = "0" + string2;
        }
        int n2 = this.cal.get(2) + 1;
        String string3 = "" + n2;
        if (string3.length() < 2) {
            string3 = "0" + string3;
        }
        String string4 = ("" + this.cal.get(1)).substring(2, 4);
        if (n > 3) {
            string4 = "" + this.cal.get(1);
        }
        if (n == 6) {
            return string4 + "-" + string3 + "-" + string2;
        }
        if (n == 0 || n == 2 || n == 4) {
            return string2 + string + string3 + "'" + string4;
        }
        return string3 + string + string2 + "'" + string4;
    }

    void getExportQifOptions() {
        this.f1 = new Form("Import/Export QIF");
        this.cgAccount = new ChoiceGroup("Account", 1);
        AccountStore accountStore = new AccountStore(this.parent);
        int n = accountStore.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            Account account = accountStore.getAccountFromIndex(i);
            this.cgAccount.append(account.name, null);
            if (!account.name.equals(this.lastExportedAccount)) continue;
            this.cgAccount.setSelectedIndex(i, true);
        }
        this.cgAccount.append("All Accounts (export only)", null);
        this.f1.append((Item)this.cgAccount);
        accountStore.closeAccountStore();
        accountStore = null;
        this.df1 = new DateField("From Date", 1);
        this.df1.setDate(new Date(this.lastExportedFromDate));
        this.f1.append((Item)this.df1);
        this.df2 = new DateField("To Date", 1);
        this.df2.setDate(new Date());
        this.f1.append((Item)this.df2);
        this.cgDateType = new ChoiceGroup("Date Type", 1);
        this.cgDateType.append("dd/mm'yy", null);
        this.cgDateType.append("mm/dd'yy", null);
        this.cgDateType.append("dd.mm'yy", null);
        this.cgDateType.append("mm.dd'yy", null);
        this.cgDateType.append("dd/mm'yyyy", null);
        this.cgDateType.append("mm/dd'yyyy", null);
        this.cgDateType.append("yyyy-mm-dd", null);
        this.cgDateType.setSelectedIndex(this.qifDateFormat, true);
        this.f1.append((Item)this.cgDateType);
        this.cgIOB = new ChoiceGroup("Include opening balance", 1);
        this.cgIOB.append("Yes", null);
        this.cgIOB.append("No", null);
        if (!this.exportOpeningBalance) {
            this.cgIOB.setSelectedIndex(1, true);
        }
        this.f1.append((Item)this.cgIOB);
        this.cgIT = new ChoiceGroup("Include transfers", 1);
        this.cgIT.append("Yes", null);
        this.cgIT.append("No", null);
        this.f1.append((Item)this.cgIT);
        this.cgSS = new ChoiceGroup("Separate splits", 1);
        this.cgSS.append("Yes", null);
        this.cgSS.append("No", null);
        this.f1.append((Item)this.cgSS);
        this.cgET = new ChoiceGroup("File type", 1);
        this.cgET.append("QIF (Import/Export)", null);
        this.cgET.append("OFX/OFC (Import only)", null);
        this.cgET.append("CSV (Export only)", null);
        this.cgET.append("TAB (Export only)", null);
        this.f1.append((Item)this.cgET);
        this.cgUTF8 = new ChoiceGroup("Select ANSI or UTF8 format", 1);
        this.cgUTF8.append("ANSI", null);
        this.cgUTF8.append("UTF8", null);
        if (this.useUTF8) {
            this.cgUTF8.setSelectedIndex(1, true);
        }
        this.f1.append((Item)this.cgUTF8);
        this.f1.addCommand(this.importCommand);
        this.f1.addCommand(this.exportCommand);
        this.f1.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.f1);
    }

    void processImport() {
        this.display.setCurrent((Displayable)this.monitorConn);
        this.importData();
    }

    void importData() {
        Object object;
        byte[] byArray;
        int n;
        this.show("Started importing data");
        try {
            this.fc = (FileConnection)Connector.open((String)("file:///" + this.root + this.directory + "JabpLite.dat"), (int)1);
            if (!this.fc.exists()) {
                this.show("JabpLite.dat does not exist");
                return;
            }
            this.dis = this.fc.openDataInputStream();
        }
        catch (IOException iOException) {
            this.showError("importData", iOException.toString());
            return;
        }
        catch (SecurityException securityException) {
            this.showError("importData", securityException.toString());
            return;
        }
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        this.parent.accountHt = new Hashtable();
        this.parent.categoryHt = new Hashtable();
        this.parent.currencyHt = new Hashtable();
        this.parent.standingOrderHt = new Hashtable();
        this.parent.regularHt = new Hashtable();
        this.parent.investmentHt = new Hashtable();
        this.parent.transactionHt = new Hashtable();
        this.parent.syncHt = new Hashtable();
        AccountStore accountStore = new AccountStore(this.parent);
        CategoryStore categoryStore = new CategoryStore(this.parent);
        CurrencyStore currencyStore = new CurrencyStore(this.parent);
        StandingOrderStore standingOrderStore = new StandingOrderStore(this.parent);
        RegularStore regularStore = new RegularStore(this.parent);
        InvestmentStore investmentStore = new InvestmentStore(this.parent);
        TransactionStore transactionStore = new TransactionStore(this.parent, new Account());
        this.show("Deleting Previous Accounts");
        RecordEnumeration recordEnumeration = accountStore.getAccounts();
        while (recordEnumeration.hasNextElement()) {
            try {
                n = recordEnumeration.nextRecordId();
                Account account = accountStore.getAccount(n);
                accountStore.deleteAccount(account);
            }
            catch (RecordStoreException recordStoreException) {}
        }
        recordEnumeration.destroy();
        accountStore.deleteAllIndices();
        this.show("Loading Accounts");
        n = this.receiveNumber();
        for (int i = 0; i < n; ++i) {
            byArray = this.receiveRecord();
            object = accountStore.fromByteArray(byArray);
            accountStore.saveNewAccount((Account)object);
        }
        this.show("Deleting Previous Categories");
        recordEnumeration = categoryStore.getCategories();
        while (recordEnumeration.hasNextElement()) {
            try {
                int n2 = recordEnumeration.nextRecordId();
                object = categoryStore.getCategory(n2);
                categoryStore.deleteCategory((Category)object);
            }
            catch (RecordStoreException recordStoreException) {}
        }
        recordEnumeration.destroy();
        categoryStore.deleteAllIndices();
        this.show("Loading Categories");
        n = this.receiveNumber();
        for (int i = 0; i < n; ++i) {
            byArray = this.receiveRecord();
            object = categoryStore.fromByteArray(byArray);
            categoryStore.saveNewCategory((Category)object);
        }
        this.show("Deleting Previous Currencies");
        recordEnumeration = currencyStore.getCurrencies();
        while (recordEnumeration.hasNextElement()) {
            try {
                int n3 = recordEnumeration.nextRecordId();
                object = currencyStore.getCurrency(n3);
                currencyStore.deleteCurrency((Currency)object);
            }
            catch (RecordStoreException recordStoreException) {}
        }
        recordEnumeration.destroy();
        this.show("Loading Currencies");
        n = this.receiveNumber();
        for (int i = 0; i < n; ++i) {
            byArray = this.receiveRecord();
            object = currencyStore.fromByteArray(byArray);
            currencyStore.saveNewCurrency((Currency)object);
        }
        this.show("Deleting Previous Standing Orders");
        recordEnumeration = standingOrderStore.getStandingOrders();
        while (recordEnumeration.hasNextElement()) {
            try {
                int n4 = recordEnumeration.nextRecordId();
                object = standingOrderStore.getStandingOrder(n4);
                standingOrderStore.deleteStandingOrder((StandingOrder)object);
            }
            catch (RecordStoreException recordStoreException) {}
        }
        recordEnumeration.destroy();
        this.show("Loading Standing Orders");
        n = this.receiveNumber();
        for (int i = 0; i < n; ++i) {
            byArray = this.receiveRecord();
            object = standingOrderStore.fromByteArray(byArray);
            ((StandingOrder)object).longProcessingDate += this.hoursOffset;
            ((StandingOrder)object).longStartDate += this.hoursOffset;
            ((StandingOrder)object).longEndDate += this.hoursOffset;
            standingOrderStore.saveNewStandingOrder((StandingOrder)object);
        }
        this.show("Deleting Previous Regulars");
        recordEnumeration = regularStore.getRegulars();
        while (recordEnumeration.hasNextElement()) {
            try {
                int n5 = recordEnumeration.nextRecordId();
                object = regularStore.getRegular(n5);
                regularStore.deleteRegular((Regular)object);
            }
            catch (RecordStoreException recordStoreException) {}
        }
        recordEnumeration.destroy();
        this.show("Loading Regulars");
        n = this.receiveNumber();
        for (int i = 0; i < n; ++i) {
            byArray = this.receiveRecord();
            object = regularStore.fromByteArray(byArray);
            regularStore.saveNewRegular((Regular)object);
        }
        this.show("Deleting Previous Investments");
        recordEnumeration = investmentStore.getInvestments();
        while (recordEnumeration.hasNextElement()) {
            try {
                int n6 = recordEnumeration.nextRecordId();
                object = investmentStore.getInvestment(n6);
                investmentStore.deleteInvestment((Investment)object);
            }
            catch (RecordStoreException recordStoreException) {}
        }
        recordEnumeration.destroy();
        this.show("Loading Investments");
        n = this.receiveNumber();
        for (int i = 0; i < n; ++i) {
            byArray = this.receiveRecord();
            object = investmentStore.fromByteArray(byArray);
            ((Investment)object).priceLongDate += this.hoursOffset;
            investmentStore.saveNewInvestment((Investment)object);
        }
        this.show("Deleting Previous Transactions");
        recordEnumeration = transactionStore.getTransactions();
        while (recordEnumeration.hasNextElement()) {
            try {
                int n7 = recordEnumeration.nextRecordId();
                object = transactionStore.getTransaction(n7);
                transactionStore.deleteTransaction((Transaction)object);
            }
            catch (RecordStoreException recordStoreException) {}
        }
        recordEnumeration.destroy();
        this.show("Loading Transactions");
        n = this.receiveNumber();
        for (int i = 0; i < n; ++i) {
            int n8;
            if (transactionStore.getSizeAvailable() <= 1000) {
                this.alert.setType(AlertType.ERROR);
                this.alert.setTimeout(-2);
                this.alert.setString(this.outOfSpaceMessage());
                this.display.setCurrent(this.alert, (Displayable)this);
                return;
            }
            byArray = this.receiveRecord();
            object = transactionStore.fromByteArray(byArray);
            ((Transaction)object).longDate += this.hoursOffset;
            Account account = new Account();
            account.name = ((Transaction)object).account;
            transactionStore.getIndex(account);
            transactionStore.saveNewTransaction((Transaction)object);
            transactionStore.setIndex(account);
            if (((Transaction)object).transferFlag) {
                transactionStore.ht = hashtable.containsKey(((Transaction)object).account) ? (Hashtable)hashtable.get(((Transaction)object).account) : new Hashtable();
                transactionStore.addIndex((Transaction)object);
                hashtable.put(((Transaction)object).account, transactionStore.ht);
            }
            if ((n8 = i + 1) != n8 / 100 * 100) continue;
            this.show(n8 + " transactions");
        }
        this.show("Deleting Sync Records");
        SyncStore syncStore = new SyncStore(this.parent);
        if (syncStore.getNumSyncRecords() > 0) {
            recordEnumeration = syncStore.getSyncRecords();
            while (recordEnumeration.hasNextElement()) {
                try {
                    int n9 = recordEnumeration.nextRecordId();
                    syncStore.deleteSyncRecord(n9);
                }
                catch (RecordStoreException recordStoreException) {}
            }
            recordEnumeration.destroy();
            syncStore.closeSyncStore();
        }
        this.show("Loading Preferences");
        PreferenceStore preferenceStore = new PreferenceStore(this.parent);
        preferenceStore.getPreferences();
        byArray = this.receiveRecord();
        if (this.overwritePreferences) {
            preferenceStore.fromByteArray(byArray);
        } else {
            preferenceStore.getPasswordOnly(byArray);
        }
        preferenceStore.savePreferences();
        preferenceStore.closePreferenceStore();
        preferenceStore = null;
        try {
            this.dis.close();
            this.fc.close();
        }
        catch (IOException iOException) {
            this.showError("importData", iOException.toString());
            return;
        }
        this.show("Linking Transfers");
        boolean bl = false;
        Account account = new Account();
        n = accountStore.getNumAccounts();
        for (int i = 0; i < n; ++i) {
            Account account2 = accountStore.getAccountFromIndex(i);
            this.show(account2.name);
            if (!hashtable.containsKey(account2.name)) continue;
            transactionStore.ht = (Hashtable)hashtable.get(account2.name);
            int n10 = transactionStore.ht.size();
            block44: for (int j = 0; j < n10; ++j) {
                Transaction transaction = transactionStore.getTransactionFromIndex(j);
                if (transaction == null || !transaction.transferFlag || transaction.transferAccountId > 0 || transaction.account.equals(transaction.transferAccount) || !hashtable.containsKey(transaction.transferAccount)) continue;
                Hashtable hashtable2 = (Hashtable)hashtable.get(transaction.transferAccount);
                int n11 = hashtable2.size();
                long l = Utilities.longToDays(transaction.longDate);
                for (int k = 0; k < n11; ++k) {
                    LongId longId = (LongId)hashtable2.get(new Short((short)k));
                    if (l == Utilities.longToDays(longId.lo)) {
                        Transaction transaction2 = transactionStore.getTransaction(longId.id);
                        if (transaction2 == null || !transaction2.transferFlag) continue;
                        if (transaction.description.equals(transaction2.description) && transaction.amount == -transaction2.amount) {
                            transaction.transferAccountId = transaction2.id;
                            transactionStore.getIndex(account2);
                            int n12 = transactionStore.findIndex(transaction);
                            transactionStore.deleteTransaction(transaction);
                            transaction.id = transactionStore.saveNewTransactionWithoutIndex(transaction);
                            transactionStore.updateIndex(n12, transaction);
                            transactionStore.setIndex(account2);
                            transaction2.transferAccountId = transaction.id;
                            transactionStore.saveExistingTransaction(transaction2);
                            continue block44;
                        }
                    }
                    if (l > Utilities.longToDays(longId.lo)) continue block44;
                }
            }
        }
        hashtable = null;
        try {
            this.dis.close();
            this.fc.close();
        }
        catch (IOException iOException) {
            this.showError("importData", iOException.toString());
            return;
        }
        transactionStore.closeTransactionStore();
        transactionStore = null;
        investmentStore.closeInvestmentStore();
        investmentStore = null;
        regularStore.closeRegularStore();
        regularStore = null;
        standingOrderStore.closeStandingOrderStore();
        standingOrderStore = null;
        currencyStore.closeCurrencyStore();
        currencyStore = null;
        categoryStore.closeCategoryStore();
        categoryStore = null;
        accountStore.closeAccountStore();
        accountStore = null;
        if (this.importKeys) {
            try {
                this.fc = (FileConnection)Connector.open((String)("file:///" + this.root + this.directory + "JabpLite.key"), (int)1);
                if (!this.fc.exists()) {
                    this.show("JabpLite.key does not exist");
                    this.fc.close();
                    this.display.setCurrent((Displayable)this);
                    return;
                }
                this.dis = this.fc.openDataInputStream();
            }
            catch (IOException iOException) {
                this.showError("importData", iOException.toString());
                return;
            }
            catch (SecurityException securityException) {
                this.showError("importData", securityException.toString());
                return;
            }
            this.show("Loading Programmed Keys");
            KeyStore keyStore = new KeyStore(this.parent);
            byArray = this.receiveRecord();
            keyStore.fromByteArray(byArray);
            keyStore.saveKeys();
            keyStore.closeKeyStore();
            keyStore = null;
            this.parent.changedKeys = true;
            try {
                this.dis.close();
                this.fc.close();
            }
            catch (IOException iOException) {
                this.showError("importData", iOException.toString());
                return;
            }
        }
        this.show("Finished importing data");
        this.display.setCurrent((Displayable)this);
    }

    void exportData() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        this.show("Started exporting data");
        try {
            this.fc = (FileConnection)Connector.open((String)("file:///" + this.root + this.directory + "JabpLite.tmp"));
            if (this.fc.exists()) {
                this.fc.delete();
            }
            this.fc.create();
            this.dos = this.fc.openDataOutputStream();
        }
        catch (IOException iOException) {
            this.showError("exportData", iOException.toString());
            return;
        }
        catch (SecurityException securityException) {
            this.showError("exportData", securityException.toString());
            return;
        }
        this.show("Saving Accounts");
        AccountStore accountStore = new AccountStore(this.parent);
        int n = accountStore.getNumAccounts();
        this.sndNumber(accountStore.getNumAccounts());
        RecordEnumeration recordEnumeration = accountStore.getAccounts();
        int n2 = 0;
        while (recordEnumeration.hasNextElement()) {
            try {
                n2 = recordEnumeration.nextRecordId();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " in6");
            }
            object7 = accountStore.getAccount(n2);
            this.sndRecord(accountStore.toByteArray((Account)object7));
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        accountStore.closeAccountStore();
        accountStore = null;
        this.show("Saving Categories");
        object7 = new CategoryStore(this.parent);
        this.sndNumber(((CategoryStore)object7).getNumCategories());
        recordEnumeration = ((CategoryStore)object7).getCategories();
        n2 = 0;
        while (recordEnumeration.hasNextElement()) {
            try {
                n2 = recordEnumeration.nextRecordId();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " in6a");
            }
            object6 = ((CategoryStore)object7).getCategory(n2);
            this.sndRecord(((CategoryStore)object7).toByteArray((Category)object6));
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        ((CategoryStore)object7).closeCategoryStore();
        object7 = null;
        this.show("Saving Currencies");
        object6 = new CurrencyStore(this.parent);
        this.sndNumber(((CurrencyStore)object6).getNumCurrencies());
        recordEnumeration = ((CurrencyStore)object6).getCurrencies();
        n2 = 0;
        while (recordEnumeration.hasNextElement()) {
            try {
                n2 = recordEnumeration.nextRecordId();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " in6b");
            }
            object5 = ((CurrencyStore)object6).getCurrency(n2);
            this.sndRecord(((CurrencyStore)object6).toByteArray((Currency)object5));
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        ((CurrencyStore)object6).closeCurrencyStore();
        object6 = null;
        this.show("Saving Standing Orders");
        object5 = new StandingOrderStore(this.parent);
        this.sndNumber(((StandingOrderStore)object5).getNumStandingOrders());
        recordEnumeration = ((StandingOrderStore)object5).getStandingOrders();
        n2 = 0;
        while (recordEnumeration.hasNextElement()) {
            try {
                n2 = recordEnumeration.nextRecordId();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " in6c");
            }
            object4 = ((StandingOrderStore)object5).getStandingOrder(n2);
            this.sndRecord(((StandingOrderStore)object5).toByteArray((StandingOrder)object4));
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        ((StandingOrderStore)object5).closeStandingOrderStore();
        object5 = null;
        this.show("Saving Regulars");
        object4 = new RegularStore(this.parent);
        this.sndNumber(((RegularStore)object4).getNumRegulars());
        recordEnumeration = ((RegularStore)object4).getRegulars();
        n2 = 0;
        while (recordEnumeration.hasNextElement()) {
            try {
                n2 = recordEnumeration.nextRecordId();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " in6d");
            }
            object3 = ((RegularStore)object4).getRegular(n2);
            this.sndRecord(((RegularStore)object4).toByteArray((Regular)object3));
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        ((RegularStore)object4).closeRegularStore();
        object4 = null;
        this.show("Saving Investments");
        object3 = new InvestmentStore(this.parent);
        this.sndNumber(((InvestmentStore)object3).getNumInvestments());
        recordEnumeration = ((InvestmentStore)object3).getInvestments();
        n2 = 0;
        while (recordEnumeration.hasNextElement()) {
            try {
                n2 = recordEnumeration.nextRecordId();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " in6d");
            }
            object2 = ((InvestmentStore)object3).getInvestment(n2);
            this.sndRecord(((InvestmentStore)object3).toByteArray((Investment)object2));
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        ((InvestmentStore)object3).closeInvestmentStore();
        object3 = null;
        this.show("Saving Transactions");
        object2 = new TransactionStore(this.parent, new Account());
        this.sndNumber(((TransactionStore)object2).getNumAllTransactions());
        recordEnumeration = ((TransactionStore)object2).getTransactions();
        n2 = 0;
        int n3 = 0;
        while (recordEnumeration.hasNextElement()) {
            try {
                n2 = recordEnumeration.nextRecordId();
            }
            catch (RecordStoreException recordStoreException) {
                System.err.println((Object)((Object)recordStoreException) + " in6c");
            }
            object = ((TransactionStore)object2).getTransaction(n2);
            this.sndRecord(((TransactionStore)object2).toByteArray((Transaction)object));
            if (++n3 != n3 / 100 * 100) continue;
            this.show(n3 + " transactions");
        }
        recordEnumeration.destroy();
        recordEnumeration = null;
        ((TransactionStore)object2).closeTransactionStore();
        object2 = null;
        this.show("Saving Preferences");
        object = new PreferenceStore(this.parent);
        ((PreferenceStore)object).getPreferences();
        this.sndRecord(((PreferenceStore)object).toByteArray());
        ((PreferenceStore)object).closePreferenceStore();
        object = null;
        try {
            this.dos.close();
            this.fc1 = (FileConnection)Connector.open((String)("file:///" + this.root + this.directory + "JabpLite.dat"));
            if (this.fc1.exists()) {
                this.fc1.delete();
            }
            this.fc1.close();
            this.fc.rename("JabpLite.dat");
            this.fc.close();
        }
        catch (IOException iOException) {
            this.showError("exportData", iOException.toString());
            return;
        }
        if (this.exportKeys) {
            try {
                this.fc = (FileConnection)Connector.open((String)("file:///" + this.root + this.directory + "JabpLite.tmp"));
                if (this.fc.exists()) {
                    this.fc.delete();
                }
                this.fc.create();
                this.dos = this.fc.openDataOutputStream();
            }
            catch (IOException iOException) {
                this.showError("exportData", iOException.toString());
                return;
            }
            catch (SecurityException securityException) {
                this.showError("exportData", securityException.toString());
                return;
            }
            this.show("Saving Programmed Keys");
            KeyStore keyStore = new KeyStore(this.parent);
            keyStore.getKeys();
            this.sndRecord(keyStore.toByteArray());
            keyStore.closeKeyStore();
            keyStore = null;
            try {
                this.dos.close();
                this.fc1 = (FileConnection)Connector.open((String)("file:///" + this.root + this.directory + "JabpLite.key"));
                if (this.fc1.exists()) {
                    this.fc1.delete();
                }
                this.fc1.close();
                this.fc.rename("JabpLite.key");
                this.fc.close();
            }
            catch (IOException iOException) {
                this.showError("exportData", iOException.toString());
                return;
            }
        }
        this.show("Finished exporting data");
        this.display.setCurrent((Displayable)this);
    }

    void processExport() {
        int n;
        this.display.setCurrent((Displayable)this.monitorConn);
        this.exportOpeningBalance = true;
        this.includeTransfers = true;
        this.separateSplits = true;
        this.qifDateFormat = this.cgDateType.getSelectedIndex();
        this.useUTF8 = false;
        if (this.cgIOB.getSelectedIndex() == 1) {
            this.exportOpeningBalance = false;
        }
        if (this.cgIT.getSelectedIndex() == 1) {
            this.includeTransfers = false;
        }
        if (this.cgSS.getSelectedIndex() == 1) {
            this.separateSplits = false;
        }
        if (this.cgUTF8.getSelectedIndex() == 1) {
            this.useUTF8 = true;
        }
        int n2 = this.cgET.getSelectedIndex();
        this.lastExportedFromDate = this.df1.getDate().getTime();
        AccountStore accountStore = new AccountStore(this.parent);
        int n3 = this.cgAccount.getSelectedIndex();
        if (n3 < (n = accountStore.getNumAccounts())) {
            this.account = accountStore.getAccountFromIndex(n3);
            this.lastExportedAccount = this.account.name;
            if (this.label.equals("Export")) {
                if (n2 == 0) {
                    this.exportQIF(this.account, this.df1.getDate(), this.df2.getDate());
                } else {
                    this.exportCSV(this.account, this.df1.getDate(), this.df2.getDate(), n2, false);
                }
            }
            if (this.label.equals("Import")) {
                this.exportAccount = this.account.name;
                if (n2 == 0) {
                    this.importQIF(this.exportAccount);
                } else {
                    this.importOFX(this.exportAccount);
                }
                accountStore.closeAccountStore();
                accountStore = null;
                return;
            }
        } else if (n2 == 0) {
            for (int i = 0; i < n; ++i) {
                this.account = accountStore.getAccountFromIndex(i);
                this.exportQIF(this.account, this.df1.getDate(), this.df2.getDate());
            }
        } else {
            this.exportCSV(new Account(), this.df1.getDate(), this.df2.getDate(), n2, true);
        }
        accountStore.closeAccountStore();
        accountStore = null;
        this.display.setCurrent((Displayable)this);
    }

    void setDirectory() {
        Enumeration enumeration = null;
        this.f3 = new Form("Set Directory");
        try {
            this.fc = (FileConnection)Connector.open((String)("file:///" + this.root), (int)1);
            enumeration = this.fc.list();
            this.fc.close();
        }
        catch (IOException iOException) {
            this.showError("setDirectory", iOException.toString());
            return;
        }
        this.cgDirectory = new ChoiceGroup("Directory", 1);
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.endsWith("/")) continue;
            this.cgDirectory.append(string, null);
            if (string.equals(this.directory)) {
                this.cgDirectory.setSelectedIndex(n, true);
            }
            ++n;
        }
        if (n == 0) {
            this.showError("setDirectory", "No directories found");
            return;
        }
        this.f3.append((Item)this.cgDirectory);
        this.f3.addCommand(this.parent.okCommand);
        this.f3.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.f3);
    }

    void setDrive() {
        this.getDrives();
        this.f5 = new Form("Set Drive");
        this.cgDrive = new ChoiceGroup("Drive", 1);
        for (int i = 0; i < this.numDrives; ++i) {
            this.cgDrive.append(this.drives[i], null);
        }
        this.cgDrive.setSelectedIndex(this.numDrives - 1, true);
        this.f5.append((Item)this.cgDrive);
        this.f5.addCommand(this.parent.okCommand);
        this.f5.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.f5);
    }

    void showError(String string, String string2) {
        this.showError = new Form("File error");
        this.showError.append("Module: " + string + "\n");
        this.showError.append("Root: " + this.root + "\n");
        this.showError.append("Directory: " + this.directory + "\n");
        this.showError.append("Error: " + string2 + "\n\n");
        this.showError.append("Pausing for 10 secs");
        this.display.setCurrent((Displayable)this.showError);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.display.setCurrent((Displayable)this);
    }

    public void commandAction(Command command, Displayable displayable) {
        Object object;
        this.label = command.getLabel();
        if (this.label.equals("Exit")) {
            this.parent.destroyApp(true);
        }
        if (this.label.equals("Main")) {
            if (this.parent.cv != null) {
                this.parent.cv = null;
            }
            if (this.parent.ccyv != null) {
                this.parent.ccyv = null;
            }
            if (this.parent.sov != null) {
                this.parent.sov = null;
            }
            if (this.parent.iv != null) {
                this.parent.iv = null;
            }
            if (this.parent.tv != null) {
                this.parent.tv = null;
            }
            this.parent.av.resetDisplay();
            this.display.setCurrent((Displayable)this.parent.av);
        }
        if (displayable == this.showError) {
            this.display.setCurrent((Displayable)this);
            return;
        }
        if (displayable == this && this.label.equals("Action")) {
            if (this.cgOption.getSelectedIndex() == 0) {
                this.runMode = 8;
                object = new Thread(this);
                ((Thread)object).start();
            }
            if (this.cgOption.getSelectedIndex() == 1) {
                this.getExportQifOptions();
            }
            if (this.cgOption.getSelectedIndex() == 2) {
                this.f2 = new Form("Import options");
                this.tf = new TextField("Offset in hours", "0", 3, 2);
                this.f2.append((Item)this.tf);
                this.cgPreferences = new ChoiceGroup("Preferences", 1);
                this.cgPreferences.append("Keep", null);
                this.cgPreferences.append("Overwrite", null);
                this.f2.append((Item)this.cgPreferences);
                this.cgKeys = new ChoiceGroup("Import Keys", 1);
                this.cgKeys.append("No", null);
                this.cgKeys.append("Yes", null);
                this.f2.append((Item)this.cgKeys);
                this.f2.addCommand(this.parent.okCommand);
                this.f2.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.f2);
            }
            if (this.cgOption.getSelectedIndex() == 3) {
                this.f6 = new Form("Export options");
                this.cgKeys = new ChoiceGroup("Export Keys", 1);
                this.cgKeys.append("No", null);
                this.cgKeys.append("Yes", null);
                this.f6.addCommand(this.parent.okCommand);
                this.f6.append((Item)this.cgKeys);
                this.f6.setCommandListener((CommandListener)this);
                this.display.setCurrent((Displayable)this.f6);
            }
            if (this.cgOption.getSelectedIndex() == 4) {
                this.runMode = 1;
                object = new Thread(this);
                ((Thread)object).start();
            }
            if (this.cgOption.getSelectedIndex() == 5) {
                this.runMode = 7;
                object = new Thread(this);
                ((Thread)object).start();
            }
        }
        if (displayable == this.f1) {
            this.runMode = 2;
            object = new Thread(this);
            ((Thread)object).start();
        }
        if (displayable == this.f2) {
            object = new Integer(0);
            this.hoursOffset = Integer.valueOf(this.tf.getString()).intValue();
            this.hoursOffset *= 3600000L;
            if (this.cgPreferences.getSelectedIndex() > 0) {
                this.overwritePreferences = true;
            }
            if (this.cgKeys.getSelectedIndex() > 0) {
                this.importKeys = true;
            }
            this.display.setCurrent((Displayable)this.monitorConn);
            this.runMode = 4;
            Thread thread = new Thread(this);
            thread.start();
        }
        if (displayable == this.f3) {
            this.directory = this.cgDirectory.getString(this.cgDirectory.getSelectedIndex());
            if (!this.directory.endsWith("/")) {
                this.directory = this.directory + "/";
            }
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.f4) {
            if (this.txf.getString().equals(this.password)) {
                this.display.setCurrent((Displayable)this);
            } else {
                object = new Alert("Password error");
                object.setTimeout(1500);
                object.setType(AlertType.ERROR);
                this.display.setCurrent((Alert)object, (Displayable)this.f4);
                ++this.passwordError;
                if (this.passwordError == 3) {
                    this.parent.destroyApp(true);
                }
            }
        }
        if (displayable == this.f5) {
            this.root = this.cgDrive.getString(this.cgDrive.getSelectedIndex());
            if (!this.root.endsWith("/")) {
                this.root = this.root + "/";
            }
            this.display.setCurrent((Displayable)this);
        }
        if (displayable == this.f6) {
            if (this.cgKeys.getSelectedIndex() > 0) {
                this.exportKeys = true;
            }
            this.display.setCurrent((Displayable)this.monitorConn);
            this.runMode = 3;
            object = new Thread(this);
            ((Thread)object).start();
        }
    }

    String receiveText() {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            try {
                n = this.isr.read();
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
            if (n < 0) {
                this.eofflag = true;
                break;
            }
            char c = (char)n;
            if (c == '\r') continue;
            if (c == '\n') break;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    byte[] receiveRecord() {
        int n = this.receiveNumber();
        byte[] byArray = new byte[n];
        try {
            this.dis.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        return byArray;
    }

    int receiveNumber() {
        try {
            return this.dis.readInt();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            return -1;
        }
    }

    long receiveLong() {
        try {
            return this.dis.readLong();
        }
        catch (IOException iOException) {
            this.eofflag = true;
            return -1L;
        }
    }

    void show(String string) {
        this.monitorConn.append(string, null);
        if (!this.parent.isAndroid) {
            this.monitorConn.setSelectedIndex(this.monitorConn.size() - 1, true);
        }
    }

    public void printString(String string) {
        System.out.println(string);
    }

    String outOfSpaceMessage() {
        return "There is no space to add more records. Delete some transactions, then use Extra Options>Regenerate.";
    }
}

