/*
 * Decompiled with CFR 0.152.
 */
package dogada.me.test;

import dogada.me.test.FPSTest;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DrawImageTest
extends FPSTest {
    private static final String imgDir = "/img/";
    private static final int maxImages = 20;
    private int imageIndex = -1;
    private Image[] images;

    public void init(Display display, Displayable next) {
        super.init(display, next);
        Vector<Image> buf = new Vector<Image>();
        int i = 0;
        try {
            while (i < 20) {
                Image image = Image.createImage((String)(imgDir + i++ + ".png"));
                buf.addElement(image);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.images = new Image[buf.size()];
        buf.copyInto(this.images);
        if (this.images.length > 0) {
            this.imageIndex = this.images.length / 2;
        }
    }

    protected void paint(Graphics g) {
        int x = g.getClipX();
        int y = g.getClipY();
        int w = g.getClipWidth();
        int h = g.getClipHeight();
        int x2 = x + w;
        int y2 = y + h;
        String mes = null;
        long paintTime = System.currentTimeMillis();
        int drawCount = 0;
        if (this.imageIndex > -1) {
            Image image = this.images[this.imageIndex];
            int iw = image.getWidth();
            int ih = image.getHeight();
            int anchor = 20;
            int xi = x;
            while (xi < x2) {
                int yi = y;
                while (yi < y2) {
                    g.drawImage(image, xi, yi, anchor);
                    ++drawCount;
                    yi += ih;
                }
                xi += iw;
            }
            paintTime = System.currentTimeMillis() - paintTime;
            mes = iw + "x" + ih + "x" + drawCount + "=" + paintTime + "\u043c\u0441";
        } else {
            g.setColor(0xFF0000);
            g.fillRect(x, y, w, h);
            mes = "\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f!";
            this.pause();
        }
        this.drawInfo(mes, g, x, y, x2, y2);
        super.paint(g);
    }

    public String getHelp() {
        String helpStr = "\u0412\u0432\u0435\u0440\u0445/\u0412\u043d\u0438\u0437 - \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u044f\n\u0412\u044b\u0431\u043e\u0440 - \u041f\u043e\u043a\u0430\u0437\u0430\u0442\u044c/\u0441\u043a\u0440\u044b\u0442\u044c fps";
        return helpStr;
    }

    protected void handleKey(int keyCode) {
        if (this.images.length > 0) {
            int action = this.getGameAction(keyCode);
            switch (action) {
                case 1: {
                    ++this.imageIndex;
                    if (this.imageIndex >= this.images.length) {
                        this.imageIndex = 0;
                    }
                    this.reset();
                    break;
                }
                case 6: {
                    --this.imageIndex;
                    if (this.imageIndex < 0) {
                        this.imageIndex = this.images.length - 1;
                    }
                    this.reset();
                    break;
                }
                default: {
                    super.handleKey(keyCode);
                }
            }
        }
    }
}

