/*
 * Decompiled with CFR 0.152.
 */
package dogada.me.test;

import dogada.me.test.TestCanvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class FontTest
extends TestCanvas {
    private int[] faces = new int[]{64, 32, 0};
    private String[] faceNames = new String[]{"\u043f\u0440\u043e\u043f\u043e\u0440\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439", "\u043c\u043e\u043d\u043e\u0448\u0438\u0440\u0438\u043d\u043d\u044b\u0439", "\u0441\u0438\u0441\u0442\u0435\u043c\u043d\u044b\u0439"};
    private int[] styles = new int[]{0, 1, 2, 0, 4};
    private String[] styleNames = new String[]{"\u0440\u043e\u0432\u043d\u044b\u0439", "\u0436\u0438\u0440\u043d\u044b\u0439", "\u043a\u0443\u0440\u0441\u0438\u0432\u043d\u044b\u0439", "\u0436\u0438\u0440\u043d\u044b\u0439&\u043a\u0443\u0440\u0441\u0438\u0432\u043d\u044b\u0439", "\u043f\u043e\u0434\u0447\u0435\u0440\u043a\u043d\u0443\u0442\u044b\u0439"};
    private int faceIndex;
    private int styleIndex;
    private int[] sizes = new int[]{8, 0, 16};
    private Font f;
    private int fHeight;
    private int infoColor = 0xFF0000;
    private String testStr = "\u041f\u0435\u0440\u0435\u0432\u043e\u0434: [M.A.X]...";

    public void init(Display display, Displayable next) {
        super.init(display, next);
        this.f = Font.getFont((int)0, (int)0, (int)8);
        this.fHeight = this.f.getHeight();
    }

    protected void paint(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, this.width, this.height);
        Font font = null;
        int x = 1;
        int y = 1;
        g.setColor(this.infoColor);
        g.setFont(this.f);
        String info = this.faceNames[this.faceIndex] + "/" + this.styleNames[this.styleIndex];
        g.drawString(info, x, y, 20);
        y += this.fHeight + 1;
        int i = 0;
        while (i < this.sizes.length) {
            font = Font.getFont((int)this.faces[this.faceIndex], (int)this.styles[this.styleIndex], (int)this.sizes[i]);
            if (font != null) {
                g.setColor(0);
                g.setFont(font);
                g.drawString(this.testStr, x, y, 20);
                int strWidth = font.stringWidth(this.testStr);
                int strHeight = font.getHeight();
                g.setColor(this.infoColor);
                g.setFont(this.f);
                info = "\u0412: " + strHeight + "  \u0428:" + strWidth;
                g.drawString(info, x, y += strHeight, 20);
                y += this.fHeight;
            }
            ++i;
        }
    }

    protected void handleKey(int keyCode) {
        int action = this.getGameAction(keyCode);
        switch (action) {
            case 1: {
                ++this.faceIndex;
                if (this.faceIndex < this.faces.length) break;
                this.faceIndex = 0;
                break;
            }
            case 6: {
                --this.faceIndex;
                if (this.faceIndex >= 0) break;
                this.faceIndex = this.faces.length - 1;
                break;
            }
            case 2: {
                --this.styleIndex;
                if (this.styleIndex >= 0) break;
                this.styleIndex = this.styles.length - 1;
                break;
            }
            case 5: {
                ++this.styleIndex;
                if (this.styleIndex < this.styles.length) break;
                this.styleIndex = 0;
                break;
            }
        }
        this.repaint();
    }

    public String getHelp() {
        String helpStr = "\u0412\u0432\u0435\u0440\u0445/\u0412\u043d\u0438\u0437 - \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0448\u0440\u0438\u0444\u0442\n\u0412\u043b\u0435\u0432\u043e/\u0412\u043f\u0440\u0430\u0432\u043e - \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u0441\u0442\u0438\u043b\u044c \u0448\u0440\u0438\u0444\u0442\u0430";
        return helpStr;
    }
}

