/*
 * Decompiled with CFR 0.152.
 */
package src;

import src.FSprite;
import src.GameCanvas;
import src.GameData;
import src.Util;

public class Camera
implements GameData {
    short camerax;
    short cameray;
    short cameraw;
    short camerah;
    short worldw;
    short worldh;
    final short BASEX = (short)120;
    final short BASEY = (short)260;
    short currentCameraX;
    short currentCameraY;
    short currentCameraW;
    short currentCameraH;
    short currentWorldW;
    short currentWorldH;
    GameCanvas canvas;
    FSprite cameraRole;
    int x;
    int y;
    boolean isShake;
    short shakeX;
    short shakeY;
    byte shakeW;
    byte shakeH;
    byte shaketype;
    byte shaketime;

    public Camera(GameCanvas canvas) {
        this.canvas = canvas;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setCameraPos() {
        this.x = this.camerax + this.shakeX;
        this.x = this.x < 0 ? 0 : this.x;
        this.y = this.cameray + this.shakeY;
        this.y = this.y < 0 ? 0 : this.y;
    }

    public void startShake(byte w2, byte h2, byte time, byte type) {
        this.shakeX = 0;
        this.shakeY = 0;
        this.shakeW = w2;
        this.shakeH = h2;
        this.isShake = true;
        this.shaketype = type;
        this.shaketime = time;
    }

    public void stopShake() {
        this.isShake = false;
    }

    public void shakeCamera() {
        this.shakeX = 0;
        this.shakeY = 0;
        if (this.isShake) {
            switch (this.shaketype) {
                case 0: {
                    if (this.shakeW > 0) {
                        this.shakeX = (short)Util.getBRandomInt(this.shakeW);
                    }
                    if (this.shakeH <= 0) break;
                    this.shakeY = (short)Util.getBRandomInt(this.shakeH);
                    break;
                }
                case 1: {
                    if (this.canvas.publiccounter % 2 != 0) break;
                    this.shakeY = this.shakeH;
                }
            }
            if (this.shaketime > 0) {
                this.shaketime = (byte)(this.shaketime - 1);
                if (this.shaketime == 0) {
                    this.isShake = false;
                }
            }
        }
    }

    public void fshakeCamera() {
        this.shakeX = 0;
        this.shakeY = 0;
        if (this.isShake) {
            if (this.canvas.publiccounter % 2 == 0) {
                this.shakeY = this.shakeH;
            }
            if (this.shaketime > 0) {
                this.shaketime = (byte)(this.shaketime - 1);
                if (this.shaketime == 0) {
                    this.isShake = false;
                }
            }
        }
    }

    public void cameraProcess() {
        if (this.cameraRole.faceto == 1) {
            if (this.cameraRole.spritex > this.camerax + 120) {
                this.moveCameraX((byte)1, (short)(20 + this.cameraRole.currentMoveSpeedX));
                if (this.cameraRole.spritex < this.camerax + 120) {
                    this.camerax = (short)(this.cameraRole.spritex - 120);
                }
            } else if (this.cameraRole.spritex < this.camerax + 120) {
                this.moveCameraX((byte)-1, (short)(20 + this.cameraRole.currentMoveSpeedX));
                if (this.cameraRole.spritex > this.camerax + 120) {
                    this.camerax = (short)(this.cameraRole.spritex - 120);
                }
            } else {
                this.moveCameraX((byte)1, this.cameraRole.currentMoveSpeedX);
                if (this.cameraRole.spritex < this.camerax + 120) {
                    this.camerax = (short)(this.cameraRole.spritex - 120);
                }
            }
        } else if (this.cameraRole.faceto == -1) {
            if (this.cameraRole.spritex < this.camerax + this.cameraw - 120) {
                this.moveCameraX((byte)-1, (short)(20 + this.cameraRole.currentMoveSpeedX));
                if (this.cameraRole.spritex > this.camerax + this.cameraw - 120) {
                    this.camerax = (short)(this.cameraRole.spritex - (this.cameraw - 120));
                }
            } else if (this.cameraRole.spritex > this.camerax + this.cameraw - 120) {
                this.moveCameraX((byte)1, (short)(20 + this.cameraRole.currentMoveSpeedX));
                if (this.cameraRole.spritex < this.camerax + this.cameraw - 120) {
                    this.camerax = (short)(this.cameraRole.spritex - (this.cameraw - 120));
                }
            } else {
                this.moveCameraX((byte)-1, this.cameraRole.currentMoveSpeedX);
                if (this.cameraRole.spritex > this.camerax + this.cameraw - 120) {
                    this.camerax = (short)(this.cameraRole.spritex - (this.cameraw - 120));
                }
            }
        }
        if (this.cameraRole.spritez > this.cameray + 260) {
            this.moveCameraY((byte)1, (byte)this.cameraRole.currentMoveSpeedY);
        } else if (this.cameraRole.spritez < this.cameray + 260) {
            this.moveCameraY((byte)-1, (byte)this.cameraRole.currentMoveSpeedY);
        } else {
            this.moveCameraY((byte)1, (byte)this.cameraRole.currentMoveSpeedY);
        }
        this.shakeCamera();
        this.setCameraPos();
        this.cameraRole.currentMoveSpeedX = 0;
        this.cameraRole.currentMoveSpeedY = 0;
    }

    public void setCamera(int x2, int y2, int w2, int h2, int ww, int wh) {
        this.camerax = (short)x2;
        this.cameray = (short)y2;
        this.cameraw = (short)w2;
        this.camerah = (short)h2;
        this.worldw = (short)ww;
        this.worldh = (short)wh;
    }

    private void moveCameraX(byte direction, short speed) {
        this.camerax = (short)(this.camerax + direction * speed);
        this.camerax = this.camerax < 0 ? (short)0 : this.camerax;
        this.camerax = (short)(this.camerax > this.worldw - this.cameraw ? this.worldw - this.cameraw : this.camerax);
    }

    private void moveCameraY(byte virection, short speed) {
        this.cameray = (short)(this.cameray + virection * speed);
        this.cameray = this.cameray < 0 ? (short)0 : this.cameray;
        this.cameray = (short)(this.cameray > this.worldh - this.camerah ? this.worldh - this.camerah : this.cameray);
    }

    public void setCameraRole(FSprite role) {
        this.cameraRole = role;
    }

    public void resetCamera() {
        if (this.cameraRole.faceto == 1) {
            this.camerax = (short)(this.cameraRole.spritex - 120);
            this.camerax = this.camerax < 0 ? (short)0 : this.camerax;
        } else if (this.cameraRole.faceto == -1) {
            this.camerax = (short)(this.cameraRole.spritex - (this.cameraw - 120));
            this.camerax = (short)(this.camerax > this.worldw - this.cameraw ? this.worldw - this.cameraw : this.camerax);
        }
        this.cameray = (short)(this.cameraRole.spritez - 260);
        this.cameray = this.cameray < 0 ? (short)0 : this.cameray;
        this.cameray = this.cameray > this.worldh - this.camerah ? (short)(this.worldh - this.camerah) : this.cameray;
        this.setCameraPos();
        this.stopShake();
    }

    public boolean isinCamera(int x2, int y2, int w2, int h2) {
        int dx = Math.abs(this.x + (this.cameraw >> 1) - (x2 + (w2 >> 1)));
        int dy = Math.abs(this.y + (this.camerah >> 1) - (y2 + (h2 >> 1)));
        return dx <= this.cameraw + w2 >> 1 && dy <= this.camerah + h2 >> 1;
    }

    public void moveCamera(byte hdir, short speedx, byte vdir, short speedz) {
        switch (hdir) {
            case 2: {
                this.camerax = (short)(this.camerax - speedx);
                break;
            }
            case 3: {
                this.camerax = (short)(this.camerax + speedx);
            }
        }
        switch (vdir) {
            case 0: {
                this.cameray = (short)(this.cameray - speedz);
                break;
            }
            case 1: {
                this.cameray = (short)(this.cameray + speedz);
            }
        }
    }

    public void eventCameraProcess() {
        if (this.canvas.mapm.iseventAotoCamera) {
            this.cameraProcess();
        }
    }
}

