/*
 * Decompiled with CFR 0.152.
 */
package src;

import src.GameData;

public class Control
implements GameData {
    static int KeyState = 0;
    static int KeyDownState = 0;
    static int KeyUpState = 0;
    static int CurKeyState = 0;
    static int CurKeyDownState = 0;
    static int CurKeyUpState = 0;
    static boolean KeyEnable = true;
    static int KeyHoldTime = 0;
    static boolean Is_E62_MODEL = false;

    private static final int GetKeyValue(int keyCode) {
        if (Is_E62_MODEL) {
            switch (keyCode) {
                case 48: 
                case 109: {
                    return 1;
                }
                case 49: 
                case 114: {
                    return 2;
                }
                case 50: 
                case 116: {
                    return 4;
                }
                case 51: 
                case 121: {
                    return 8;
                }
                case 52: 
                case 102: {
                    return 16;
                }
                case 53: 
                case 103: {
                    return 32;
                }
                case 54: 
                case 104: {
                    return 64;
                }
                case 55: 
                case 118: {
                    return 128;
                }
                case 56: 
                case 98: {
                    return 256;
                }
                case 57: 
                case 110: {
                    return 512;
                }
                case 35: 
                case 106: {
                    return 1024;
                }
                case 117: {
                    return 2048;
                }
            }
        }
        switch (keyCode) {
            case 32: 
            case 48: {
                return 1;
            }
            case 49: 
            case 101: 
            case 114: {
                return 2;
            }
            case 50: 
            case 116: 
            case 121: {
                return 4;
            }
            case 51: 
            case 105: 
            case 117: {
                return 8;
            }
            case 52: 
            case 100: 
            case 102: {
                return 16;
            }
            case 53: 
            case 103: 
            case 104: {
                return 32;
            }
            case 54: 
            case 106: 
            case 107: {
                return 64;
            }
            case 55: 
            case 99: 
            case 120: {
                return 128;
            }
            case 56: 
            case 98: 
            case 118: {
                return 256;
            }
            case 57: 
            case 109: 
            case 110: {
                return 512;
            }
            case 35: {
                return 1024;
            }
            case 42: {
                return 2048;
            }
            case -1: 
            case 1: {
                return 4096;
            }
            case -2: 
            case 6: {
                return 8192;
            }
            case -3: 
            case 2: {
                return 16384;
            }
            case -4: 
            case 5: {
                return 32768;
            }
            case -21: 
            case -6: 
            case 21: {
                return 65536;
            }
            case -22: 
            case -7: 
            case 22: {
                return 131072;
            }
            case -20: 
            case -5: 
            case 20: {
                return 262144;
            }
        }
        return 0;
    }

    public static final void KeyStateDestroy() {
        KeyState = 0;
        KeyDownState = 0;
        KeyUpState = 0;
    }

    public static final void GetKey() {
        CurKeyDownState = KeyDownState;
        CurKeyState = KeyState;
        CurKeyUpState = KeyUpState;
        KeyDownState = 0;
        KeyUpState = 0;
    }

    public static final void ClearKey() {
        CurKeyDownState = 0;
        CurKeyState = 0;
        CurKeyUpState = 0;
    }

    public static final boolean IsKeyDown(int TheKey) {
        return (CurKeyDownState & TheKey) != 0;
    }

    public static final boolean IsKeyUp(int TheKey) {
        return (CurKeyUpState & TheKey) != 0;
    }

    public static final boolean IsKeyHold(int TheKey) {
        return (CurKeyState & TheKey) != 0;
    }

    public static final boolean IsKeyHold(int TheKey, int HoldTime) {
        if (++KeyHoldTime > HoldTime) {
            KeyHoldTime = HoldTime;
            return (CurKeyState & TheKey) != 0;
        }
        return false;
    }

    public static final void keyPressed(int keyCode) {
        if (!KeyEnable) {
            Control.KeyStateDestroy();
        } else {
            int Code = Control.GetKeyValue(keyCode);
            KeyDownState |= Code;
            KeyState |= Code;
            KeyHoldTime = 0;
        }
    }

    public static final void keyReleased(int keyCode) {
        if (!KeyEnable) {
            Control.KeyStateDestroy();
        } else {
            int Code = Control.GetKeyValue(keyCode);
            KeyUpState |= Code;
            KeyState &= ~Code;
            KeyHoldTime = 0;
        }
    }

    public static final void keyReleased() {
        int Code = KeyState;
        KeyUpState |= Code;
        KeyState &= ~Code;
        KeyHoldTime = 0;
    }
}

