/*
 * Decompiled with CFR 0.152.
 */
package src;

import src.GameCanvas;
import src.GameData;

public class Scroll
implements GameData {
    GameCanvas canvas;
    String[] scrollWord;
    String[][] scrollWord1;
    short clipx;
    short clipy;
    short clipw;
    short cliph;
    short wordx;
    short wordy;
    short basey;
    byte speedy;
    byte scrollstate;
    byte startline;
    byte showlinenum;
    int scrollanchor;
    int waittime;
    byte laststartline;
    short[] clipx1;
    short[] clipy1;
    short[] clipw1;
    short[] cliph1;
    short[] wordx1;
    short[] wordy1;
    short[] basey1;
    byte[] speedy1;
    byte[] scrollstate1;
    byte[] startline1;
    byte[] showlinenum1;
    int[] scrollanchor1;
    int[] waittime1;
    byte[] laststartline1;

    public Scroll(GameCanvas canvas) {
        this.canvas = canvas;
        this.initscrollWord1();
    }

    public void initscrollWord1() {
        this.scrollWord1 = new String[2][];
        this.clipx1 = new short[2];
        this.clipy1 = new short[2];
        this.clipw1 = new short[2];
        this.cliph1 = new short[2];
        this.wordx1 = new short[2];
        this.wordy1 = new short[2];
        this.basey1 = new short[2];
        this.speedy1 = new byte[2];
        this.scrollstate1 = new byte[2];
        this.startline1 = new byte[2];
        this.showlinenum1 = new byte[2];
        this.scrollanchor1 = new int[2];
        this.waittime1 = new int[2];
        this.laststartline1 = new byte[2];
    }

    public void setscroll(String word, int x2, int y2, int w2, int h2, int state, int anchor) {
        this.scrollWord = this.canvas.formatzkword(word, w2, 0);
        this.waittime = 20;
        this.speedy = (byte)-1;
        this.clipx = (short)x2;
        this.clipy = (short)y2;
        this.clipw = (short)w2;
        this.cliph = (short)h2;
        this.wordx = (short)x2;
        this.wordy = (short)y2;
        this.basey = (short)y2;
        this.scrollstate = (byte)state;
        this.laststartline = this.startline = 0;
        this.showlinenum = (byte)(this.cliph / 16);
        if (this.scrollstate == 1 && this.scrollWord.length <= this.showlinenum) {
            this.scrollstate = 0;
            this.waittime = 0;
            this.speedy = 0;
        }
        this.scrollanchor = anchor;
    }

    public void setscroll(String word, int index, int x2, int y2, int w2, int h2, int state, int anchor) {
        this.scrollWord1[index] = this.canvas.formatzkword(word, w2, 0);
        this.waittime1[index] = 20;
        this.speedy1[index] = -1;
        this.clipx1[index] = (short)x2;
        this.clipy1[index] = (short)y2;
        this.clipw1[index] = (short)w2;
        this.cliph1[index] = (short)h2;
        this.wordx1[index] = (short)x2;
        this.wordy1[index] = (short)y2;
        this.basey1[index] = (short)y2;
        this.scrollstate1[index] = (byte)state;
        this.startline1[index] = 0;
        this.laststartline1[index] = this.startline1[index];
        this.showlinenum1[index] = (byte)(this.cliph1[index] / 16);
        if (this.scrollstate1[index] == 1 && this.scrollWord1[index].length <= this.showlinenum1[index]) {
            this.scrollstate1[index] = 0;
            this.waittime1[index] = 0;
            this.speedy1[index] = 0;
        }
        this.scrollanchor1[index] = anchor;
    }

    public void setscroll(String word, int x2, int y2, int sx, int sy, int w2, int h2, int speey, int state, int anchor) {
        this.scrollWord = this.canvas.formatzkword(word, w2, 0);
        this.clipx = (short)x2;
        this.clipy = (short)y2;
        this.wordx = (short)sx;
        this.basey = this.wordy = (short)sy;
        this.clipw = (short)w2;
        this.cliph = (short)h2;
        this.speedy = (byte)speey;
        this.scrollstate = (byte)state;
        this.startline = (byte)((this.clipy - this.wordy) / 16);
        this.startline = this.startline < 0 ? (byte)0 : this.startline;
        this.showlinenum = (byte)(this.cliph / 16);
        if (this.scrollstate == 2 && this.scrollWord.length <= this.showlinenum) {
            this.scrollstate = 0;
            this.wordy = this.clipy;
        }
        this.scrollanchor = anchor;
    }

    public void close() {
        this.scrollWord = null;
    }

    public void close(int index) {
        this.scrollWord1[index] = null;
    }

    public void drawscroll() {
        if (this.scrollWord == null) {
            return;
        }
        this.canvas.g.setClip((int)this.clipx, (int)this.clipy, (int)this.clipw, (int)this.cliph);
        this.canvas.drawZkStringArry(this.scrollWord, this.wordx, this.wordy, this.scrollanchor, 0, this.scrollWord.length, 0);
        this.canvas.setClip();
        this.move();
    }

    public void drawscroll(int x2) {
        if (this.scrollWord == null) {
            return;
        }
        this.canvas.g.setClip((int)this.clipx, (int)this.clipy, (int)this.clipw, (int)this.cliph);
        this.canvas.drawZkStringArry(this.scrollWord, this.wordx + x2, this.wordy, this.scrollanchor, 0, this.scrollWord.length, 0);
        this.canvas.setClip();
        this.move();
    }

    public void drawscroll(int x2, int index) {
        if (this.scrollWord1[index] == null) {
            return;
        }
        this.canvas.g.setClip((int)this.clipx1[index], (int)this.clipy1[index], (int)this.clipw1[index], (int)this.cliph1[index]);
        this.canvas.drawZkStringArry(this.scrollWord1[index], this.wordx1[index] + x2, this.wordy1[index], this.scrollanchor1[index], 0, this.scrollWord1[index].length, 0);
        this.canvas.setClip();
        if (this.scrollWord1[index].length > 1) {
            this.move(index);
        }
    }

    private void move(int index) {
        switch (this.scrollstate1[index]) {
            case 1: {
                if (this.waittime1[index] > 0) {
                    int n2 = index;
                    this.waittime1[n2] = this.waittime1[n2] - 1;
                    break;
                }
                if (this.startline1[index] > this.scrollWord1[index].length - 1) {
                    this.startline1[index] = 0;
                    this.wordy1[index] = this.basey1[index];
                    this.waittime1[index] = 20;
                    this.laststartline1[index] = this.startline1[index];
                    break;
                }
                int n3 = index;
                this.wordy1[n3] = (short)(this.wordy1[n3] + this.speedy1[index]);
                this.startline1[index] = (byte)((this.clipy1[index] - this.wordy1[index]) / 16);
                if (this.laststartline1[index] == this.startline1[index]) break;
                this.waittime1[index] = 20;
                this.laststartline1[index] = this.startline1[index];
                break;
            }
            case 2: {
                if (this.startline1[index] > this.scrollWord1[index].length - 1) {
                    this.startline1[index] = 0;
                    this.wordy1[index] = this.basey1[index];
                    break;
                }
                int n4 = index;
                this.wordy1[n4] = (short)(this.wordy1[n4] + this.speedy1[index]);
                this.startline1[index] = (byte)((this.clipy1[index] - this.wordy1[index]) / 16);
            }
        }
    }

    private void move() {
        switch (this.scrollstate) {
            case 1: {
                if (this.waittime > 0) {
                    --this.waittime;
                    break;
                }
                if (this.startline > this.scrollWord.length - 1) {
                    this.startline = 0;
                    this.wordy = this.basey;
                    this.waittime = 20;
                    this.laststartline = this.startline;
                    break;
                }
                this.wordy = (short)(this.wordy + this.speedy);
                this.startline = (byte)((this.clipy - this.wordy) / 16);
                if (this.laststartline == this.startline) break;
                this.waittime = 20;
                this.laststartline = this.startline;
                break;
            }
            case 2: {
                if (this.startline > this.scrollWord.length - 1) {
                    this.startline = 0;
                    this.wordy = this.basey;
                    break;
                }
                this.wordy = (short)(this.wordy + this.speedy);
                this.startline = (byte)((this.clipy - this.wordy) / 16);
            }
        }
    }
}

