/*
 * Decompiled with CFR 0.152.
 */
package src;

import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class Sound {
    Player music = null;
    public int volume;
    public VolumeControl vc = null;

    public void createMusic(String path) {
        this.closeMusic();
        try {
            InputStream in = this.getClass().getResourceAsStream(path);
            this.music = Manager.createPlayer((InputStream)in, (String)"audio/midi");
            if (this.music != null && this.music.getState() != 0) {
                this.music.realize();
                this.music.prefetch();
            }
            this.setVolume();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setVolume() {
        if (this.music != null) {
            this.vc = (VolumeControl)this.music.getControl("VolumeControl");
            this.vc.setLevel(this.volume * 25);
        }
    }

    public void playMusic() {
        if (this.volume <= 0) {
            this.closeMusic();
        } else {
            try {
                if (this.music != null && this.music.getState() == 300) {
                    this.music.setLoopCount(-1);
                    this.music.start();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void pauseMusic() {
        try {
            if (this.music != null && this.music.getState() == 400) {
                this.music.stop();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void closeMusic() {
        if (this.music != null) {
            this.music.close();
            this.music = null;
        }
    }

    public void musicPlay(int musicIndex) {
        if (this.music != null && this.music.getState() != 400 && this.volume > 0) {
            this.createMusic("/data/" + musicIndex + ".m");
            this.setVolume();
            this.playMusic();
        }
    }
}

