/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.GUIGraphics;
import com.gui.GUIManager;
import com.gui.SiemensNativeBackground;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public final class Theme {
    int fonRGB1;
    int fonRGB2;
    int fonFrameRGB;
    int lineRGB;
    int bordFonRGB1;
    int bordFonRGB2;
    int bordFrameRGB;
    int bordTextRGB;
    int itemRGB;
    int itemPasteRGB;
    int itemHideRGB;
    int cursorFonRGB1;
    int cursorFonRGB2;
    int cursorFrameRGB;
    int scrollRGB1;
    int scrollRGB2;
    int scrollFrameRGB;
    int scrollFieldFonRGB1;
    int scrollFieldFonRGB2;
    int textRGB;
    int labelRGB;
    int entryFieldRGB;
    int entryFieldFrameRGB;
    int entryFieldTextRGB;
    int gaugeFieldRGB;
    int gaugeFieldFrameRGB;
    int gaugeProcessRGB1;
    int gaugeProcessRGB2;
    int gaugeTextRGB;
    int alertFonRGB1;
    int alertFonRGB2;
    int alertFrameRGB;
    int alertBordRGB;
    int alertTextRGB;
    int alertLabelRGB;
    int alertScrollRGB1;
    int alertScrollRGB2;
    int alertScrollFrameRGB;
    int alertScrollFieldFonRGB1;
    int alertScrollFieldFonRGB2;
    public static final int NATIVE_THEME = 0;
    public static final int BLUE_THEME = 1;
    public static final int GRAY_THEME = 2;
    public static final int NIGHT_THEME = 3;
    public static final int BLACK_THEME = 4;
    public static final int BLUE = 0x7F0000FF;
    public static final int NEON_BLUE = 2135818239;
    public static final int LIGHT_BLUE = 2130755583;
    public static final int MEDIUM_BLUE = 2130706602;
    public static final int DARK_BLUE = 2130706534;
    public static final int GRAY = 0x7F666666;
    public static final int MEDIUM_GRAY = 2139127936;
    public static final int LIGHT_GRAY = 2146101994;
    public static final int DARK_GRAY = 0x7F333333;
    public static final int WHITE = Integer.MAX_VALUE;
    public static final int SILVER = 2143338688;
    public static final int BLACK = 0x7F000000;
    Font itemFont;
    Font bordFont;
    Font textFont;
    int itemHeight;
    int bordHeight;
    int textHeight;
    public int[] color = new int[]{0, 1, 2, 3, 4, 5};

    public Theme() {
        this.setTheme(-1);
        this.setBorderFont(Font.getFont((int)0, (int)1, (int)0));
        this.setItemFont(Font.getFont((int)0, (int)1, (int)8));
        this.setTextFont(Font.getFont((int)0, (int)1, (int)8));
    }

    public void setTheme(String source) {
        if (source != null && !source.equals("")) {
            this.parser(source);
            try {
                GUIManager.setBackground(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.setBorderFont(Font.getFont((int)0, (int)1, (int)0));
            this.setItemFont(Font.getFont((int)0, (int)1, (int)8));
        } else {
            this.setTheme(-1);
        }
    }

    public void setTheme(int identificator) {
        switch (identificator) {
            case 2: {
                this.fonRGB1 = 2146101994;
                this.fonRGB2 = Integer.MAX_VALUE;
                this.fonFrameRGB = Integer.MAX_VALUE;
                this.lineRGB = 0x7F333333;
                this.bordFonRGB1 = 0x7F333333;
                this.bordFonRGB2 = 2146101994;
                this.bordFrameRGB = 2146101994;
                this.bordTextRGB = 2146101994;
                this.itemRGB = 0x7F666666;
                this.itemPasteRGB = 2146101994;
                this.itemHideRGB = Integer.MAX_VALUE;
                this.cursorFonRGB1 = 2146101994;
                this.cursorFonRGB2 = 2139127936;
                this.cursorFrameRGB = 0x7F333333;
                this.scrollRGB1 = 0x7F333333;
                this.scrollRGB2 = 2146101994;
                this.scrollFrameRGB = 0x7F333333;
                this.scrollFieldFonRGB1 = 2139127936;
                this.scrollFieldFonRGB2 = 2146101994;
                this.textRGB = 0x7F666666;
                this.labelRGB = 0x7F333333;
                this.entryFieldRGB = Integer.MAX_VALUE;
                this.entryFieldFrameRGB = 0x7F333333;
                this.entryFieldTextRGB = 0x7F333333;
                this.gaugeFieldRGB = Integer.MAX_VALUE;
                this.gaugeFieldFrameRGB = 0x7F333333;
                this.gaugeProcessRGB1 = 0x7F333333;
                this.gaugeProcessRGB2 = 2146101994;
                this.gaugeTextRGB = 0x7F333333;
                this.alertFonRGB1 = 2146101994;
                this.alertFonRGB2 = 2146101994;
                this.alertFrameRGB = 0x7F333333;
                this.alertBordRGB = 0xC0C0C0;
                this.alertTextRGB = this.textRGB;
                this.alertLabelRGB = 0x7F333333;
                this.alertScrollRGB1 = 0x7F333333;
                this.alertScrollRGB2 = 2146101994;
                this.alertScrollFrameRGB = 0x7F333333;
                this.alertScrollFieldFonRGB1 = 2139127936;
                this.alertScrollFieldFonRGB2 = 2146101994;
                try {
                    GUIManager.setBackground(null);
                }
                catch (Throwable e) {}
                break;
            }
            case 3: {
                this.fonRGB1 = 2130706512;
                this.fonRGB2 = 2130706506;
                this.fonFrameRGB = Integer.MAX_VALUE;
                this.lineRGB = Integer.MAX_VALUE;
                this.bordFonRGB1 = 2136298888;
                this.bordFonRGB2 = 0x7F777799;
                this.bordFrameRGB = this.bordFonRGB1;
                this.bordTextRGB = 64;
                this.itemRGB = 2146101994;
                this.itemPasteRGB = 64;
                this.itemHideRGB = 2130706543;
                this.cursorFonRGB1 = this.bordFonRGB1;
                this.cursorFonRGB2 = 2146101994;
                this.cursorFrameRGB = this.bordFonRGB1;
                this.scrollRGB1 = this.bordFonRGB1;
                this.scrollRGB2 = 2146101994;
                this.scrollFrameRGB = this.bordFonRGB1;
                this.scrollFieldFonRGB1 = 2130706496;
                this.scrollFieldFonRGB2 = 2130706496;
                this.textRGB = 2146101994;
                this.labelRGB = 2146101994;
                this.entryFieldRGB = Integer.MAX_VALUE;
                this.entryFieldFrameRGB = this.bordFonRGB1;
                this.entryFieldTextRGB = this.bordFonRGB1;
                this.gaugeFieldRGB = Integer.MAX_VALUE;
                this.gaugeFieldFrameRGB = this.bordFonRGB1;
                this.gaugeProcessRGB1 = this.bordFonRGB1;
                this.gaugeProcessRGB2 = 2146101994;
                this.gaugeTextRGB = this.bordFonRGB1;
                this.alertFonRGB1 = 2130706512;
                this.alertFonRGB2 = 2130706512;
                this.alertFrameRGB = 2130706512;
                this.alertBordRGB = this.bordFonRGB1;
                this.alertTextRGB = this.textRGB;
                this.alertLabelRGB = this.bordTextRGB;
                this.alertScrollRGB1 = this.bordFonRGB1;
                this.alertScrollRGB2 = 2146101994;
                this.alertScrollFrameRGB = this.bordFonRGB1;
                this.alertScrollFieldFonRGB1 = 2130706496;
                this.alertScrollFieldFonRGB2 = 2130706496;
                try {
                    GUIManager.setBackground(null);
                }
                catch (Throwable e) {}
                break;
            }
            case 4: {
                this.fonRGB1 = 0x7F000000;
                this.fonRGB2 = 0x7F000000;
                this.fonFrameRGB = 2143338688;
                this.lineRGB = 2146101994;
                this.bordFonRGB1 = 0x7F333333;
                this.bordFonRGB2 = 2146101994;
                this.bordFrameRGB = 2143338688;
                this.bordTextRGB = 0x7F333333;
                this.itemRGB = 2143338688;
                this.itemPasteRGB = 0x7F000000;
                this.itemHideRGB = 0x7F333333;
                this.cursorFonRGB1 = 0x7F000000;
                this.cursorFonRGB2 = 2146101994;
                this.cursorFrameRGB = 2146101994;
                this.scrollRGB1 = 0x7F000000;
                this.scrollRGB2 = 2146101994;
                this.scrollFrameRGB = 0x7F000000;
                this.scrollFieldFonRGB1 = 0x7F000000;
                this.scrollFieldFonRGB2 = 0x7F333333;
                this.textRGB = 2143338688;
                this.labelRGB = 2146101994;
                this.entryFieldRGB = 2143338688;
                this.entryFieldFrameRGB = 0x7F333333;
                this.entryFieldTextRGB = 0x7F333333;
                this.gaugeFieldRGB = 2143338688;
                this.gaugeFieldFrameRGB = 0x7F333333;
                this.gaugeProcessRGB1 = 0x7F000000;
                this.gaugeProcessRGB2 = 2143338688;
                this.gaugeTextRGB = 0x7F333333;
                this.alertFonRGB1 = 0;
                this.alertFonRGB2 = 0;
                this.alertFrameRGB = 2143338688;
                this.alertBordRGB = 0x7F333333;
                this.alertTextRGB = 2143338688;
                this.alertLabelRGB = 0;
                this.alertScrollRGB1 = 0x7F000000;
                this.alertScrollRGB2 = 2146101994;
                this.alertScrollFrameRGB = 0x7F000000;
                this.alertScrollFieldFonRGB1 = 0x7F000000;
                this.alertScrollFieldFonRGB2 = 0x7F333333;
                try {
                    GUIManager.setBackground(null);
                }
                catch (Throwable e) {}
                break;
            }
            default: {
                this.fonRGB1 = 2130755583;
                this.fonRGB2 = Integer.MAX_VALUE;
                this.fonFrameRGB = 2130706534;
                this.lineRGB = 2130706534;
                this.bordFonRGB1 = 2130706534;
                this.bordFonRGB2 = 2130706602;
                this.bordFrameRGB = 2130706534;
                this.bordTextRGB = 2146101994;
                this.itemRGB = 0x7F666666;
                this.itemPasteRGB = 2146101994;
                this.itemHideRGB = 2146101994;
                this.cursorFonRGB1 = 0x7F0000FF;
                this.cursorFonRGB2 = 2130755583;
                this.cursorFrameRGB = Integer.MAX_VALUE;
                this.scrollRGB1 = 2130706534;
                this.scrollRGB2 = 2130755583;
                this.scrollFrameRGB = 2130706534;
                this.scrollFieldFonRGB1 = Integer.MAX_VALUE;
                this.scrollFieldFonRGB2 = 2130755583;
                this.textRGB = 0x7F666666;
                this.labelRGB = 0x7F333333;
                this.entryFieldRGB = Integer.MAX_VALUE;
                this.entryFieldFrameRGB = 2130755583;
                this.entryFieldTextRGB = 0x7F666666;
                this.gaugeFieldRGB = Integer.MAX_VALUE;
                this.gaugeFieldFrameRGB = 2130755583;
                this.gaugeProcessRGB1 = 0x7F0000FF;
                this.gaugeProcessRGB2 = 2130755583;
                this.gaugeTextRGB = 0x7F666666;
                this.alertFonRGB1 = Integer.MAX_VALUE;
                this.alertFonRGB2 = Integer.MAX_VALUE;
                this.alertFrameRGB = Integer.MAX_VALUE;
                this.alertBordRGB = 0x7F0000FF;
                this.alertTextRGB = 0x7F666666;
                this.alertLabelRGB = 2146101994;
                this.alertScrollRGB1 = 2130706534;
                this.alertScrollRGB2 = 2130755583;
                this.alertScrollFrameRGB = 2130706534;
                this.alertScrollFieldFonRGB1 = Integer.MAX_VALUE;
                this.alertScrollFieldFonRGB2 = 2130755583;
                try {
                    GUIManager.setBackground(null);
                }
                catch (Throwable e) {}
                break;
            }
            case 0: {
                int[] cc2 = new int[]{0, 1, 2, 3, 4};
                int[] cc = new int[]{0x7F000000, 2143338688, 2146101994, 0x7F333333, 0};
                Hashtable<Integer, Integer> table = new Hashtable<Integer, Integer>();
                table.put(new Integer(cc[0]), new Integer(cc2[0]));
                table.put(new Integer(cc[1]), new Integer(cc2[1]));
                table.put(new Integer(cc[2]), new Integer(cc2[2]));
                table.put(new Integer(cc[3]), new Integer(cc2[3]));
                table.put(new Integer(cc[4]), new Integer(cc2[4]));
                int[] ccsort = this.shellSort(cc);
                int[] color1 = new int[this.color.length];
                for (int i = 0; i < this.color.length; ++i) {
                    int c;
                    color1[i] = c = GUIManager.display.getColor(this.color[i]);
                }
                int[] color2 = this.colorFilter(color1);
                for (int i = 0; i < cc.length; ++i) {
                    cc[i] = color2[(Integer)table.get(new Integer(ccsort[i]))];
                }
                table.clear();
                table = null;
                cc2 = null;
                ccsort = null;
                this.fonRGB1 = cc[0];
                this.fonRGB2 = cc[0];
                this.fonFrameRGB = cc[1];
                this.lineRGB = this.invert(cc[0]);
                this.bordFonRGB1 = cc[3];
                this.bordFonRGB2 = cc[2];
                this.bordFrameRGB = cc[1];
                this.bordTextRGB = this.invert((cc[2] + cc[3]) / 2);
                this.itemRGB = cc[1];
                this.itemPasteRGB = cc[0];
                this.itemHideRGB = cc[3];
                this.cursorFonRGB1 = this.color2(cc[0]);
                this.cursorFonRGB2 = this.color2(cc[2]);
                this.cursorFrameRGB = cc[2];
                this.scrollRGB1 = cc[0];
                this.scrollRGB2 = cc[2];
                this.scrollFrameRGB = cc[0];
                this.scrollFieldFonRGB1 = cc[0];
                this.scrollFieldFonRGB2 = cc[3];
                this.labelRGB = this.textRGB = this.invert(cc[0]);
                this.entryFieldRGB = cc[1];
                this.entryFieldFrameRGB = cc[3];
                this.entryFieldTextRGB = this.invert(cc[3]);
                this.gaugeFieldRGB = cc[1];
                this.gaugeFieldFrameRGB = cc[3];
                this.gaugeProcessRGB1 = cc[0];
                this.gaugeProcessRGB2 = cc[1];
                this.gaugeTextRGB = this.invert((cc[1] + cc[0]) / 2);
                this.alertFonRGB1 = cc[4];
                this.alertFonRGB2 = cc[4];
                this.alertFrameRGB = cc[1];
                this.alertBordRGB = cc[3];
                this.alertTextRGB = this.invert(cc[4]);
                this.alertLabelRGB = this.invert(cc[4]);
                this.alertScrollRGB1 = cc[0];
                this.alertScrollRGB2 = cc[2];
                this.alertScrollFrameRGB = cc[0];
                this.alertScrollFieldFonRGB1 = cc[0];
                this.alertScrollFieldFonRGB2 = cc[3];
                try {
                    Class.forName("com.siemens.mp.io.file.FileConnection");
                    GUIManager.setBackground(new SiemensNativeBackground());
                    break;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
    }

    public void setBorderFont(Font font) {
        this.bordFont = font;
        this.bordHeight = font.getHeight() + 2;
    }

    public void setItemFont(Font font) {
        this.itemFont = font;
        this.itemHeight = font.getHeight() + 2;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
        this.textHeight = font.getHeight() + 2;
    }

    public Font getBorderFont() {
        return this.bordFont;
    }

    public Font getItemFont() {
        return this.itemFont;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void gradientFill(Graphics g, int x, int y, int width, int height, boolean fillVertically, int color1, int color2) {
        if (GUIGraphics.getFullMode() && color1 == color2) {
            color2 = this.invert(color1);
        }
        if (color1 == color2) {
            GUIGraphics.fillRect(g, x, y, width, height);
            return;
        }
        int max = fillVertically ? height : width;
        for (int i = 0; i < max; ++i) {
            int color = this.midColor(color1, color2, max * (max - 1 - i) / (max - 1), max);
            g.setColor(color);
            if (fillVertically) {
                g.drawLine(x, y + i, x + width, y + i);
                continue;
            }
            g.drawLine(x + i, y, x + i, y + height);
        }
    }

    public int alphaBlend(int c1, int c2, int alpha) {
        int alpha2 = 255 - alpha;
        int r1 = (c1 >> 16 & 0xFF) << 8;
        int g1 = (c1 >> 8 & 0xFF) << 8;
        int b1 = (c1 & 0xFF) << 8;
        int r2 = (c2 >> 16 & 0xFF) << 8;
        int g2 = (c2 >> 8 & 0xFF) << 8;
        int b2 = (c2 & 0xFF) << 8;
        r2 *= alpha;
        g2 *= alpha;
        b2 *= alpha;
        r1 *= alpha2;
        g1 *= alpha2;
        b1 *= alpha2;
        r1 = (r2 + r1) / 255 >> 8;
        g1 = (g2 + g1) / 255 >> 8;
        b1 = (b2 + b1) / 255 >> 8;
        return r1 << 16 | g1 << 8 | b1;
    }

    private void light(int[] rgb, int light) {
        int fp = 8;
        for (int i = rgb.length - 1; i >= 0; --i) {
            int color = rgb[i];
            int cr = color >> 16 & 0xFF;
            int cg = color >> 8 & 0xFF;
            int cb = color & 0xFF;
            cr = cr * light >> 8;
            cg = cg * light >> 8;
            cb = cb * light >> 8;
            rgb[i] = cr << 16 | cg << 8 | cb;
        }
    }

    public static int mixColor(int color1, int color2, int alpha) {
        double ratio = (double)(alpha * 100 / 255) * 0.01;
        double d = 1.0 - ratio;
        return alpha << 24 | (int)((double)(color1 >> 16 & 0xFF) * d + (double)(color2 >> 16 & 0xFF) * ratio) << 16 | (int)((double)(color1 >> 8 & 0xFF) * d + (double)(color2 >> 8 & 0xFF) * ratio) << 8 | (int)((double)(color1 & 0xFF) * d + (double)(color2 & 0xFF) * ratio);
    }

    public int color2(int color) {
        int cs1 = 0;
        int cs2 = 0x202020;
        if (color <= 0xC0C0C0) {
            return this.invert(color / 2);
        }
        cs1 = 5 * cs2;
        cs2 = 0;
        return color - cs1;
    }

    public int[] colorFilter(int[] array) {
        Hashtable<Integer, Integer> table = new Hashtable<Integer, Integer>();
        for (int i = 0; i < array.length; ++i) {
            table.put(new Integer(array[i]), new Integer(array[i]));
        }
        int[] arr = new int[table.size()];
        Enumeration keys = table.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            arr[i] = (Integer)table.get((Integer)keys.nextElement());
            ++i;
        }
        keys = null;
        table.clear();
        table = null;
        array = arr;
        return this.shellSort(array);
    }

    public int[] shellSort(int[] arr) {
        int increment = arr.length / 2;
        while (increment > 0) {
            for (int i = increment; i < arr.length; ++i) {
                int temp = arr[i];
                for (int j = i; j >= increment && arr[j - increment] > temp; j -= increment) {
                    arr[j] = arr[j - increment];
                    arr[j - increment] = temp;
                }
            }
            increment = increment == 2 ? 1 : (int)Math.floor((double)increment / 2.2);
        }
        return arr;
    }

    public int[] hsb(int c) {
        int a1 = c >> 24 & 0xFF;
        int r1 = c >> 16 & 0xFF;
        int g1 = c >> 8 & 0xFF;
        int b1 = c & 0xFF;
        return this.rgb2hsb(r1, g1, b1);
    }

    public int invert(int c) {
        int a1 = c >> 24 & 0xFF;
        int r1 = c >> 16 & 0xFF;
        int g1 = c >> 8 & 0xFF;
        int b1 = c & 0xFF;
        float b = 0.3f * (float)r1 + 0.59f * (float)g1 + 0.11f * (float)b1;
        if (b < 102.0f) {
            return 0xFFFFFF;
        }
        if (b > 191.25f) {
            return 0;
        }
        if (this.Cm(r1) && this.Cm(g1) && this.Cm(b1)) {
            return b > 153.0f ? 0 : 0xFFFFFF;
        }
        int h = this.rgb2hsb(r1, g1, b1)[0];
        if (h > 340 || h >= 0 && h < 20) {
            return 0xFFFF00;
        }
        if (h > 100 && h < 140) {
            return 35723;
        }
        if (h > 220 && h < 260) {
            return 0xFFFF00;
        }
        return a1 << 24 | (int)(this.pow(255.0, r1) % 255.0) << 16 | (int)(this.pow(255.0, g1) % 255.0) << 8 | (int)(this.pow(255.0, b1) % 255.0);
    }

    public int[] rgb2hsb(int vRedIn, int vGreenIn, int vBlueIn) {
        float vHue;
        float cmin;
        float cmax;
        float vRed = vRedIn;
        float vGreen = vGreenIn;
        float vBlue = vBlueIn;
        float f = cmax = vRed > vGreen ? vRed : vGreen;
        if (vBlue > cmax) {
            cmax = vBlue;
        }
        float f2 = cmin = vRed < vGreen ? vRed : vGreen;
        if (vBlue < cmin) {
            cmin = vBlue;
        }
        float vBrightness = cmax / 255.0f;
        float vSaturation = cmax != 0.0f ? (cmax - cmin) / cmax : 0.0f;
        if (vSaturation == 0.0f) {
            vHue = 0.0f;
        } else {
            float redc = (cmax - vRed) / (cmax - cmin);
            float greenc = (cmax - vGreen) / (cmax - cmin);
            float bluec = (cmax - vBlue) / (cmax - cmin);
            vHue = vRed == cmax ? bluec - greenc : (vGreen == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((vHue /= 6.0f) < 0.0f) {
                vHue += 1.0f;
            }
        }
        return new int[]{(int)(vHue * 360.0f), (int)(vSaturation * 100.0f), (int)(vBrightness * 100.0f)};
    }

    public double pow(double B, int C) {
        double result = 1.0;
        for (int i = 0; i < C; ++i) {
            result *= B;
        }
        return result;
    }

    public boolean Cm(int c) {
        return c > 100 && c < 156;
    }

    int midColor(int color1, int color2, int prop, int max) {
        int red = ((color1 >> 16 & 0xFF) * prop + (color2 >> 16 & 0xFF) * (max - prop)) / max;
        int green = ((color1 >> 8 & 0xFF) * prop + (color2 >> 8 & 0xFF) * (max - prop)) / max;
        int blue = ((color1 >> 0 & 0xFF) * prop + (color2 >> 0 & 0xFF) * (max - prop)) / max;
        int color = red << 16 | green << 8 | blue;
        return color;
    }

    void parser(String source) {
        this.fonRGB1 = this.getValue(source, "FonRGB1");
        this.fonRGB2 = this.getValue(source, "FonRGB2");
        this.fonFrameRGB = this.getValue(source, "FonFrameRGB");
        this.lineRGB = this.getValue(source, "LineRGB");
        this.bordFonRGB1 = this.getValue(source, "BorderFonRGB1");
        this.bordFonRGB2 = this.getValue(source, "BorderFonRGB2");
        this.bordFrameRGB = this.getValue(source, "BorderFrameRGB");
        this.bordTextRGB = this.getValue(source, "BorderTextRGB");
        this.itemRGB = this.getValue(source, "ItemRGB");
        this.itemPasteRGB = this.getValue(source, "ItemPasteRGB");
        this.itemHideRGB = this.getValue(source, "ItemHideRGB");
        this.cursorFonRGB1 = this.getValue(source, "CursorFonRGB1");
        this.cursorFonRGB2 = this.getValue(source, "CursorFonRGB2");
        this.cursorFrameRGB = this.getValue(source, "CursorFrameRGB");
        this.scrollRGB1 = this.getValue(source, "ScrollRGB1");
        this.scrollRGB2 = this.getValue(source, "ScrollRGB2");
        this.scrollFrameRGB = this.getValue(source, "ScrollFrameRGB");
        this.scrollFieldFonRGB1 = this.getValue(source, "ScrollFieldFonRGB1");
        this.scrollFieldFonRGB2 = this.getValue(source, "ScrollFieldFonRGB2");
        this.textRGB = this.getValue(source, "TextRGB");
        this.labelRGB = this.getValue(source, "LabelRGB");
        this.entryFieldRGB = this.getValue(source, "EntryFieldRGB");
        this.entryFieldFrameRGB = this.getValue(source, "EntryFieldFrameRGB");
        this.entryFieldTextRGB = this.getValue(source, "EntryFieldTextRGB");
        this.gaugeFieldRGB = this.getValue(source, "GaugeFieldRGB");
        this.gaugeFieldFrameRGB = this.getValue(source, "GaugeFieldFrameRGB");
        this.gaugeProcessRGB1 = this.getValue(source, "GaugeProcessRGB1");
        this.gaugeProcessRGB2 = this.getValue(source, "GaugeProcessRGB2");
        this.gaugeTextRGB = this.getValue(source, "GaugeTextRGB");
        this.alertFonRGB1 = this.getValue(source, "AlertFonRGB1");
        this.alertFonRGB2 = this.getValue(source, "AlertFonRGB2");
        this.alertFrameRGB = this.getValue(source, "AlertFrameRGB");
        this.alertBordRGB = this.getValue(source, "AlertBordRGB");
        this.alertTextRGB = this.getValue(source, "AlertTextRGB");
        this.alertLabelRGB = this.getValue(source, "AlertLabelRGB");
        this.alertScrollRGB1 = this.getValue(source, "AlertScrollRGB1");
        this.alertScrollRGB2 = this.getValue(source, "AlertScrollRGB2");
        this.alertScrollFrameRGB = this.getValue(source, "AlertScrollFrameRGB");
        this.alertScrollFieldFonRGB1 = this.getValue(source, "AlertScrollFieldFonRGB1");
        this.alertScrollFieldFonRGB2 = this.getValue(source, "AlertScrollFieldFonRGB2");
    }

    int getValue(String source, String search) {
        int ind = source.indexOf(search);
        if (ind != -1) {
            try {
                int ind2 = source.indexOf(61, ind);
                if (ind2 != -1) {
                    return Integer.parseInt(source.substring(ind2 + 1, source.indexOf(59, ind2)).trim(), 16);
                }
            }
            catch (Exception e) {
                return 0;
            }
        }
        return 0;
    }
}

