/*
 * Decompiled with CFR 0.152.
 */
package sheet;

import java.util.EmptyStackException;
import java.util.Stack;
import sheet.Calculator;
import sheet.Operand;
import sheet.Operation;

public final class CellCalc {
    private static final short STACK_DEPTH = 10;
    private static final short SYM_DATA = 1;
    private static final short SYM_OPEN_BR = 2;
    private static final short SYM_CLOSE_BR = 3;
    private static final short SYM_DELIMITER = 4;
    private static final short SYM_OPERATION = 5;
    private static final short SYM_STRING = 6;
    private static final short SYM_COMMA = 7;
    private static final short PUSH_NO = 0;
    private static final short PUSH_OPERATION = 1;
    private static final short PUSH_DATA = 2;
    private static final short PUSH_FUNCTION = 3;
    private static final Operation[] OPS = new Operation[]{new Operation(0, 0, 4, '+'), new Operation(1, 0, 4, '-'), new Operation(2, 2, 2, '+'), new Operation(3, 2, 2, '-'), new Operation(4, 2, 3, '*'), new Operation(5, 2, 3, '/'), new Operation(6, 3, 5, '\u0000')};
    private Calculator callBack;
    private IntegerStack operations = new IntegerStack();
    private Stack operands = new Stack();
    private String expression;
    private short last_push;
    private short fargs;

    public CellCalc(Calculator calc) {
        this.callBack = calc;
    }

    private static short symbolType(char c) {
        switch (c) {
            case '(': {
                return 2;
            }
            case ')': {
                return 3;
            }
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return 4;
            }
            case '*': 
            case '+': 
            case '-': 
            case '/': {
                return 5;
            }
            case '\"': {
                return 6;
            }
            case ',': {
                return 7;
            }
        }
        return 1;
    }

    private boolean execute(boolean leaveBracket, int newPrior) throws RuntimeException {
        short op;
        try {
            op = this.operations.pop();
        }
        catch (EmptyStackException e) {
            return false;
        }
        if (op == 7) {
            if (leaveBracket) {
                this.operations.push(op);
            }
            return false;
        }
        if (newPrior > CellCalc.OPS[op].priority) {
            this.operations.push(op);
            return false;
        }
        switch (CellCalc.OPS[op].type) {
            case 2: {
                try {
                    Operand op2 = (Operand)this.operands.pop();
                    Operand op1 = (Operand)this.operands.pop();
                    this.operands.push(this.callBack.oper(op, op1, op2));
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    throw new IllegalArgumentException(Operation.OPNAME[op] + " ops are wrong");
                }
            }
            case 3: {
                Operand[] args = new Operand[this.fargs];
                short i = 0;
                while (i < this.fargs) {
                    args[this.fargs - i - 1] = (Operand)this.operands.pop();
                    i = (short)(i + 1);
                }
                this.fargs = 0;
                this.operands.push(this.callBack.call(Operand.getName((Operand)this.operands.pop()), args));
                break;
            }
            default: {
                this.operands.push(this.callBack.oper(op, (Operand)this.operands.pop(), null));
            }
        }
        return true;
    }

    private short pushOperand(short startIdx, short curIdx) throws IllegalArgumentException {
        if (startIdx != curIdx) {
            Operand data = null;
            if (this.last_push == 3) {
                data = new CellCalc(this.callBack).calculate(this.expression, startIdx, curIdx);
                this.operands.push(data);
                this.fargs = (short)(this.fargs + 1);
            } else {
                data = new Operand(this.expression.substring(startIdx, curIdx));
                this.operands.push(data);
                this.last_push = (short)2;
            }
        }
        return (short)(curIdx + 1);
    }

    public Operand calculate(String expr, short idxStart, short idxEnd) throws IllegalArgumentException {
        short curIdx = idxStart;
        short startIdx = idxStart;
        int brNo = 0;
        while (!this.operands.empty()) {
            this.operands.pop();
        }
        this.operations.clear();
        this.last_push = 0;
        this.expression = expr;
        while (curIdx < idxEnd) {
            char ch = expr.charAt(curIdx);
            switch (CellCalc.symbolType(ch)) {
                case 2: {
                    if (this.last_push == 3) {
                        brNo = (short)(brNo + 1);
                        break;
                    }
                    startIdx = this.pushOperand(startIdx, curIdx);
                    if (this.last_push == 2) {
                        this.operations.push((short)6);
                        this.last_push = (short)3;
                        this.fargs = 0;
                        brNo = 1;
                        break;
                    }
                    this.operations.push((short)7);
                    this.last_push = 1;
                    break;
                }
                case 3: {
                    if (this.last_push == 3) {
                        brNo = (short)(brNo - 1);
                    }
                    if (brNo != 0) break;
                    startIdx = this.pushOperand(startIdx, curIdx);
                    while (this.execute(false, 0)) {
                        this.last_push = (short)2;
                    }
                    break;
                }
                case 7: {
                    if (brNo != true) break;
                    startIdx = this.pushOperand(startIdx, curIdx);
                    break;
                }
                case 6: {
                    if (curIdx != startIdx) {
                        throw new IllegalArgumentException("\" inside text");
                    }
                    while ((curIdx = (short)(curIdx + 1)) < idxEnd && CellCalc.symbolType(expr.charAt(curIdx)) != 6) {
                    }
                    if (curIdx < idxEnd) {
                        curIdx = (short)(curIdx + 1);
                        startIdx = this.pushOperand(startIdx, curIdx);
                        short s = curIdx;
                        curIdx = (short)(s - 1);
                        startIdx = s;
                        break;
                    }
                    throw new IllegalArgumentException("No ending \"");
                }
                case 4: {
                    if (this.last_push == 3) break;
                    startIdx = this.pushOperand(startIdx, curIdx);
                    break;
                }
                case 5: {
                    if (this.last_push == 3) break;
                    startIdx = this.pushOperand(startIdx, curIdx);
                    short op = Operation.find(OPS, ch, this.last_push != 2);
                    try {
                        while (this.execute(true, CellCalc.OPS[op].priority)) {
                            this.last_push = (short)2;
                        }
                        this.operations.push(op);
                        this.last_push = 1;
                        if (CellCalc.OPS[op].type != 1) break;
                        while (this.execute(true, CellCalc.OPS[op].priority)) {
                            this.last_push = (short)2;
                        }
                        break;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("Bad " + String.valueOf(ch));
                    }
                }
            }
            curIdx = (short)(curIdx + 1);
        }
        this.pushOperand(startIdx, curIdx);
        while (this.execute(true, 0)) {
        }
        if (!this.operations.isEmpty()) {
            throw new IllegalArgumentException(Operation.OPNAME[this.operations.pop()] + " doesn't have a match");
        }
        return this.callBack.oper((short)0, (Operand)this.operands.pop(), null);
    }

    private static class IntegerStack {
        private short[] data = new short[10];
        private short top = 0;

        private IntegerStack() {
        }

        public void clear() {
            this.top = 0;
        }

        public boolean isEmpty() {
            return this.top == 0;
        }

        public void push(short elem) throws IllegalArgumentException {
            if (this.top >= this.data.length) {
                throw new IllegalArgumentException("Too complex expression");
            }
            short s = this.top;
            this.top = (short)(s + 1);
            this.data[s] = elem;
        }

        public short pop() throws EmptyStackException {
            if (this.top > 0) {
                this.top = (short)(this.top - 1);
                return this.data[this.top];
            }
            throw new EmptyStackException();
        }
    }
}

