/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;
import javax.microedition.media.control.VolumeControl;

class FileCanvas
extends Canvas {
    private Image image;
    private Image playerctrl;
    private String i1;
    private String i2;
    private String i3;
    private String i4 = null;
    private Player player;
    private VolumeControl vol;
    private VideoControl vc;
    private String ContentType;
    private String[] metaKeys;
    private String[] metaInfo;
    private Image currentImage;

    FileCanvas() {
    }

    private String formatNumber(long num, int len, boolean leadingZeros) {
        StringBuffer ret = new StringBuffer(String.valueOf(num));
        if (leadingZeros) {
            while (ret.length() < len) {
                ret.insert(0, '0');
            }
        } else {
            while (ret.length() < len) {
                ret.append('0');
            }
        }
        return ret.toString();
    }

    private String timeDisplay(long us) {
        long ts = us / 100000L;
        return this.formatNumber(ts / 600L, 2, true) + ":" + this.formatNumber(ts % 600L / 10L, 2, true);
    }

    public String getFileSize(long a) {
        long fSize;
        String memoryType = null;
        for (fSize = a; fSize > 1024L; fSize /= 1024L) {
            memoryType = memoryType == null ? "KB" : "MB";
        }
        return fSize + memoryType;
    }

    public void getMetaInfo(String loc, String f, long size) {
        int spos = f.length() - 3;
        int epos = f.length();
        String type = f.substring(spos, epos);
        this.i1 = f;
        this.i2 = this.getFileSize(size);
        this.i3 = type.toUpperCase();
        this.i4 = this.timeDisplay(this.player.getDuration());
    }

    public void playMedia(String loc, String f, long size, String mediaType) {
        try {
            this.ContentType = mediaType;
            this.player = Manager.createPlayer((String)(loc + f));
            this.player.prefetch();
            this.player.realize();
            if (mediaType.equals("video")) {
                this.vc = (VideoControl)this.player.getControl("VideoControl");
                this.vc.initDisplayMode(1, (Object)this);
                this.vc.setVisible(true);
                this.vc.setDisplaySize(this.getWidth(), this.getHeight());
                this.vc.setDisplayFullScreen(true);
            }
            if (mediaType.equals("audio")) {
                this.getMetaInfo(loc, f, size);
            }
            this.vol = (VolumeControl)this.player.getControl("VolumeControl");
            if (this.vol != null) {
                this.vol.setLevel(50);
            }
            this.player.start();
        }
        catch (IOException io) {
        }
        catch (MediaException me) {
            // empty catch block
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    private final Image getThumbnailWrapper(Image image, int expectedWidth, int expectedHeight, int padding) {
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        int thumbWidth = -1;
        int thumbHeight = -1;
        if (sourceWidth >= sourceHeight) {
            thumbWidth = expectedWidth - padding;
            thumbHeight = thumbWidth * sourceHeight / sourceWidth;
            if (thumbHeight > expectedHeight - padding) {
                thumbHeight = expectedHeight - padding;
                thumbWidth = thumbHeight * sourceWidth / sourceHeight;
            }
        } else {
            thumbHeight = expectedHeight - padding;
            thumbWidth = thumbHeight * sourceWidth / sourceHeight;
            if (thumbWidth > expectedWidth - padding) {
                thumbWidth = expectedWidth - padding;
                thumbHeight = thumbWidth * sourceHeight / sourceWidth;
            }
        }
        thumbHeight = sourceHeight < thumbHeight ? sourceHeight : thumbHeight;
        thumbWidth = sourceWidth < thumbWidth ? sourceWidth : thumbWidth;
        return this.getThumbnail(image, thumbWidth, thumbHeight);
    }

    private final Image getThumbnail(Image image, int thumbWidth, int thumbHeight) {
        int tmp;
        int x;
        int z = 0;
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        int ratio = sourceWidth / thumbWidth;
        int[] in = new int[sourceWidth];
        int[] out = new int[thumbWidth * thumbHeight];
        int[] cols = new int[thumbWidth];
        int pos = 0;
        for (x = 0; x < thumbWidth; ++x) {
            cols[x] = pos;
            tmp = (pos += ratio) + (thumbWidth - x) * ratio;
            if (tmp > sourceWidth) {
                --pos;
                continue;
            }
            if (tmp >= sourceWidth - ratio) continue;
            ++pos;
        }
        pos = 0;
        z = 0;
        for (int y = 0; y < thumbHeight; ++y) {
            image.getRGB(in, 0, sourceWidth, 0, pos, sourceWidth, 1);
            x = 0;
            while (x < thumbWidth) {
                out[z] = in[cols[x]];
                ++x;
                ++z;
            }
            tmp = (pos += ratio) + (thumbHeight - y) * ratio;
            if (tmp > sourceHeight) {
                --pos;
                continue;
            }
            if (tmp >= sourceHeight - ratio) continue;
            ++pos;
        }
        return Image.createRGBImage((int[])out, (int)thumbWidth, (int)thumbHeight, (boolean)true);
    }

    public void setImage(byte[] im) {
        this.ContentType = "Picture";
        this.currentImage = Image.createImage((byte[])im, (int)0, (int)im.length);
        this.currentImage = this.getThumbnailWrapper(this.currentImage, this.getWidth(), this.getHeight(), 1);
    }

    protected void paint(Graphics g) {
        if (this.ContentType.equals("audio")) {
            try {
                this.image = Image.createImage((String)"/resource/art.png");
                this.playerctrl = Image.createImage((String)"/resource/control.png");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            Font f1 = Font.getFont((int)0, (int)1, (int)0);
            g.setColor(207, 218, 231);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.image, this.getWidth(), 0, 24);
            g.setColor(104, 166, 211);
            g.setFont(f1);
            int line = 0;
            g.drawString(this.i1, 5, this.getHeight() / 3 + line, 20);
            g.drawString(this.i2, 5, this.getHeight() / 3 + line + 20, 20);
            g.drawString(this.i3, 5, this.getHeight() / 3 + line + 40, 20);
            g.drawString(this.i4, 5, this.getHeight() / 3 + line + 60, 20);
            g.drawImage(this.playerctrl, this.getWidth() / 2, this.getHeight(), 33);
        } else if (this.ContentType.equals("Picture")) {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.currentImage, 0, this.getHeight() / 2, 6);
        } else {
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public int getWidth() {
        return super.getWidth();
    }

    public int getHeight() {
        return super.getHeight();
    }

    protected void keyPressed(int keyCode) {
        if (keyCode > 0) {
            System.out.println("keyPressed " + (char)keyCode);
        } else {
            System.out.println("keyPressed action " + this.getGameAction(keyCode));
        }
        if ((char)keyCode == '6' || this.getGameAction(keyCode) == 5) {
            new Thread(new Runnable(){

                public void run() {
                    if (FileCanvas.this.player != null) {
                        try {
                            int n = FileCanvas.this.player.getState();
                            FileCanvas.this.player;
                            if (n == 400) {
                                FileCanvas.this.player.stop();
                                long mTime = FileCanvas.this.player.getMediaTime();
                                long jump = 10000000L;
                                long duration = FileCanvas.this.player.getDuration();
                                if (duration >= 0L && (jump = duration / 20L) < 2000000L) {
                                    jump = 2000000L;
                                }
                                FileCanvas.this.player.setMediaTime(mTime + jump);
                                FileCanvas.this.player.start();
                            } else {
                                FileCanvas.this.player.start();
                            }
                        }
                        catch (MediaException mediaException) {
                            // empty catch block
                        }
                    }
                }
            }).start();
        } else if ((char)keyCode == '4' || this.getGameAction(keyCode) == 2) {
            new Thread(new Runnable(){

                public void run() {
                    if (FileCanvas.this.player != null) {
                        try {
                            int n = FileCanvas.this.player.getState();
                            FileCanvas.this.player;
                            if (n == 400) {
                                FileCanvas.this.player.stop();
                                long mTime = FileCanvas.this.player.getMediaTime();
                                long jump = 10000000L;
                                long duration = FileCanvas.this.player.getDuration();
                                if (duration >= 0L && (jump = duration / 20L) < 2000000L) {
                                    jump = 2000000L;
                                }
                                FileCanvas.this.player.setMediaTime(mTime - jump);
                                FileCanvas.this.player.start();
                            } else {
                                FileCanvas.this.player.start();
                            }
                        }
                        catch (MediaException mediaException) {
                            // empty catch block
                        }
                    }
                }
            }).start();
        } else if ((char)keyCode == '5' || this.getGameAction(keyCode) == 8) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        int n = FileCanvas.this.player.getState();
                        FileCanvas.this.player;
                        if (n == 400) {
                            FileCanvas.this.player.stop();
                        } else {
                            FileCanvas.this.player.start();
                        }
                    }
                    catch (MediaException mediaException) {
                        // empty catch block
                    }
                }
            }).start();
        } else if ((char)keyCode == '2' || this.getGameAction(keyCode) == 1) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        FileCanvas.this.vol = (VolumeControl)FileCanvas.this.player.getControl("VolumeControl");
                        if (FileCanvas.this.vol != null) {
                            FileCanvas.this.vol.setLevel(FileCanvas.this.vol.getLevel() + 10);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        } else if ((char)keyCode == '8' || this.getGameAction(keyCode) == 6) {
            new Thread(new Runnable(){

                public void run() {
                    try {
                        FileCanvas.this.vol = (VolumeControl)FileCanvas.this.player.getControl("VolumeControl");
                        if (FileCanvas.this.vol != null) {
                            FileCanvas.this.vol.setLevel(FileCanvas.this.vol.getLevel() - 10);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        }
    }
}

