/*
 * Decompiled with CFR 0.152.
 */
package TorrentEngine;

import Logger.MTLogger;
import TorrentEngine.MTFile;
import TorrentEngine.MTTorrent;
import TorrentEngine.MTTorrentManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import sha1.SHA1;

public class MTFileManager {
    private Vector fileEntries = new Vector();

    public static byte[] viewFile(String string) {
        FileConnection fileConnection = null;
        try {
            fileConnection = (FileConnection)Connector.open((String)("file:///" + string), (int)1);
            InputStream inputStream = fileConnection.openInputStream();
            byte[] byArray = new byte[(int)fileConnection.fileSize()];
            inputStream.read(byArray);
            inputStream.close();
            fileConnection.close();
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static long freeSize(String string) {
        FileConnection fileConnection = null;
        try {
            fileConnection = (FileConnection)Connector.open((String)("file:///" + string), (int)1);
            long l = fileConnection.availableSize();
            return l;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1L;
        }
    }

    public static boolean fileExists(String string) {
        FileConnection fileConnection = null;
        boolean bl = false;
        try {
            fileConnection = (FileConnection)Connector.open((String)("file:///" + string), (int)1);
            bl = fileConnection.exists();
            return bl;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return bl;
        }
    }

    public static void createFolder(String string) {
        FileConnection fileConnection = null;
        try {
            int n = string.indexOf("/");
            String string2 = string.substring(0, n + 1);
            String string3 = string.substring(n + 1);
            while (n > 0) {
                fileConnection = (FileConnection)Connector.open((String)("file:///" + string2), (int)3);
                if (!fileConnection.exists()) {
                    fileConnection.mkdir();
                }
                n = string3.indexOf("/");
                string2 = string2 + string3.substring(0, n + 1);
                string3 = string3.substring(n + 1);
            }
            fileConnection.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public synchronized FileEntry getFileEntry(String string) {
        FileEntry fileEntry = null;
        for (int i = 0; i < this.fileEntries.size(); ++i) {
            fileEntry = (FileEntry)this.fileEntries.elementAt(i);
            if (!fileEntry.getPath().equals(string)) continue;
            return fileEntry;
        }
        return null;
    }

    public synchronized void closeFileEntry(FileEntry fileEntry) {
        try {
            if (fileEntry.getConnection() != null) {
                fileEntry.getConnection().close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public synchronized void closeAll() {
        for (int i = 0; i < this.fileEntries.size(); ++i) {
            this.closeFileEntry((FileEntry)this.fileEntries.elementAt(i));
        }
        this.fileEntries.removeAllElements();
    }

    public int writeFile(MTFile mTFile, int n, byte[] byArray) {
        return this.writeFile(mTFile, n, byArray, 0, byArray.length);
    }

    public synchronized int writeFile(MTFile mTFile, int n, byte[] byArray, int n2, int n3) {
        block6: {
            FileConnection fileConnection = null;
            OutputStream outputStream = null;
            try {
                FileEntry fileEntry = this.getFileEntry(mTFile.getPath());
                fileConnection = fileEntry == null ? (FileConnection)Connector.open((String)("file:///" + mTFile.getPath()), (int)3) : fileEntry.getConnection();
                if (fileConnection.exists()) {
                    outputStream = fileConnection.openOutputStream((long)n);
                    outputStream.write(byArray, n2, n3);
                    outputStream.flush();
                    outputStream.close();
                    if (fileEntry == null) {
                        fileEntry = new FileEntry();
                        fileEntry.setPath(mTFile.getPath());
                        fileEntry.setConnection(fileConnection);
                        this.fileEntries.addElement(fileEntry);
                    }
                    break block6;
                }
                MTLogger.writeLine("[FILE] error");
                fileConnection.close();
                if (fileEntry != null && this.fileEntries.indexOf(fileEntry) > 0) {
                    this.fileEntries.removeElement(fileEntry);
                }
                return -6;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                MTLogger.writeLine("[FILE] " + iOException.getMessage());
                return -6;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MTLogger.writeLine("[FILE] " + exception.getMessage());
                return -6;
            }
        }
        return 0;
    }

    public synchronized byte[] read(MTFile mTFile, int n, int n2) {
        byte[] byArray;
        block12: {
            FileConnection fileConnection = null;
            InputStream inputStream = null;
            byArray = new byte[n2];
            try {
                FileEntry fileEntry = this.getFileEntry(mTFile.getPath());
                fileConnection = fileEntry == null ? (FileConnection)Connector.open((String)("file:///" + mTFile.getPath()), (int)3) : fileEntry.getConnection();
                if (fileConnection.exists()) {
                    inputStream = fileConnection.openInputStream();
                    int n3 = 5000;
                    if (n == 0) {
                        inputStream.read(byArray);
                    } else if (n < n3) {
                        inputStream.skip(n);
                        inputStream.read(byArray);
                    } else {
                        int n4 = n % n3;
                        byte[] byArray2 = new byte[n3];
                        for (int i = n - n4; i > 0; i -= n3) {
                            inputStream.read(byArray2);
                        }
                        byArray2 = null;
                        if (n4 > 0) {
                            byte[] byArray3 = new byte[n4];
                            inputStream.read(byArray3);
                            byArray3 = null;
                        }
                        inputStream.read(byArray);
                    }
                    inputStream.close();
                    if (fileEntry == null) {
                        fileEntry = new FileEntry();
                        fileEntry.setPath(mTFile.getPath());
                        fileEntry.setConnection(fileConnection);
                        this.fileEntries.addElement(fileEntry);
                    }
                    break block12;
                }
                fileConnection.close();
                if (fileEntry != null && this.fileEntries.indexOf(fileEntry) > 0) {
                    this.fileEntries.removeElement(fileEntry);
                }
                return null;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MTLogger.writeLine("[FILE] " + exception.getMessage());
                return null;
            }
        }
        return byArray;
    }

    public synchronized SHA1 readHashed(MTFile mTFile, int n, int n2, SHA1 sHA1) {
        block12: {
            FileConnection fileConnection = null;
            InputStream inputStream = null;
            long l = 0L;
            try {
                FileEntry fileEntry = this.getFileEntry(mTFile.getPath());
                fileConnection = fileEntry == null ? (FileConnection)Connector.open((String)("file:///" + mTFile.getPath()), (int)3) : fileEntry.getConnection();
                if (fileConnection.exists()) {
                    byte[] byArray;
                    int n3;
                    inputStream = fileConnection.openInputStream();
                    int n4 = 32768;
                    int n5 = 1000;
                    l = System.currentTimeMillis();
                    if (n < n5) {
                        inputStream.skip(n);
                        MTLogger.writeLine("BUILTINSKIP");
                    } else {
                        n3 = n % n4;
                        byArray = new byte[n4];
                        for (int i = n - n3; i > 0; i -= n4) {
                            inputStream.read(byArray);
                        }
                        byArray = null;
                        if (n3 > 0) {
                            byte[] byArray2 = new byte[n3];
                            inputStream.read(byArray2);
                            byArray2 = null;
                        }
                    }
                    MTLogger.writeLine("HASHREADSKIP: " + (System.currentTimeMillis() - l));
                    l = System.currentTimeMillis();
                    n3 = 20480;
                    byte[] byArray3 = new byte[n3];
                    while (n2 > 0) {
                        if (n2 >= n3) {
                            inputStream.read(byArray3);
                            sHA1.update(byArray3);
                            n2 -= n3;
                            continue;
                        }
                        byArray = new byte[n2];
                        inputStream.read(byArray);
                        sHA1.update(byArray);
                        n2 -= n2;
                        byArray = null;
                    }
                    MTLogger.writeLine("HASHCALCULATION: " + (System.currentTimeMillis() - l));
                    byArray3 = null;
                    inputStream.close();
                    if (fileEntry == null) {
                        fileEntry = new FileEntry();
                        fileEntry.setPath(mTFile.getPath());
                        fileEntry.setConnection(fileConnection);
                        this.fileEntries.addElement(fileEntry);
                    }
                    break block12;
                }
                fileConnection.close();
                if (fileEntry != null && this.fileEntries.indexOf(fileEntry) > 0) {
                    this.fileEntries.removeElement(fileEntry);
                }
                return null;
            }
            catch (IOException iOException) {
                MTLogger.writeLine("read piece hash ERROR: " + iOException.getMessage());
                iOException.printStackTrace();
                return null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                MTLogger.writeLine("[FILE] " + exception.getMessage());
                return null;
            }
        }
        return sHA1;
    }

    public static int createFile(String string, long l, MTTorrentManager mTTorrentManager, MTTorrent mTTorrent, String string2) {
        MTLogger.writeLine("FileManager: creating file: " + string + " (" + l + ")");
        FileConnection fileConnection = null;
        OutputStream outputStream = null;
        try {
            int n = string.indexOf("/");
            String string3 = string.substring(0, n + 1);
            String string4 = string.substring(n + 1);
            while (n > 0) {
                fileConnection = (FileConnection)Connector.open((String)("file:///" + string3), (int)3);
                if (!fileConnection.exists()) {
                    fileConnection.mkdir();
                }
                n = string4.indexOf("/");
                string3 = string3 + string4.substring(0, n + 1);
                string4 = string4.substring(n + 1);
            }
            fileConnection = (FileConnection)Connector.open((String)("file:///" + string), (int)3);
            long l2 = 0L;
            if (fileConnection.exists()) {
                l2 = fileConnection.fileSize();
                if (l2 > l) {
                    fileConnection.truncate(l);
                    l2 = l;
                }
            } else {
                fileConnection.create();
            }
            outputStream = fileConnection.openOutputStream(l2);
            long l3 = l - l2;
            byte[] byArray = new byte[262144];
            double d = 0.0;
            while (262144L <= l3) {
                outputStream.write(byArray);
                d = (double)((l - (l3 -= 262144L)) * 100L) / (double)l;
                mTTorrentManager.notifyOpenTorrentStateChanged(1, mTTorrent, string2, d);
            }
            outputStream.write(byArray, 0, (int)l3);
            outputStream.flush();
            byArray = null;
            mTTorrentManager.notifyOpenTorrentStateChanged(1, mTTorrent, string2, 100.0);
            outputStream.close();
            fileConnection.close();
            System.gc();
        }
        catch (Exception exception) {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (fileConnection != null) {
                    fileConnection.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            exception.printStackTrace();
            return -6;
        }
        return 0;
    }

    class FileEntry {
        private String path;
        private FileConnection connection = null;

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public FileConnection getConnection() {
            return this.connection;
        }

        public void setConnection(FileConnection fileConnection) {
            this.connection = fileConnection;
        }
    }
}

