/*
 * Decompiled with CFR 0.152.
 */
package TorrentEngine;

import Logger.MTLogger;
import Settings.Preferences;
import TorrentEngine.MTNetworkStatusManager;
import TorrentEngine.MTTorrentManager;
import java.io.IOException;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;

public class MTNetworkManager {
    private MTTorrentManager torrentManager;
    private boolean isListening = false;
    private ServerSocketConnection serverconn;
    private AcceptConnectionThread acceptConnectionThread;

    public MTNetworkManager(MTTorrentManager mTTorrentManager) {
        this.torrentManager = mTTorrentManager;
    }

    public void startListening() {
        if (!this.isListening) {
            try {
                MTLogger.writeLine("--- START LISTENING");
                this.serverconn = (ServerSocketConnection)MTNetworkStatusManager.connect("socket://:6882", 3);
                Preferences.LocalAddress = this.serverconn.getLocalAddress();
                MTLogger.writeLine("--- LISTENING STARTED ON: " + this.serverconn.getLocalAddress() + ":" + this.serverconn.getLocalPort());
                this.isListening = true;
                this.acceptConnectionThread = new AcceptConnectionThread();
                this.acceptConnectionThread.start();
            }
            catch (Exception exception) {
                MTLogger.writeLine("Server socket open error: " + exception.getMessage());
            }
        }
    }

    public void stopListening() {
        this.isListening = false;
        try {
            if (this.serverconn != null) {
                this.serverconn.close();
            }
        }
        catch (IOException iOException) {
            MTLogger.writeLine("Server socket close error: " + iOException.getMessage());
        }
        try {
            this.acceptConnectionThread = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public class AcceptConnectionThread
    extends Thread {
        public void run() {
            while (MTNetworkManager.this.isListening) {
                try {
                    MTLogger.writeLine("--- Wait for accepting");
                    SocketConnection socketConnection = (SocketConnection)MTNetworkManager.this.serverconn.acceptAndOpen();
                    MTNetworkManager.this.torrentManager.registerIncomingConnection(socketConnection);
                    MTLogger.writeLine("--- CONNECTION ACCEPTED!!!");
                    AcceptConnectionThread.sleep(3000L);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    MTLogger.writeLine("--- ACCEPT TERMINTATED: " + iOException.getMessage());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    MTLogger.writeLine("--- ACCEPT TERMINTATED(e): " + exception.getMessage());
                }
            }
        }
    }
}

