/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;

public class BackupParser {
    private BackupRecordHandler recordHandler;
    private BufferedReader backupReader;

    public void parse(InputStream backupFileStream, BackupRecordHandler recordHandler) throws IOException {
        String lineWithEol;
        if (backupFileStream == null) {
            throw new IllegalArgumentException("backupFileStream may not be null");
        }
        if (recordHandler == null) {
            throw new IllegalArgumentException("recordHandler may not be null");
        }
        System.out.println("BackupParser.parse: starting...");
        this.recordHandler = recordHandler;
        this.backupReader = new BufferedReader(backupFileStream);
        String readEncoding = "ISO-8859-1";
        this.backupReader.setReadEncoding("ISO-8859-1");
        int lineCount = 0;
        boolean withinContact = false;
        boolean withinCalendar = false;
        boolean recordEndReached = false;
        StringBuffer recordText = new StringBuffer();
        int recordType = -1;
        String recordSubTypeName = null;
        while ((lineWithEol = this.backupReader.readLine()) != null) {
            ++lineCount;
            String lineEolLess = lineWithEol.trim();
            String lineEolLessUC = lineEolLess.toUpperCase();
            if ("BEGIN:VCARD".equals(lineEolLessUC)) {
                withinContact = true;
                recordType = 1;
            } else if ("END:VCARD".equals(lineEolLessUC)) {
                withinContact = false;
                recordEndReached = true;
            } else if ("BEGIN:VCALENDAR".equals(lineEolLessUC)) {
                withinCalendar = true;
            } else if ("END:VCALENDAR".equals(lineEolLessUC)) {
                withinCalendar = false;
                recordEndReached = true;
            } else if (withinCalendar) {
                if ("BEGIN:VTODO".equals(lineEolLessUC)) {
                    recordType = 3;
                } else if ("BEGIN:VEVENT".equals(lineEolLessUC)) {
                    recordType = 2;
                }
            }
            if (withinCalendar || withinContact || recordEndReached) {
                recordText.append(lineWithEol);
            } else if (!recordEndReached) {
                if (lineEolLess.startsWith("# Contacts ")) {
                    recordSubTypeName = lineEolLess.substring("# Contacts ".length());
                } else if (lineEolLess.startsWith("# Calendar ")) {
                    recordSubTypeName = lineEolLess.substring("# Calendar ".length());
                } else if (lineEolLess.startsWith("# TODO ")) {
                    recordSubTypeName = lineEolLess.substring("# TODO ".length());
                }
                System.out.println("BackupParser.parse: trash line: " + lineEolLess);
            }
            if (!recordEndReached) continue;
            recordHandler.handleRecord(recordType, recordSubTypeName, recordText.toString().getBytes("ISO-8859-1"));
            recordText.setLength(0);
            recordEndReached = false;
            recordType = -1;
        }
        System.out.println("BackupParser.parse: done, #lines=" + lineCount);
    }
}

