/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import mynotes.Utils;

public class FileDescriptor {
    static final int T_NORMAL = 1;
    static final int T_ENCRYPTED = 16;
    static final int T_CHECKLIST = 256;
    static final int T_BROKEN = 1;
    static final int T_DELETED = 1;
    int id;
    int parentDirId;
    int dirRecordId;
    int type;
    int size;
    long date;
    boolean isDirectory;
    String name;
    int recordId;

    byte[] toByteArray() {
        byte[] data = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream das = new DataOutputStream(baos);
            das.writeInt(this.id);
            das.writeInt(this.parentDirId);
            das.writeInt(this.dirRecordId);
            das.writeInt(this.type);
            das.writeInt(this.size);
            das.writeLong(this.date);
            das.writeBoolean(this.isDirectory);
            das.writeUTF(this.name);
            data = baos.toByteArray();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Utils.encrypt(data);
        return data;
    }

    public boolean fromByteArray(byte[] data) {
        Utils.encrypt(data);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data, 0, data.length);
            DataInputStream dis = new DataInputStream(bais);
            this.id = dis.readInt();
            this.parentDirId = dis.readInt();
            this.dirRecordId = dis.readInt();
            this.type = dis.readInt();
            this.size = dis.readInt();
            this.date = dis.readLong();
            this.isDirectory = dis.readBoolean();
            this.name = dis.readUTF();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public int compareTo(Object o) {
        FileDescriptor fd = (FileDescriptor)o;
        return this.name.compareTo(fd.name);
    }

    public FileDescriptor clone() {
        FileDescriptor fd = new FileDescriptor();
        fd.id = this.id;
        fd.parentDirId = this.parentDirId;
        fd.dirRecordId = this.dirRecordId;
        fd.type = this.type;
        fd.size = this.size;
        fd.date = this.date;
        fd.isDirectory = this.isDirectory;
        fd.name = this.name;
        fd.recordId = this.recordId;
        return fd;
    }
}

