/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import mynotes.MyNotes;

public class FontsManager {
    private static final String KEY = "fonts";
    private static final String DELIM = ",";
    public static final int A_LISTS = 0;
    public static final int A_CONTEXTMENU = 1;
    public static final int A_NOTESVIEWER = 2;
    private static final int NUM_OF_FONTS = 3;
    Hashtable fonts = new Hashtable(3);
    private static volatile FontsManager instance;
    static /* synthetic */ Class class$mynotes$FontsManager;

    private FontsManager() {
        this.loadSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FontsManager getInstance() {
        if (instance == null) {
            Class clazz = class$mynotes$FontsManager == null ? (class$mynotes$FontsManager = FontsManager.class$("mynotes.FontsManager")) : class$mynotes$FontsManager;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new FontsManager();
                }
            }
        }
        return instance;
    }

    public void saveSettings() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.fontToString(0));
        sb.append(this.fontToString(1));
        sb.append(this.fontToString(2));
        MyNotes.properties.put(KEY, sb.toString(), 9);
    }

    private void loadSettings() {
        String s = MyNotes.properties.getStringValue(KEY);
        if (s == null) {
            this.setDefaultFonts();
            this.saveSettings();
        } else {
            int delimIndex;
            Vector<Integer> params = new Vector<Integer>(9);
            int startIndex = 0;
            while ((delimIndex = s.indexOf(DELIM, startIndex)) != -1 && startIndex < s.length()) {
                String numeric = s.substring(startIndex, delimIndex);
                params.addElement(Integer.valueOf(numeric));
                startIndex = delimIndex + 1;
            }
            if (params.size() == 9) {
                this.setFont(0, (Integer)params.elementAt(0), (Integer)params.elementAt(1), (Integer)params.elementAt(2));
                this.setFont(1, (Integer)params.elementAt(3), (Integer)params.elementAt(4), (Integer)params.elementAt(5));
                this.setFont(2, (Integer)params.elementAt(6), (Integer)params.elementAt(7), (Integer)params.elementAt(8));
            } else {
                this.setDefaultFonts();
                this.saveSettings();
            }
        }
    }

    private String fontToString(int type) {
        Font font = this.getFont(type);
        StringBuffer sb = new StringBuffer();
        sb.append(Integer.toString(font.getFace()));
        sb.append(DELIM);
        sb.append(Integer.toString(font.getStyle()));
        sb.append(DELIM);
        sb.append(Integer.toString(font.getSize()));
        sb.append(DELIM);
        return sb.toString();
    }

    public Font getFont(int type) {
        Font font = (Font)this.fonts.get(new Integer(type));
        if (font == null) {
            return Font.getDefaultFont();
        }
        return font;
    }

    public void setFont(int type, int face, int style, int size) {
        Font value;
        Integer key = new Integer(type);
        try {
            value = Font.getFont((int)face, (int)style, (int)size);
        }
        catch (IllegalArgumentException ex) {
            value = Font.getDefaultFont();
        }
        this.fonts.put(key, value);
    }

    public void setFont(int type, Font font) {
        this.setFont(type, font.getFace(), font.getStyle(), font.getSize());
    }

    public void setDefaultFont(int type) {
        this.setFont(type, Font.getDefaultFont());
    }

    public void setDefaultFonts() {
        this.setFont(0, 0, 0, 0);
        this.setFont(1, 0, 0, 8);
        this.setFont(2, 0, 0, 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

