/*
 * Decompiled with CFR 0.152.
 */
package mynotes;

import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mynotes.ColorScheme;
import mynotes.FontsManager;
import mynotes.MyNotes;
import mynotes.ResourceBundle;

public class MyList
extends Canvas {
    static final int SIZE_INC = 5;
    int numOfItems = 0;
    String[] strings = new String[5];
    Image[] images = new Image[5];
    int currentItemIndex;
    Graphics g;
    int _x;
    int _y;
    int width;
    int height;
    Font font;
    Font menuFont;
    int lineHeight;
    int menuLineHeight;
    int topItemIndex;
    boolean isFirstRun;
    int scrollBarWidth = 5;
    int totalHeight;
    int menuBarHeight;
    int titleBarHeight;
    int listHeight;
    int menuWidth;
    boolean inMenu;
    CommandListener listener;
    String title;
    Vector commands;
    int currentCommand;
    private static final int DOUBLE_CLICK_TIME = 500;
    long previousPressTime;
    int previousPressedX = -1;
    int previousPressedY = -1;

    public MyList(String aTitle) {
        this.updateFont();
        this.title = aTitle;
        this.isFirstRun = true;
        this.topItemIndex = 0;
        this.lineHeight = 18;
        this.menuLineHeight = 18;
        this.menuBarHeight = 18;
        this.titleBarHeight = 18;
        this.commands = new Vector();
        this.deleteCommands();
        this.inMenu = false;
        this.previousPressTime = 0L;
    }

    public void deleteCommands() {
        this.commands.removeAllElements();
        this.commands.addElement(null);
        this.commands.addElement(null);
    }

    public void initGraphics(Graphics g) {
        this.g = g;
        this._x = 0;
        this._y = 0;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.updateFont();
        this.updateMenuWidth();
        this.setSelectedIndex(0);
    }

    public void updateMenuWidth() {
        int maxWidth = 0;
        for (int i = 2; i < this.commands.size(); ++i) {
            Command c = (Command)this.commands.elementAt(i);
            int currWidth = this.menuFont.stringWidth(c.getLabel());
            if (currWidth <= maxWidth) continue;
            maxWidth = currWidth;
        }
        this.menuWidth = maxWidth;
    }

    public void updateFont() {
        FontsManager fm = FontsManager.getInstance();
        this.font = fm.getFont(0);
        this.menuBarHeight = this.lineHeight = this.font.getHeight() + 2;
        this.titleBarHeight = this.lineHeight;
        this.listHeight = this.height - this.menuBarHeight - this.titleBarHeight;
        this.menuFont = fm.getFont(1);
        this.menuLineHeight = this.menuFont.getHeight() + 2;
    }

    public int append(String string, Image image) {
        if (this.numOfItems == this.strings.length) {
            String[] newStrings = new String[this.numOfItems + 5];
            Image[] newImages = new Image[this.numOfItems + 5];
            System.arraycopy(this.strings, 0, newStrings, 0, this.numOfItems);
            System.arraycopy(this.images, 0, newImages, 0, this.numOfItems);
            this.strings = newStrings;
            this.images = newImages;
        }
        this.strings[this.numOfItems] = string;
        this.images[this.numOfItems] = image;
        ++this.numOfItems;
        this.repaint();
        return this.numOfItems;
    }

    public void set(int itemNum, String name, Image icon) {
        if (itemNum < 0 || itemNum > this.numOfItems) {
            throw new IndexOutOfBoundsException();
        }
        this.strings[itemNum] = name;
        this.images[itemNum] = icon;
        this.repaint();
    }

    public void delete(int itemNum) {
        if (itemNum < 0 || itemNum > this.numOfItems) {
            throw new IndexOutOfBoundsException();
        }
        if (itemNum != this.numOfItems - 1) {
            System.arraycopy(this.strings, itemNum + 1, this.strings, itemNum, this.numOfItems - itemNum - 1);
            System.arraycopy(this.images, itemNum + 1, this.images, itemNum, this.numOfItems - itemNum - 1);
        }
        --this.numOfItems;
        if (this.currentItemIndex > itemNum) {
            --this.currentItemIndex;
        }
        if (this.currentItemIndex >= this.numOfItems) {
            this.currentItemIndex = this.numOfItems - 1;
        }
        this.repaint();
    }

    public void deleteAll() {
        this.numOfItems = 0;
        this.repaint();
    }

    public void setSelectedIndex(int itemNum) {
        int bottomItem;
        if (itemNum < 0 || itemNum > this.numOfItems) {
            return;
        }
        this.currentItemIndex = itemNum;
        int onScreenItems = this.listHeight / this.lineHeight;
        if (this.currentItemIndex < this.topItemIndex) {
            this.topItemIndex = this.currentItemIndex;
        }
        if ((bottomItem = this.topItemIndex + onScreenItems - 1) > this.numOfItems) {
            bottomItem = this.numOfItems;
        }
        if (this.currentItemIndex >= bottomItem) {
            this.topItemIndex += this.currentItemIndex - bottomItem;
        }
        this.repaint();
    }

    public int getSelectedIndex() {
        return this.currentItemIndex;
    }

    public int size() {
        return this.numOfItems;
    }

    public void drawList() {
        this.g.setFont(this.font);
        this.g.setColor(ColorScheme.CL_LISTBACKGROUND);
        this.g.fillRect(this._x, this._y, this.width, this.height);
        this.g.setColor(ColorScheme.CL_LISTFONT);
        int baseY = this._y + this.titleBarHeight - this.lineHeight;
        for (int i = this.topItemIndex; i < this.numOfItems && (baseY += this.lineHeight) <= this.listHeight + this._y; ++i) {
            if (i == this.currentItemIndex) {
                this.g.setColor(ColorScheme.CL_SELECTEDBACKGROUND);
                this.g.fillRect(this._x, baseY, this.width - this.scrollBarWidth, this.lineHeight);
                this.g.setColor(ColorScheme.CL_SELECTEDFONT);
            } else {
                this.g.setColor(ColorScheme.CL_LISTFONT);
            }
            this.g.setFont(this.font);
            this.g.drawString(this.strings[i], this._x + 20, baseY + 1, 20);
            if (this.images[i] == null) continue;
            this.g.drawImage(this.images[i], this._x + 1, baseY + this.lineHeight / 2, 6);
        }
    }

    void drawTitleBar() {
        this.g.setColor(ColorScheme.CL_TITLEBARBACKGROUND);
        this.g.fillRect(this._x, this._y, this.width, this.titleBarHeight);
        this.g.setColor(ColorScheme.CL_TITLEBARFONT);
        if (this.title != null) {
            this.g.setFont(this.font);
            this.g.drawString(this.title, this._x + 1, this._y + 1, 20);
        }
    }

    void drawMenuBar() {
        Command c;
        this.g.setFont(this.font);
        this.g.setColor(ColorScheme.CL_MENUBARBACKGROUND);
        this.g.fillRect(this._x, this.height + this._y - this.menuBarHeight, this.width, this.menuBarHeight);
        this.g.setColor(ColorScheme.CL_MENUBARFONT);
        if (this.commands.size() > 2) {
            if (this.commands.size() == 3) {
                c = (Command)this.commands.elementAt(2);
                this.g.drawString(c.getLabel(), this._x + 3, this.height + this._y - this.menuBarHeight + 1, 20);
            } else {
                this.g.drawString(ResourceBundle.getString("menu"), this._x + 3, this.height + this._y - this.menuBarHeight + 1, 20);
            }
        }
        if ((c = (Command)this.commands.elementAt(1)) != null) {
            this.g.drawString(c.getLabel(), this.width + this._x - 3, this.height + this._y - this.menuBarHeight + 1, 24);
        }
        if ((c = (Command)this.commands.elementAt(0)) != null) {
            this.g.drawString(c.getLabel(), (this.width + this._x - this.scrollBarWidth) / 2, this.height + this._y - this.menuBarHeight + 1, 17);
        }
    }

    public void drawScrollBar() {
        this.totalHeight = this.numOfItems * this.lineHeight;
        int upInvis = this.topItemIndex * this.lineHeight;
        int midAndDown = this.totalHeight - upInvis;
        int midVis = midAndDown > this.listHeight ? this.listHeight : midAndDown;
        int sbHeight = 0;
        int sbTop = 0;
        double scale = 1.0;
        if (this.totalHeight < this.listHeight) {
            sbTop = 0;
            sbHeight = this.listHeight;
            scale = 1.0;
        } else {
            scale = (double)midVis / (double)this.totalHeight;
            if (scale < 0.1) {
                scale = 0.1;
            }
            sbHeight = (int)((double)this.listHeight * scale);
            sbTop = (int)((double)this.listHeight * (double)upInvis / (double)this.totalHeight);
        }
        if (sbHeight != this.listHeight) {
            this.g.setColor(ColorScheme.CL_SCROLLBAR);
            this.g.fillRect(this.width + this._x - this.scrollBarWidth, this._y + this.titleBarHeight, this.scrollBarWidth, this.listHeight);
            this.g.setColor(ColorScheme.CL_SCROLLBOX);
            this.g.fillRect(this.width + this._x - this.scrollBarWidth, this._y + this.titleBarHeight + sbTop, this.scrollBarWidth, sbHeight);
        }
    }

    public void drawMenu() {
        this.g.setFont(this.menuFont);
        int menuSize = this.commands.size() - 2;
        this.g.setColor(ColorScheme.CL_MENUBACKGROUND);
        this.g.fillRect(this._x, this.height - this.menuBarHeight - menuSize * this.menuLineHeight - 1, this.menuWidth + 11, menuSize * this.menuLineHeight + 1);
        this.g.setColor(ColorScheme.CL_MENUBORDER);
        this.g.drawRect(this._x, this.height - this.menuBarHeight - menuSize * this.menuLineHeight - 1, this.menuWidth + 11, menuSize * this.menuLineHeight + 1);
        if (menuSize != 0) {
            for (int i = 2; i < this.commands.size(); ++i) {
                Command c = (Command)this.commands.elementAt(i);
                if (i - 2 == this.currentCommand) {
                    this.g.setColor(ColorScheme.CL_SELECTEDMENUBACKGROUND);
                    this.g.fillRect(this._x + 1, this.height - this.menuBarHeight - (menuSize - i + 2) * this.menuLineHeight, this.menuWidth + 10, this.menuLineHeight);
                    this.g.setColor(ColorScheme.CL_SELECTEDMENUFONT);
                } else {
                    this.g.setColor(ColorScheme.CL_MENUFONT);
                }
                this.g.drawString(c.getLabel(), this._x + 5, this.height - this.menuBarHeight - (menuSize - i + 2) * this.menuLineHeight, 20);
            }
        }
    }

    protected void paint(Graphics g) {
        if (this.isFirstRun) {
            this.initGraphics(g);
            this.isFirstRun = false;
        }
        this.drawList();
        this.drawScrollBar();
        this.drawMenuBar();
        this.drawTitleBar();
        if (this.inMenu && this.commands.size() > 2) {
            this.drawMenu();
        }
    }

    public void activate() {
        this.inMenu = false;
        this.setFullScreenMode(true);
        MyNotes.display.setCurrent((Displayable)this);
    }

    public void setTitle(String aTitle) {
        this.title = aTitle;
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    public String getString(int index) {
        if (index >= 0 && index < this.strings.length) {
            return this.strings[index];
        }
        return null;
    }

    public void setCommandListener(CommandListener listener) {
        this.listener = listener;
    }

    protected void keyRepeated(int keyCode) {
        if (this.hasRepeatEvents()) {
            // empty if block
        }
    }

    public void onRightSoftKeyPressed() {
        if (this.inMenu) {
            this.inMenu = false;
        } else if (this.listener != null) {
            Command c = (Command)this.commands.elementAt(1);
            this.listener.commandAction(c, (Displayable)this);
        }
    }

    public void onLeftSoftKeyPressed() {
        if (!this.inMenu && this.commands.size() > 2) {
            if (this.commands.size() == 3) {
                Command c = (Command)this.commands.elementAt(2);
                this.listener.commandAction(c, (Displayable)this);
            } else {
                this.inMenu = true;
                this.currentCommand = 0;
            }
        } else if (this.inMenu) {
            this.inMenu = false;
        }
    }

    public void onFire() {
        if (this.listener != null) {
            Command c = (Command)this.commands.elementAt(this.inMenu ? this.currentCommand + 2 : 0);
            this.inMenu = false;
            this.listener.commandAction(c, (Displayable)this);
        }
    }

    public void onUp() {
        if (this.inMenu) {
            this.currentCommand = this.currentCommand != 0 ? --this.currentCommand : this.commands.size() - 3;
        } else {
            this.lineUp();
        }
    }

    public void onDown() {
        if (this.inMenu) {
            this.currentCommand = this.currentCommand != this.commands.size() - 3 ? ++this.currentCommand : 0;
        } else {
            this.lineDown();
        }
    }

    public void onLeft() {
        this.onLeft();
        if (!this.inMenu && this.numOfItems != 0) {
            this.pageUp();
        }
    }

    public void onRight() {
        if (!this.inMenu && this.numOfItems != 0) {
            this.pageDown();
        }
    }

    protected void keyPressed(int keyCode) {
        int action = 2128506;
        try {
            action = this.getGameAction(keyCode);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (keyCode == -7 || keyCode == -22 || keyCode == 22 || keyCode == -203 || keyCode == 35) {
            this.onRightSoftKeyPressed();
        }
        if (keyCode == -6 || keyCode == -21 || keyCode == 21 || keyCode == -202 || keyCode == 42) {
            this.onLeftSoftKeyPressed();
        }
        if (action == 8 || keyCode == 53) {
            this.onFire();
        }
        if (action == 1 || keyCode == 50) {
            this.onUp();
        }
        if (action == 6 || keyCode == 56) {
            this.onDown();
        }
        if (action == 2 || keyCode == 51) {
            // empty if block
        }
        if (action == 5 || keyCode == 57) {
            // empty if block
        }
        if (keyCode == 49) {
            if (!this.inMenu) {
                if (this.numOfItems != 0) {
                    this.currentItemIndex = 0;
                }
            } else {
                this.currentCommand = 0;
            }
        }
        if (keyCode == 55) {
            if (!this.inMenu) {
                if (this.numOfItems != 0) {
                    this.currentItemIndex = this.numOfItems - 1;
                }
            } else {
                this.currentCommand = this.commands.size() - 3;
            }
        }
        this.setSelectedIndex(this.currentItemIndex);
    }

    protected void pointerPressed(int x, int y) {
        boolean isFastEnough = System.currentTimeMillis() - this.previousPressTime < 500L;
        this.previousPressTime = System.currentTimeMillis();
        if (y < this._y + this.titleBarHeight) {
            // empty if block
        }
        if (y >= this._y + this.titleBarHeight + this.listHeight) {
            if (x < this._x + this.width / 3) {
                this.onLeftSoftKeyPressed();
            } else if (x > this._x + 2 * this.width / 3) {
                this.onRightSoftKeyPressed();
            } else {
                this.onFire();
            }
        }
        if (y >= this._y + this.titleBarHeight && y < this._y + this.titleBarHeight + this.listHeight) {
            if (!this.inMenu) {
                int currentItemSave = this.currentItemIndex;
                this.previousPressedX = x;
                this.previousPressedY = y;
                this.currentItemIndex = this.topItemIndex + (y - this._y - this.titleBarHeight) / this.lineHeight;
                if (this.currentItemIndex > this.numOfItems) {
                    this.currentItemIndex = this.numOfItems - 1;
                }
                if (currentItemSave == this.currentItemIndex && isFastEnough) {
                    this.onFire();
                }
            }
            if (this.inMenu) {
                int menuSize = this.commands.size() - 2;
                int currentCommandSave = this.currentCommand;
                this.currentCommand = (y - this._y - this.height + this.menuBarHeight + menuSize * this.menuLineHeight) / this.menuLineHeight;
                if (this.currentCommand < 0) {
                    this.currentCommand = 0;
                }
                if (currentCommandSave == this.currentCommand && isFastEnough) {
                    this.onFire();
                }
            }
        }
        System.out.println(this.currentItemIndex);
        this.setSelectedIndex(this.currentItemIndex);
    }

    protected void pointerDragged(int x, int y) {
        if (!this.inMenu && y >= this._y + this.titleBarHeight && y < this._y + this.titleBarHeight + this.listHeight) {
            int i;
            if (this.numOfItems <= this.listHeight / this.lineHeight) {
                return;
            }
            int deltaY = y - this.previousPressedY;
            int deltaLines = deltaY / this.lineHeight;
            System.out.println(deltaLines);
            if (deltaLines < 0) {
                for (i = 0; i < -deltaLines; ++i) {
                    ++this.topItemIndex;
                    int maxTopItem = this.numOfItems - this.listHeight / this.lineHeight;
                    if (this.topItemIndex <= maxTopItem) continue;
                    this.topItemIndex = maxTopItem;
                }
                this.previousPressedX = x;
                this.previousPressedY = y;
            }
            if (deltaLines > 0) {
                for (i = 0; i < deltaLines; ++i) {
                    --this.topItemIndex;
                    if (this.topItemIndex >= 0) continue;
                    this.topItemIndex = 0;
                }
                this.previousPressedX = x;
                this.previousPressedY = y;
            }
            this.repaint();
        }
    }

    protected void pointerReleased(int x, int y) {
        this.previousPressedX = -1;
        this.previousPressedY = -1;
    }

    public void addCommand(Command c, int keyType) {
        switch (keyType) {
            case 5: {
                this.commands.setElementAt(c, 1);
                break;
            }
            case 8: {
                this.commands.setElementAt(c, 0);
                break;
            }
            case 2: {
                this.commands.addElement(c);
            }
        }
    }

    public void lineDown() {
        if (this.numOfItems == 0) {
            return;
        }
        this.currentItemIndex = this.currentItemIndex != this.numOfItems - 1 ? ++this.currentItemIndex : 0;
    }

    public void lineUp() {
        if (this.numOfItems == 0) {
            return;
        }
        this.currentItemIndex = this.currentItemIndex != 0 ? --this.currentItemIndex : this.numOfItems - 1;
    }

    public void pageUp() {
        this.currentItemIndex -= 5;
        if (this.currentItemIndex < 0) {
            this.currentItemIndex = 0;
        }
    }

    public void pageDown() {
        this.currentItemIndex += 5;
        if (this.currentItemIndex >= this.numOfItems) {
            this.currentItemIndex = this.numOfItems - 1;
        }
    }
}

