/*
 * Decompiled with CFR 0.152.
 */
public class Engine {
    static byte state;
    static final byte STATE_INIT_GAME = 0;
    static final byte STATE_FREE_MOVE = 1;
    static final byte STATE_SELECT_MOVE = 2;
    static final byte STATE_ROTATE = 3;
    static final byte STATE_ERASE = 4;
    static final byte STATE_END = 5;
    static boolean bWin;
    static Tile[][] mapArray;
    static byte mapWidth;
    static byte mapHeight;
    static int[] mapCoord;
    static byte[] cursor;
    static byte animateType;
    static byte animateFrame;
    static final byte[] ANIMATE_COUNT;
    static Record record;

    static final int run() {
        switch (state) {
            case 1: {
                if (MainCanvas.isKeyPressed(16, true) && cursor[0] > 0) {
                    cursor[0] = (byte)(cursor[0] - 1);
                    break;
                }
                if (MainCanvas.isKeyPressed(17, true) && cursor[0] < mapWidth - 1) {
                    cursor[0] = (byte)(cursor[0] + 1);
                    break;
                }
                if (MainCanvas.isKeyPressed(15, true) && cursor[1] > 0) {
                    cursor[1] = (byte)(cursor[1] - 1);
                    break;
                }
                if (MainCanvas.isKeyPressed(18, true) && cursor[1] < mapHeight - 1) {
                    cursor[1] = (byte)(cursor[1] + 1);
                    break;
                }
                if (!MainCanvas.isKeyPressed(19, false)) break;
                mapArray[cursor[0]][cursor[1]].mask((byte)15);
                state = (byte)2;
                break;
            }
            case 2: {
                if (MainCanvas.isKeyPressed(16, true)) {
                    Engine.selectMove(0);
                    break;
                }
                if (MainCanvas.isKeyPressed(17, true)) {
                    Engine.selectMove(1);
                    break;
                }
                if (MainCanvas.isKeyPressed(15, true)) {
                    Engine.selectMove(2);
                    break;
                }
                if (MainCanvas.isKeyPressed(18, true)) {
                    Engine.selectMove(3);
                    break;
                }
                if (MainCanvas.isKeyPressed(19, false)) {
                    Engine.setAnimate(0);
                    state = (byte)3;
                    break;
                }
                if (!MainCanvas.isKeyPressed(13, false)) break;
                for (int i = 0; i < mapWidth; ++i) {
                    for (int j = 0; j < mapHeight; ++j) {
                        mapArray[i][j].reset();
                    }
                }
                state = 1;
                break;
            }
            case 3: {
                animateFrame = (byte)(animateFrame - 1);
                if (animateFrame != 0) break;
                for (int i = 0; i < mapWidth; ++i) {
                    for (int j = 0; j < mapHeight; ++j) {
                        mapArray[i][j].rotate();
                    }
                }
                Engine.checkErase();
                Engine.setAnimate(1);
                state = (byte)4;
                break;
            }
            case 4: {
                animateFrame = (byte)(animateFrame - 1);
                if (animateFrame != 0) break;
                if (bWin) {
                    Engine.setAnimate(3);
                } else {
                    Engine.setAnimate(2);
                }
                state = (byte)5;
                if (MainCanvas.nGameStatus != 11) break;
                GameUtils.stopMusic(1);
                if (!bWin) break;
                GameUtils.playMIDI(2, 1);
                break;
            }
            case 5: {
                byte by = animateFrame;
                animateFrame = (byte)(by - 1);
                if (by != 0) break;
                if (bWin) {
                    if (MainCanvas.nGameStatus == 11 && GameUtils.isPlaying(2)) {
                        animateFrame = (byte)(animateFrame + 1);
                        break;
                    }
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    static final void setAnimate(int type) {
        animateType = (byte)type;
        animateFrame = ANIMATE_COUNT[animateType];
    }

    static final boolean selectMove(int direction) {
        switch (direction) {
            case 0: {
                if (cursor[0] <= 0 || (Engine.mapArray[Engine.cursor[0] - 1][Engine.cursor[1]].pathType & 8) != 0) break;
                if (Engine.mapArray[Engine.cursor[0] - 1][Engine.cursor[1]].pathType != 0) {
                    mapArray[cursor[0]][cursor[1]].unMask((byte)15);
                    cursor[0] = (byte)(cursor[0] - 1);
                    mapArray[cursor[0]][cursor[1]].mask((byte)8);
                } else {
                    mapArray[cursor[0]][cursor[1]].unMask((byte)4);
                    cursor[0] = (byte)(cursor[0] - 1);
                    mapArray[cursor[0]][cursor[1]].mask((byte)7);
                }
                ++MainCanvas.keyPressCount;
                return true;
            }
            case 1: {
                if (cursor[0] >= mapWidth - 1 || (Engine.mapArray[Engine.cursor[0] + 1][Engine.cursor[1]].pathType & 4) != 0) break;
                if (Engine.mapArray[Engine.cursor[0] + 1][Engine.cursor[1]].pathType != 0) {
                    mapArray[cursor[0]][cursor[1]].unMask((byte)15);
                    cursor[0] = (byte)(cursor[0] + 1);
                    mapArray[cursor[0]][cursor[1]].mask((byte)4);
                } else {
                    mapArray[cursor[0]][cursor[1]].unMask((byte)8);
                    cursor[0] = (byte)(cursor[0] + 1);
                    mapArray[cursor[0]][cursor[1]].mask((byte)11);
                }
                ++MainCanvas.keyPressCount;
                return true;
            }
            case 2: {
                if (cursor[1] <= 0 || (Engine.mapArray[Engine.cursor[0]][Engine.cursor[1] - 1].pathType & 2) != 0) break;
                if (Engine.mapArray[Engine.cursor[0]][Engine.cursor[1] - 1].pathType != 0) {
                    mapArray[cursor[0]][cursor[1]].unMask((byte)15);
                    cursor[1] = (byte)(cursor[1] - 1);
                    mapArray[cursor[0]][cursor[1]].mask((byte)2);
                } else {
                    mapArray[cursor[0]][cursor[1]].unMask((byte)1);
                    cursor[1] = (byte)(cursor[1] - 1);
                    mapArray[cursor[0]][cursor[1]].mask((byte)13);
                }
                ++MainCanvas.keyPressCount;
                return true;
            }
            case 3: {
                if (cursor[1] >= mapHeight - 1 || (Engine.mapArray[Engine.cursor[0]][Engine.cursor[1] + 1].pathType & 1) != 0) break;
                if (Engine.mapArray[Engine.cursor[0]][Engine.cursor[1] + 1].pathType != 0) {
                    mapArray[cursor[0]][cursor[1]].unMask((byte)15);
                    cursor[1] = (byte)(cursor[1] + 1);
                    mapArray[cursor[0]][cursor[1]].mask((byte)1);
                } else {
                    mapArray[cursor[0]][cursor[1]].unMask((byte)2);
                    cursor[1] = (byte)(cursor[1] + 1);
                    mapArray[cursor[0]][cursor[1]].mask((byte)14);
                }
                ++MainCanvas.keyPressCount;
                return true;
            }
        }
        return false;
    }

    static final boolean checkErase() {
        bWin = true;
        boolean bEraseCheck = false;
        block0: for (int j = 1; j < mapHeight - 1; ++j) {
            int i;
            byte tileType = Engine.mapArray[1][j].type;
            for (i = 2; i < mapWidth - 1; ++i) {
                if (tileType == Engine.mapArray[i][j].type) continue;
                bWin = false;
                continue block0;
            }
            for (i = 1; i < mapWidth - 1; ++i) {
                mapArray[i][j].Erase();
            }
            bEraseCheck = true;
        }
        return bEraseCheck;
    }

    static final void loadGame(int level) {
        try {
            if (mapArray != null) {
                mapArray = null;
                System.gc();
            }
            GameUtils.fileOpen(0);
            GameUtils.skipFile(level);
            GameUtils.readInt(GameUtils.dis, 3);
            mapWidth = (byte)GameUtils.dis.read();
            mapHeight = (byte)GameUtils.dis.read();
            mapArray = new Tile[mapWidth][mapHeight];
            for (int i = 0; i < mapWidth; ++i) {
                for (int j = 0; j < mapHeight; ++j) {
                    Engine.mapArray[i][j] = new Tile((byte)GameUtils.dis.read());
                }
            }
            GameUtils.fileClose();
            Engine.mapCoord[0] = MainCanvas.GAMEMAP_COORD[level / 10][0] + (8 - mapWidth) * 13 / 2;
            Engine.mapCoord[1] = MainCanvas.GAMEMAP_COORD[level / 10][1] + (11 - mapHeight) * 13 / 2;
            Engine.cursor[1] = 1;
            Engine.cursor[0] = 1;
            animateType = 0;
            state = 1;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static final void saveRecord() {
        record = new Record();
    }

    static final void loadRecord() {
        state = Engine.record.state;
        animateType = Engine.record.animateType;
        animateFrame = Engine.record.animateFrame;
        bWin = Engine.record.bWin;
        mapWidth = Engine.record.mapWidth;
        mapHeight = Engine.record.mapHeight;
        mapArray = new Tile[mapWidth][mapHeight];
        System.arraycopy(Engine.record.mapArray, 0, mapArray, 0, mapArray.length);
        System.arraycopy(Engine.record.mapCoord, 0, mapCoord, 0, mapCoord.length);
        System.arraycopy(Engine.record.cursor, 0, cursor, 0, cursor.length);
        record = null;
    }

    static final void restartGame() {
        for (int i = 0; i < mapWidth; ++i) {
            for (int j = 0; j < mapHeight; ++j) {
                mapArray[i][j].resume();
            }
        }
        animateType = 0;
        state = (byte)2;
    }

    static {
        mapCoord = new int[2];
        cursor = new byte[2];
        ANIMATE_COUNT = new byte[]{7, 8, 10, 30};
    }
}

