/*
 * Decompiled with CFR 0.152.
 */
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;

public class GameUtils {
    public static final int KEY_UP_ARROW = -1;
    public static final int KEY_DOWN_ARROW = -2;
    public static final int KEY_LEFT_ARROW = -3;
    public static final int KEY_RIGHT_ARROW = -4;
    public static final int KEY_SOFT1 = -6;
    public static final int KEY_SOFT2 = -7;
    public static final int KEY_SOFT3 = -5;
    public static final int SCREEN_WIDTH = 176;
    public static final int SCREEN_HEIGHT = 208;
    public static final int IMG_FILE_INDEX = 0;
    public static final long LOW_MEM = Runtime.getRuntime().totalMemory() * 2L / 5L;
    public static Image[] images;
    public static byte[][] imgIndex;
    private static byte header;
    private static byte tail;
    public static InputStream dis;
    static int pausedPlayer;
    static boolean isSound;
    static String[] stringResource;
    static String[] line;
    static int lineCount;

    public static void initImageIndex(int imgCount) {
        images = new Image[imgCount];
        imgIndex = new byte[imgCount][2];
        tail = (byte)-1;
        header = (byte)-1;
        for (int i = 0; i < imgCount; i = (int)((byte)(i + 1))) {
            for (int j = 0; j < 2; j = (int)((byte)(j + 1))) {
                GameUtils.imgIndex[i][j] = i;
            }
        }
    }

    public static void loadImages(byte[] imgs) {
        int count = imgs.length;
        for (int i = 0; i < count; ++i) {
            GameUtils.loadImage(imgs[i], imgs[0]);
        }
    }

    public static void loadImages(byte[] imgs, int currentFrame, int totalFrame, byte startImage) {
        int count = imgs.length;
        for (int i = currentFrame * count / totalFrame; i < (currentFrame + 1) * count / totalFrame; ++i) {
            GameUtils.loadImage(imgs[i], startImage);
        }
    }

    private static void loadImage(byte imgID, byte start) {
        if (imgID >= images.length) {
            return;
        }
        if (images[imgID] != null) {
            if (tail != imgID) {
                if (header == imgID) {
                    header = imgIndex[imgID][1];
                } else {
                    GameUtils.imgIndex[GameUtils.imgIndex[imgID][0]][1] = imgIndex[imgID][1];
                    GameUtils.imgIndex[GameUtils.imgIndex[imgID][1]][0] = imgIndex[imgID][0];
                }
                GameUtils.imgIndex[GameUtils.tail][1] = imgID;
                GameUtils.imgIndex[imgID][0] = tail;
                tail = imgID;
            }
        } else {
            while (Runtime.getRuntime().freeMemory() < LOW_MEM && header != -1 && header != start) {
                GameUtils.images[GameUtils.header] = null;
                System.gc();
                if (header != tail) {
                    header = imgIndex[header][1];
                    continue;
                }
                tail = (byte)-1;
                header = (byte)-1;
            }
            try {
                GameUtils.images[imgID] = Image.createImage((String)("/" + imgID + ".png"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (header == -1) {
                header = tail = imgID;
            } else {
                GameUtils.imgIndex[GameUtils.tail][1] = imgID;
                GameUtils.imgIndex[imgID][0] = tail;
                tail = imgID;
            }
        }
    }

    public static void releaseImage(byte imgID) {
        if (imgID >= images.length) {
            return;
        }
        if (images[imgID] != null) {
            if (tail != imgID) {
                if (header == imgID) {
                    header = imgIndex[imgID][1];
                } else {
                    GameUtils.imgIndex[GameUtils.imgIndex[imgID][0]][1] = imgIndex[imgID][1];
                    GameUtils.imgIndex[GameUtils.imgIndex[imgID][1]][0] = imgIndex[imgID][0];
                }
            } else {
                GameUtils.imgIndex[GameUtils.imgIndex[imgID][0]][1] = imgIndex[imgID][0];
                tail = imgIndex[imgID][0];
            }
            GameUtils.images[imgID] = null;
            System.gc();
        }
    }

    public static void fileOpen(int i) {
        try {
            if (dis != null) {
                dis.close();
            }
            dis = "".getClass().getResourceAsStream("/" + i + ".bin");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static final void fileClose() {
        if (dis != null) {
            try {
                dis.close();
                dis = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static final void skipFile(int i) {
        try {
            while (i > 0) {
                int count = GameUtils.readInt(dis, 3);
                dis.skip(count);
                --i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static final byte[] loadFile() {
        byte[] data = null;
        try {
            int count = GameUtils.readInt(dis, 3);
            data = new byte[count];
            dis.read(data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    static final int readInt(InputStream is, int count) {
        int cell;
        try {
            cell = is.read();
            if (count > 1) {
                cell += is.read() << 8;
            }
            if (count > 2) {
                cell += is.read() << 16;
            }
            if (count > 3) {
                cell += is.read() << 24;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            cell = -1;
        }
        return cell;
    }

    static final void initMIDI(int count) {
    }

    static final void initWAV(int count) {
    }

    static final void loadSoundMIDI(int i) {
    }

    static final void loadSoundWav(int i) {
    }

    static final void playMIDI(int j, int loop) {
    }

    static final boolean isPlaying(int i) {
        return false;
    }

    static final void playWAV(int j) {
    }

    static final void stopMusic(int i) {
    }

    static final void pauseMusic() {
    }

    static final void restartMusic() {
    }

    static final void initStringResources() {
        try {
            DataInputStream dis = new DataInputStream("a".getClass().getResourceAsStream("/s.bin"));
            int num = dis.readInt();
            stringResource = new String[num];
            for (int i = 0; i < num; ++i) {
                GameUtils.stringResource[i] = GameUtils.readString(dis);
            }
            dis.close();
        }
        catch (IOException ex) {
            GameUtils.initStringResources();
        }
    }

    public static final String readString(DataInputStream dis) throws IOException {
        int n = dis.readInt();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            sb.append(dis.readChar());
        }
        return sb.toString();
    }

    static void addString(String s, int width) {
        lineCount = 0;
        int nfirst = 0;
        int nLen = 0;
        StringBuffer sb = new StringBuffer();
        while (nfirst + nLen < s.length()) {
            if (s.charAt(nfirst + nLen) == '`') {
                GameUtils.line[GameUtils.lineCount++] = sb.toString();
                sb.delete(0, sb.length());
                nfirst += ++nLen;
                nLen = 0;
                continue;
            }
            if (MainCanvas.FONT_DEFAULT.substringWidth(s, nfirst, nLen + 1) <= width) {
                sb.append(s.charAt(nfirst + nLen));
                ++nLen;
                continue;
            }
            GameUtils.line[GameUtils.lineCount++] = sb.toString();
            sb.delete(0, sb.length());
            nfirst += nLen;
            nLen = 0;
        }
        if (sb.length() > 0) {
            GameUtils.line[GameUtils.lineCount++] = sb.toString();
        }
        sb = null;
    }

    public static byte[] readSram(String s) {
        try {
            RecordStore recordstore = RecordStore.openRecordStore((String)s, (boolean)false);
            byte[] abyte0 = recordstore.getRecord(1);
            recordstore.closeRecordStore();
            return abyte0;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void writeSram(String s, byte[] abyte0) {
        while (true) {
            try {
                RecordStore recordstore = RecordStore.openRecordStore((String)s, (boolean)true);
                if (recordstore.getNumRecords() == 0) {
                    recordstore.addRecord(abyte0, 0, abyte0.length);
                } else {
                    recordstore.setRecord(1, abyte0, 0, abyte0.length);
                }
                recordstore.closeRecordStore();
                return;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public static final void drawImage(Graphics g, byte index, int x, int y, int anchor, int mark) {
        switch (mark) {
            case 1: {
                mark = 8192;
                break;
            }
            case 2: {
                mark = 16384;
                break;
            }
            case 3: {
                mark = 180;
                break;
            }
            case 4: {
                mark = 90;
                break;
            }
            default: {
                mark = 0;
            }
        }
        if (mark == 0) {
            g.drawImage(images[index], x, y, anchor);
        } else {
            DirectGraphics dg = DirectUtils.getDirectGraphics((Graphics)g);
            dg.drawImage(images[index], x, y, anchor, mark);
        }
    }

    public static final void drawClip(Graphics g, byte index, int x_src, int y_src, int width, int height, int x_dest, int y_dest, int anchor) {
        int oldWidth = g.getClipWidth();
        int oldHeight = g.getClipHeight();
        g.setClip(x_dest, y_dest, width, height);
        g.clipRect(x_dest, y_dest, width, height);
        g.drawImage(images[index], x_dest - x_src, y_dest - y_src, anchor);
        g.setClip(0, 0, oldWidth, oldHeight);
    }

    public static final void fillPolygon(Graphics g, int x, int y, int width, int height, int color) {
        g.setColor(color & 0xFFFFFF);
        g.fillRect(x, y, width, height);
    }

    static {
        dis = null;
        pausedPlayer = -1;
        line = new String[20];
    }
}

