/*
 * Decompiled with CFR 0.152.
 */
public class Tile {
    static final byte TILE_WIDTH = 13;
    static final byte UP_MASK = 1;
    static final byte DOWN_MASK = 2;
    static final byte LEFT_MASK = 4;
    static final byte RIGHT_MASK = 8;
    public byte type;
    public boolean bErase;
    public byte pathType;

    public Tile(byte tileType) {
        this.type = tileType;
        this.reset();
    }

    public final void reset() {
        this.pathType = 0;
        this.bErase = false;
    }

    public final void resume() {
        this.bErase = false;
        this.rotate();
    }

    public final void mask(byte mask) {
        this.pathType = (byte)(this.pathType | mask);
    }

    public final void unMask(byte mask) {
        this.pathType = (byte)(this.pathType & ~mask);
    }

    public final void rotate() {
        if (this.type < 2 && this.pathType != 0) {
            this.type = (byte)(this.type + 1);
            this.type = (byte)(this.type % 2);
        }
    }

    public final void Erase() {
        if (this.type < 2) {
            this.bErase = true;
        }
    }
}

