/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.midlet.MIDlet;

public final class LogManager {
    private static Logger log = new LoggerImpl();
    private static LogShower shower = new LogShower();

    private LogManager() {
    }

    public static void install(LogShower shower) {
        LogManager.shower = shower;
    }

    public static void info(String info) {
        log.log(10, info);
    }

    public static void debug(String info) {
        log.log(20, info);
    }

    public static void error(String info) {
        log.log(40, info);
    }

    public static void warning(String info) {
        log.log(30, info);
    }

    public static void fine(String info) {
        log.log(0, info);
    }

    public static void showLog(MIDlet midlet) {
        Displayable screen = Display.getDisplay((MIDlet)midlet).getCurrent();
        shower.showLog(log.getLogContent(), midlet, screen);
    }

    public static void clearLog() {
        log.clearLog();
    }

    static class LoggerImpl
    implements Logger {
        private int index = 0;
        private Calendar c = Calendar.getInstance();
        private StringBuffer sb = new StringBuffer();
        public static boolean showInDevice = false;
        public static boolean showInConsole = true;

        public void log(int level, String info) {
            if (showInDevice | showInConsole) {
                ++this.index;
            }
            if (showInDevice) {
                this.sb.append("[").append(this.index).append("].").append(this.getPrefix()).append("-").append(this.getLevelName(level)).append(":").append(info).append("/n");
            }
            if (showInConsole) {
                System.out.println("[" + this.index + "]." + this.getPrefix() + "-" + this.getLevelName(level) + ": " + info);
            }
        }

        private String getPrefix() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.c.get(2) + 1 + "-");
            sb.append(this.c.get(5) + " ");
            sb.append(this.c.get(11) + ":");
            sb.append(this.c.get(12) + ":");
            sb.append(this.c.get(13));
            return sb.toString();
        }

        private String getLevelName(int level) {
            switch (level) {
                case 0: {
                    return "FINE";
                }
                case 10: {
                    return "INFO";
                }
                case 20: {
                    return "DEBUG";
                }
                case 30: {
                    return "WARNING";
                }
                case 40: {
                    return "ERROR";
                }
            }
            return "UNKNOWN";
        }

        public String getLogContent() {
            return this.sb.toString();
        }

        public void clearLog() {
            this.index = 0;
            this.sb.delete(0, this.sb.length());
        }
    }

    static class LogShower {
        private final Command back = new Command("\u8fd4\u56de", 2, 1);
        private final Command clear = new Command("\u6e05\u9664", 1, 1);

        LogShower() {
        }

        public void showLog(String logContent, MIDlet midlet, Displayable screen) {
            Form form = new Form("\u65e5\u5fd7\u5185\u5bb9");
            form.addCommand(this.back);
            form.addCommand(this.clear);
            form.append(logContent);
            form.setCommandListener(new CommandListener(this, midlet, screen, form){
                private final /* synthetic */ MIDlet val$midlet;
                private final /* synthetic */ Displayable val$screen;
                private final /* synthetic */ Form val$form;
                private final /* synthetic */ LogShower this$0;
                {
                    this.this$0 = this$0;
                    this.val$midlet = val$midlet;
                    this.val$screen = val$screen;
                    this.val$form = val$form;
                }

                public void commandAction(Command c2, Displayable d2) {
                    if (c2 == LogShower.access$000(this.this$0)) {
                        Display.getDisplay((MIDlet)this.val$midlet).setCurrent(this.val$screen);
                    } else if (c2 == LogShower.access$100(this.this$0)) {
                        LogManager.clearLog();
                        this.val$form.deleteAll();
                    }
                }
            });
            Display.getDisplay((MIDlet)midlet).setCurrent((Displayable)form);
        }

        static /* synthetic */ Command access$000(LogShower x0) {
            return x0.back;
        }

        static /* synthetic */ Command access$100(LogShower x0) {
            return x0.clear;
        }
    }
}

