/*
 * Decompiled with CFR 0.152.
 */
class CDPCharic {
    static int m_nCharicCount;
    static int m_nCurrentCharicIdx;
    static STCharic[] m_pCharic;
    static CDPCharic g_pCharic;
    static final String KEY_CHARIC_HEADER = "charic_header";
    static final String KEY_CHARIC_DATA = "charic_data";
    static final String KEY_CURRENT_CHARIC = "current_charic";
    static final String KEY_BUY_STATE = "charic_get_flag";
    static final int DEFAULT_SEL_CHARIC_IDX = 0;
    static int[] CharicbGet;

    static int GetCharicCount() {
        return m_nCharicCount;
    }

    static void SetCurrentCharicIdx(int nIndex) {
        m_nCurrentCharicIdx = nIndex;
    }

    static boolean HaveCharic(int nIdx) {
        return CDPCharic.m_pCharic[nIdx].bGet;
    }

    static int GetCurrentCharicIdx() {
        return m_nCurrentCharicIdx;
    }

    static void BuyCharic(int nIdx) {
        CDPCharic.m_pCharic[nIdx].bGet = true;
    }

    CDPCharic() {
        m_nCharicCount = 0;
        m_nCurrentCharicIdx = 0;
        m_pCharic = null;
    }

    static void DestoryCDPCharic() {
        m_pCharic = null;
    }

    int LoadCharicData() {
        if (this.LoadCharicFile() > 0) {
            return -1;
        }
        return this.LoadCharicBuyStateFile();
    }

    static int SaveCharicData() {
        return CDPCharic.SaveCharicBuyStateFile();
    }

    int LoadCharicFile() {
        int i;
        m_nCharicCount = 4;
        m_pCharic = new STCharic[4];
        for (i = 0; i < 4; ++i) {
            CDPCharic.m_pCharic[i] = new STCharic();
        }
        for (i = 0; i < m_nCharicCount; ++i) {
            CDPCharic.m_pCharic[i].szName = DPCharicDefine.g_pCharicData[i].szName;
            CDPCharic.m_pCharic[i].szDesc = DPCharicDefine.g_pCharicData[i].szDesc;
            CDPCharic.m_pCharic[i].szDescAfter = DPCharicDefine.g_pCharicData[i].szDescAfter;
            CDPCharic.m_pCharic[i].szAniFile = DPCharicDefine.g_pCharicData[i].szAniCharic;
            CDPCharic.m_pCharic[i].cBuyType = DPCharicDefine.g_pCharicData[i].cBuyType;
            CDPCharic.m_pCharic[i].cShowType = DPCharicDefine.g_pCharicData[i].cBuyType;
            CDPCharic.m_pCharic[i].wBuyCash = DPCharicDefine.g_pCharicData[i].wBuyCash;
            CDPCharic.m_pCharic[i].wBuyMoney = DPCharicDefine.g_pCharicData[i].wBuyMoney;
        }
        return 0;
    }

    int LoadCharicBuyStateFile() {
        CSWLFile file = new CSWLFile();
        String szInfoFile = "charic_buy_state.sav";
        byte[] readData = file.ReadFile(szInfoFile);
        if (readData != null) {
            for (int i = 0; i < m_nCharicCount; ++i) {
                CDPCharic.CharicbGet[i] = 0;
                CDPCharic.CharicbGet[i] = Yulib.data_ordering(CharicbGet[i], readData, 0 + i * 4);
                CDPCharic.m_pCharic[i].bGet = CharicbGet[i] == 1;
            }
            return 1;
        }
        return 0;
    }

    static int SaveCharicBuyStateFile() {
        CSWLFile file = new CSWLFile();
        String szInfoFile = "charic_buy_state.sav";
        char[] saveData = new char[128];
        for (int i = 0; i < m_nCharicCount; ++i) {
            CDPCharic.CharicbGet[i] = CDPCharic.m_pCharic[i].bGet ? 1 : 0;
            Yulib.char_ordering(CharicbGet[i], saveData, 0 + i * 4);
        }
        String SaveData = new String(saveData);
        file.WriteFile(SaveData, szInfoFile, saveData.length);
        return 0;
    }

    int CreateCharicBuyStateFile() {
        m_nCurrentCharicIdx = 0;
        for (int i = 0; i < m_nCharicCount; ++i) {
            CDPCharic.m_pCharic[i].bGet = (CDPCharic.m_pCharic[i].cBuyType & 1) == 1;
        }
        return CDPCharic.SaveCharicBuyStateFile();
    }

    static STCharic GetCharicData(int nIndex) {
        return m_pCharic[nIndex];
    }

    static {
        g_pCharic = null;
        CharicbGet = new int[4];
    }
}

