/*
 * Decompiled with CFR 0.152.
 */
class CDPPackListInfo {
    static CSWLList m_listPackListInfo;
    static String m_szFileName;
    static CDPPackListInfo g_pPackListInfo;
    static final String KEY_PACKLISTINFO_HEADER = "packlistinfo_header";
    static final String KEY_PACK_DATA = "pack_data";
    static final String FORMAT_PACK_BUY_DATE = "0000-00-00 00:00:00";

    static int GetPackListInfoCnt() {
        return m_listPackListInfo.GetCount();
    }

    static STOnePackListInfo GetPackListInfoByIdx(int nIdx) {
        return m_listPackListInfo.Item(nIdx);
    }

    CDPPackListInfo() {
        m_listPackListInfo = new CSWLList();
    }

    void DestoryCDPPackListInfo() {
        this.ClearPackListInfo();
    }

    void ClearPackListInfo() {
        while (m_listPackListInfo.GetCount() > 0) {
            m_listPackListInfo.Delete(0);
        }
    }

    int LoadPackListInfoFile(String lpFileName) {
        if (lpFileName == null) {
            return -1;
        }
        m_szFileName = lpFileName;
        CSWLFile file = new CSWLFile();
        if (!file.OpenFile(lpFileName, 2, 0)) {
            this.CreatePackListInfoFile();
            if (!file.OpenFile(lpFileName, 2, 0)) {
                return -1;
            }
        }
        if (Yulib.__BINARY_MODE__) {
            byte[] pRes;
            int dwResSize = file.GetFileSize(lpFileName);
            byte[] lpPtr = pRes = new byte[dwResSize];
            int cPackCnt = 0;
            STOnePackListInfo lpInfo = new STOnePackListInfo();
            if (!file.ReadFile(new String(pRes), dwResSize)) {
                pRes = null;
                file.CloseFile();
                return -1;
            }
            lpPtr = CSWLStrUtil.GetByte(lpPtr, (byte)cPackCnt);
            cPackCnt = (byte)(cPackCnt + 1);
            for (int i = 0; i < cPackCnt; ++i) {
                STOnePackListInfo pNewInfo = new STOnePackListInfo();
                pNewInfo = lpInfo;
                m_listPackListInfo.Add(pNewInfo);
                lpPtr = new byte[32 + pNewInfo.szBuyDate.length()];
            }
            pRes = null;
            file.CloseFile();
            return 0;
        }
        if (!file.ReadLineStart()) {
            file.CloseFile();
            return -1;
        }
        CSWLToken tknList = new CSWLToken();
        int nTokenCnt = 0;
        int nRet = 0;
        TOKEN first_tok = null;
        TOKEN tok = null;
        char[] szBuf = new char[]{'\u0000'};
        String szKey = "";
        STDPPackListInfoHD stHD = new STDPPackListInfoHD();
        STOnePackListInfo lpInfo = null;
        while (file.ReadLine(new String(szBuf), 256)) {
            int i;
            char[] a = new char["=,".length()];
            for (i = 0; i < "=,".length(); ++i) {
                a[i] = "=,".charAt(i);
            }
            nRet = tknList.TokenList(szBuf, nTokenCnt, a);
            if (nRet < 0) {
                tknList.TokenFree(tknList.m_tok);
                continue;
            }
            if (nTokenCnt < 2) {
                tknList.TokenFree(tknList.m_tok);
                continue;
            }
            tok = first_tok = tknList.m_tok;
            szKey = new String(tok.Data);
            tok = tok.Next;
            if (szKey.charAt(0) == '#') {
                tknList.TokenFree(first_tok);
                continue;
            }
            if (szKey == KEY_PACKLISTINFO_HEADER) {
                stHD.cListCnt = CSWLStrUtil.AtoI(new String(tok.Data));
                for (i = 0; i < stHD.cListCnt; ++i) {
                    STOnePackListInfo lpListInfo = new STOnePackListInfo();
                    m_listPackListInfo.Add(lpListInfo);
                }
                lpInfo = m_listPackListInfo.GetHeadData();
            } else if (szKey == KEY_PACK_DATA) {
                lpInfo.wPackID = CSWLStrUtil.AtoI(new String(tok.Data));
                tok = tok.Next;
                lpInfo.cBuyFlag = CSWLStrUtil.AtoI(new String(tok.Data));
                tok = tok.Next;
                lpInfo.cPackDataExist = CSWLStrUtil.AtoI(new String(tok.Data));
                tok = tok.Next;
                lpInfo.cThumbnailExist = CSWLStrUtil.AtoI(new String(tok.Data));
                tok = tok.Next;
                lpInfo.wFindObjCnt = CSWLStrUtil.AtoI(new String(tok.Data));
                tok = tok.Next;
                lpInfo.szBuyDate = new String(tok.Data);
                tok = tok.Next;
                lpInfo.wBuyYear = CSWLStrUtil.AtoI(new String(tok.Data));
                tok = tok.Next;
                lpInfo.wBuyYearDay = CSWLStrUtil.AtoI(new String(tok.Data));
                lpInfo = m_listPackListInfo.GetNextData();
            }
            tknList.TokenFree(first_tok);
        }
        file.ReadLineEnd();
        file.CloseFile();
        return 0;
    }

    int ReLoadPackListInfoFile() {
        STDPPackList lpPackList = CDPPackList.GetPackList();
        if (lpPackList == null) {
            return -1;
        }
        for (int i = 0; i < lpPackList.stHD.wPackCnt; ++i) {
            STOnePackListInfo lpPackListInfo = this.GetPackListInfo(lpPackList.pData[i].wPackID);
            if (lpPackListInfo == null) continue;
            STOnePackListInfo pNewInfo = new STOnePackListInfo();
            pNewInfo.wPackID = lpPackList.pData[i].wPackID;
            pNewInfo.wObjCnt = lpPackList.pData[i].wObjCnt;
            m_listPackListInfo.Add(pNewInfo);
        }
        return CDPPackListInfo.SavePackListInfoFile(m_szFileName);
    }

    static int SavePackListInfoFile(String lpFileName) {
        if (Yulib.__BINARY_MODE__) {
            CSWLFile file = new CSWLFile();
            if (!file.OpenFile(lpFileName, 0, 0)) {
                return -1;
            }
            byte cPackCnt = (byte)m_listPackListInfo.GetCount();
            STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
            while (lpInfo != null) {
                lpInfo = m_listPackListInfo.GetNextData();
            }
            file.CloseFile();
            return 0;
        }
        CSWLFile file = new CSWLFile();
        if (!file.OpenFile(lpFileName, 0, 0)) {
            return -1;
        }
        String szTemp = "";
        szTemp = "packlistinfo_header=" + m_listPackListInfo.GetCount() + "\r\n\r\n";
        if (!file.WriteFile(szTemp, lpFileName, szTemp.length())) {
            file.CloseFile();
            return -1;
        }
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            szTemp = "pack_data=" + lpInfo.wPackID + "," + lpInfo.cBuyFlag + "," + lpInfo.cPackDataExist + "," + lpInfo.cThumbnailExist + "," + lpInfo.wFindObjCnt + "," + lpInfo.szBuyDate + "," + lpInfo.wBuyYear + "," + lpInfo.wBuyYearDay + "\r\n";
            if (!file.WriteFile(szTemp, lpFileName, szTemp.length())) {
                file.CloseFile();
                return -1;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
        file.CloseFile();
        return 0;
    }

    int CreatePackListInfoFile() {
        STOnePackListInfo lpInfo = new STOnePackListInfo();
        STDPPackList lpPackList = CDPPackList.GetPackList();
        for (int i = 0; i < lpPackList.stHD.wPackCnt; ++i) {
            lpInfo.wPackID = lpPackList.pData[i].wPackID;
            lpInfo.wObjCnt = lpPackList.pData[i].wObjCnt;
            if (lpInfo.wPackID == 1) {
                lpInfo.cPackDataExist = 1;
                lpInfo.cBuyFlag = 3;
            } else {
                lpInfo.cPackDataExist = 0;
                lpInfo.cBuyFlag = 0;
            }
            lpInfo.cThumbnailExist = 1;
            lpInfo.wFindObjCnt = 0;
            lpInfo.szBuyDate = FORMAT_PACK_BUY_DATE;
            lpInfo.wBuyYear = 0;
            lpInfo.wBuyYearDay = 0;
            m_listPackListInfo.Add(lpInfo);
        }
        int nRet = CDPPackListInfo.SavePackListInfoFile(m_szFileName);
        this.ClearPackListInfo();
        return nRet;
    }

    STOnePackListInfo GetPackListInfo(int wPackID) {
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.wPackID == wPackID) {
                return lpInfo;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
        return null;
    }

    static byte GetPackDataExist(int wPackID) {
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.wPackID == wPackID) {
                return (byte)lpInfo.cPackDataExist;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
        return 0;
    }

    static void UpdatePackDataExist(int wPackID, int eType) {
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.wPackID == wPackID) {
                lpInfo.cPackDataExist = (byte)eType;
                break;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
        CDPPackListInfo.SavePackListInfoFile(m_szFileName);
    }

    static byte GetThumbnailExist(int wPackID) {
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.wPackID == wPackID) {
                return (byte)lpInfo.cThumbnailExist;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
        return 0;
    }

    void UpdateThumbnailExist(int wPackID, int eType) {
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.wPackID == wPackID) {
                lpInfo.cThumbnailExist = (byte)eType;
                break;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
        CDPPackListInfo.SavePackListInfoFile(m_szFileName);
    }

    static int GetFindObjCnt(int wPackID) {
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.wPackID == wPackID) {
                return lpInfo.wFindObjCnt;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
        return 0;
    }

    static int GetBuyFlag(int wPackID) {
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.wPackID == wPackID) {
                return lpInfo.cBuyFlag;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
        return 0;
    }

    void GetBuyDate(int wPackID, String lpBuf, int nBufLen) {
        if (lpBuf == null) {
            return;
        }
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.wPackID == wPackID) {
                lpBuf = lpInfo.szBuyDate;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
    }

    static int GetBuyYear(int wPackID) {
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.wPackID == wPackID) {
                return lpInfo.wBuyYear;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
        return 0;
    }

    static int GetBuyYearDay(int wPackID) {
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.wPackID == wPackID) {
                return lpInfo.wBuyYearDay;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
        return 0;
    }

    void AddPackData(STOnePackListInfo lpInfo) {
        STOnePackListInfo lpListInfo = new STOnePackListInfo();
        lpListInfo = lpInfo;
        m_listPackListInfo.Add(lpListInfo);
    }

    void BuyPack(int wPackID, byte cBuyType, int wYear, int wYearDay, String szBuyDate) {
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.wPackID == wPackID) {
                if (wYear > 0) {
                    lpInfo.wBuyYear = wYear;
                }
                if (wYearDay > 0) {
                    lpInfo.wBuyYearDay = wYearDay;
                }
                lpInfo.cBuyFlag = cBuyType;
                if (szBuyDate == null) break;
                lpInfo.szBuyDate = szBuyDate;
                break;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
    }

    void CancelBuyPack(int wPackID) {
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.wPackID == wPackID) {
                lpInfo.wBuyYear = 0;
                lpInfo.wBuyYearDay = 0;
                lpInfo.cBuyFlag = 0;
                lpInfo.szBuyDate = FORMAT_PACK_BUY_DATE;
                break;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
    }

    static void SetFindObjCnt(int wPackID, int wObjCnt) {
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.wPackID == wPackID) {
                lpInfo.wFindObjCnt = wObjCnt;
                break;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
    }

    void ClearPackDataExist() {
        STOnePackListInfo lpInfo = m_listPackListInfo.GetHeadData();
        while (lpInfo != null) {
            if (lpInfo.cPackDataExist == 2) {
                lpInfo.cPackDataExist = 0;
            }
            if (lpInfo.cThumbnailExist == 2) {
                lpInfo.cThumbnailExist = 0;
            }
            lpInfo = m_listPackListInfo.GetNextData();
        }
    }

    static {
        m_szFileName = "";
        g_pPackListInfo = null;
    }
}

