/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

class CGamePointer {
    static final int SWL_CURSOR_DEFAULT_SPEED = 9000;
    static final int SWL_CURSOR_DEFAULT_MAXSPEED = 20000;
    static final int SWL_CURSOR_DEFAULT_ACCEL = 1000;
    int m_nMinSpeed1000;
    int m_nMaxSpeed1000 = 20000;
    int m_nAccel1000 = 1000;
    int m_nSpeed1000 = 0;
    CSWLAni m_pAniPointer;
    CSWLPoint m_ptPos;
    CSWLAni m_pAniDefault;
    boolean m_bLeftKey = false;
    boolean m_bRightKey = false;
    boolean m_bUpKey = false;
    boolean m_bDownKey = false;
    int m_nMoveDir = 0;
    CSWLSize m_siRemainPixel = new CSWLSize();
    boolean m_bShow;
    CSWLRect m_rtGameArea = new CSWLRect();
    boolean m_bStop;
    long m_qwStopStartTime;
    int m_dwStopPeriod;
    boolean m_bAround;
    long m_qwMoveStartTick = 0L;
    Image m_pImgPointEffect;
    CSWLAni m_pAniPointerStartEf;
    boolean m_bTouchStart;
    CSWLPoint m_ptDiff = new CSWLPoint();
    static final int CURSOR_MOVEDIR_NONE = 0;
    static final int CURSOR_MOVEDIR_SOUTH = 1;
    static final int CURSOR_MOVEDIR_SOUTHWEST = 2;
    static final int CURSOR_MOVEDIR_WEST = 3;
    static final int CURSOR_MOVEDIR_NORTHWEST = 4;
    static final int CURSOR_MOVEDIR_NORTH = 5;
    static final int CURSOR_MOVEDIR_NORTHEAST = 6;
    static final int CURSOR_MOVEDIR_EAST = 7;
    static final int CURSOR_MOVEDIR_SOUTHEAST = 8;
    static final int MAX_CURSOR_MOVEDIR_KIND = 9;

    void Show(boolean bShow) {
        this.m_bShow = bShow;
    }

    boolean IsAround() {
        return this.m_bAround;
    }

    boolean IsStop() {
        return this.m_bStop;
    }

    int GetSpeed() {
        return this.m_nSpeed1000;
    }

    void StartRound() {
        this.m_pAniPointerStartEf.Play(false);
    }

    CGamePointer() {
        this.m_nMinSpeed1000 = CDPOptionData.GetPointerSpeed() * 1000;
        this.m_siRemainPixel.SetSize(0, 0);
        this.m_pAniPointer = null;
        this.m_bShow = true;
        this.m_rtGameArea.left = 0;
        this.m_rtGameArea.top = 50;
        this.m_rtGameArea.right = 240;
        this.m_rtGameArea.bottom = 310;
        this.m_pImgPointEffect = Yulib.LoadImage("Pointer_Ef_06.png");
        this.m_pAniPointerStartEf = new CSWLAni();
        this.m_pAniPointerStartEf.SetClock(MainCanvas.g_pGameClock);
    }

    void DestoryCGamePointer() {
        this.m_pAniDefault = null;
        this.m_pImgPointEffect = null;
        this.m_pAniPointerStartEf = null;
    }

    void SetAni(String lpFileName) {
        if (lpFileName == null) {
            return;
        }
        this.m_pAniDefault = new CSWLAni();
        this.m_pAniDefault.SetClock(MainCanvas.g_pInterfaceClock);
        this.m_pAniDefault.LoadFromRes(lpFileName);
        this.m_pAniDefault.Play(true);
        this.m_pAniPointer = this.m_pAniDefault;
    }

    void SetPos(int x, int y) {
        this.m_ptPos.SetPoint(x, y);
    }

    void SetPos(CSWLPoint ptPos) {
        this.m_ptPos = ptPos;
        this.m_ptPos.x = Yulib.SWL_Limit(this.m_ptPos.x, 0, 240);
        this.m_ptPos.y = Yulib.SWL_Limit(this.m_ptPos.y, 50, 310);
    }

    CSWLPoint GetPos(CSWLPoint ptPos) {
        ptPos = this.m_ptPos;
        return ptPos;
    }

    void Stop(int dwTime) {
        this.m_qwStopStartTime = System.currentTimeMillis();
        this.m_dwStopPeriod = dwTime;
        this.m_bStop = true;
        this.ResetKeyState();
    }

    void SetAniPointer(CSWLAni pPointer) {
        this.m_pAniPointer = pPointer != null ? pPointer : this.m_pAniDefault;
        this.m_pAniPointer.Play(true);
    }

    CSWLPoint GetMoveDistance(int cDir, int wSpeed1000, CSWLSize siRemainPixel) {
        int nDegreeValY;
        int nDegreeValX;
        if (cDir == 1 || cDir == 3 || cDir == 5 || cDir == 7) {
            nDegreeValX = 1000;
            nDegreeValY = 1000;
        } else {
            nDegreeValX = Yulib.GetCos1000(45);
            nDegreeValY = Yulib.GetSin1000(45);
        }
        CSWLSize siDistance1000 = new CSWLSize();
        CSWLSize siDistance = new CSWLSize();
        siDistance1000.cx = wSpeed1000 * nDegreeValX + siRemainPixel.cx;
        siDistance1000.cy = wSpeed1000 * nDegreeValY + siRemainPixel.cy;
        siDistance.cx = siDistance1000.cx / 2000000;
        siDistance.cy = siDistance1000.cy / 2000000;
        siRemainPixel.cx = siDistance1000.cx - siDistance.cx * 2000000;
        siRemainPixel.cy = siDistance1000.cy - siDistance.cy * 2000000;
        CSWLPoint ptDistance = new CSWLPoint(0, 0);
        switch (cDir) {
            case 1: {
                ptDistance.y = siDistance.cy;
                break;
            }
            case 3: {
                ptDistance.x = -siDistance.cx;
                break;
            }
            case 5: {
                ptDistance.y = -siDistance.cy;
                break;
            }
            case 7: {
                ptDistance.x = siDistance.cx;
                break;
            }
            case 2: {
                ptDistance.x = -siDistance.cx;
                ptDistance.y = siDistance.cy;
                break;
            }
            case 4: {
                ptDistance.x = -siDistance.cx;
                ptDistance.y = -siDistance.cy;
                break;
            }
            case 6: {
                ptDistance.x = siDistance.cx;
                ptDistance.y = -siDistance.cy;
                break;
            }
            case 8: {
                ptDistance.x = siDistance.cx;
                ptDistance.y = siDistance.cy;
            }
        }
        return ptDistance;
    }

    void OnSWLKeyUp(STSWLEventKey stEvent) {
        switch (stEvent.key) {
            case -3: {
                this.m_bLeftKey = true;
                if (!this.m_bRightKey) break;
                this.m_bRightKey = false;
                break;
            }
            case -4: {
                this.m_bRightKey = true;
                if (!this.m_bLeftKey) break;
                this.m_bLeftKey = false;
                break;
            }
            case -1: {
                this.m_bUpKey = true;
                if (!this.m_bDownKey) break;
                this.m_bDownKey = false;
                break;
            }
            case -2: {
                this.m_bDownKey = true;
                if (!this.m_bUpKey) break;
                this.m_bUpKey = false;
            }
        }
        int nMoveDir = this.CalMoveDir();
        if (nMoveDir != this.m_nMoveDir) {
            this.m_nSpeed1000 = this.m_nMinSpeed1000;
        }
        if (this.m_nMoveDir == 0 && nMoveDir != 0) {
            this.m_qwMoveStartTick = System.currentTimeMillis();
        }
        this.m_nMoveDir = nMoveDir;
        if (this.m_nMoveDir == 0) {
            this.m_nSpeed1000 = 0;
            this.m_qwMoveStartTick = 0L;
        }
    }

    void OnSWLKeyDown(STSWLEventKey stEvent) {
        switch (stEvent.key) {
            case -3: {
                this.m_bLeftKey = false;
                break;
            }
            case -4: {
                this.m_bRightKey = false;
                break;
            }
            case -1: {
                this.m_bUpKey = false;
                break;
            }
            case -2: {
                this.m_bDownKey = false;
            }
        }
        int nMoveDir = this.CalMoveDir();
        if (nMoveDir != this.m_nMoveDir) {
            this.m_nSpeed1000 = this.m_nMinSpeed1000;
        }
        this.m_nMoveDir = nMoveDir;
        if (this.m_nMoveDir == 0) {
            this.m_nSpeed1000 = 0;
            this.m_qwMoveStartTick = 0L;
        }
    }

    int OnSWLTouchUp(STSWLEventTouch stEvent) {
        this.m_ptDiff.x = 0;
        this.m_ptDiff.y = 0;
        this.m_bTouchStart = false;
        return 0;
    }

    int OnSWLTouchDown(STSWLEventTouch stEvent) {
        this.m_bTouchStart = true;
        this.ResetKeyState();
        CSWLPoint ptTouch = new CSWLPoint();
        ptTouch.x = stEvent.x;
        ptTouch.y = stEvent.y;
        CSWLRect rtPointer = new CSWLRect(this.m_ptPos.x, this.m_ptPos.y, this.m_ptPos.x + this.m_pAniPointer.GetCurFrmWidth(), this.m_ptPos.y + this.m_pAniPointer.GetCurFrmHeight());
        if (rtPointer.PtInRect(ptTouch)) {
            this.m_ptDiff.x = this.m_ptPos.x - ptTouch.x;
            this.m_ptDiff.y = this.m_ptPos.y - ptTouch.y;
        }
        ptTouch.x += this.m_ptDiff.x;
        ptTouch.y += this.m_ptDiff.y;
        this.SetPos(ptTouch);
        return 0;
    }

    int OnSWLTouchDrag(STSWLEventTouch stEvent) {
        this.m_bTouchStart = true;
        this.ResetKeyState();
        CSWLPoint ptTouch = new CSWLPoint();
        ptTouch.x = stEvent.x;
        ptTouch.y = stEvent.y;
        ptTouch.x += this.m_ptDiff.x;
        ptTouch.y += this.m_ptDiff.y;
        this.SetPos(ptTouch);
        return 0;
    }

    int CalMoveDir() {
        int nMoveDir = this.m_bLeftKey ? (this.m_bUpKey ? 4 : (this.m_bDownKey ? 2 : 3)) : (this.m_bRightKey ? (this.m_bUpKey ? 6 : (this.m_bDownKey ? 8 : 7)) : (this.m_bUpKey ? 5 : (this.m_bDownKey ? 1 : 0)));
        return nMoveDir;
    }

    void Process() {
        this.m_pAniPointer.Process();
        long qwCurTick = System.currentTimeMillis();
        if (this.m_bStop && (int)(qwCurTick - this.m_qwStopStartTime) > this.m_dwStopPeriod) {
            this.m_bStop = false;
        }
        if (this.m_pAniPointerStartEf.IsPlay()) {
            this.m_pAniPointerStartEf.Process();
        }
        if (this.m_nMoveDir == 0) {
            return;
        }
        this.m_nSpeed1000 = this.m_nMinSpeed1000;
        CSWLPoint ptNext = this.GetMoveDistance(this.m_nMoveDir, this.m_nSpeed1000, this.m_siRemainPixel);
        this.m_ptPos.x += ptNext.x;
        this.m_ptPos.y += ptNext.y;
        if (!this.m_rtGameArea.PtInRect(this.m_ptPos)) {
            if (this.m_ptPos.x > this.m_rtGameArea.right) {
                this.m_ptPos.x -= this.m_rtGameArea.Width();
            } else if (this.m_ptPos.x < this.m_rtGameArea.left) {
                this.m_ptPos.x += this.m_rtGameArea.Width();
            }
            if (this.m_ptPos.y > this.m_rtGameArea.bottom) {
                this.m_ptPos.y -= this.m_rtGameArea.Height();
            } else if (this.m_ptPos.y < this.m_rtGameArea.top) {
                this.m_ptPos.y += this.m_rtGameArea.Height();
            }
            this.m_bAround = true;
        } else if (this.m_bAround) {
            this.m_bAround = false;
        }
    }

    void Draw() {
        if (!this.m_bShow) {
            return;
        }
        Yulib.m_g.setClip(0, 0, 240, 320);
        Yulib.m_g.drawImage(this.m_pImgPointEffect, this.m_ptPos.x, this.m_ptPos.y, 0);
        this.m_pAniPointer.Draw(this.m_ptPos.x, this.m_ptPos.y);
    }

    void cbChangeOption(boolean lpCaller) {
        if (lpCaller) {
            this.OnChangeOption();
        }
    }

    void OnChangeOption() {
        this.m_nMinSpeed1000 = CDPOptionData.GetPointerSpeed() * 1000;
    }

    void ResetKeyState() {
        this.m_bLeftKey = false;
        this.m_bRightKey = false;
        this.m_bUpKey = false;
        this.m_bDownKey = false;
        this.m_nMoveDir = 0;
        this.m_nSpeed1000 = 0;
        this.m_qwMoveStartTick = 0L;
    }

    void SetSpeedZero() {
        this.m_nSpeed1000 = 0;
        this.m_qwMoveStartTick = System.currentTimeMillis();
    }

    boolean IsMove() {
        return this.m_bDownKey || this.m_bRightKey || this.m_bLeftKey || this.m_bUpKey;
    }
}

