/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class CKDotMatrixFont {
    public static CKDotMatrixFont m_Instance;
    private int m_nMatrixFontAllDataLegnth;
    private int m_nMatrixFontHeight;
    private int m_nByteCounts;
    private int m_nCharacterCounts;
    private String m_strFontCharacter = "";
    private int m_nASCIIFontW;
    private int[] m_nCharacterFontWH;
    private int[] m_nMatrixFontData;
    private int[] m_nTmpMatrixFontData;
    private int m_nMatrixFontDataLegnth;

    public static CKDotMatrixFont getInstance() {
        if (m_Instance == null) {
            m_Instance = new CKDotMatrixFont();
        }
        return m_Instance;
    }

    public void loadFontData(String strKdmfName) {
        try {
            int i;
            InputStream fis = this.getClass().getResourceAsStream("/" + strKdmfName + ".kdmf");
            DataInputStream dis = new DataInputStream(fis);
            this.m_nMatrixFontHeight = fis.read();
            this.m_nByteCounts = fis.read();
            this.m_nMatrixFontDataLegnth = this.m_nMatrixFontHeight * this.m_nByteCounts;
            this.m_nTmpMatrixFontData = new int[this.m_nMatrixFontDataLegnth];
            int nValue0 = fis.read();
            int nValue1 = fis.read();
            this.m_nCharacterCounts = (nValue0 << 8) + nValue1;
            this.m_nMatrixFontAllDataLegnth = this.m_nCharacterCounts * this.m_nMatrixFontHeight * this.m_nByteCounts;
            for (i = 0; i < this.m_nCharacterCounts; ++i) {
                char c = dis.readChar();
                this.m_strFontCharacter = this.m_strFontCharacter + c;
            }
            this.m_nASCIIFontW = fis.read();
            this.m_nCharacterFontWH = new int[2];
            for (i = 0; i < 2; ++i) {
                this.m_nCharacterFontWH[i] = fis.read();
            }
            this.m_nMatrixFontData = new int[this.m_nMatrixFontAllDataLegnth];
            for (i = 0; i < this.m_nMatrixFontAllDataLegnth; ++i) {
                this.m_nMatrixFontData[i] = fis.read();
            }
            System.out.println("load MatrixFontData Succeed!");
            fis.close();
            dis.close();
        }
        catch (Exception e) {
            System.out.println("[loadFontData]:font file is not exist!!!");
            e.printStackTrace();
        }
    }

    public void drawString(Graphics g, String str, int x, int y, int nAnchor) {
        int nLength = str.length();
        int nOffsetX = 0;
        int nStringWidth = this.stringWidth(str);
        if ((nAnchor & 8) != 0) {
            x -= nStringWidth;
        }
        if ((nAnchor & 0x20) != 0) {
            y -= this.getHeight();
        }
        if ((nAnchor & 1) != 0) {
            x -= nStringWidth >> 1;
        }
        if ((nAnchor & 2) != 0 || (nAnchor & 0x40) != 0) {
            y -= this.getHeight() >> 1;
        }
        for (int i = 0; i < nLength; ++i) {
            char c = str.charAt(i);
            this.getMatrixFontData(c);
            if (c < '\u007f') {
                this.drawMatrixFont(g, x + nOffsetX, y, nAnchor);
                nOffsetX += this.m_nASCIIFontW;
                continue;
            }
            this.drawMatrixFont(g, x + nOffsetX, y, nAnchor);
            nOffsetX += this.m_nCharacterFontWH[0];
        }
    }

    private void drawMatrixFont(Graphics g, int x, int y, int nAnchor) {
        for (int i = 0; i < this.m_nMatrixFontHeight; ++i) {
            for (int j = 0; j < this.m_nByteCounts; ++j) {
                for (int k = 0; k < 8; ++k) {
                    if ((this.m_nTmpMatrixFontData[i * this.m_nByteCounts + j] & 128 >> k) == 0) continue;
                    g.drawLine(x + j * 8 + k, y + i, x + j * 8 + k, y + i);
                }
            }
        }
    }

    private void getMatrixFontData(char c) {
        int nTableIndex = this.m_strFontCharacter.indexOf(c);
        if (nTableIndex == -1) {
            System.arraycopy(this.m_nMatrixFontData, (this.m_nCharacterCounts - 1) * this.m_nMatrixFontDataLegnth, this.m_nTmpMatrixFontData, 0, this.m_nMatrixFontDataLegnth);
            return;
        }
        System.arraycopy(this.m_nMatrixFontData, nTableIndex * this.m_nMatrixFontDataLegnth, this.m_nTmpMatrixFontData, 0, this.m_nMatrixFontDataLegnth);
    }

    public int stringWidth(String str) {
        int nLength = str.length();
        int nStrLen = 0;
        for (int i = 0; i < nLength; ++i) {
            char c = str.charAt(i);
            if (c < '\u007f') {
                nStrLen += this.m_nASCIIFontW;
                continue;
            }
            nStrLen += this.m_nCharacterFontWH[0];
        }
        return nStrLen;
    }

    public int charWidth(char c) {
        if (c < '\u007f') {
            return this.m_nASCIIFontW;
        }
        return this.m_nCharacterFontWH[0];
    }

    public int charsWidth(char[] c, int nOffset, int nLength) {
        if (c == null) {
            return 0;
        }
        int nCharLength = c.length;
        if (nOffset < 0 || nOffset > nCharLength) {
            throw new IllegalArgumentException();
        }
        int nCharsWidth = 0;
        for (int i = nOffset; i < nCharLength; ++i) {
            if (c[i] < '\u007f') {
                nCharsWidth += this.m_nASCIIFontW;
                continue;
            }
            nCharsWidth += this.m_nCharacterFontWH[0];
        }
        return nCharsWidth;
    }

    public int getHeight() {
        return this.m_nCharacterFontWH[1];
    }
}

