/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

class CObstacleCat
extends CObstacleBase {
    static final int DRAG_NONE = 0;
    static final int DRAG_LEFT = 1;
    static final int DRAG_RIGHT = 2;
    static final int DRAG_UP = 4;
    static final int DRAG_DOWN = 8;
    static final int DRAG_LEFT_UP = 5;
    static final int DRAG_LEFT_DOWN = 9;
    static final int DRAG_RIGHT_UP = 6;
    static final int DRAG_RIGHT_DOWN = 10;
    static final int OBSTACLE_STATE_PRE_FIRSTGEN = 0;
    static final int OBSTACLE_STATE_AFTER_FIRSTGEN = 1;
    static final int OBSTACLE_STATE_GENERATING = 2;
    static final int MAX_OBSTACLE_STATE = 3;
    int m_eDragDirection;
    int m_dwObstacleState = 0;
    boolean m_bFirstGen = true;
    int m_dwFirstGenElapse = 0;
    int m_dwReGenElapse = 0;
    int m_dwFootprintCnt = 0;
    int m_dwFootprintHealth = 0;
    CSWLList m_listFootprint = new CSWLList();
    CSWLList m_listTempFootprint = new CSWLList();
    boolean m_bShowCat = false;
    CSWLPoint m_ptCatStart = new CSWLPoint();
    CSWLPoint m_ptCatEnd = new CSWLPoint();
    CSWLPoint m_ptCatCur = new CSWLPoint();
    int m_nSlope1000;
    int m_nMoveXCatPerTick = 0;
    long m_qwMoveStartTick = 0L;
    int m_dwCurFootprint;
    CSWLAni m_pAniEraser = null;
    CSWLAni m_pAniCat = null;
    CSWLAni m_pAniCatMirror = null;
    Image m_pImgFootprint = null;
    Image m_pImgFootprintMirror = null;
    int m_nEraseTick = -1;
    STSWLListNode m_lpEraseNode = null;
    int m_nClearFootprint;
    CSWLPoint m_ptPrevDragPos = new CSWLPoint();
    static final int MOVE_X_PIXEL_PER_TICK = 1;
    static final int GIFT_BOX_RATE = 40;
    static final int REGEN_GIFT_BOX_RATE = 10;
    static final int DIST_CLEAR_FOOTPRINT = 900;
    STFootprint lpFootprint = new STFootprint();

    CObstacleCat() {
        this.m_pAniTouch = null;
    }

    void DestoryCObstacle() {
        this.Free();
    }

    int Init() {
        this.m_pAniCat = new CSWLAni();
        this.m_pAniCat.SetClock(MainCanvas.g_pGameClock);
        this.m_pAniCat.LoadFromRes("ani_cat.txt");
        this.m_pAniCatMirror = new CSWLAni();
        this.m_pAniCatMirror.SetClock(MainCanvas.g_pGameClock);
        this.m_pAniCatMirror.LoadFromRes("ani_cat_mirror.txt");
        this.m_pImgFootprint = Yulib.LoadImage("Obstacle_Cat_Fut.png");
        CSWLImgOpt imgOpt = new CSWLImgOpt();
        imgOpt.Mirror();
        this.m_pImgFootprintMirror = Yulib.LoadImage("Obstacle_Cat_Fut.png");
        this.m_qwGameStartTick = this.GetCurrentTick();
        CObstacleBase.m_bCharic = CDPCharic.HaveCharic(1);
        this.m_pAniEraser = new CSWLAni();
        this.m_pAniEraser.SetClock(MainCanvas.g_pGameClock);
        if (CObstacleBase.m_bCharic) {
            // empty if block
        }
        this.m_pAniEraser.Show(false);
        this.m_nClearFootprint = 0;
        this.m_nGiftBoxRate = 40;
        this.m_nGiftBoxRateRegen = 10;
        return 0;
    }

    void Free() {
        this.m_pAniEraser = null;
        this.m_pAniCat = null;
        this.m_pAniCatMirror = null;
        this.m_pImgFootprint = null;
        this.m_pImgFootprintMirror = null;
        while (this.m_listFootprint.GetCount() > 0) {
            this.lpFootprint = this.m_listFootprint.Item(0, this.lpFootprint);
            this.lpFootprint = null;
            this.m_listFootprint.Delete(0);
        }
        this.ClearTempFootPrint();
        if (this.m_nClearFootprint > 0) {
            int nClearFootprint = CDPSaveAchieve.GetClearFootprint();
            CDPSaveAchieve.SetClearFootprint(this.m_nClearFootprint + nClearFootprint);
        }
        this.m_pAniTouch = null;
    }

    void ClearTempFootPrint() {
        while (this.m_listTempFootprint.GetCount() > 0) {
            this.lpFootprint = this.m_listTempFootprint.Item(0, this.lpFootprint);
            this.lpFootprint = null;
            this.m_listTempFootprint.Delete(0);
        }
    }

    void SetRoundData(CDPRnd lpRnd) {
        this.Init();
        if (CMainViewSelPack.m_nSelPackIdx == 0) {
            CViewGameFDP.UseImg_fdp_data = CViewGameFDP.UseImg_fdp_data1;
        } else if (CMainViewSelPack.m_nSelPackIdx == 1) {
            CViewGameFDP.UseImg_fdp_data = CViewGameFDP.UseImg_fdp_data2;
        } else if (CMainViewSelPack.m_nSelPackIdx == 2) {
            CViewGameFDP.UseImg_fdp_data = CViewGameFDP.UseImg_fdp_data3;
        } else if (CMainViewSelPack.m_nSelPackIdx == 3) {
            CViewGameFDP.UseImg_fdp_data = CViewGameFDP.UseImg_fdp_data4;
        }
        if (CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][0] == 0) {
            this.m_dwFirstGenElapse = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][7];
            this.m_dwReGenElapse = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][8];
            this.m_dwFootprintCnt = 1;
            this.m_dwFootprintHealth = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][10];
        } else if (CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][0] == 1) {
            this.m_dwFirstGenElapse = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][11];
            this.m_dwReGenElapse = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][12];
            this.m_dwFootprintCnt = 1;
            this.m_dwFootprintHealth = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][14];
        } else if (CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][0] == 2) {
            this.m_dwFirstGenElapse = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][9];
            this.m_dwReGenElapse = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][10];
            this.m_dwFootprintCnt = 1;
            this.m_dwFootprintHealth = CViewGameFDP.UseImg_fdp_data[CMainFrame.g_pMainDoc.GetCurrentLevel()][CMainDoc.GetCurrentRound()][12];
        }
        this.m_qwGameStartTick = this.GetCurrentTick();
    }

    void DecideCatPath() {
        CSWLRect rtScreen = new CSWLRect();
        CSWLScreen.GetSystemScreenRect(rtScreen);
        this.m_ptCatStart.x = Yulib.RAND(0, 1) == 1 ? rtScreen.left : rtScreen.right;
        this.m_ptCatStart.y = Yulib.RAND(30, 230);
        this.m_ptCatEnd.x = this.m_ptCatStart.x > 0 ? rtScreen.left : rtScreen.right;
        this.m_ptCatEnd.y = Yulib.RAND(30, 230);
        this.m_nSlope1000 = (this.m_ptCatEnd.y - this.m_ptCatStart.y) * 1000 / (this.m_ptCatEnd.x - this.m_ptCatStart.x);
        if (this.m_ptCatStart.x > this.m_ptCatEnd.x) {
            this.m_nMoveXCatPerTick = -1;
            this.m_pAniCat.Play(true);
        } else {
            this.m_nMoveXCatPerTick = 1;
            this.m_pAniCatMirror.Play(true);
        }
        this.m_ptCatCur = this.m_ptCatStart;
        this.m_qwMoveStartTick = this.GetCurrentTick();
        this.m_bShowCat = true;
        this.m_qwGameStartTick = this.m_qwMoveStartTick;
        this.m_dwCurFootprint = 0;
    }

    void GenerateFootprint() {
        CSWLPoint ptFootprint = new CSWLPoint();
        this.ClearTempFootPrint();
        int nCX = Math.abs(this.m_ptCatStart.x - this.m_ptCatEnd.x) / this.m_dwFootprintCnt;
        for (int i = 0; i < this.m_dwFootprintCnt; ++i) {
            if (this.m_ptCatStart.x > this.m_ptCatEnd.x) {
                ptFootprint.x = Yulib.RAND(this.m_ptCatStart.x - (i + 1) * nCX, this.m_ptCatStart.x - i * nCX);
                ptFootprint.y = this.m_ptCatEnd.y + this.m_nSlope1000 * ptFootprint.x / 1000;
            } else {
                ptFootprint.x = Yulib.RAND(this.m_ptCatStart.x + i * nCX, this.m_ptCatStart.x + (i + 1) * nCX);
                ptFootprint.y = this.m_ptCatStart.y + this.m_nSlope1000 * ptFootprint.x / 1000;
            }
            STFootprint pFootprint = new STFootprint();
            pFootprint.ptPos = ptFootprint;
            pFootprint.dwHealth = this.m_dwFootprintHealth;
            pFootprint.nDirection = this.m_ptCatStart.x > this.m_ptCatEnd.x ? 1 : 0;
            this.m_listTempFootprint.Add(pFootprint);
        }
    }

    STSWLListNode CheckPtInFootprint() {
        CGamePointer lpPointer = this.m_lpGameView.GetPointer();
        if (lpPointer != null) {
            CSWLPoint ptPointer = new CSWLPoint();
            ptPointer = lpPointer.GetPos(ptPointer);
            return this.CheckPtInFootprint(ptPointer);
        }
        return null;
    }

    STSWLListNode CheckPtInFootprint(CSWLPoint ptPointer) {
        CSWLRect rtFootprint = new CSWLRect();
        this.lpFootprint = this.m_listFootprint.GetTailData(this.lpFootprint);
        while (this.lpFootprint != null) {
            rtFootprint.left = this.lpFootprint.ptPos.x - (this.m_pImgFootprint.getWidth() >> 1);
            rtFootprint.right = rtFootprint.left + this.m_pImgFootprint.getWidth();
            rtFootprint.top = 50 + this.lpFootprint.ptPos.y - (this.m_pImgFootprint.getHeight() >> 1);
            rtFootprint.bottom = rtFootprint.top + this.m_pImgFootprint.getHeight();
            if (rtFootprint.PtInRect(ptPointer)) {
                return this.m_listFootprint.GetCurrent();
            }
            this.lpFootprint = this.m_listFootprint.GetPrevData(this.lpFootprint);
        }
        return null;
    }

    int OnSWLKeyUp(STSWLEventKey stEvent) {
        switch (stEvent.key) {
            case -5: {
                STSWLListNode lpDelNode;
                if (this.m_bShowCat) {
                    CSWLPoint ptCursorPos = new CSWLPoint();
                    ptCursorPos = this.m_lpGameView.GetPointer().GetPos(ptCursorPos);
                    if (this.HitTest(ptCursorPos) > 0) {
                        return -1;
                    }
                }
                if (!this.m_pAniEraser.IsShow() || (lpDelNode = this.CheckPtInFootprint()) == null) break;
                STFootprint lpFootprint = lpDelNode.STFootprintdata;
                if ((CObstacleBase.m_bCharic || lpFootprint.dwHealth <= 0) && this.m_nEraseTick >= 0) {
                    return -1;
                }
                --lpFootprint.dwHealth;
                if (lpFootprint.dwHealth <= 0) {
                    MainCanvas.Vibrator(300);
                }
                this.m_nEraseTick = 0;
                this.m_lpEraseNode = lpDelNode;
                this.m_pAniEraser.Play(false);
                if (this.m_bFirstGen) {
                    this.m_bFirstGen = false;
                }
                return 1;
            }
        }
        return 0;
    }

    int TouchClick(STSWLEventTouch stEvent) {
        CSWLPoint ptTouch = new CSWLPoint();
        ptTouch.x = stEvent.x;
        ptTouch.y = stEvent.y;
        if (this.m_bShowCat && this.HitTest(ptTouch) > 0) {
            return -1;
        }
        STSWLListNode lpDelNode = this.CheckPtInFootprint(ptTouch);
        if (lpDelNode != null) {
            return -1;
        }
        return 0;
    }

    int TouchDrag(STSWLEventTouch stEvent) {
        STFootprint lpFootNode = null;
        if ((lpFootNode = this.m_listFootprint.GetHeadData(lpFootNode)) != null) {
            lpFootNode.eDragDirection = 0;
            lpFootNode.nTotalDragDist = 0;
            lpFootNode = this.m_listFootprint.GetNextData(lpFootNode);
        }
        return 0;
    }

    int OnSWLTouchDown(STSWLEventTouch stEvent) {
        CSWLPoint ptTouch = new CSWLPoint();
        ptTouch.x = stEvent.x;
        ptTouch.y = stEvent.y;
        this.m_ptPrevDragPos = ptTouch;
        return 0;
    }

    int OnSWLTouchDrag(STSWLEventTouch stEvent) {
        CSWLPoint ptTouch = new CSWLPoint();
        ptTouch.x = stEvent.x;
        ptTouch.y = stEvent.y;
        this.m_eDragDirection = this.GetDirection(this.m_ptPrevDragPos, ptTouch);
        this.lpFootprint = this.m_listFootprint.GetTailData(this.lpFootprint);
        while (this.lpFootprint != null) {
            if (!this.ProcessDrag(this.m_ptPrevDragPos, ptTouch, this.lpFootprint)) continue;
            if (this.lpFootprint.dwHealth > 0) {
                this.lpFootprint = this.m_listFootprint.GetNextData(this.lpFootprint);
                continue;
            }
            STSWLListNode lpDelNode = this.m_listFootprint.GetCurrent();
            this.lpFootprint = this.m_listFootprint.GetNextData(this.lpFootprint);
            lpDelNode.data = null;
            this.m_listFootprint.Delete(lpDelNode);
            ++this.m_nClearFootprint;
        }
        this.m_ptPrevDragPos = ptTouch;
        return 0;
    }

    int Process() {
        long qwCurTick = this.GetCurrentTick();
        switch (this.m_dwObstacleState) {
            case 0: {
                if ((int)(qwCurTick - this.m_qwGameStartTick) <= this.m_dwFirstGenElapse) break;
                this.ShowObstacle(true);
                this.DecideCatPath();
                this.GenerateFootprint();
                this.m_dwObstacleState = 2;
                break;
            }
            case 1: {
                if ((int)(qwCurTick - this.m_qwGameStartTick) <= this.m_dwReGenElapse) break;
                this.ShowObstacle(true);
                this.DecideCatPath();
                this.GenerateFootprint();
                this.m_dwObstacleState = 2;
                break;
            }
            case 2: {
                this.m_ptCatCur.x = this.m_ptCatStart.x + this.m_nMoveXCatPerTick * ((int)(qwCurTick - this.m_qwMoveStartTick) / 200);
                this.m_ptCatCur.y = this.m_ptCatStart.y + this.m_nSlope1000 * (this.m_ptCatCur.x - this.m_ptCatStart.x) / 1000;
                this.lpFootprint = this.m_listTempFootprint.GetHeadData(this.lpFootprint);
                while (this.lpFootprint != null) {
                    STSWLListNode lpDelNode = null;
                    if (this.m_ptCatStart.x > this.m_ptCatEnd.x) {
                        if (this.lpFootprint.ptPos.x >= this.m_ptCatCur.x) {
                            lpDelNode = this.m_listTempFootprint.GetCurrent();
                        }
                    } else if (this.lpFootprint.ptPos.x <= this.m_ptCatCur.x) {
                        lpDelNode = this.m_listTempFootprint.GetCurrent();
                    }
                    this.lpFootprint = this.m_listTempFootprint.GetNextData(this.lpFootprint);
                    if (lpDelNode == null) continue;
                    STFootprint lpDelFootprint = lpDelNode.STFootprintdata;
                    STFootprint pTemp = new STFootprint();
                    pTemp.ptPos = lpDelFootprint.ptPos;
                    pTemp.dwHealth = lpDelFootprint.dwHealth;
                    pTemp.nDirection = lpDelFootprint.nDirection;
                    pTemp.eDragDirection = lpDelFootprint.eDragDirection;
                    pTemp.nTotalDragDist = lpDelFootprint.nTotalDragDist;
                    this.m_listFootprint.Add(pTemp);
                    lpDelFootprint = null;
                    this.m_listTempFootprint.Delete(lpDelNode);
                }
                if (this.m_ptCatStart.x == 240 && this.m_ptCatCur.x <= this.m_ptCatEnd.x || this.m_ptCatStart.x == 0 && this.m_ptCatCur.x >= this.m_ptCatEnd.x) {
                    this.m_dwObstacleState = 1;
                    this.m_pAniCat.Stop();
                    this.m_pAniCatMirror.Stop();
                    this.m_bShowCat = false;
                    break;
                }
                this.m_pAniCat.Process();
                this.m_pAniCatMirror.Process();
            }
        }
        if (this.m_nEraseTick >= 0) {
            this.m_pAniEraser.Process();
            ++this.m_nEraseTick;
            if (!CObstacleBase.m_bCharic && this.m_nEraseTick > 2 || CObstacleBase.m_bCharic && this.m_nEraseTick > 2) {
                this.m_nEraseTick = -1;
                this.lpFootprint = this.m_lpEraseNode.STFootprintdata;
                if (CObstacleBase.m_bCharic) {
                    this.lpFootprint.dwHealth = 0;
                }
                if (this.lpFootprint.dwHealth == 0) {
                    this.GenerateGiftBox(new CSWLPoint(this.lpFootprint.ptPos.x, this.lpFootprint.ptPos.y));
                    this.lpFootprint = null;
                    this.m_listFootprint.Delete(this.m_lpEraseNode);
                    ++this.m_nClearFootprint;
                }
                this.m_lpEraseNode = this.CheckPtInFootprint();
                this.m_pAniEraser.Play(false);
                this.m_pAniEraser.Stop();
                if (this.m_lpEraseNode != null) {
                    this.m_pAniEraser.Show(true);
                }
            }
        } else {
            if (this.CheckPtInFootprint() != null) {
                this.m_lpGameView.GetPointer().Show(false);
                this.m_pAniEraser.Show(true);
            } else {
                this.m_lpGameView.GetPointer().Show(true);
                this.m_pAniEraser.Show(false);
            }
            if (this.m_bShowCat) {
                CSWLPoint ptCursorPos = new CSWLPoint();
                this.m_lpGameView.GetPointer().GetPos(ptCursorPos);
                if (this.HitTest(ptCursorPos) > 0) {
                    this.m_pAniEraser.Show(false);
                    this.m_lpGameView.GetPointer().Show(true);
                }
            }
        }
        this.lpFootprint = this.m_listFootprint.GetHeadData(this.lpFootprint);
        return 0;
    }

    void Draw(int x, int y) {
        if (!CObstacleBase.m_bShowObstacle) {
            return;
        }
        Image lpImgFootprint = null;
        this.lpFootprint = this.m_listFootprint.GetTailData(this.lpFootprint);
        while (this.lpFootprint != null) {
            lpImgFootprint = this.lpFootprint.nDirection > 0 ? this.m_pImgFootprint : this.m_pImgFootprintMirror;
            Yulib.Draw(lpImgFootprint, x + this.lpFootprint.ptPos.x - (lpImgFootprint.getWidth() >> 1), y + this.lpFootprint.ptPos.y - (lpImgFootprint.getHeight() >> 1));
            this.lpFootprint = this.m_listFootprint.GetNextData(this.lpFootprint);
        }
        this.lpFootprint = this.m_listFootprint.GetTailData(this.lpFootprint);
        if (this.lpFootprint != null && this.m_bFirstGen) {
            this.DrawTouchUp(x + this.lpFootprint.ptPos.x - (lpImgFootprint.getWidth() >> 1), y + this.lpFootprint.ptPos.y - lpImgFootprint.getHeight(), 1);
        }
        if (this.m_bShowCat) {
            CSWLAni lpAniCat = this.m_ptCatStart.x > this.m_ptCatEnd.x ? this.m_pAniCat : this.m_pAniCatMirror;
            lpAniCat.Draw(x + this.m_ptCatCur.x, y + this.m_ptCatCur.y);
        }
        if (this.m_pAniEraser != null) {
            CGamePointer lpPointer = this.m_lpGameView.GetPointer();
            CSWLPoint ptPointer = new CSWLPoint();
            lpPointer.GetPos(ptPointer);
        }
    }

    int HitTest(CSWLPoint ptPos) {
        CSWLAni lpAniCat = this.m_ptCatStart.x > this.m_ptCatEnd.x ? this.m_pAniCat : this.m_pAniCatMirror;
        CSWLPoint ptDatum = new CSWLPoint();
        lpAniCat.GetCurFrmDatum(ptDatum);
        CSWLPoint ptCurPos = new CSWLPoint(ptPos.x, ptPos.y);
        ptCurPos.Offset(-(this.m_ptCatCur.x - ptDatum.x), -(this.m_ptCatCur.y - ptDatum.y + 50));
        lpAniCat.HitTest(ptCurPos);
        int a = 0;
        a = lpAniCat.HitTest(ptCurPos) ? 1 : 0;
        return a;
    }

    int GetDirection(CSWLPoint ptPos1, CSWLPoint ptPos2) {
        CSWLPoint ptDiff = new CSWLPoint();
        ptDiff.x = ptPos2.x - ptPos1.x;
        ptDiff.y = ptPos2.y - ptPos1.y;
        int nRet = 0;
        if (ptDiff.x > 0 && ptDiff.y < ptDiff.x * 2 && ptDiff.y > -ptDiff.x * 2) {
            ++nRet;
        }
        if (ptDiff.x < 0 && ptDiff.y < -ptDiff.x * 2 && ptDiff.y > ptDiff.x * 2) {
            nRet += 2;
        }
        if (ptDiff.y > 0 && ptDiff.x < ptDiff.y * 2 && ptDiff.x > -ptDiff.y * 2) {
            nRet += 4;
        }
        if (ptDiff.y < 0 && ptDiff.x < -ptDiff.y * 2 && ptDiff.x > ptDiff.y * 2) {
            nRet += 8;
        }
        return nRet;
    }

    void GetOverlapPos(CSWLPoint ptPos1, CSWLPoint ptPos2, CSWLPoint ptOverlapPos1, CSWLPoint ptOverlapPos2, CSWLRect rtRect) {
        int nY;
        int nB;
        int nSlope1000;
        if (rtRect.PtInRect(ptPos1)) {
            ptOverlapPos1 = ptPos1;
        } else if (ptPos2.x - ptPos1.x == 0) {
            if (ptPos2.y > ptPos1.y) {
                ptOverlapPos1.x = ptPos1.x;
                ptOverlapPos1.y = ptPos1.y < rtRect.top ? rtRect.top : ptPos1.y;
            } else {
                ptOverlapPos1.x = ptPos1.x;
                ptOverlapPos1.y = ptPos1.y > rtRect.bottom ? rtRect.bottom : ptPos1.y;
            }
        } else {
            nSlope1000 = (ptPos2.y - ptPos1.y) * 1000 / (ptPos2.x - ptPos1.x);
            nB = ptPos1.y - nSlope1000 * ptPos1.x / 1000;
            if (ptPos2.x > ptPos1.x) {
                nY = nSlope1000 * rtRect.left / 1000 + nB;
                if (nY > rtRect.bottom || nY < rtRect.top) {
                    if (nSlope1000 > 0) {
                        ptOverlapPos1.x = (rtRect.top - nB) * 1000 / nSlope1000;
                        ptOverlapPos1.y = rtRect.top;
                    } else {
                        ptOverlapPos1.x = (rtRect.bottom - nB) * 1000 / nSlope1000;
                        ptOverlapPos1.y = rtRect.bottom;
                    }
                } else {
                    ptOverlapPos1.x = rtRect.left;
                    ptOverlapPos1.y = nY;
                }
            } else {
                nY = nSlope1000 * rtRect.right / 1000 + nB;
                if (nY > rtRect.bottom || nY < rtRect.top) {
                    if (nSlope1000 > 0) {
                        ptOverlapPos1.x = (rtRect.top - nB) * 1000 / nSlope1000;
                        ptOverlapPos1.y = rtRect.top;
                    } else {
                        ptOverlapPos1.x = (rtRect.bottom - nB) * 1000 / nSlope1000;
                        ptOverlapPos1.y = rtRect.bottom;
                    }
                } else {
                    ptOverlapPos1.x = rtRect.right;
                    ptOverlapPos1.y = nY;
                }
            }
        }
        if (rtRect.PtInRect(ptPos2)) {
            ptOverlapPos2 = ptPos2;
        } else if (ptPos2.x - ptPos1.x == 0) {
            if (ptPos1.y > ptPos2.y) {
                ptOverlapPos2.x = ptPos2.x;
                ptOverlapPos2.y = ptPos2.y < rtRect.top ? rtRect.top : ptPos2.y;
            } else {
                ptOverlapPos2.x = ptPos2.x;
                ptOverlapPos2.y = ptPos2.y > rtRect.bottom ? rtRect.bottom : ptPos2.y;
            }
        } else {
            nSlope1000 = (ptPos2.y - ptPos1.y) * 1000 / (ptPos2.x - ptPos1.x);
            nB = ptPos1.y - nSlope1000 * ptPos1.x / 1000;
            if (ptPos1.x > ptPos2.x) {
                nY = nSlope1000 * rtRect.left / 1000 + nB;
                if (nY > rtRect.bottom || nY < rtRect.top) {
                    if (nSlope1000 > 0) {
                        ptOverlapPos2.x = (rtRect.top - nB) * 1000 / nSlope1000;
                        ptOverlapPos2.y = rtRect.top;
                    } else {
                        ptOverlapPos2.x = (rtRect.bottom - nB) * 1000 / nSlope1000;
                        ptOverlapPos2.y = rtRect.bottom;
                    }
                } else {
                    ptOverlapPos2.x = rtRect.left;
                    ptOverlapPos2.y = nY;
                }
            } else {
                nY = nSlope1000 * rtRect.right / 1000 + nB;
                if (nY > rtRect.bottom || nY < rtRect.top) {
                    if (nSlope1000 > 0) {
                        ptOverlapPos2.x = (rtRect.top - nB) * 1000 / nSlope1000;
                        ptOverlapPos2.y = rtRect.top;
                    } else {
                        ptOverlapPos2.x = (rtRect.bottom - nB) * 1000 / nSlope1000;
                        ptOverlapPos2.y = rtRect.bottom;
                    }
                } else {
                    ptOverlapPos2.x = rtRect.right;
                    ptOverlapPos2.y = nY;
                }
            }
        }
    }

    boolean ProcessDrag(CSWLPoint ptPos1, CSWLPoint ptPos2, STFootprint lpFootprint) {
        CSWLRect rtFoot = new CSWLRect(lpFootprint.ptPos.x - this.m_pImgFootprint.getWidth() / 2, lpFootprint.ptPos.y - this.m_pImgFootprint.getHeight() / 2 + 50, lpFootprint.ptPos.x + this.m_pImgFootprint.getWidth() / 2, lpFootprint.ptPos.y + this.m_pImgFootprint.getHeight() / 2 + 50);
        if (MainCanvas.IsOverlapLine(ptPos1, ptPos2, rtFoot)) {
            CSWLPoint ptOverlapPos1 = new CSWLPoint();
            CSWLPoint ptOverlapPos2 = new CSWLPoint();
            this.GetOverlapPos(ptPos1, ptPos2, ptOverlapPos1, ptOverlapPos2, rtFoot);
            int nDistInRect = Yulib.SWL_Sqr(ptOverlapPos1.x - ptOverlapPos2.x) + Yulib.SWL_Sqr(ptOverlapPos1.y - ptOverlapPos2.y);
            if (lpFootprint.nTotalDragDist > 0) {
                lpFootprint.nTotalDragDist += nDistInRect;
            } else if (lpFootprint.eDragDirection != this.m_eDragDirection) {
                lpFootprint.eDragDirection = 0;
                lpFootprint.nTotalDragDist = nDistInRect;
            }
            if (lpFootprint.nTotalDragDist > 900) {
                if ((CObstacleBase.m_bCharic || lpFootprint.dwHealth <= 0) && this.m_nEraseTick >= 0) {
                    return false;
                }
                lpFootprint.nTotalDragDist = 0;
                lpFootprint.eDragDirection = this.m_eDragDirection;
                lpFootprint.dwHealth = CObstacleBase.m_bCharic ? 0 : --lpFootprint.dwHealth;
                if (lpFootprint.dwHealth <= 0) {
                    if (CObstacleBase.m_bCharic) {
                        MainCanvas.Vibrator(500);
                    } else {
                        MainCanvas.Vibrator(300);
                    }
                }
                if (this.m_bFirstGen) {
                    this.m_bFirstGen = false;
                }
            }
            if (!rtFoot.PtInRect(ptPos2)) {
                lpFootprint.eDragDirection = 0;
                lpFootprint.nTotalDragDist = 0;
            }
        } else {
            lpFootprint.eDragDirection = 0;
            lpFootprint.nTotalDragDist = 0;
        }
        return true;
    }
}

