/*
 * Decompiled with CFR 0.152.
 */
class CSWLClock {
    private long m_qwStartTime;
    private long m_qwStartPauseTime;
    private long m_qwPausedTime;
    private boolean m_bPause;
    private CSWLClock m_lpParentClock;

    public CSWLClock() {
        this.Init(null, 0);
    }

    public CSWLClock(CSWLClock lpParentClock) {
        this.Init(this.m_lpParentClock, 0);
    }

    void Init(CSWLClock lpParentClock, int nPastTime) {
        this.m_lpParentClock = lpParentClock;
        this.m_qwStartTime = this.m_lpParentClock != null ? this.m_lpParentClock.GetCurrentTime() : System.currentTimeMillis();
        this.m_qwStartTime -= (long)nPastTime;
        this.m_qwStartPauseTime = 0L;
        this.m_qwPausedTime = 0L;
        this.m_bPause = false;
    }

    long GetCurrentTime() {
        long qwCurTick = this.m_bPause ? this.m_qwStartPauseTime : (this.m_lpParentClock != null ? this.m_lpParentClock.GetCurrentTime() : System.currentTimeMillis());
        return qwCurTick - this.m_qwStartTime - this.m_qwPausedTime;
    }

    void Pause() {
        if (this.m_bPause) {
            return;
        }
        this.m_qwStartPauseTime = this.m_lpParentClock != null ? this.m_lpParentClock.GetCurrentTime() : System.currentTimeMillis();
        this.m_bPause = true;
    }

    void Resume() {
        if (!this.m_bPause) {
            return;
        }
        long qwCurTick = this.m_lpParentClock != null ? this.m_lpParentClock.GetCurrentTime() : System.currentTimeMillis();
        this.m_qwPausedTime += qwCurTick - this.m_qwStartPauseTime;
        this.m_qwStartPauseTime = 0L;
        this.m_bPause = false;
    }
}

