/*
 * Decompiled with CFR 0.152.
 */
class CSWLImgOpt {
    int m_nChngClrCnt;
    int[] m_pwChngClrSrc = null;
    int[] m_pwChngClrDest = null;
    RGBQUAD[] m_pPalSrc = null;
    RGBQUAD[] m_pPalDest = null;
    char m_cCalRed;
    char m_cCalGreen;
    char m_cCalBlue;
    boolean m_bMirror;
    int m_wRotate;
    int m_wScale;
    byte m_cOptFlag;
    int m_eFXOpt;
    byte[] m_lpFXData;

    byte GetFlag() {
        return this.m_cOptFlag;
    }

    boolean GetMirror() {
        return this.m_bMirror;
    }

    int GetRotate() {
        return this.m_wRotate;
    }

    int GetScale() {
        return this.m_wScale;
    }

    int GetFXOpt() {
        return this.m_eFXOpt;
    }

    CSWLImgOpt() {
        this.Clear();
    }

    CSWLImgOpt(CSWLImgOpt rhs) {
        this.m_nChngClrCnt = rhs.m_nChngClrCnt;
        if (rhs.m_pwChngClrSrc != null) {
            this.m_pwChngClrSrc = new int[this.m_nChngClrCnt];
            this.m_pwChngClrSrc = rhs.m_pwChngClrSrc;
        }
        if (rhs.m_pwChngClrDest != null) {
            this.m_pwChngClrDest = new int[this.m_nChngClrCnt];
            this.m_pwChngClrDest = rhs.m_pwChngClrDest;
        }
        if (rhs.m_pPalSrc != null) {
            this.m_pPalSrc = new RGBQUAD[this.m_nChngClrCnt];
            this.m_pPalSrc = rhs.m_pPalSrc;
        }
        if (rhs.m_pPalDest != null) {
            this.m_pPalDest = new RGBQUAD[this.m_nChngClrCnt];
            this.m_pPalDest = rhs.m_pPalDest;
        }
        this.m_cCalRed = rhs.m_cCalRed;
        this.m_cCalGreen = rhs.m_cCalGreen;
        this.m_cCalBlue = rhs.m_cCalBlue;
        this.m_bMirror = rhs.m_bMirror;
        this.m_wRotate = rhs.m_wRotate;
        this.m_wScale = rhs.m_wScale;
        this.m_cOptFlag = rhs.m_cOptFlag;
        this.m_eFXOpt = rhs.m_eFXOpt;
        this.m_lpFXData = rhs.m_lpFXData;
    }

    void DestoryCSWLImgOpt() {
        this.Clear();
    }

    CSWLImgOpt operatorEqual(CSWLImgOpt rhs) {
        this.ClearChngClr();
        this.m_nChngClrCnt = rhs.m_nChngClrCnt;
        if (rhs.m_pwChngClrSrc != null) {
            this.m_pwChngClrSrc = new int[this.m_nChngClrCnt];
            this.m_pwChngClrSrc = rhs.m_pwChngClrSrc;
        }
        if (rhs.m_pwChngClrDest != null) {
            this.m_pwChngClrDest = new int[this.m_nChngClrCnt];
            this.m_pwChngClrDest = rhs.m_pwChngClrDest;
        }
        if (rhs.m_pPalSrc != null) {
            this.m_pPalSrc = new RGBQUAD[this.m_nChngClrCnt];
            this.m_pPalSrc = rhs.m_pPalSrc;
        }
        if (rhs.m_pPalDest != null) {
            this.m_pPalDest = new RGBQUAD[this.m_nChngClrCnt];
            this.m_pPalDest = rhs.m_pPalDest;
        }
        this.m_cCalRed = rhs.m_cCalRed;
        this.m_cCalGreen = rhs.m_cCalGreen;
        this.m_cCalBlue = rhs.m_cCalBlue;
        this.m_bMirror = rhs.m_bMirror;
        this.m_wRotate = rhs.m_wRotate;
        this.m_wScale = rhs.m_wScale;
        this.m_cOptFlag = rhs.m_cOptFlag;
        this.m_eFXOpt = rhs.m_eFXOpt;
        this.m_lpFXData = rhs.m_lpFXData;
        return this;
    }

    CSWLImgOpt operatorAddEqual(CSWLImgOpt rhs) {
        byte cOptFlag = rhs.m_cOptFlag;
        if ((cOptFlag & 2) == 2) {
            int j;
            int i;
            STImgOptChngClrOne[] lpTempChngClrOne = new STImgOptChngClrOne[1536];
            int nTempChngClrCnt = 0;
            int[] pnUsedFlagOld = null;
            if (this.m_nChngClrCnt > 0) {
                pnUsedFlagOld = new int[this.m_nChngClrCnt];
            }
            int[] pnUsedFlagNew = new int[rhs.m_nChngClrCnt];
            block0: for (i = 0; i < this.m_nChngClrCnt; ++i) {
                for (j = 0; j < rhs.m_nChngClrCnt; ++j) {
                    if (this.m_pPalSrc[i].rgbRed != rhs.m_pPalSrc[j].rgbRed || this.m_pPalSrc[i].rgbGreen != rhs.m_pPalSrc[j].rgbGreen || this.m_pPalSrc[i].rgbBlue != rhs.m_pPalSrc[j].rgbBlue || this.m_pPalDest[i].rgbRed != rhs.m_pPalDest[j].rgbRed || this.m_pPalDest[i].rgbGreen != rhs.m_pPalDest[j].rgbGreen || this.m_pPalDest[i].rgbBlue != rhs.m_pPalDest[j].rgbBlue) continue;
                    lpTempChngClrOne[nTempChngClrCnt].cSrcRed = this.m_pPalSrc[i].rgbRed;
                    lpTempChngClrOne[nTempChngClrCnt].cSrcGreen = this.m_pPalSrc[i].rgbGreen;
                    lpTempChngClrOne[nTempChngClrCnt].cSrcBlue = this.m_pPalSrc[i].rgbBlue;
                    lpTempChngClrOne[nTempChngClrCnt].cDestRed = this.m_pPalDest[i].rgbRed;
                    lpTempChngClrOne[nTempChngClrCnt].cDestGreen = this.m_pPalDest[i].rgbGreen;
                    lpTempChngClrOne[nTempChngClrCnt].cSrcBlue = this.m_pPalDest[i].rgbBlue;
                    pnUsedFlagOld[i] = 1;
                    pnUsedFlagNew[j] = 1;
                    ++nTempChngClrCnt;
                    continue block0;
                }
            }
            block2: for (i = 0; i < this.m_nChngClrCnt; ++i) {
                for (j = 0; j < rhs.m_nChngClrCnt; ++j) {
                    if (this.m_pPalDest[i].rgbRed != rhs.m_pPalSrc[j].rgbRed || this.m_pPalDest[i].rgbGreen != rhs.m_pPalSrc[j].rgbGreen || this.m_pPalDest[i].rgbBlue != rhs.m_pPalSrc[j].rgbBlue) continue;
                    lpTempChngClrOne[nTempChngClrCnt].cSrcRed = this.m_pPalSrc[i].rgbRed;
                    lpTempChngClrOne[nTempChngClrCnt].cSrcGreen = this.m_pPalSrc[i].rgbGreen;
                    lpTempChngClrOne[nTempChngClrCnt].cSrcBlue = this.m_pPalSrc[i].rgbBlue;
                    lpTempChngClrOne[nTempChngClrCnt].cDestRed = rhs.m_pPalDest[j].rgbRed;
                    lpTempChngClrOne[nTempChngClrCnt].cDestGreen = rhs.m_pPalDest[j].rgbGreen;
                    lpTempChngClrOne[nTempChngClrCnt].cDestBlue = rhs.m_pPalDest[j].rgbBlue;
                    pnUsedFlagOld[i] = 1;
                    pnUsedFlagNew[j] = 1;
                    ++nTempChngClrCnt;
                    continue block2;
                }
            }
            for (i = 0; i < this.m_nChngClrCnt; ++i) {
                if (pnUsedFlagOld[i] > 0) continue;
                lpTempChngClrOne[nTempChngClrCnt].cSrcRed = this.m_pPalSrc[i].rgbRed;
                lpTempChngClrOne[nTempChngClrCnt].cSrcGreen = this.m_pPalSrc[i].rgbGreen;
                lpTempChngClrOne[nTempChngClrCnt].cSrcBlue = this.m_pPalSrc[i].rgbBlue;
                lpTempChngClrOne[nTempChngClrCnt].cDestRed = this.m_pPalDest[i].rgbRed;
                lpTempChngClrOne[nTempChngClrCnt].cDestGreen = this.m_pPalDest[i].rgbGreen;
                lpTempChngClrOne[nTempChngClrCnt].cDestBlue = this.m_pPalDest[i].rgbBlue;
                ++nTempChngClrCnt;
            }
            for (i = 0; i < rhs.m_nChngClrCnt; ++i) {
                if (pnUsedFlagNew[i] > 0) continue;
                lpTempChngClrOne[nTempChngClrCnt].cSrcRed = rhs.m_pPalSrc[i].rgbRed;
                lpTempChngClrOne[nTempChngClrCnt].cSrcGreen = rhs.m_pPalSrc[i].rgbGreen;
                lpTempChngClrOne[nTempChngClrCnt].cSrcBlue = rhs.m_pPalSrc[i].rgbBlue;
                lpTempChngClrOne[nTempChngClrCnt].cDestRed = rhs.m_pPalDest[i].rgbRed;
                lpTempChngClrOne[nTempChngClrCnt].cDestGreen = rhs.m_pPalDest[i].rgbGreen;
                lpTempChngClrOne[nTempChngClrCnt].cDestBlue = rhs.m_pPalDest[i].rgbBlue;
                ++nTempChngClrCnt;
            }
            this.SetChngClr(nTempChngClrCnt, lpTempChngClrOne);
            lpTempChngClrOne = null;
            pnUsedFlagOld = null;
            pnUsedFlagNew = null;
            this.SetFlag((byte)2);
        }
        if ((cOptFlag & 4) == 4) {
            this.m_cCalRed = (char)Yulib.SWL_Limit(this.m_cCalRed + rhs.m_cCalRed, -31, 31);
            this.m_cCalGreen = (char)Yulib.SWL_Limit(this.m_cCalGreen + rhs.m_cCalGreen, -63, 63);
            this.m_cCalBlue = (char)Yulib.SWL_Limit(this.m_cCalBlue + rhs.m_cCalBlue, -31, 31);
            this.SetFlag((byte)4);
        }
        if ((cOptFlag & 8) == 8) {
            if (rhs.m_bMirror) {
                this.m_bMirror ^= true;
            }
            this.SetFlag((byte)8);
        }
        if ((cOptFlag & 0x10) == 16) {
            this.m_wRotate = (this.m_wRotate + rhs.m_wRotate) % 360;
            this.SetFlag((byte)16);
        }
        if ((cOptFlag & 0x20) == 32) {
            this.m_wScale = this.m_wScale * rhs.m_wScale / 100;
            this.SetFlag((byte)32);
        }
        if ((cOptFlag & 0x40) == 64) {
            this.m_eFXOpt = rhs.m_eFXOpt;
            this.m_lpFXData = rhs.m_lpFXData;
            this.SetFlag((byte)64);
        }
        return this;
    }

    boolean operatorDEqual(CSWLImgOpt rhs) {
        if (this.m_cOptFlag != rhs.m_cOptFlag) {
            return false;
        }
        if (this.m_nChngClrCnt != rhs.m_nChngClrCnt) {
            return false;
        }
        if (this.m_cCalRed != rhs.m_cCalRed) {
            return false;
        }
        if (this.m_cCalGreen != rhs.m_cCalGreen) {
            return false;
        }
        if (this.m_cCalBlue != rhs.m_cCalBlue) {
            return false;
        }
        if (this.m_bMirror != rhs.m_bMirror) {
            return false;
        }
        if (this.m_wRotate != rhs.m_wRotate) {
            return false;
        }
        if (this.m_wScale != rhs.m_wScale) {
            return false;
        }
        for (int i = 0; i < this.m_nChngClrCnt; ++i) {
            if (this.m_pwChngClrSrc[i] != rhs.m_pwChngClrSrc[i]) {
                return false;
            }
            if (this.m_pwChngClrDest[i] != rhs.m_pwChngClrDest[i]) {
                return false;
            }
            if (this.m_pPalSrc[i] != rhs.m_pPalSrc[i]) {
                return false;
            }
            if (this.m_pPalDest[i] == rhs.m_pPalDest[i]) continue;
            return false;
        }
        if (this.m_eFXOpt != rhs.m_eFXOpt) {
            return false;
        }
        return this.m_eFXOpt != 1 || this.m_lpFXData == rhs.m_lpFXData;
    }

    void Clear() {
        this.ClearChngClr();
        this.m_cCalRed = '\u0000';
        this.m_cCalGreen = '\u0000';
        this.m_cCalBlue = '\u0000';
        this.m_bMirror = false;
        this.m_wRotate = 0;
        this.m_wScale = 100;
        this.m_cOptFlag = 0;
        this.m_eFXOpt = 0;
        this.m_lpFXData = null;
    }

    void ClearChngClr() {
        this.m_pwChngClrSrc = null;
        this.m_pwChngClrDest = null;
        this.m_pPalSrc = null;
        this.m_pPalDest = null;
        this.m_nChngClrCnt = 0;
    }

    boolean IsExistOpt() {
        return this.m_cOptFlag > 0;
    }

    void SetFlag(byte cFlag) {
        this.m_cOptFlag = (byte)(this.m_cOptFlag | cFlag);
    }

    void ResetFlag(byte cFlag) {
        this.m_cOptFlag = (byte)(this.m_cOptFlag & ~cFlag);
    }

    boolean IsSetFlag(byte cFlag) {
        return (this.m_cOptFlag & cFlag) == cFlag;
    }

    boolean SetChngClr(int nCnt, STImgOptChngClrOne[] lpData) {
        this.ClearChngClr();
        this.SetFlag((byte)2);
        int[] pTempChngClrSrc = new int[nCnt];
        int[] pTempChngClrDest = new int[nCnt];
        RGBQUAD[] pTempPalSrc = new RGBQUAD[nCnt];
        for (int i = 0; i < nCnt; ++i) {
            pTempPalSrc[i] = new RGBQUAD();
        }
        RGBQUAD[] pTempPalDest = new RGBQUAD[nCnt];
        for (int i = 0; i < nCnt; ++i) {
            pTempPalDest[i] = new RGBQUAD();
        }
        int nRealCnt = 0;
        for (int i = 0; i < nCnt; ++i) {
            if (lpData[i].cSrcRed == lpData[i].cDestRed && lpData[i].cSrcGreen == lpData[i].cDestGreen && lpData[i].cSrcBlue == lpData[i].cDestBlue) continue;
            pTempChngClrSrc[nRealCnt] = SWLGrpDefine.RGBTO565(lpData[i].cSrcRed, lpData[i].cSrcGreen, lpData[i].cSrcBlue);
            pTempChngClrDest[nRealCnt] = SWLGrpDefine.RGBTO565(lpData[i].cDestRed, lpData[i].cDestGreen, lpData[i].cDestBlue);
            pTempPalSrc[nRealCnt].SetVal(lpData[i].cSrcRed, lpData[i].cSrcGreen, lpData[i].cSrcBlue);
            pTempPalDest[nRealCnt].SetVal(lpData[i].cDestRed, lpData[i].cDestGreen, lpData[i].cDestBlue);
            ++nRealCnt;
        }
        if (nRealCnt > 0) {
            this.m_pwChngClrSrc = new int[nRealCnt];
            this.m_pwChngClrDest = new int[nRealCnt];
            this.m_pPalSrc = new RGBQUAD[nRealCnt];
            this.m_pPalDest = new RGBQUAD[nRealCnt];
            this.m_pwChngClrSrc = pTempChngClrSrc;
            this.m_pwChngClrDest = pTempChngClrDest;
            this.m_pPalSrc = pTempPalSrc;
            this.m_pPalDest = pTempPalDest;
        }
        pTempChngClrSrc = null;
        pTempChngClrDest = null;
        pTempPalSrc = null;
        pTempPalDest = null;
        this.m_nChngClrCnt = nRealCnt;
        return true;
    }

    void GetChngClr(int nCnt, STImgOptChngClrOne[] lpData) {
        nCnt = this.m_nChngClrCnt;
        if (lpData == null) {
            return;
        }
        for (int i = 0; i < this.m_nChngClrCnt; ++i) {
            lpData[i].cSrcRed = this.m_pPalSrc[i].rgbRed;
            lpData[i].cSrcGreen = this.m_pPalSrc[i].rgbGreen;
            lpData[i].cSrcBlue = this.m_pPalSrc[i].rgbBlue;
            lpData[i].cDestRed = this.m_pPalDest[i].rgbRed;
            lpData[i].cDestGreen = this.m_pPalDest[i].rgbGreen;
            lpData[i].cDestBlue = this.m_pPalDest[i].rgbBlue;
        }
    }

    boolean SetCalClr(char r, char g, char b) {
        this.SetFlag((byte)4);
        this.m_cCalRed = r;
        this.m_cCalGreen = g;
        this.m_cCalBlue = b;
        return true;
    }

    void GetCalClr(char r, char g, char b) {
        r = this.m_cCalRed;
        g = this.m_cCalGreen;
        b = this.m_cCalBlue;
    }

    boolean Scaling(int wPercent) {
        this.SetFlag((byte)32);
        this.m_wScale = wPercent;
        return true;
    }

    boolean Mirror() {
        this.SetFlag((byte)8);
        this.m_bMirror = true;
        return true;
    }

    boolean Rotate(int nDegree) {
        if (nDegree <= 0 || nDegree >= 360) {
            return false;
        }
        this.SetFlag((byte)16);
        this.m_wRotate = nDegree;
        return true;
    }

    boolean SetAlpha(byte[] cAlpha) {
        return true;
    }

    void SetFXOpt(int eKind, byte[] lpData) {
        this.m_eFXOpt = eKind;
        this.m_lpFXData = lpData;
        this.SetFlag((byte)64);
    }

    void ResetFXOpt() {
        this.m_eFXOpt = 0;
        this.m_lpFXData = null;
        this.ResetFlag((byte)64);
    }

    boolean IsSetFXOpt() {
        return this.m_eFXOpt != 0;
    }

    void ResetDrawOpt(byte cOpt) {
        this.ResetFlag(cOpt);
        if (cOpt == 2) {
            this.ClearChngClr();
        }
    }
}

