/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

class CViewCookie {
    static final int COOKIE_CREATE = 0;
    static final int COOKIE_IDLE = 1;
    static final int COOKIE_DISAPPEAR = 2;
    static final int COOKIE_EAT = 3;
    int m_wCreateCashPeriod = 0;
    int[] m_wCashLifeTime = new int[4];
    int[] m_cCreateCashRate = new int[4];
    boolean m_bShow;
    long m_qwRoundEndTime;
    CSWLList m_listCookieList = new CSWLList();
    CGamePointer m_lpPointer = null;
    CMainViewGame m_lpGameView = null;
    Image m_pImgCashNormal;
    Image m_pImgCashWink;
    Image[] m_pImgCashKiss = new Image[2];
    Image[] m_pImgCashHi = new Image[2];
    Image[] m_pImgCashSulk = new Image[2];
    Image[] m_pImgCashSulkEffect = new Image[2];
    CSWLAni m_pAniPointer;
    Image[] m_pImgCursorEffect = new Image[3];
    Image[] m_pImgCashMissEffect = new Image[3];
    Image m_pImgNumber;
    Image m_pImgPlus;
    CSWLAni m_pAniCharic;
    CSWLPoint m_ptAniCharic;
    long m_qwNextCreateTick = 0L;
    CSWLPoint m_ptPrevPos = new CSWLPoint();
    int m_nFrameCnt = 0;
    boolean m_bCharic;
    int m_nCookie = 0;
    int m_nEatSulkCash = CDPSaveData.GetEatSulkCash();
    static final int COOKIE_POS_LEFT = 20;
    static final int COOKIE_POS_RIGHT = 200;
    static final int COOKIE_POS_TOP = 20;
    static final int COOKIE_POS_BOTTOM = 220;
    static final int DIFF_Y_PLUS = -28;
    static final int DIFF_Y_NUMBER = -25;
    static final int FRAME_CNT = 2;
    static final int CREATE_FRAME = 180;
    static final int DISAPPEAR_FRAME = 8;
    static final int EAT_FRAME = 7;
    static final int EAT_CHARIC_FRAME = 11;
    static final int EAT_SULK_FRAME = 8;
    static final int IDLE_FRAME_WINK = 22;
    static final int IDLE_FRAME_OTHERS = 26;
    static final int WIDTH_FIND_POS = 5;
    static final int HEIGHT_FIND_POS = 5;
    static final int ADD_CASH_WINK = 3;
    static final int ADD_CASH_KISS = 2;
    static final int ADD_CASH_HI = 1;

    void SetGameView(CMainViewGame lpView) {
        this.m_lpGameView = lpView;
    }

    void SetPointer(CGamePointer lpPointer) {
        this.m_lpPointer = lpPointer;
    }

    CViewCookie() {
        this.InitImg();
    }

    void DestoryCViewCookie() {
        int i;
        this.ClearCookie();
        this.m_pImgCashNormal = null;
        this.m_pImgCashWink = null;
        for (i = 0; i < 2; ++i) {
            this.m_pImgCashKiss[i] = null;
            this.m_pImgCashHi[i] = null;
            this.m_pImgCashSulk[i] = null;
            this.m_pImgCashSulkEffect[i] = null;
        }
        this.m_pAniPointer = null;
        for (i = 0; i < 3; ++i) {
            this.m_pImgCursorEffect[i] = null;
            this.m_pImgCashMissEffect[i] = null;
        }
        this.m_pAniCharic = null;
        this.m_pImgNumber = null;
        this.m_pImgPlus = null;
        if (!this.m_bCharic) {
            CDPSaveData.SetEatSulkCash(this.m_nEatSulkCash);
            CDPSaveData.SaveSaveData();
        }
    }

    void ClearCookie() {
        if (this.m_listCookieList == null) {
            return;
        }
        while (this.m_listCookieList.GetCount() > 0) {
            STCookie lpCookie = null;
            lpCookie = this.m_listCookieList.Item(0, lpCookie);
            lpCookie = null;
            this.m_listCookieList.Delete(0);
        }
    }

    void InitImg() {
        this.m_pImgCashNormal = Yulib.LoadImage("Cookie_01.png");
        this.m_pImgCashWink = Yulib.LoadImage("Cookie_02.png");
        this.m_pImgCashKiss[0] = Yulib.LoadImage("Cookie_03.png");
        this.m_pImgCashKiss[1] = Yulib.LoadImage("Cookie_04.png");
        this.m_pImgCashHi[0] = Yulib.LoadImage("Cookie_05.png");
        this.m_pImgCashHi[1] = Yulib.LoadImage("Cookie_06.png");
        this.m_pImgCashSulk[0] = Yulib.LoadImage("Cookie_07.png");
        this.m_pImgCashSulk[1] = Yulib.LoadImage("Cookie_08.png");
        this.m_pImgCashSulkEffect[0] = Yulib.LoadImage("Cookie_08_Obj_01.png");
        this.m_pImgCashSulkEffect[1] = Yulib.LoadImage("Cookie_08_Obj_02.png");
        this.m_pAniPointer = new CSWLAni();
        this.m_pAniPointer.SetClock(MainCanvas.g_pGameClock);
        this.m_pAniPointer.LoadFromRes("ani_pointer.txt");
        this.m_pAniPointer.Play(true);
        String szFileName = "";
        for (int i = 0; i < 3; ++i) {
            szFileName = "Cookie_08_Obj_0" + (i + 3) + ".png";
            this.m_pImgCursorEffect[i] = Yulib.LoadImage(szFileName);
        }
        this.m_pImgCashMissEffect[0] = Yulib.LoadImage("Cookie_08_Obj_07.png");
        this.m_pImgCashMissEffect[1] = Yulib.LoadImage("Cookie_08_Obj_06.png");
        this.m_pImgCashMissEffect[2] = Yulib.LoadImage("Cookie_08_Obj_07.png");
        this.m_pImgNumber = Yulib.LoadImage("Number_1_W10.png");
        this.m_pImgPlus = Yulib.LoadImage("Cookie_Obj.png");
        this.m_pAniCharic = new CSWLAni();
        this.m_pAniCharic.SetClock(MainCanvas.g_pGameClock);
        this.m_pAniCharic.Show(false);
    }

    void SetLevelData(CDPLvl lpLvl) {
        STDPLvlHD stLvl = new STDPLvlHD();
        stLvl = lpLvl.GetLevelHeader(stLvl);
        this.m_wCreateCashPeriod = stLvl.wCreateCashPeriod;
        for (int i = 0; i < 4; ++i) {
            this.m_wCashLifeTime[i] = stLvl.wCashLifeTime[i];
            this.m_cCreateCashRate[i] = stLvl.cCreateCashRate[i];
        }
        this.m_qwNextCreateTick = this.m_wCreateCashPeriod * 1000;
        if (this.m_lpPointer != null) {
            CSWLPoint ptPos = new CSWLPoint();
            ptPos = this.m_lpPointer.GetPos(ptPos);
            this.m_ptPrevPos.x = ptPos.x;
            this.m_ptPrevPos.y = ptPos.y;
        }
    }

    int OnSWLKeyUp(STSWLEventKey stEvent) {
        return 0;
    }

    int TouchClick(STSWLEventTouch stEvent) {
        CSWLPoint ptTouch = new CSWLPoint();
        ptTouch.x = stEvent.x;
        ptTouch.y = stEvent.y;
        STCookie lpCookie = null;
        lpCookie = this.m_listCookieList.GetHeadData(lpCookie);
        while (lpCookie != null) {
            CSWLRect rtCookie = new CSWLRect();
            rtCookie.left = lpCookie.ptPos.x + 0;
            rtCookie.top = lpCookie.ptPos.y + 50;
            rtCookie.right = rtCookie.left + this.m_pImgCashNormal.getWidth();
            rtCookie.bottom = rtCookie.top + this.m_pImgCashNormal.getHeight();
            for (int i = 0; i < 25; ++i) {
                CSWLPoint ptFindPos = new CSWLPoint(ptTouch.x - 2 + i / 5, ptTouch.y - 2 + i % 5);
                if (!rtCookie.PtInRect(ptFindPos)) continue;
                if (lpCookie.eState == 3) {
                    return 1;
                }
                switch (lpCookie.cType) {
                    case 0: {
                        this.m_nCookie += 3;
                        if (!this.m_bCharic) break;
                        this.m_nCookie += 3;
                        break;
                    }
                    case 1: {
                        this.m_nCookie += 2;
                        if (!this.m_bCharic) break;
                        this.m_nCookie += 2;
                        break;
                    }
                    case 2: {
                        ++this.m_nCookie;
                        if (!this.m_bCharic) break;
                        ++this.m_nCookie;
                        break;
                    }
                    case 3: {
                        this.m_lpPointer.Stop(1600);
                        this.m_lpPointer.Show(false);
                        ++this.m_nEatSulkCash;
                    }
                }
                CDPSaveGame.SetEatCookie(this.m_nCookie);
                if (CDPSaveData.GetFirstEatCookie()) {
                    this.m_lpGameView.ShowCookieExplain();
                }
                lpCookie.cTick = 0;
                lpCookie.eState = 3;
                if (lpCookie.cType != 3) {
                    this.m_ptAniCharic = lpCookie.ptPos;
                    this.m_ptAniCharic.Offset(-10, -54);
                    this.m_pAniCharic.Play(false);
                    this.m_lpPointer.SetSpeedZero();
                }
                this.Eat(lpCookie);
                return 1;
            }
            lpCookie = this.m_listCookieList.GetNextData(lpCookie);
        }
        return 0;
    }

    int Process() {
        if (!this.m_bShow) {
            return 0;
        }
        long nCurrentTick = System.currentTimeMillis();
        if (this.m_qwNextCreateTick <= nCurrentTick) {
            this.CreateCookie();
            this.m_qwNextCreateTick = nCurrentTick;
            this.m_qwNextCreateTick += (long)(this.m_wCreateCashPeriod * 1000);
        }
        ++this.m_nFrameCnt;
        if (this.m_nFrameCnt >= 2) {
            this.m_nFrameCnt = 0;
        }
        this.m_pAniPointer.Process();
        if (this.m_pAniCharic.IsShow() && this.m_pAniCharic.Process() == 0) {
            this.m_pAniCharic.Show(false);
        }
        STCookie lpCookie = null;
        lpCookie = this.m_listCookieList.GetHeadData(lpCookie);
        while (lpCookie != null) {
            if (this.m_nFrameCnt <= 0) {
                ++lpCookie.cTick;
            }
            this.CheckEat(lpCookie);
            switch (lpCookie.eState) {
                case 0: {
                    this.Create(lpCookie);
                    break;
                }
                case 1: {
                    this.Idle(lpCookie);
                    break;
                }
                case 2: {
                    this.Disappear(lpCookie);
                    break;
                }
                case 3: {
                    this.Eat(lpCookie);
                }
            }
            if (lpCookie == null) {
                STSWLListNode pNode = this.m_listCookieList.GetCurrent();
                lpCookie = this.m_listCookieList.GetNextData(lpCookie);
                this.m_listCookieList.Delete(pNode);
                continue;
            }
            lpCookie = this.m_listCookieList.GetNextData(lpCookie);
        }
        CSWLPoint ptPos = new CSWLPoint();
        ptPos = this.m_lpPointer.GetPos(ptPos);
        this.m_ptPrevPos.x = ptPos.x;
        this.m_ptPrevPos.y = ptPos.y;
        return 0;
    }

    int Draw(int x, int y) {
        Yulib.m_g.setClip(0, 0, 240, 320);
        if (this.m_bCharic && this.m_pAniCharic.GetCurrentFrmIdx() < 2) {
            this.m_pAniCharic.Draw(x + this.m_ptAniCharic.x, y + this.m_ptAniCharic.y);
        }
        STCookie lpCookie = null;
        lpCookie = this.m_listCookieList.GetHeadData(lpCookie);
        while (lpCookie != null) {
            switch (lpCookie.eState) {
                case 0: {
                    this.DrawCreate(x, y, lpCookie);
                    break;
                }
                case 1: {
                    this.DrawIdle(x, y, lpCookie);
                    break;
                }
                case 2: {
                    this.DrawDisappear(x, y, lpCookie);
                    break;
                }
                case 3: {
                    this.DrawEat(x, y, lpCookie);
                }
            }
            lpCookie = this.m_listCookieList.GetNextData(lpCookie);
        }
        if (this.m_bCharic && this.m_pAniCharic.GetCurrentFrmIdx() >= 2) {
            this.m_pAniCharic.Draw(x + this.m_ptAniCharic.x, y + this.m_ptAniCharic.y);
        }
        return 0;
    }

    void CreateCookie() {
        CSWLPoint ptPos = new CSWLPoint();
        ptPos.x = Yulib.RAND(20, 200);
        ptPos.y = Yulib.RAND(20, 220);
        this.CreateCookie(ptPos);
    }

    void CreateCookie(CSWLPoint ptPos) {
        STCookie pCookie = new STCookie();
        pCookie.ptPos.x = ptPos.x;
        pCookie.ptPos.y = ptPos.y;
        pCookie.qwCreateTime = System.currentTimeMillis();
        int nType = Yulib.RAND(1, 100);
        int nRate = 0;
        for (int i = 0; i < 4; ++i) {
            if (nType > (nRate += this.m_cCreateCashRate[i])) continue;
            pCookie.cType = i;
            break;
        }
        this.m_listCookieList.Add(pCookie);
    }

    void CreateCookie(CSWLPoint ptPos, int eType) {
        STCookie pCookie = new STCookie();
        pCookie.ptPos.x = ptPos.x;
        pCookie.ptPos.y = ptPos.y;
        pCookie.qwCreateTime = System.currentTimeMillis();
        pCookie.cType = eType;
        pCookie.eState = 3;
        pCookie.cTick = 0;
        switch (pCookie.cType) {
            case 0: {
                this.m_nCookie += 3;
                if (!this.m_bCharic) break;
                this.m_nCookie += 3;
                break;
            }
            case 1: {
                this.m_nCookie += 2;
                if (!this.m_bCharic) break;
                this.m_nCookie += 2;
                break;
            }
            case 2: {
                ++this.m_nCookie;
                if (!this.m_bCharic) break;
                ++this.m_nCookie;
            }
        }
        CDPSaveGame.SetEatCookie(this.m_nCookie);
        if (CDPSaveData.GetFirstEatCookie()) {
            this.m_lpGameView.ShowCookieExplain();
        }
        this.m_ptAniCharic = pCookie.ptPos;
        this.m_ptAniCharic.Offset(-10, -54);
        this.m_pAniCharic.Play(false);
        this.m_listCookieList.Add(pCookie);
    }

    void StartRound() {
        this.m_bShow = true;
        this.m_qwNextCreateTick += System.currentTimeMillis() - this.m_qwRoundEndTime;
        this.m_lpPointer.Show(true);
    }

    void EndRound() {
        this.m_qwRoundEndTime = System.currentTimeMillis();
        this.ClearCookie();
        this.m_bShow = false;
    }

    void CheckEat(STCookie lpCookie) {
        if (!this.m_lpGameView.IsTouchDrag() && !this.m_lpPointer.IsMove()) {
            return;
        }
        if (lpCookie.eState != 3 && !this.m_lpPointer.IsAround()) {
            CSWLPoint ptPos = new CSWLPoint();
            ptPos = this.m_lpPointer.GetPos(ptPos);
            CSWLRect rtCookie = new CSWLRect();
            rtCookie.left = lpCookie.ptPos.x + 0;
            rtCookie.top = lpCookie.ptPos.y + 50;
            rtCookie.right = rtCookie.left + this.m_pImgCashNormal.getWidth();
            rtCookie.bottom = rtCookie.top + this.m_pImgCashNormal.getHeight();
            if (MainCanvas.IsOverlapLine(this.m_ptPrevPos, ptPos, rtCookie)) {
                if (this.m_ptPrevPos.x > ptPos.x) {
                    lpCookie.ptPos.x -= this.m_lpPointer.GetSpeed() / 2000;
                } else if (this.m_ptPrevPos.x < ptPos.x) {
                    lpCookie.ptPos.x += this.m_lpPointer.GetSpeed() / 2000;
                }
                if (this.m_ptPrevPos.y > ptPos.y) {
                    lpCookie.ptPos.y -= this.m_lpPointer.GetSpeed() / 2000;
                } else if (this.m_ptPrevPos.y < ptPos.y) {
                    lpCookie.ptPos.y += this.m_lpPointer.GetSpeed() / 2000;
                }
                switch (lpCookie.cType) {
                    case 0: {
                        this.m_nCookie += 3;
                        if (!this.m_bCharic) break;
                        this.m_nCookie += 3;
                        break;
                    }
                    case 1: {
                        this.m_nCookie += 2;
                        if (!this.m_bCharic) break;
                        this.m_nCookie += 2;
                        break;
                    }
                    case 2: {
                        ++this.m_nCookie;
                        if (!this.m_bCharic) break;
                        ++this.m_nCookie;
                        break;
                    }
                    case 3: {
                        this.m_lpPointer.Stop(1600);
                        this.m_lpPointer.Show(false);
                        ++this.m_nEatSulkCash;
                    }
                }
                CDPSaveGame.SetEatCookie(this.m_nCookie);
                if (CDPSaveData.GetFirstEatCookie()) {
                    this.m_lpGameView.ShowCookieExplain();
                }
                lpCookie.cTick = 0;
                lpCookie.eState = 3;
                if (lpCookie.cType != 3) {
                    this.m_ptAniCharic = lpCookie.ptPos;
                    this.m_ptAniCharic.Offset(-10, -54);
                    this.m_pAniCharic.Play(false);
                    this.m_lpPointer.SetSpeedZero();
                }
            }
        }
    }

    void Create(STCookie lpCookie) {
        if (lpCookie.cTick > 180) {
            lpCookie.cTick = 0;
            lpCookie.eState = 1;
            this.ClearCookie();
        }
    }

    void Idle(STCookie lpCookie) {
        long qwCurTick = System.currentTimeMillis();
        if (qwCurTick - lpCookie.qwCreateTime > (long)(this.m_wCashLifeTime[lpCookie.cType] * 100)) {
            lpCookie.cTick = 0;
            lpCookie.eState = 2;
            return;
        }
        lpCookie.cTick = lpCookie.cType == 0 ? (lpCookie.cTick %= 22) : (lpCookie.cTick %= 26);
    }

    void Disappear(STCookie lpCookie) {
        if (lpCookie.cTick > 8) {
            lpCookie = null;
        }
    }

    void Eat(STCookie lpCookie) {
        if (lpCookie.cType != 3 && lpCookie.cTick > 7) {
            lpCookie = null;
        } else if (lpCookie.cType == 3 && lpCookie.cTick > 8) {
            lpCookie = null;
            this.m_lpPointer.Show(true);
        }
    }

    void DrawCreate(int x, int y, STCookie lpCookie) {
        Yulib.Draw(this.m_pImgCashNormal, x + lpCookie.ptPos.x, y + lpCookie.ptPos.y);
    }

    void DrawIdle(int x, int y, STCookie lpCookie) {
        Image pImgCash = null;
        switch (lpCookie.cType) {
            case 0: {
                if (lpCookie.cTick == 10 || lpCookie.cTick == 11) {
                    pImgCash = this.m_pImgCashWink;
                    break;
                }
                pImgCash = this.m_pImgCashNormal;
                break;
            }
            case 1: {
                if (lpCookie.cTick < 10) {
                    pImgCash = this.m_pImgCashNormal;
                    break;
                }
                pImgCash = this.m_pImgCashKiss[lpCookie.cTick / 2 % 2];
                break;
            }
            case 2: {
                if (lpCookie.cTick < 10) {
                    pImgCash = this.m_pImgCashNormal;
                    break;
                }
                pImgCash = this.m_pImgCashHi[lpCookie.cTick / 2 % 2];
                break;
            }
            case 3: {
                pImgCash = lpCookie.cTick < 10 ? this.m_pImgCashNormal : this.m_pImgCashSulk[lpCookie.cTick / 2 % 2];
            }
        }
        Yulib.Draw(pImgCash, x + lpCookie.ptPos.x, y + lpCookie.ptPos.y);
    }

    void DrawDisappear(int x, int y, STCookie lpCookie) {
        Yulib.Draw(this.m_pImgCashNormal, x + lpCookie.ptPos.x, y + lpCookie.ptPos.y);
    }

    void DrawEat(int x, int y, STCookie lpCookie) {
        int nCash = 0;
        Image pImgCash = null;
        int nTick = lpCookie.cTick / 2;
        switch (lpCookie.cType) {
            case 0: {
                nCash = 3;
                pImgCash = this.m_pImgCashWink;
                break;
            }
            case 1: {
                nCash = 2;
                pImgCash = this.m_pImgCashKiss[nTick % 2];
                break;
            }
            case 2: {
                nCash = 1;
                pImgCash = this.m_pImgCashHi[nTick % 2];
                break;
            }
            case 3: {
                pImgCash = this.m_pImgCashSulk[nTick % 2];
            }
        }
        if (lpCookie.cType != 3) {
            if (this.m_bCharic) {
                if (lpCookie.cTick >= 4) {
                    int nDiffX = SWLDefine.MIN((lpCookie.cTick - 4) * 7, 20);
                    Yulib.Draw(this.m_pImgPlus, x + lpCookie.ptPos.x + nDiffX, y + lpCookie.ptPos.y - -28 - (lpCookie.cTick - 4) * 3);
                    MainCanvas.DrawImgNumber(x + lpCookie.ptPos.x + nDiffX + this.m_pImgPlus.getWidth(), y + lpCookie.ptPos.y - -25 - (lpCookie.cTick - 4) * 3, this.m_pImgNumber, nCash, 1, 0);
                    Yulib.Draw(pImgCash, x + lpCookie.ptPos.x + nDiffX, y + lpCookie.ptPos.y);
                    Yulib.Draw(this.m_pImgPlus, x + lpCookie.ptPos.x - nDiffX, y + lpCookie.ptPos.y - -28 - (lpCookie.cTick - 4) * 3);
                    MainCanvas.DrawImgNumber(x + lpCookie.ptPos.x - nDiffX + this.m_pImgPlus.getWidth(), y + lpCookie.ptPos.y - -25 - (lpCookie.cTick - 4) * 3, this.m_pImgNumber, nCash, 1, 0);
                }
                if (lpCookie.cTick < 6) {
                    Yulib.Draw(this.m_pImgCashNormal, x + lpCookie.ptPos.x, y + lpCookie.ptPos.y);
                }
            } else if (lpCookie.cTick < 16) {
                Yulib.Draw(this.m_pImgPlus, x + lpCookie.ptPos.x, y + lpCookie.ptPos.y - -28 - lpCookie.cTick / 2 * 3);
                MainCanvas.DrawImgNumber(x + lpCookie.ptPos.x + this.m_pImgPlus.getWidth(), y + lpCookie.ptPos.y - -25 - lpCookie.cTick / 2 * 3, this.m_pImgNumber, nCash, 1, 0);
            }
        } else if (nTick < 2) {
            Yulib.Draw(pImgCash, x + lpCookie.ptPos.x, y + lpCookie.ptPos.y);
            if ((nTick *= 2) % 2 == 0) {
                Yulib.Draw(this.m_pImgCashSulkEffect[1], x + lpCookie.ptPos.x + 32, y + lpCookie.ptPos.y - 21);
            } else {
                Yulib.Draw(this.m_pImgCashSulkEffect[0], x + lpCookie.ptPos.x + 33, y + lpCookie.ptPos.y - 14);
            }
            CSWLPoint ptPointer = new CSWLPoint();
            ptPointer = this.m_lpPointer.GetPos(ptPointer);
            this.m_pAniPointer.Draw(ptPointer.x, ptPointer.y);
            switch (nTick) {
                case 0: {
                    Yulib.Draw(this.m_pImgCursorEffect[0], ptPointer.x - 6, ptPointer.y - 3);
                    break;
                }
                case 1: {
                    Yulib.Draw(this.m_pImgCashMissEffect[0], x + lpCookie.ptPos.x - 9, y + lpCookie.ptPos.y + 3);
                    Yulib.Draw(this.m_pImgCursorEffect[1], ptPointer.x - 4, ptPointer.y);
                    break;
                }
                case 2: {
                    Yulib.Draw(this.m_pImgCashMissEffect[1], x + lpCookie.ptPos.x - 9, y + lpCookie.ptPos.y + 3);
                    Yulib.Draw(this.m_pImgCursorEffect[2], ptPointer.x - 3, ptPointer.y - 2);
                    break;
                }
                case 3: {
                    Yulib.Draw(this.m_pImgCashMissEffect[2], x + lpCookie.ptPos.x - 9, y + lpCookie.ptPos.y + 3);
                    Yulib.Draw(this.m_pImgCursorEffect[1], ptPointer.x, ptPointer.y);
                    break;
                }
                default: {
                    Yulib.Draw(this.m_pImgCashMissEffect[nTick % 3], x + lpCookie.ptPos.x, y + lpCookie.ptPos.y);
                    Yulib.Draw(this.m_pImgCursorEffect[nTick % 2 + 1], ptPointer.x, ptPointer.y);
                }
            }
        }
    }
}

