/*
 * Decompiled with CFR 0.152.
 */
package se.krka.kahlua.stdlib;

import se.krka.kahlua.stdlib.BaseLib;
import se.krka.kahlua.vm.JavaFunction;
import se.krka.kahlua.vm.LuaCallFrame;
import se.krka.kahlua.vm.LuaState;
import se.krka.kahlua.vm.LuaTable;
import se.krka.kahlua.vm.LuaTableImpl;

public final class TableLib
implements JavaFunction {
    private static final int CONCAT = 0;
    private static final int INSERT = 1;
    private static final int REMOVE = 2;
    private static final int MAXN = 3;
    private static final int NUM_FUNCTIONS = 4;
    private static final String[] names = new String[4];
    private static TableLib[] functions;
    private int index;

    public TableLib(int index) {
        this.index = index;
    }

    public static void register(LuaState state) {
        TableLib.initFunctions();
        LuaTableImpl table = new LuaTableImpl();
        state.getEnvironment().rawset("table", (Object)table);
        for (int i2 = 0; i2 < 4; ++i2) {
            table.rawset(names[i2], (Object)functions[i2]);
        }
    }

    private static synchronized void initFunctions() {
        if (functions == null) {
            functions = new TableLib[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                TableLib.functions[i2] = new TableLib(i2);
            }
        }
    }

    public String toString() {
        return "table." + names[this.index];
    }

    public int call(LuaCallFrame callFrame, int nArguments) {
        switch (this.index) {
            case 0: {
                return TableLib.concat(callFrame, nArguments);
            }
            case 1: {
                return TableLib.insert(callFrame, nArguments);
            }
            case 2: {
                return TableLib.remove(callFrame, nArguments);
            }
            case 3: {
                return TableLib.maxn(callFrame, nArguments);
            }
        }
        return 0;
    }

    private static int concat(LuaCallFrame callFrame, int nArguments) {
        int last;
        BaseLib.luaAssert(nArguments >= 1, "expected table, got no arguments");
        LuaTable table = (LuaTable)callFrame.get(0);
        String separator = "";
        if (nArguments >= 2) {
            separator = BaseLib.rawTostring(callFrame.get(1));
        }
        int first = 1;
        if (nArguments >= 3) {
            Integer firstInteger = BaseLib.rawTonumber(callFrame.get(2));
            first = firstInteger;
        }
        if (nArguments >= 4) {
            Integer lastInteger = BaseLib.rawTonumber(callFrame.get(3));
            last = lastInteger;
        } else {
            last = table.len();
        }
        StringBuffer buffer = new StringBuffer();
        for (int i2 = first; i2 <= last; ++i2) {
            if (i2 > first) {
                buffer.append(separator);
            }
            Integer key = LuaState.toInt(i2);
            Object value = table.rawget(key);
            buffer.append(BaseLib.rawTostring(value));
        }
        return callFrame.push(buffer.toString());
    }

    public static void insert(LuaState state, LuaTable table, Object element) {
        TableLib.append(state, table, element);
    }

    public static void append(LuaState state, LuaTable table, Object element) {
        int position = 1 + table.len();
        state.tableSet(table, LuaState.toInt(position), element);
    }

    public static void rawappend(LuaTable table, Object element) {
        int position = 1 + table.len();
        table.rawset(LuaState.toInt(position), element);
    }

    public static void insert(LuaState state, LuaTable table, int position, Object element) {
        int len;
        for (int i2 = len = table.len(); i2 >= position; --i2) {
            state.tableSet(table, LuaState.toInt(i2 + 1), state.tableGet(table, LuaState.toInt(i2)));
        }
        state.tableSet(table, LuaState.toInt(position), element);
    }

    public static void rawinsert(LuaTable table, int position, Object element) {
        int len = table.len();
        if (position <= len) {
            Integer dest = LuaState.toInt(len + 1);
            for (int i2 = len; i2 >= position; --i2) {
                Integer src = LuaState.toInt(i2);
                table.rawset(dest, table.rawget(src));
                dest = src;
            }
            table.rawset(dest, element);
        } else {
            table.rawset(LuaState.toInt(position), element);
        }
    }

    private static int insert(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 2, "Not enough arguments");
        LuaTable t = (LuaTable)callFrame.get(0);
        int pos = t.len() + 1;
        Object elem = null;
        if (nArguments > 2) {
            pos = BaseLib.rawTonumber(callFrame.get(1));
            elem = callFrame.get(2);
        } else {
            elem = callFrame.get(1);
        }
        TableLib.insert(callFrame.thread.state, t, pos, elem);
        return 0;
    }

    public static Object remove(LuaState state, LuaTable table) {
        return TableLib.remove(state, table, table.len());
    }

    public static Object remove(LuaState state, LuaTable table, int position) {
        Object ret = state.tableGet(table, LuaState.toInt(position));
        int len = table.len();
        for (int i2 = position; i2 < len; ++i2) {
            state.tableSet(table, LuaState.toInt(i2), state.tableGet(table, LuaState.toInt(i2 + 1)));
        }
        state.tableSet(table, LuaState.toInt(len), null);
        return ret;
    }

    private static int remove(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 1, "expected table, got no arguments");
        LuaTable t = (LuaTable)callFrame.get(0);
        int pos = t.len();
        if (nArguments > 1) {
            pos = BaseLib.rawTonumber(callFrame.get(1));
        }
        callFrame.push(TableLib.remove(callFrame.thread.state, t, pos));
        return 1;
    }

    private static int maxn(LuaCallFrame callFrame, int nArguments) {
        BaseLib.luaAssert(nArguments >= 1, "expected table, got no arguments");
        LuaTable t = (LuaTable)callFrame.get(0);
        Object key = null;
        int max = 0;
        while ((key = t.next(key)) != null) {
            int what;
            if (!(key instanceof Integer) || (what = LuaState.fromInt(key)) <= max) continue;
            max = what;
        }
        callFrame.push(LuaState.toInt(max));
        return 1;
    }

    static {
        TableLib.names[0] = "concat";
        TableLib.names[1] = "insert";
        TableLib.names[2] = "remove";
        TableLib.names[3] = "maxn";
    }
}

