/*
 * Decompiled with CFR 0.152.
 */
package se.krka.kahlua.vm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import se.krka.kahlua.vm.LuaClosure;
import se.krka.kahlua.vm.LuaState;
import se.krka.kahlua.vm.LuaTable;

public final class LuaPrototype {
    public int[] code;
    public Object[] constants;
    public LuaPrototype[] prototypes;
    public int numParams;
    public boolean isVararg;
    public String name;
    public int[] lines;
    public int numUpvalues;
    public int maxStacksize;
    public static final Boolean bTRUE = new Boolean(true);
    public static final Boolean bFALSE = new Boolean(false);

    public LuaPrototype() {
    }

    public LuaPrototype(DataInputStream in, boolean littleEndian, String parentName, int size_t) throws IOException {
        int i2;
        this.name = LuaPrototype.readLuaString(in, size_t, littleEndian);
        if (this.name == null) {
            this.name = parentName;
        }
        in.readInt();
        in.readInt();
        this.numUpvalues = in.read();
        this.numParams = in.read();
        int isVararg = in.read();
        this.isVararg = (isVararg & 2) != 0;
        this.maxStacksize = in.read();
        int codeLen = LuaPrototype.toInt(in.readInt(), littleEndian);
        this.code = new int[codeLen];
        for (int i3 = 0; i3 < codeLen; ++i3) {
            int op;
            this.code[i3] = op = LuaPrototype.toInt(in.readInt(), littleEndian);
        }
        int constantsLen = LuaPrototype.toInt(in.readInt(), littleEndian);
        this.constants = new Object[constantsLen];
        for (int i4 = 0; i4 < constantsLen; ++i4) {
            Object o2 = null;
            int type = in.read();
            switch (type) {
                case 0: {
                    break;
                }
                case 1: {
                    int b2 = in.read();
                    o2 = b2 == 0 ? bFALSE : bTRUE;
                    break;
                }
                case 3: {
                    int bits = in.readInt();
                    if (littleEndian) {
                        bits = LuaPrototype.rev(bits);
                    }
                    o2 = LuaState.toInt(bits);
                    break;
                }
                case 4: {
                    o2 = LuaPrototype.readLuaString(in, size_t, littleEndian);
                    break;
                }
                default: {
                    throw new IOException("unknown constant type: " + type);
                }
            }
            this.constants[i4] = o2;
        }
        int prototypesLen = LuaPrototype.toInt(in.readInt(), littleEndian);
        this.prototypes = new LuaPrototype[prototypesLen];
        for (i2 = 0; i2 < prototypesLen; ++i2) {
            this.prototypes[i2] = new LuaPrototype(in, littleEndian, this.name, size_t);
        }
        int tmp = LuaPrototype.toInt(in.readInt(), littleEndian);
        this.lines = new int[tmp];
        for (i2 = 0; i2 < tmp; ++i2) {
            int tmp2;
            this.lines[i2] = tmp2 = LuaPrototype.toInt(in.readInt(), littleEndian);
        }
        tmp = LuaPrototype.toInt(in.readInt(), littleEndian);
        for (i2 = 0; i2 < tmp; ++i2) {
            LuaPrototype.readLuaString(in, size_t, littleEndian);
            in.readInt();
            in.readInt();
        }
        tmp = LuaPrototype.toInt(in.readInt(), littleEndian);
        for (i2 = 0; i2 < tmp; ++i2) {
            LuaPrototype.readLuaString(in, size_t, littleEndian);
        }
    }

    public String toString() {
        return this.name;
    }

    private static String readLuaString(DataInputStream in, int size_t, boolean littleEndian) throws IOException {
        long len = 0L;
        if (size_t == 4) {
            int i2 = in.readInt();
            len = LuaPrototype.toInt(i2, littleEndian);
        } else if (size_t == 8) {
            len = LuaPrototype.toLong(in.readLong(), littleEndian);
        } else {
            LuaPrototype.loadAssert(false, "Bad string size");
        }
        if (len == 0L) {
            return null;
        }
        LuaPrototype.loadAssert(--len < 65536L, "Too long string:" + len);
        int iLen = (int)len;
        byte[] stringData = new byte[3 + iLen];
        stringData[0] = (byte)(iLen >> 8 & 0xFF);
        stringData[1] = (byte)(iLen & 0xFF);
        int bytesRead = in.read(stringData, 2, iLen + 1);
        LuaPrototype.loadAssert(bytesRead == iLen + 1, "String loading 1");
        LuaPrototype.loadAssert(stringData[2 + iLen] == 0, "String loading 2");
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(stringData));
        String s2 = dis.readUTF();
        dis.close();
        return s2;
    }

    public static int rev(int v) {
        int a2 = v >>> 24 & 0xFF;
        int b2 = v >>> 16 & 0xFF;
        int c2 = v >>> 8 & 0xFF;
        int d2 = v & 0xFF;
        return d2 << 24 | c2 << 16 | b2 << 8 | a2;
    }

    public static long rev(long v) {
        long a2 = v >>> 56 & 0xFFL;
        long b2 = v >>> 48 & 0xFFL;
        long c2 = v >>> 40 & 0xFFL;
        long d2 = v >>> 32 & 0xFFL;
        long e2 = v >>> 24 & 0xFFL;
        long f2 = v >>> 16 & 0xFFL;
        long g2 = v >>> 8 & 0xFFL;
        long h2 = v & 0xFFL;
        return h2 << 56 | g2 << 48 | f2 << 40 | e2 << 32 | d2 << 24 | c2 << 16 | b2 << 8 | a2;
    }

    public static int toInt(int bits, boolean littleEndian) {
        return littleEndian ? LuaPrototype.rev(bits) : bits;
    }

    public static long toLong(long bits, boolean littleEndian) {
        return littleEndian ? LuaPrototype.rev(bits) : bits;
    }

    public static LuaClosure loadByteCode(DataInputStream in, LuaTable env) throws IOException {
        int tmp = in.read();
        LuaPrototype.loadAssert(tmp == 27, "Signature 1");
        tmp = in.read();
        LuaPrototype.loadAssert(tmp == 76, "Signature 2");
        tmp = in.read();
        LuaPrototype.loadAssert(tmp == 117, "Signature 3");
        tmp = in.read();
        LuaPrototype.loadAssert(tmp == 97, "Signature 4");
        tmp = in.read();
        LuaPrototype.loadAssert(tmp == 81, "Version");
        tmp = in.read();
        LuaPrototype.loadAssert(tmp == 0, "Format");
        boolean littleEndian = in.read() == 1;
        tmp = in.read();
        LuaPrototype.loadAssert(tmp == 4, "Size int");
        int size_t = in.read();
        LuaPrototype.loadAssert(size_t == 4 || size_t == 8, "Size t");
        tmp = in.read();
        LuaPrototype.loadAssert(tmp == 4, "Size instr");
        tmp = in.read();
        LuaPrototype.loadAssert(tmp == 4, "Size number");
        tmp = in.read();
        LuaPrototype.loadAssert(tmp == 1, "Integral");
        LuaPrototype mainPrototype = new LuaPrototype(in, littleEndian, null, size_t);
        LuaClosure closure = new LuaClosure(mainPrototype, env);
        return closure;
    }

    private static void loadAssert(boolean c2, String message) throws IOException {
        if (!c2) {
            throw new IOException("Could not load bytecode:" + message);
        }
    }

    public static LuaClosure loadByteCode(InputStream in, LuaTable env) throws IOException {
        if (!(in instanceof DataInputStream)) {
            in = new DataInputStream(in);
        }
        return LuaPrototype.loadByteCode((DataInputStream)in, env);
    }

    public void dump(OutputStream os) throws IOException {
        DataOutputStream dos = os instanceof DataOutputStream ? (DataOutputStream)os : new DataOutputStream(os);
        dos.write(27);
        dos.write(76);
        dos.write(117);
        dos.write(97);
        dos.write(81);
        dos.write(0);
        dos.write(0);
        dos.write(4);
        dos.write(4);
        dos.write(4);
        dos.write(8);
        dos.write(0);
        this.dumpPrototype(dos);
    }

    private void dumpPrototype(DataOutputStream dos) throws IOException {
        LuaPrototype.dumpString(this.name, dos);
        dos.writeInt(0);
        dos.writeInt(0);
        dos.write(this.numUpvalues);
        dos.write(this.numParams);
        dos.write(this.isVararg ? 2 : 0);
        dos.write(this.maxStacksize);
        int codeLen = this.code.length;
        dos.writeInt(codeLen);
        for (int i2 = 0; i2 < codeLen; ++i2) {
            dos.writeInt(this.code[i2]);
        }
        int constantsLen = this.constants.length;
        dos.writeInt(constantsLen);
        for (int i3 = 0; i3 < constantsLen; ++i3) {
            Object o2 = this.constants[i3];
            if (o2 == null) {
                dos.write(0);
                continue;
            }
            if (o2 instanceof Boolean) {
                dos.write(1);
                dos.write((Boolean)o2 != false ? 1 : 0);
                continue;
            }
            if (o2 instanceof Integer) {
                dos.write(3);
                Integer d2 = (Integer)o2;
                dos.writeInt(d2);
                continue;
            }
            if (o2 instanceof String) {
                dos.write(4);
                LuaPrototype.dumpString((String)o2, dos);
                continue;
            }
            throw new RuntimeException("Bad type in constant pool");
        }
        int prototypesLen = this.prototypes.length;
        dos.writeInt(prototypesLen);
        for (int i4 = 0; i4 < prototypesLen; ++i4) {
            this.prototypes[i4].dumpPrototype(dos);
        }
        int linesLen = this.lines.length;
        dos.writeInt(linesLen);
        for (int i5 = 0; i5 < linesLen; ++i5) {
            dos.writeInt(this.lines[i5]);
        }
        dos.writeInt(0);
        dos.writeInt(0);
    }

    private static void dumpString(String name, DataOutputStream dos) throws IOException {
        if (name == null) {
            dos.writeShort(0);
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new DataOutputStream(baos).writeUTF(name);
        byte[] bytes = baos.toByteArray();
        int numBytes = bytes.length - 2;
        dos.writeInt(numBytes + 1);
        dos.write(bytes, 2, numBytes);
        dos.write(0);
    }
}

