/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Debug {
    GameEngine engine;
    GameMap m;
    private int dTime;
    private static final byte D_MENU = 0;
    private static final byte D_SCRIPT = 1;
    private static final byte D_MAP = 2;
    private static final byte D_SPRTIE = 3;
    private static final byte D_MORE = 4;
    private static final byte D_SPRTIEPROPERTY = 5;
    private static final byte D_SYSTEMINFO = 6;
    private static final byte D_RANK = 7;
    private static final byte D_MAPINFO = 8;
    private static final byte D_SETSPRTIE = 9;
    private int strHeight = MyGameCanvas.FONT_SMALL.getHeight();
    private static final String version = "[#] 1.0";
    private int index;
    private int debugST;
    public static boolean isDebug;
    private String[] debugMenu = new String[]{"\u811a\u672c\u4e8b\u4ef6", "\u8bbe\u7f6e\u5173\u5361", "\u5730\u56fe\u5c5e\u6027", "\u7cbe\u7075\u5c5e\u6027", "\u7cfb\u7edf\u4fe1\u606f", "\u5e38\u7528\u529f\u80fd", "\u589e\u52a0\u91d1\u94b1", "\u589e\u52a0\u7ecf\u9a8c"};
    private int[] rank = new int[]{0, 0, 0};
    int lastX;
    int lastY;
    boolean b1 = true;
    boolean b2 = true;
    boolean b3 = true;
    int px;
    int py;
    private int rowNumber = 15;
    private boolean pressedUp;
    private boolean pressedDown;
    private boolean pressedLeft;
    private boolean pressedRight;
    byte spriteIndex;
    static String[] moreMenu;
    String[] moreInfo = new String[]{"\u6253\u5370\u5185\u5b58\u4f7f\u7528\u60c5\u51b5\u548c\u7ed8\u56fe\u6b21\u6570", "\u5728\u6bcf\u4e2a\u7cbe\u7075\u8eab\u4e0a\u6807\u8bb0\u51fa\u7cbe\u7075\u7684ID", "\u53ef\u4ee5\u63091\uff0c3\u952e\u6539\u53d8\u6e38\u620f\u901f\u5ea6", "\u663e\u793a\u5730\u56fe\u7f51\u683c", "\u5173\u95ed/\u5f00\u542f\u5730\u56fe\u4e0a\u7684\u660e\u96f7"};
    static boolean[] more;
    private short[] sleepTime = new short[]{30, 60, 90, 120, 300, 500, 1000};
    private byte sleepIndex = 1;
    int delay = 8;
    Image mapBuff;
    int buffWidth;
    int buffHeight;
    boolean isBuffNull;
    int lastStartX;
    int lastStartY;
    int lastEndX;
    int lastEndY;

    public Debug(GameEngine en) {
        this.engine = en;
        this.m = GameEngine.map;
    }

    private void drawDebugMenu(int x, int y, int drawLevel) {
        this.drawColorScreenBG(0, drawLevel);
        String[] info = new String[]{"\u67e5\u770b\u3001\u8bbe\u7f6e\u3001\u811a\u672c\u4e8b\u4ef6", "\u8bbe\u7f6e\u5f00\u59cb\u6e38\u620f\u7684\u5173\u5361\uff0c\u8df3\u5173", "\u67e5\u770b\u5730\u56fe\u5c5e\u6027\uff0c\u88c5\u9970\uff0c\u5207\u7247\u5c5e\u6027\u7b49", "\u67e5\u770b\u3001\u8bbe\u7f6e\u7cbe\u7075\u5c5e\u6027", "\u67e5\u770b\u5e38\u89c1\u7684\u7cfb\u7edf\u53d8\u91cf\u503c", "\u5e38\u7528\u529f\u80fd\u5408\u96c6", "\u6bcf\u6b21\u70b9\u51fb\u589e\u52a0\u4e00\u4e07\u91d1\u94b1", "\u6bcf\u6b21\u70b9\u51fb\u589e\u52a0\u4e00\u4e07\u7ecf\u9a8c"};
        int dis = this.strHeight + 2;
        int i = 0;
        while (i < this.debugMenu.length) {
            int color = i == 3 && !this.spriteIsInit() ? 0x999999 : (i != this.index ? 0xFFFFFF : 0xFFFF33);
            Tools.addString((byte)4, this.debugMenu[i], x + 20, y + 30 + i * dis, 36, color, drawLevel);
            ++i;
        }
        Tools.addString((byte)4, info[this.index], x + 20, y + 360 - 80, 36, 16775337, drawLevel);
        Tools.addRect((byte)1, x + 18, y + 32 + this.index * dis, this.strHeight * this.debugMenu[this.index].length(), 1, true, 36, 0xFFFFFF, drawLevel);
        this.drawYesNo("\u786e\u5b9a", "\u9000\u51fa", drawLevel);
    }

    private boolean spriteIsInit() {
        return GameEngine.sprite != null;
    }

    private void drawSetGameRank(int x, int y, int drawLevel) {
        this.drawColorScreenBG(0, drawLevel);
        String[] setGameRank = new String[]{"\u8bf7\u9009\u62e9\u521d\u59cb\u5316\u5173\u5361"};
        int i = 0;
        while (i < setGameRank.length) {
            Tools.addString((byte)4, setGameRank[i], x + 180, y + 30 + i * 15, 33, 16775337, drawLevel);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.rank.length) {
            Tools.addString((byte)4, this.rank[i2] + "", x + 90 + i2 * 20, y + 100, 36, 0xFFFFFF, drawLevel);
            ++i2;
        }
        Tools.addString((byte)4, "*", x + 90 + this.index * 20, y + 80 + (this.dTime % 2 == 0 ? -1 : 0), 36, 0xFFFFFF, drawLevel);
        Tools.addString((byte)4, "*", x + 90 + this.index * 20, y + 105 + (this.dTime % 2 == 0 ? 1 : 0), 20, 0xFFFFFF, drawLevel);
        this.drawYesNo(MyGameCanvas.gameStatus > 0 ? "\u8df3\u81f3\u6b64\u5173" : "", "\u66f4\u6539", drawLevel);
    }

    private int getRank(int[] dat) {
        int rank = 0;
        int i = 0;
        while (i < dat.length) {
            rank += dat[i] * Debug.square(10, dat.length - 1 - i);
            ++i;
        }
        return rank;
    }

    static int square(int base, int exponent) {
        int pro = 1;
        int i = 0;
        while (i < exponent) {
            pro *= base;
            ++i;
        }
        return pro;
    }

    private void drawMapProperty(int x, int y, int drawLevel) {
        String[] stringArray = new String[7];
        stringArray[0] = "\u5730\u56fe\u5e8f\u53f7 \uff1a " + GameMap.mapID;
        stringArray[1] = "\u5730\u56fe\u540d\u79f0 \uff1a " + this.m.mapName;
        stringArray[2] = "\u5730\u56fe\u6587\u4ef6 \uff1a " + (GameEngine.map.fileName == null ? "null" : this.m.fileName + "a.dat");
        stringArray[3] = "\u80cc\u666f\u97f3\u4e50 \uff1a " + this.m.music;
        stringArray[4] = "\u6218\u6597\u80cc\u666f \uff1a " + this.m.battleBg;
        stringArray[5] = "\u654c\u4eba\u7b49\u7ea7 \uff1a " + this.m.enemyLevel;
        stringArray[6] = "\u654c\u4eba\u7c7b\u578b \uff1a " + this.toString(this.m.enemys);
        String[] mapProperty = stringArray;
        this.drawColorScreenBG(0, drawLevel);
        int i = 0;
        while (i < mapProperty.length) {
            Tools.addString((byte)4, mapProperty[i], x + 20, y + 30 + i * 15, 36, 0xFFFFFF, drawLevel);
            ++i;
        }
        this.drawYesNo(GameMap.mapData[0] == null ? "" : "\u5168\u5c40\u5730\u56fe", "\u8fd4\u56de", drawLevel);
    }

    private String toString(byte[] dat) {
        String str = null;
        if (dat != null) {
            str = new String("");
            int i = 0;
            while (i < dat.length) {
                str = str + dat[i] + ",";
                ++i;
            }
        }
        return str;
    }

    private void initMap() {
        this.initMapBuff();
        this.lastX = GameMap.setOffX;
        this.lastY = GameMap.setOffY;
        GameMap.setOffX = 0;
        GameMap.setOffY = 0;
        this.px = 0;
        this.py = 0;
    }

    private void drawMapInfoUI(int drawLevel) {
        Tools.addColorString((byte)4, "\u5750\u6807 (" + this.px + "," + this.py + ")", GameMap.setOffX + 2, GameMap.setOffY + 2, 20, 0, 15062383, drawLevel);
        Tools.addColorString((byte)4, "\u683c\u5b50 (" + this.px / GameMap.tileWidth + "," + this.py / GameMap.tileHight + ")", GameMap.setOffX + GameMap.screenWidth - 2, GameMap.setOffY + 2, 24, 0, 15062383, drawLevel);
        String[] str = new String[]{"[#] \u88c5\u9970", "[0] \u963b\u6321", "[*] \u7f51\u683c"};
        int i = 0;
        while (i < str.length) {
            Tools.addColorString((byte)4, str[i], GameMap.setOffX + 2, GameMap.setOffY + GameMap.screenHeight - 2 - 15 * i, 36, 0, 15062383, drawLevel);
            ++i;
        }
    }

    private void drawCanNotMove(int drawLevel) {
        int n = GameMap.setOffX / GameMap.tileWidth * GameMap.mapSize[1] + GameMap.setOffY / GameMap.tileHight;
        int nw = GameMap.screenWidth / GameMap.tileWidth + 2;
        int nh = GameMap.screenHeight / GameMap.tileHight + 2;
        int j = 0;
        while (j < nw) {
            int s;
            int i = s = n + j * GameMap.mapSize[1];
            while (i < s + nh) {
                if (i < GameMap.mapData[1].length && i >= 0) {
                    int x = i / GameMap.mapSize[1] * GameMap.tileHight;
                    int y = i % GameMap.mapSize[1] * GameMap.tileWidth;
                    if (!this.m.canRun(x + GameMap.tileWidth / 2, y + GameMap.tileHight / 2)) {
                        Tools.addRect((byte)1, x, y, GameMap.tileWidth, GameMap.tileHight, false, 20, this.dTime % 10 < 5 ? 0xFF0000 : 0xFFFF99, drawLevel);
                    }
                }
                ++i;
            }
            ++j;
        }
    }

    private void drawDecorations() {
    }

    private void drawMapInfo(Graphics g) {
        this.drawMap(g, GameMap.setOffX, GameMap.setOffY);
        this.drawMapInfoUI(9999);
        if (this.b3) {
            this.drawGrid(30);
        }
        if (this.b2) {
            this.drawCanNotMove(30);
        }
        if (this.b1) {
            this.drawDecorations();
        }
        this.drawCursor(9999);
        this.m.AdjustSrceen(this.px, this.py);
        if (this.pressedUp) {
            if (--this.delay <= 0) {
                this.py -= GameMap.tileHight;
            }
            this.py = Math.max(0, this.py);
        }
        if (this.pressedDown) {
            if (--this.delay <= 0) {
                this.py += GameMap.tileHight;
            }
            this.py = Math.min(this.py, (GameMap.mapSize[1] - 1) * GameMap.tileHight);
        }
        if (this.pressedLeft) {
            if (--this.delay <= 0) {
                this.px -= GameMap.tileWidth;
            }
            this.px = Math.max(0, this.px);
        }
        if (this.pressedRight) {
            if (--this.delay <= 0) {
                this.px += GameMap.tileWidth;
            }
            this.px = Math.min(this.px, (GameMap.mapSize[0] - 1) * GameMap.tileWidth);
        }
        this.drawYesNo("", "\u8fd4\u56de", 9999);
    }

    private void drawCursor(int drawLevel) {
        Tools.addARC((byte)2, this.px + 4, this.py + 4, 8, 8, 0, 360, true, 20, this.dTime % 4 < 2 ? 0xFF0000 : 0xFFFF99, drawLevel);
    }

    private void drawScript(int x, int y, int drawLevel) {
        this.drawColorScreenBG(0, drawLevel);
        String[] title = new String[]{"\u4e8b\u4ef6ID", "\u4e8b\u4ef6\u503c"};
        int dis = 15;
        int i = 0;
        while (i < title.length) {
            Tools.addString((byte)4, title[i], x + 90 + i * 360 / 2, y + 30, 33, 15062383, drawLevel);
            ++i;
        }
        int i2 = this.index / this.rowNumber * this.rowNumber;
        while (i2 < Math.min(this.index / this.rowNumber * this.rowNumber + this.rowNumber, Script.scriptVar.length)) {
            Tools.addString((byte)4, "event[" + i2 + "] : ", x + 90, y + 50 + i2 % this.rowNumber * dis, 33, 0xFFFFFF, drawLevel);
            Tools.addString((byte)4, Script.scriptVar[i2] + "", x + 270, y + 50 + i2 % this.rowNumber * dis, 33, Script.scriptVar[i2] == 0 ? 0xFFFFFF : 0x33FF33, drawLevel);
            ++i2;
        }
        Tools.addRect((byte)1, x + 10, y + 58 + this.index % this.rowNumber * dis, 200, 1, true, 36, 0xFFFFFF, drawLevel);
        Tools.addString((byte)4, this.index + " / " + Script.scriptVar.length, x + 180, y + 360 - 10, 33, 0xFFFFFF, drawLevel);
        if (this.index >= this.rowNumber) {
            Tools.addString((byte)4, "<<", x + 90, y + 360 - 10, 33, this.dTime % 3 == 0 ? 0xFFFFFF : 0xFF0000, drawLevel);
        }
        if (this.index <= Script.scriptVar.length / this.rowNumber * this.rowNumber) {
            Tools.addString((byte)4, ">>", x + 270, y + 360 - 10, 33, this.dTime % 3 == 0 ? 0xFFFFFF : 0xFF0000, drawLevel);
        }
        if (this.pressedUp) {
            if (--this.delay <= 0) {
                --this.index;
            }
            this.index = Math.max(0, this.index);
        }
        if (this.pressedDown) {
            if (--this.delay <= 0) {
                ++this.index;
            }
            this.index = Math.min(this.index, Script.scriptVar.length - 1);
        }
        this.drawYesNo("\u4fee\u6539", "\u8fd4\u56de", drawLevel);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawSprite(int x, int y, int drawLevel) {
        if (GameEngine.sprite == null) {
            return;
        }
        this.drawColorScreenBG(0, drawLevel);
        int dis = 15;
        String[] title = new String[]{"\u7cbe\u7075ID", "\u540d\u79f0", "\u53ef\u89c1", "\u6574\u683c"};
        int i = 0;
        while (i < title.length) {
            Tools.addString((byte)4, title[i], x + 50 + i * 50, y + 30, 33, 15062383, drawLevel);
            ++i;
        }
        int i2 = 0;
        while (i2 < GameEngine.sprite.length) {
            Tools.addString((byte)4, i2 + "", x + 50, y + 50 + i2 * dis, 33, 0xFFFFFF, drawLevel);
            Tools.addString((byte)4, GameEngine.sprite[i2].name, x + 100, y + 50 + i2 * dis, 33, 0xFFFFFF, drawLevel);
            Tools.addString((byte)4, GameEngine.sprite[i2].visible + "", x + 150, y + 50 + i2 * dis, 33, 0xFFFFFF, drawLevel);
            Tools.addString((byte)4, this.isFullTile(GameEngine.sprite[i2]) + "", x + 200, y + 50 + i2 * dis, 33, this.isFullTile(GameEngine.sprite[i2]) ? 0xFFFFFF : 0xFF0000, drawLevel);
            ++i2;
        }
        Tools.addString((byte)4, "[0]\u8bbe\u7f6e\u5f53\u524d\u63a7\u5236\u7cbe\u7075", x + 180, y + 360 - this.strHeight / 2 - 2, 33, 0xFFFFFF, drawLevel);
        Tools.addString((byte)4, "*", x + 30, y + 50 + GameEngine.spriteIndex * dis, 33, this.dTime % 2 == 0 ? 0xFFFFFF : 0xFF0000, drawLevel);
        Tools.addRect((byte)1, x + 10, y + 58 + this.index * dis, 220, 1, true, 36, 0xFFFFFF, drawLevel);
        this.drawYesNo("\u67e5\u770b", "\u8fd4\u56de", drawLevel);
    }

    boolean isFullTile(GameSprite s) {
        return s.x % GameMap.tileWidth == 0 && s.y % GameMap.tileHight == 0;
    }

    private void drawSpriteProperty(GameSprite s, int x, int y, int drawLevel) {
        String[] DIR = new String[]{"\u4e0a", "\u53f3", "\u4e0b", "\u5de6"};
        String[] stringArray = new String[8];
        stringArray[0] = "\u5e8f\u53f7 \uff1a " + s.ID;
        stringArray[1] = "\u5750\u6807 \uff1a (" + s.x + " , " + s.y + ")" + "(" + s.x / GameMap.tileWidth + " , " + s.y / GameMap.tileHight + ")";
        stringArray[2] = "\u9762\u5411 \uff1a " + DIR[s.dir];
        stringArray[3] = "\u72b6\u6001 \uff1a " + s.curStates;
        stringArray[4] = "\u6b65\u957f \uff1a " + s.STEP + " \u50cf\u7d20" + (s.STEP >= GameMap.tileWidth ? "\uff08\u503c\u8fc7\u5927\uff09" : "");
        stringArray[5] = "\u884c\u52a8 \uff1a " + s.isMotion;
        stringArray[6] = "\u56fe\u7247 \uff1a s" + s.modle + ".png";
        stringArray[7] = "\u7d22\u5f15 \uff1a " + s.index;
        String[] spriteProperty = stringArray;
        this.drawColorScreenBG(0, drawLevel);
        int i = 0;
        while (i < spriteProperty.length) {
            Tools.addString((byte)4, spriteProperty[i], x + 20, y + 30 + i * 15, 36, 0xFFFFFF, drawLevel);
            ++i;
        }
        this.drawYesNo("\u8bbe\u7f6e", "\u8fd4\u56de", drawLevel);
    }

    private void drawSetSprite(Graphics g) {
        this.drawMap(g, GameMap.setOffX, GameMap.setOffY);
        Tools.addColorString((byte)4, "\u5750\u6807 (" + this.px + "," + this.py + ")", GameMap.setOffX + 2, GameMap.setOffY + 2, 20, 0, 15062383, 9999);
        Tools.addColorString((byte)4, "\u683c\u5b50 (" + this.px / GameMap.tileWidth + "," + this.py / GameMap.tileHight + ")", GameMap.setOffX + GameMap.screenWidth - 2, GameMap.setOffY + 2, 24, 0, 15062383, 9999);
        Tools.addColorString((byte)4, "[0] " + (GameEngine.sprite[this.spriteIndex].visible ? "\u53ef\u89c1" : "\u9690\u85cf"), GameMap.setOffX + GameMap.screenWidth / 2, GameMap.setOffY + GameMap.screenHeight - this.strHeight / 2 - 2, 33, 0, 15062383, 9999);
        this.drawGrid(30);
        this.drawCanNotMove(30);
        this.drawDecorations();
        this.drawCursor(9999);
        this.m.AdjustSrceen(this.px, this.py);
        if (this.pressedUp) {
            if (--this.delay <= 0) {
                this.py -= GameMap.tileHight;
            }
            this.py = Math.max(0, this.py);
        }
        if (this.pressedDown) {
            if (--this.delay <= 0) {
                this.py += GameMap.tileHight;
            }
            this.py = Math.min(this.py, (GameMap.mapSize[1] - 1) * GameMap.tileHight);
        }
        if (this.pressedLeft) {
            if (--this.delay <= 0) {
                this.px -= GameMap.tileWidth;
            }
            this.px = Math.max(0, this.px);
        }
        if (this.pressedRight) {
            if (--this.delay <= 0) {
                this.px += GameMap.tileWidth;
            }
            this.px = Math.min(this.px, (GameMap.mapSize[0] - 1) * GameMap.tileWidth);
        }
        this.drawYesNo("\u786e\u5b9a\u653e\u7f6e", "\u8fd4\u56de", 9999);
    }

    private void drawSystemInfo(int x, int y, int drawLevel) {
        this.drawColorScreenBG(0, drawLevel);
        String[] systemInfo = new String[]{"\u7cfb\u7edf\u6682\u505c\u65f6\u95f4: " + MyGameCanvas.stopTime, "\u73a9\u5bb6\u63a7\u5236\u6743: " + Script.isUserCtrl, "\u63d0\u793a\u4fe1\u606f\u4e2d: " + MyGameCanvas.isInfo, "\u5f53\u524d\u8fd0\u884c\u7684\u4e8b\u4ef6: " + Script.curEvent, "temp : " + Script.temp, "\u7126\u70b9\u7cbe\u7075ID: " + GameEngine.spriteIndex, "\u5176\u4ed61: "};
        int i = 0;
        while (i < systemInfo.length) {
            Tools.addString((byte)4, systemInfo[i], x + 20, y + 30 + i * 15, 36, 0xFFFFFF, drawLevel);
            ++i;
        }
        this.drawYesNo("", "\u8fd4\u56de", drawLevel);
    }

    private void drawMore(int x, int y, int drawLevel) {
        this.drawColorScreenBG(0, drawLevel);
        int dis = 15;
        int i = 0;
        while (i < moreMenu.length) {
            Tools.addString((byte)4, moreMenu[i], x + 80, y + 50 + i * dis, 33, 0xFFFFFF, drawLevel);
            Tools.addString((byte)4, more[i] ? "\u5f00\u542f" : "\u5173\u95ed", x + 160, y + 50 + i * dis, 33, 0xFFFFFF, drawLevel);
            ++i;
        }
        Tools.addRect((byte)1, x + 10, y + 58 + this.index * dis, 220, 1, true, 36, 0xFFFFFF, drawLevel);
        Tools.addString((byte)4, this.moreInfo[this.index], x + 20, y + 240, 36, 16775337, drawLevel);
        this.drawYesNo("\u786e\u5b9a", "\u8fd4\u56de", drawLevel);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void screenPrint(int x, int y, int drawLevel) {
        ++this.dTime;
        Tools.addString((byte)4, version, x + 180, y + 360 - this.strHeight / 2 - 2, 33, 0xFF0000, drawLevel);
        if (more[0]) {
            Tools.addString((byte)4, "\u603b\u5185\u5b58: " + Runtime.getRuntime().totalMemory(), x + 5, y + 10, 20, 0xFF0000, drawLevel);
            Tools.addString((byte)4, "\u5269\u4f59\u5185\u5b58: " + Runtime.getRuntime().freeMemory(), x + 5, y + 30, 20, 0xFF0000, drawLevel);
            Tools.addString((byte)4, "\u7ed8\u56fe\u6b21\u6570: " + MyGameCanvas.drawMax, x + 5, y + 50, 20, 0xFF0000, drawLevel);
        }
        if (more[1]) {
            if (GameEngine.sprite != null && MyGameCanvas.gameStatus == 7) {
                int i = 0;
                while (i < GameEngine.sprite.length) {
                    Tools.addColorString((byte)4, i + "", GameEngine.sprite[i].x + 4, GameEngine.sprite[i].y, 36, 0, this.dTime % 4 < 2 ? 0xFF0000 : 0xFFFF99, drawLevel);
                    ++i;
                }
            }
        }
        if (more[2]) {
            Tools.addString((byte)4, "\u7ebf\u7a0b: " + GameMIDlet.sleepTime, x + 360 - 3, y + 10, 24, 0xFF0000, drawLevel);
        }
        if (more[3] && MyGameCanvas.gameStatus == 7) {
            this.drawGrid(30);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void drawGrid(int drawLevel) {
        int i = 0;
        while (i < GameMap.mapSize[0]) {
            Tools.addRect((byte)1, GameMap.tileWidth * i, 0, GameMap.tileWidth, GameMap.mapSize[1] * GameMap.tileHight, false, 20, 255, drawLevel);
            i += 2;
        }
        int i2 = 0;
        while (i2 < GameMap.mapSize[1]) {
            Tools.addRect((byte)1, 0, GameMap.tileHight * i2, GameMap.mapSize[0] * GameMap.tileWidth, GameMap.tileHight, false, 20, 255, drawLevel);
            i2 += 2;
        }
    }

    public void setGameSleepTime(int keyCode) {
        if (more[2]) {
            if (keyCode == 49) {
                this.sleepIndex = (byte)(this.sleepIndex == 0 ? 0 : this.sleepIndex - 1);
            } else if (keyCode == 51) {
                this.sleepIndex = (byte)(this.sleepIndex == this.sleepTime.length - 1 ? this.sleepTime.length - 1 : this.sleepIndex + 1);
            }
        }
        GameMIDlet.sleepTime = this.sleepTime[this.sleepIndex];
    }

    public void paint(Graphics g, int x, int y, int drawLevel) {
        ++this.dTime;
        switch (this.debugST) {
            case 0: {
                this.drawDebugMenu(x, y, drawLevel);
                break;
            }
            case 1: {
                this.drawScript(x, y, drawLevel);
                break;
            }
            case 2: {
                this.drawMapProperty(x, y, drawLevel);
                break;
            }
            case 3: {
                this.drawSprite(x, y, drawLevel);
                break;
            }
            case 5: {
                this.drawSpriteProperty(GameEngine.sprite[this.spriteIndex], x, y, drawLevel);
                break;
            }
            case 4: {
                this.drawMore(x, y, drawLevel);
                break;
            }
            case 6: {
                this.drawSystemInfo(x, y, drawLevel);
                break;
            }
            case 7: {
                this.drawSetGameRank(x, y, drawLevel);
                break;
            }
            case 8: {
                this.drawMapInfo(g);
                break;
            }
            case 9: {
                this.drawSetSprite(g);
            }
        }
    }

    public void ctrlReleased(int keyCode) {
        block0 : switch (this.debugST) {
            case 1: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.pressedUp = false;
                        this.delay = 8;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.pressedDown = false;
                        this.delay = 8;
                    }
                }
                break;
            }
            case 8: 
            case 9: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.pressedUp = false;
                        this.delay = 8;
                        break block0;
                    }
                    case -2: 
                    case 56: {
                        this.pressedDown = false;
                        this.delay = 8;
                        break block0;
                    }
                    case -3: 
                    case 52: {
                        this.pressedLeft = false;
                        this.delay = 8;
                        break block0;
                    }
                    case -4: 
                    case 54: {
                        this.pressedRight = false;
                        this.delay = 8;
                    }
                }
            }
        }
    }

    public void ctrl(int keyCode) {
        block0 : switch (this.debugST) {
            case 9: {
                switch (keyCode) {
                    case 48: {
                        GameEngine.sprite[this.spriteIndex].visible = !GameEngine.sprite[this.spriteIndex].visible;
                        break;
                    }
                    case -1: 
                    case 50: {
                        this.pressedUp = true;
                        if (this.delay == 0) break;
                        this.py = this.py == 0 ? 0 : this.py - GameMap.tileHight;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.pressedDown = true;
                        if (this.delay == 0) break;
                        this.py = this.py == (GameMap.mapSize[1] - 1) * GameMap.tileHight ? (GameMap.mapSize[1] - 1) * GameMap.tileHight : this.py + GameMap.tileHight;
                        break;
                    }
                    case -3: 
                    case 52: {
                        this.pressedLeft = true;
                        if (this.delay == 0) break;
                        this.px = this.px == 0 ? 0 : this.px - GameMap.tileWidth;
                        break;
                    }
                    case -4: 
                    case 54: {
                        this.pressedRight = true;
                        if (this.delay == 0) break;
                        this.px = this.px == (GameMap.mapSize[0] - 1) * GameMap.tileWidth ? (GameMap.mapSize[0] - 1) * GameMap.tileWidth : this.px + GameMap.tileWidth;
                        break;
                    }
                    case -7: {
                        this.setDebugST((byte)3);
                        GameMap.setOff(this.lastX, this.lastY);
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        GameEngine.sprite[this.spriteIndex].x = this.px;
                        GameEngine.sprite[this.spriteIndex].y = this.py + GameMap.tileHight;
                        GameEngine.sprite[this.spriteIndex].setAXY();
                        this.setDebugST((byte)3);
                        GameMap.setOff(this.lastX, this.lastY);
                    }
                }
                break;
            }
            case 8: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.pressedUp = true;
                        if (this.delay == 0) break;
                        this.py = this.py == 0 ? 0 : this.py - GameMap.tileHight;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.pressedDown = true;
                        if (this.delay == 0) break;
                        this.py = this.py == (GameMap.mapSize[1] - 1) * GameMap.tileHight ? (GameMap.mapSize[1] - 1) * GameMap.tileHight : this.py + GameMap.tileHight;
                        break;
                    }
                    case -3: 
                    case 52: {
                        this.pressedLeft = true;
                        if (this.delay == 0) break;
                        this.px = this.px == 0 ? 0 : this.px - GameMap.tileWidth;
                        break;
                    }
                    case -4: 
                    case 54: {
                        this.pressedRight = true;
                        if (this.delay == 0) break;
                        this.px = this.px == (GameMap.mapSize[0] - 1) * GameMap.tileWidth ? (GameMap.mapSize[0] - 1) * GameMap.tileWidth : this.px + GameMap.tileWidth;
                        break;
                    }
                    case -7: {
                        this.setDebugST((byte)2);
                        GameMap.setOff(this.lastX, this.lastY);
                        break;
                    }
                    case 42: {
                        this.b3 = !this.b3;
                        break;
                    }
                    case 48: {
                        this.b2 = !this.b2;
                        break;
                    }
                    case 35: {
                        this.b1 = !this.b1;
                    }
                }
                break;
            }
            case 7: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.rank[this.index] = this.rank[this.index] == 9 ? 0 : this.rank[this.index] + 1;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.rank[this.index] = this.rank[this.index] == 0 ? 9 : this.rank[this.index] - 1;
                        break;
                    }
                    case -3: 
                    case 52: {
                        this.index = this.index == 0 ? this.rank.length - 1 : this.index - 1;
                        break;
                    }
                    case -4: 
                    case 54: {
                        this.index = this.index == this.rank.length - 1 ? 0 : this.index + 1;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        GameEngine.playX = (short)-1;
                        GameEngine.playY = (short)-1;
                        GameEngine.playDir = (short)-1;
                        GameEngine.setRankEnd(this.getRank(this.rank));
                        isDebug = false;
                        break;
                    }
                    case -7: {
                        GameEngine.initRank = (byte)this.getRank(this.rank);
                        this.setDebugST((byte)0);
                    }
                }
                break;
            }
            case 0: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.index = this.index == 0 ? this.debugMenu.length - 1 : this.index - 1;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.index = this.index == this.debugMenu.length - 1 ? 0 : this.index + 1;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        switch (this.index) {
                            case 0: {
                                this.setDebugST((byte)1);
                                break;
                            }
                            case 1: {
                                this.setDebugST((byte)7);
                                break;
                            }
                            case 2: {
                                this.setDebugST((byte)2);
                                break;
                            }
                            case 3: {
                                if (!this.spriteIsInit()) break;
                                this.setDebugST((byte)3);
                                break;
                            }
                            case 4: {
                                this.setDebugST((byte)6);
                                break;
                            }
                            case 5: {
                                this.setDebugST((byte)4);
                                break;
                            }
                            case 6: {
                                this.drawColorScreenBG(0xFFFFFF, 10000);
                                GameEngine.money += 10000;
                                break;
                            }
                            case 7: {
                                if (GameEngine.role == null) break;
                                this.drawColorScreenBG(0xFFFFFF, 10000);
                                int i = 0;
                                while (i < GameEngine.roleTeam.length) {
                                    GameEngine.role[GameEngine.roleTeam[GameEngine.roleIndex]].exp += 10000;
                                    ++i;
                                }
                                break;
                            }
                        }
                        break;
                    }
                    case -7: {
                        isDebug = false;
                    }
                }
                break;
            }
            case 1: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.pressedUp = true;
                        if (this.delay == 0) break;
                        this.index = this.index == 0 ? 0 : this.index - 1;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.pressedDown = true;
                        if (this.delay == 0) break;
                        this.index = this.index == Script.scriptVar.length - 1 ? Script.scriptVar.length - 1 : this.index + 1;
                        break;
                    }
                    case -3: 
                    case 52: {
                        this.index -= this.rowNumber;
                        this.index = Math.max(0, this.index);
                        break;
                    }
                    case -4: 
                    case 54: {
                        this.index += this.rowNumber;
                        this.index = Math.min(Script.scriptVar.length - 1, this.index);
                        break;
                    }
                    case -5: 
                    case 53: {
                        Script.scriptVar[this.index] = (byte)(Script.scriptVar[this.index] == 0 ? 1 : 0);
                        break;
                    }
                    case -7: {
                        this.setDebugST((byte)0);
                    }
                }
                break;
            }
            case 6: {
                switch (keyCode) {
                    case -7: {
                        this.setDebugST((byte)0);
                    }
                }
                break;
            }
            case 2: {
                switch (keyCode) {
                    case -7: {
                        this.setDebugST((byte)0);
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        if (GameMap.mapData[0] == null) break;
                        this.initMap();
                        this.setDebugST((byte)8);
                    }
                }
                break;
            }
            case 3: {
                switch (keyCode) {
                    case -1: 
                    case 50: {
                        this.index = this.index == 0 ? GameEngine.sprite.length - 1 : this.index - 1;
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.index = this.index == GameEngine.sprite.length - 1 ? 0 : this.index + 1;
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        this.spriteIndex = (byte)this.index;
                        this.setDebugST((byte)5);
                        break;
                    }
                    case 48: {
                        GameEngine.spriteIndex = (byte)this.index;
                        break;
                    }
                    case -7: {
                        this.setDebugST((byte)0);
                    }
                }
                break;
            }
            case 5: {
                switch (keyCode) {
                    case -7: {
                        this.setDebugST((byte)3);
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        this.initMap();
                        this.px = GameEngine.sprite[this.spriteIndex].x / GameMap.tileWidth * GameMap.tileWidth;
                        this.py = GameEngine.sprite[this.spriteIndex].y / GameMap.tileHight * GameMap.tileHight - GameMap.tileHight;
                        this.setDebugST((byte)9);
                    }
                }
                break;
            }
            case 4: {
                switch (keyCode) {
                    case -7: {
                        this.setDebugST((byte)0);
                        break block0;
                    }
                    case -1: 
                    case 50: {
                        this.index = this.index == 0 ? moreMenu.length - 1 : this.index - 1;
                        break block0;
                    }
                    case -2: 
                    case 56: {
                        this.index = this.index == moreMenu.length - 1 ? 0 : this.index + 1;
                        break block0;
                    }
                    case -6: 
                    case -5: 
                    case 53: {
                        Debug.more[this.index] = !more[this.index];
                    }
                }
            }
        }
    }

    public void setDebugST(byte st) {
        isDebug = true;
        this.debugST = st;
        this.index = 0;
    }

    private void drawColorScreenBG(int color, int drawLevel) {
        Tools.addRect((byte)1, GameMap.setOffX, GameMap.setOffY - 20, GameMap.screenWidth, GameMap.screenHeight + 40, true, 20, color, drawLevel);
    }

    private void drawYesNo(String str1, String str2, int drawLevel) {
        if (str1 != null) {
            Tools.addString((byte)4, str1, GameMap.setOffX + 2, GameMap.setOffY + 360 - 2, 36, 16775337, drawLevel);
        }
        if (str2 != null) {
            Tools.addString((byte)4, str2, GameMap.setOffX + 360 - 2, GameMap.setOffY + 360 - 2, 40, 16775337, drawLevel);
        }
    }

    void initMapBuff() {
        this.mapBuff = null;
        this.isBuffNull = true;
        this.buffWidth = GameMap.screenWidth - GameMap.screenWidth % GameMap.tileWidth + GameMap.tileWidth * 2;
        this.buffHeight = GameMap.screenHeight - GameMap.screenHeight % GameMap.tileHight + GameMap.tileHight * 2;
        this.mapBuff = Image.createImage((int)this.buffWidth, (int)this.buffHeight);
    }

    void drawBuff(Graphics g, int clipX, int clipY, int clipW, int clipH, int x, int y) {
        g.setClip(x, y, clipW, clipH);
        g.drawImage(this.mapBuff, x - clipX, y - clipY, 20);
        g.setClip(0, 0, GameMap.screenWidth, GameMap.screenHeight);
    }

    void drawMap(Graphics g, int setOffX, int setOffY) {
        Graphics g1 = this.mapBuff.getGraphics();
        int startX = setOffX / GameMap.tileWidth;
        int endX = startX + GameMap.screenWidth / GameMap.tileWidth + 1;
        int startY = setOffY / GameMap.tileHight;
        int endY = startY + GameMap.screenHeight / GameMap.tileHight + 1;
        if (this.isBuffNull) {
            this.isBuffNull = false;
            this.updateBuff(g1, startX, startY, endX, endY);
            this.lastStartX = startX;
            this.lastStartY = startY;
            this.lastEndX = endX;
            this.lastEndY = endY;
        }
        if (this.lastStartX != startX) {
            int tmp2;
            int tmp1;
            if (this.lastStartX < startX) {
                tmp1 = this.lastEndX + 1;
                tmp2 = endX;
            } else {
                tmp1 = startX;
                tmp2 = this.lastStartX - 1;
            }
            this.updateBuff(g1, tmp1, startY, tmp2, endY);
            this.lastStartX = startX;
            this.lastEndX = endX;
        }
        if (this.lastStartY != startY) {
            int tmp4;
            int tmp3;
            if (this.lastStartY < startY) {
                tmp3 = this.lastEndY + 1;
                tmp4 = endY;
            } else {
                tmp3 = startY;
                tmp4 = this.lastStartY - 1;
            }
            this.updateBuff(g1, startX, tmp3, endX, tmp4);
            this.lastStartY = startY;
            this.lastEndY = endY;
        }
        int t1 = setOffX % this.buffWidth;
        int t2 = setOffY % this.buffHeight;
        int t3 = (setOffX + GameMap.screenWidth) % this.buffWidth;
        int t4 = (setOffY + GameMap.screenHeight) % this.buffHeight;
        if (t3 > t1) {
            if (t4 > t2) {
                this.drawBuff(g, t1, t2, GameMap.screenWidth, GameMap.screenHeight, 0, 0);
            } else {
                this.drawBuff(g, t1, t2, GameMap.screenWidth, GameMap.screenHeight - t4, 0, 0);
                this.drawBuff(g, t1, 0, GameMap.screenWidth, t4, 0, GameMap.screenHeight - t4);
            }
        } else if (t4 > t2) {
            this.drawBuff(g, t1, t2, GameMap.screenWidth - t3, GameMap.screenHeight, 0, 0);
            this.drawBuff(g, 0, t2, t3, GameMap.screenHeight, GameMap.screenWidth - t3, 0);
        } else {
            this.drawBuff(g, t1, t2, GameMap.screenWidth - t3, GameMap.screenHeight - t4, 0, 0);
            this.drawBuff(g, t1, 0, GameMap.screenWidth - t3, t4, 0, GameMap.screenHeight - t4);
            this.drawBuff(g, 0, t2, t3, GameMap.screenHeight - t4, GameMap.screenWidth - t3, 0);
            this.drawBuff(g, 0, 0, t3, t4, GameMap.screenWidth - t3, GameMap.screenHeight - t4);
        }
    }

    void updateBuff(Graphics g, int startX, int startY, int endX, int endY) {
        int y = startY * GameMap.tileHight % this.buffHeight;
        int i = startY;
        while (i <= endY) {
            int x = startX * GameMap.tileWidth % this.buffWidth;
            int j = startX;
            while (j <= endX) {
                byte mapIndex2 = GameMap.inMapData(j * GameMap.tileWidth, i * GameMap.tileHight, 1);
                int dataTemp2 = GameMap.getIndex(mapIndex2);
                int transData2 = GameMap.getTrans(mapIndex2);
                if ((byte)mapIndex2 != -1) {
                    g.setClip(x, y, (int)GameMap.tileWidth, (int)GameMap.tileHight);
                    Tools.drawClipImage(g, 600 + dataTemp2, x, y, 0, 0, GameMap.tileWidth, GameMap.tileHight, 20, transData2);
                    g.setClip(GameMap.setOffX, GameMap.setOffY, 360, 390);
                } else {
                    g.setClip(x, y, (int)GameMap.tileWidth, (int)GameMap.tileHight);
                    g.setColor(0);
                    g.fillRect(x, y, (int)GameMap.tileWidth, (int)GameMap.tileHight);
                    g.setClip(GameMap.setOffX, GameMap.setOffY, 360, 390);
                }
                byte mapIndex1 = GameMap.inMapData(j * GameMap.tileWidth, i * GameMap.tileHight, 0);
                int dataTemp1 = GameMap.getIndex(mapIndex1);
                int transData = GameMap.getTrans(mapIndex1);
                if ((byte)mapIndex1 != -1) {
                    g.setClip(x, y, (int)GameMap.tileWidth, (int)GameMap.tileHight);
                    Tools.drawClipImage(g, 300 + dataTemp1, x, y, 0, 0, GameMap.tileWidth, GameMap.tileHight, 20, transData);
                    g.setClip(GameMap.setOffX, GameMap.setOffY, 360, 390);
                }
                if ((x += GameMap.tileWidth) >= this.buffWidth) {
                    x -= this.buffWidth;
                }
                ++j;
            }
            if ((y += GameMap.tileHight) >= this.buffHeight) {
                y -= this.buffHeight;
            }
            ++i;
        }
    }

    static {
        moreMenu = new String[]{"\u5185\u5b58\u76d1\u89c6", "\u7cbe\u7075\u6807\u8bb0", "\u6e38\u620f\u901f\u5ea6", "\u5730\u56fe\u7f51\u683c", "\u89e6\u96f7\u5f00\u5173"};
        more = new boolean[moreMenu.length];
    }
}

