/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class GameEngine {
    MyGameCanvas canvas;
    Battle battle;
    public static GameEngine me;
    public static Equipment[] equip;
    public static Food[] food;
    public static Dish[] dish;
    public static Passive[] pav;
    static Skill[] sk;
    static Effect eft;
    static GameSprite[] sprite;
    public static GameMap map;
    static Random rnd;
    public static byte spriteIndex;
    static byte gameRank;
    public static boolean gameFinish;
    public static int money;
    static byte bagMax;
    static final byte REPEATMAX = 99;
    public static byte[][] foodData;
    public static byte[][] dishData;
    public static byte[][] equipData;
    public static byte[][] passiveData;
    public static byte[] dishMenuData;
    public static byte[][] roleSP;
    public static Fighter[] role;
    public static final byte ROLEMAX = 4;
    public static final byte ENEMYMAX = 33;
    public static byte[] roleTeam;
    public static byte[] enemyTeam;
    public static byte roleIndex;
    static int injueTime;
    static boolean isBattle;
    static boolean isCook;
    static boolean isShowGame;
    public static final byte B_\u6570\u91cf = 0;
    public static final byte B_\u7c7b\u578b = 1;
    public static final byte B_\u7f16\u53f7 = 2;
    public static final byte BT_\u88c5\u5907 = 0;
    public static final byte BT_\u79d8\u7c4d = 2;
    public static final byte BT_\u98df\u6750 = 3;
    public static final byte BT_\u83dc = 4;
    static Hashtable taskLog;
    static short playX;
    static short playY;
    static short playDir;
    static boolean isVisible;
    static boolean stopBomb;
    int studyIndex = 0;
    int pages;
    String[] word;
    String[][] words = new String[][]{{"\u8fdb\u5165\u83dc\u5355\u540e\u9009\u62e9\u6280", "\u80fd\u9009\u9879\u540e\u53ef\u4ee5\u770b\u5230", "\u89d2\u8272\u62e5\u6709\u7684\u79d8\u7c4d"}, {"\u6280\u80fd\u83dc\u5355\u4e2d\u63090\u53f7\u952e", "\u53ef\u4ee5\u7528\u4e0b\u65b9\u7684\u6280\u80fd\u70b9", "\u5347\u7ea7\u79d8\u7c4d"}, {"\u79d8\u7c4d\u5df2\u7ecf\u5347\u7ea7\uff0c", "\u79d8\u7c4d\u7684\u80fd\u529b\u4f1a\u9644\u52a0", "\u5230\u4eba\u7269\u8eab\u4e0a\u3002\u5982\u679c", "\u6709\u6280\u80fd\u70b9\u53ef\u4ee5\u7ee7\u7eed\u5347\u7ea7\u3002"}, {"\u5f53\u79d8\u7c4d\u5347\u52303\u7ea7\u540e", "\u4f1a\u89c9\u9192\u6280\u80fd\uff0c\u7ee7\u7eed", "\u5347\u7ea7\u8fd8\u4f1a\u51fa\u73b0\u66f4\u9ad8\u7ea7\u7684\u6280\u80fd\u3002"}};
    static byte dishType;
    static boolean isChangMap;
    static boolean isScreenFlash;
    static byte screenFlashTime;
    static int screenFlashColor;
    public static int posX;
    public static int posY;
    static boolean isToPoint;
    static int shakeTime;
    static int shakeWave;
    byte areaIndex;
    boolean isAreaName;
    int initIndex = 0;
    static byte initRank;
    public static final byte SK_\u5927\u96f7\u7535 = 1;
    public static final byte SK_\u67ab\u53f6 = 2;
    public static final byte SK_\u90aa\u98ce = 3;
    public static final byte SK_\u8001\u864e\u9635 = 4;
    public static final byte SK_\u516b\u5366\u5c01\u795e = 25;
    public static final byte SK_\u66b4\u98ce\u96ea = 6;
    public static final byte SK_\u52a0\u8840 = 7;
    public static final byte SK_\u6495\u54ac = 8;
    public static final byte SK_\u5272\u88c2 = 9;
    public static final byte SK_\u722a\u51fb = 10;
    public static final byte SK_\u5730\u9707 = 11;
    public static final byte SK_\u98ce\u96f7\u6c34\u706b = 12;
    public static final byte SK_\u5c0f\u843d\u96f7 = 13;
    public static final byte SK_\u5c0f\u55b7\u706b = 14;
    public static final byte SK_\u6bd2\u5355\u4f53 = 15;
    public static final byte SK_\u52a0\u72b6\u6001 = 16;
    public static final byte SK_\u51cf\u72b6\u6001 = 17;
    public static final byte SK_\u8840\u7206 = 18;
    byte skillFinshTime;
    byte skillTime;
    short ex;
    short ey;
    short[][] snowData = new short[40][3];
    byte[][] imgRianData = new byte[][]{{0, 0, 19, 19}, {19, 0, 13, 13}, {19, 13, 5, 5}};
    short[][] leafData;
    public static Vector Vrsd;
    public static Vector VBee;
    private static Vector vEnemys;
    public static short[][] starPos;
    public static byte[] starSpeed;
    public static final int STARNUM = 20;
    public static int speedOfScroll;
    int mapYPix = 360;
    int topScrollPos = 0;
    byte jn = 1;
    short[][] bombs;
    public static final int RANK_MOVE = 12;
    public static final int RANK_ATTACK = 31;
    public static final int BOMB_SPEED = 4;
    public static final byte FOLLOW_MAX = 10;
    public static final byte BOMB_X = 0;
    public static final byte BOMB_Y = 1;
    public static final byte BOMB_DIR = 2;
    public static final byte BOMB_ST = 3;
    public static final byte BOMB_RANK = 4;
    public static final byte BOMB_INDEX = 5;
    public static final byte BOMB_COUNT = 6;
    public static final byte BST_STOP = 0;
    public static final byte BST_MOVE = 1;
    public static final byte BST_FOLLOW = 2;
    public static final byte BST_ATTACK = 3;
    public static final byte BST_DEAD = 4;
    public static final byte DIR_RIGHT = 0;
    public static final byte DIR_LEFT = 1;
    public static final byte DIR_DOWN = 2;
    public static final byte DIR_UP = 3;
    byte speed = (byte)10;
    short len = (short)120;
    short ballR = (short)12;
    int ballX;
    int ballY;
    int fishTime;
    static byte[] gift;
    byte times = 0;
    byte[] goldGift = new byte[]{25, 26, 27};
    short perfectP;
    boolean isTurnL = false;
    boolean isSusseed = false;
    boolean isBeginFish = false;
    public static final byte FST_RUN = 0;
    public static final byte FST_WIN = 1;
    public static final byte FST_FALSE = 2;
    public static final byte FST_HELP = 3;
    public static final byte FST_READY = 4;
    static byte FISHST;
    boolean isFish = false;
    byte choice;

    public GameEngine() {
        me = this;
        this.canvas = MyGameCanvas.me;
        map = new GameMap(this, 360, 360);
        this.battle = new Battle(this);
        eft = new Effect(this);
    }

    public static void addTask(String key) {
        taskLog.put(key, "");
    }

    public static void delTask(String key) {
        taskLog.remove(key);
    }

    public static void setGameFinish() {
        MyGameCanvas.setST((byte)14);
        gameFinish = true;
    }

    public void ctrlReleased(int keyCode) {
        sprite[spriteIndex].ctrlRelease();
    }

    public void ctrlPlay(int keyCode) {
        switch (keyCode) {
            default: 
        }
        sprite[spriteIndex].ctrl(keyCode);
    }

    public int hitsSrite(int x, int y) {
        if (sprite.length <= 1 || !Script.isUserCtrl) {
            return -1;
        }
        int i = 0;
        while (i < sprite.length) {
            if (i != spriteIndex && GameEngine.sprite[i].visible && !GameEngine.sprite[i].isPass && x == GameEngine.sprite[i].ax && y == GameEngine.sprite[i].ay) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void initSpirateXY() {
        if (playX == -1 || playY == -1 || playDir == -1) {
            return;
        }
        GameEngine.sprite[GameEngine.spriteIndex].x = playX;
        GameEngine.sprite[GameEngine.spriteIndex].y = playY;
        short s = playDir;
        GameEngine.sprite[GameEngine.spriteIndex].nextFaceDir = s;
        GameEngine.sprite[GameEngine.spriteIndex].faceDir = s;
        GameEngine.sprite[GameEngine.spriteIndex].dir = s;
        GameEngine.sprite[GameEngine.spriteIndex].nextDir = s;
        GameEngine.sprite[GameEngine.spriteIndex].visible = isVisible;
        sprite[spriteIndex].setAXY();
    }

    public static void setPlayXY(int x, int y, int dir, boolean visible) {
        playX = (short)x;
        playY = (short)y;
        playDir = (short)dir;
        isVisible = visible;
    }

    public static void initSprite(Vector v) {
        sprite = null;
        if (v.size() == 0) {
            System.out.println("Load npc Data Fail");
            return;
        }
        sprite = new GameSprite[v.size()];
        v.copyInto(sprite);
        System.out.println("12314" + dishMenuData.length);
    }

    public void moveSprite() {
        if (sprite != null) {
            int i = 0;
            while (i < sprite.length) {
                sprite[i].run();
                ++i;
            }
        }
    }

    public void drawSprite(Graphics g) {
        if (sprite != null) {
            int i = 0;
            while (i < sprite.length) {
                sprite[i].paint();
                ++i;
            }
        }
    }

    public void bomb() {
        this.getEnemyTeam();
        sprite[spriteIndex].setStates(-1);
        Battle.canEscape = true;
        Battle.canLose = false;
        Battle.curBattleEvent = (byte)-1;
        Battle.stopBattle = false;
        MyGameCanvas.setST((byte)20);
        SoundPlayerUtil.playmusic(SoundPlayerUtil.Music_\u6218\u6597, -1);
    }

    void getEnemyTeam() {
        enemyTeam = null;
        enemyTeam = new byte[this.getEnemyTeamLen()];
        int i = 0;
        while (i < enemyTeam.length) {
            GameEngine.enemyTeam[i] = GameEngine.map.enemys[GameEngine.nextInt(GameEngine.map.enemys.length - 1)];
            ++i;
        }
    }

    int getEnemyTeamLen() {
        switch (roleTeam.length) {
            case 1: {
                return GameEngine.nextInt(1, 2);
            }
        }
        return GameEngine.nextInt(2, 3);
    }

    public void drawStudy(int index, int x, int y, int maxLine) {
        this.word = this.words[this.studyIndex];
        this.pages = (this.word.length - 1) / maxLine + 1;
        if (index >= this.pages || index < 0) {
            index = (index + this.pages) % this.pages;
        }
        int start = index * maxLine;
        int i = 0;
        while (i < maxLine && start + i < this.word.length) {
            Tools.addString((byte)4, this.word[start + i], x, y + i * 19, 36, 13041518, 9999);
            ++i;
        }
    }

    public void drawGame(Graphics g) {
        this.drawSprite(g);
        if (isShowGame) {
            map.setMap(g);
        } else {
            GameEngine.drawColorScreenBG(0, 10);
        }
        this.drawInterFace(g, GameMap.setOffX, GameMap.setOffY);
        this.drawBomb();
        if (isScreenFlash) {
            MyGameCanvas.drawOpenEft();
        }
    }

    public static void getEqu(int type) {
        GameEngine.addItem(new byte[]{1, 0, (byte)type}, equipData);
        MyGameCanvas.ToAside(new String[]{"\u5f97\u5230" + GameEngine.equip[type].name + "X1"});
    }

    public static void getPav(int type) {
        byte roleIndex = GameEngine.pav[type].range;
        if (GameEngine.isHavePav(type) > 0) {
            return;
        }
        GameEngine.addItem(new byte[]{1, 2, (byte)type}, passiveData);
        if (type < 8) {
            GameEngine.roleSP[GameEngine.pav[type].id][0] = 1;
        }
        int i = 0;
        while (i < roleSP.length) {
            int j = 0;
            while (j < roleSP[i].length) {
                System.out.print(roleSP[i][j]);
                ++j;
            }
            System.out.println("-----");
            ++i;
        }
        MyGameCanvas.ToAside(new String[]{"\u5f97\u5230" + GameEngine.pav[type].name + "X1"});
    }

    public static void removePav(int type) {
        int i = 0;
        while (i < passiveData.length - GameEngine.getBagEmpty(passiveData)) {
            if (passiveData[i][2] == type) {
                GameEngine.removeData(i, passiveData);
            }
            ++i;
        }
    }

    public static void getSp(byte type, byte num) {
        GameEngine.role[type].sp = (short)(GameEngine.role[type].sp + num);
    }

    public static void getFood(int type, int num) {
        GameEngine.addItem(new byte[]{(byte)num, 3, (byte)type}, foodData);
        MyGameCanvas.ToAside(new String[]{"\u5f97\u5230" + GameEngine.food[type].name + "X" + num});
    }

    public static void removeFood(int type, int num) {
        int i = 0;
        while (i < foodData.length) {
            if (foodData[i][2] == type) {
                byte[] byArray = foodData[i];
                byArray[0] = (byte)(byArray[0] - num);
                if (foodData[i][0] <= 0) {
                    // empty if block
                }
                MyGameCanvas.ToAside(new String[]{"\u5931\u53bb" + GameEngine.food[type].name + "X" + num});
            }
            ++i;
        }
    }

    public static void getDish(int type, int num) {
        GameEngine.addItem(new byte[]{(byte)num, 4, (byte)type}, dishData);
        if (MyGameCanvas.gameStatus == 61) {
            MyGameCanvas.ToAside(new String[]{"\u6210\u529f\u5408\u6210" + GameEngine.dish[type].name + "X" + num});
        } else {
            MyGameCanvas.ToAside(new String[]{"\u5f97\u5230" + GameEngine.dish[type].name + "X" + num});
        }
    }

    public void getDishMenu(byte type) {
        if (GameEngine.isHaveDishMenu(type) > 0) {
            return;
        }
        byte[] data = dishMenuData;
        if (data == null) {
            dishMenuData = new byte[]{type};
        } else {
            int lenM = data.length;
            dishMenuData = new byte[lenM + 1];
            int i = 0;
            while (i < lenM) {
                GameEngine.dishMenuData[i] = data[i];
                ++i;
            }
            GameEngine.dishMenuData[lenM] = type;
        }
    }

    public void removeDish(int type, int num, byte returnSt, boolean isReturn) {
        byte[] byArray = dishData[type];
        byArray[0] = (byte)(byArray[0] - num);
        if (dishData[type][0] <= 0) {
            GameEngine.removeData(type, dishData);
            if (isReturn) {
                MyGameCanvas.setST(returnSt);
            }
        }
    }

    public static void haveDish(byte type) {
        if (dishData.length == 0) {
            dishType = (byte)-1;
        }
        int i = 0;
        while (i < dishData.length) {
            if (GameEngine.dish[GameEngine.dishData[i][2]].type == type && dishData[i][0] > 0) {
                dishType = type;
            }
            ++i;
        }
    }

    public static void getSkill(Fighter r, int skillIndex) {
        if (GameEngine.checkSkill(r, skillIndex)) {
            r.skillData = GameEngine.addData1(r.skillData, (byte)skillIndex);
        }
    }

    public static boolean checkSkill(Fighter f, int skillIndex) {
        if (f.skillData == null) {
            return true;
        }
        int i = 0;
        while (i < f.skillData.length) {
            if (f.skillData[i] == skillIndex) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void getPassive(Fighter r, int pavIndex) {
        if (GameEngine.getPav(r, pavIndex)) {
            r.passiveData = GameEngine.addData1(r.passiveData, (byte)pavIndex);
        }
    }

    public static boolean getPav(Fighter f, int pavIndex) {
        if (f.passiveData == null) {
            return true;
        }
        int i = 0;
        while (i < f.passiveData.length) {
            if (f.passiveData[i] == pavIndex) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int isHavePav(int id) {
        int i = 0;
        while (i < passiveData.length - GameEngine.getBagEmpty(passiveData)) {
            if (passiveData[i][2] == id) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public static int isHaveDishMenu(int id) {
        int i = 0;
        while (i < dishMenuData.length) {
            if (dishMenuData[i] == id) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public static void getMoney(int num) {
        money += num;
        MyGameCanvas.ToAside(new String[]{(num >= 0 ? "\u5f97\u5230" : "\u5931\u53bb") + "\u91d1\u94b1" + Math.abs(num) + "\u4e24"});
    }

    public static void setRankEnd(int id) {
        MyGameCanvas.setST((byte)14);
        isChangMap = true;
        gameRank = (byte)id;
        Event.isChangeMap = false;
    }

    public void drawScreenFlash() {
        if (screenFlashTime != 0 && (screenFlashTime = (byte)(screenFlashTime - 1)) % 2 != 0) {
            Tools.addRect((byte)1, GameMap.setOffX, GameMap.setOffY, GameMap.screenWidth, GameMap.screenHeight, true, 20, screenFlashColor, 9000);
        }
    }

    static void setScreenFlash(int time, int color) {
        screenFlashTime = (byte)(time * 2);
        screenFlashColor = color;
    }

    public void runGame() {
        if (MyGameCanvas.chargeDelay == 0) {
            Script.runScript();
        }
        this.moveBomb();
        this.run();
        Fighter.levelMax = (byte)(MyMessage.canSendAgian(20) ? 60 : 60);
        MyMessage.PPData[0] = 0;
    }

    public void run() {
        this.moveSprite();
        if (!isToPoint) {
            posX = GameEngine.sprite[GameEngine.spriteIndex].sx + GameMap.tileWidth / 2;
            posY = GameEngine.sprite[GameEngine.spriteIndex].sy - GameMap.tileWidth / 2;
        }
        map.AdjustSrceen(posX, posY);
        GameEngine.screenShake();
    }

    static void toChooseStatus(String chooseTitle, String[] options, boolean rs) {
        MyGameCanvas.title = chooseTitle;
        MyGameCanvas.option = options;
        MyGameCanvas.choice = 0;
        MyGameCanvas.setST((byte)11);
        MyGameCanvas.canUseRS = rs;
    }

    public static void toBlackStatus(String content) {
        MyGameCanvas.index = 0;
        MyGameCanvas.blackWord = content;
        MyGameCanvas.gameStatus = (byte)25;
    }

    public static void screenShake() {
        if (shakeTime == 0) {
            return;
        }
        if (shakeTime > 0) {
            --shakeTime;
        }
        GameMap.setOffY = MyGameCanvas.gameTime % 2 == 0 ? GameMap.setOffY + shakeWave : GameMap.setOffY - shakeWave;
    }

    public static int nextInt(int n) {
        return Math.abs(rnd.nextInt()) % (n + 1);
    }

    public static int nextInt(int n, int m) {
        if (n == m) {
            return n;
        }
        if (n > m) {
            int temp = n;
            n = m;
            m = temp;
        }
        return Math.abs(rnd.nextInt()) % (m - n + 1) + n;
    }

    void drawAreaName(int x, int y) {
        byte[] areaNameY = new byte[]{-30, -24, -20, -16, -12, -8, -4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -4, -8, -12, -16, -20, -24, -30};
        byte len = (byte)GameEngine.map.mapName.length();
        this.canvas.drawBar((short)255, this.canvas.bar1Data, x + 2, y + 2 + areaNameY[this.areaIndex], len * 21 + 16, 24, 15062383, 9000, false);
        Tools.addString((byte)4, GameEngine.map.mapName, x + 2 + (len * 20 + 16) / 2, y + 4 + 10 + areaNameY[this.areaIndex], 33, 51967, 9000);
        this.areaIndex = (byte)(this.areaIndex + 1);
        if (this.areaIndex >= areaNameY.length) {
            this.areaIndex = 0;
            this.isAreaName = false;
        }
    }

    final void drawInterFace(Graphics g, int x, int y) {
        if (this.isAreaName) {
            this.drawAreaName(x, y);
        }
        if (MyGameCanvas.gameStatus == 7 && Script.isUserCtrl) {
            Tools.addImage(269, x + 2, y + GameMap.screenHeight - 2, 0, 0, 29, 15, 36, (byte)0, 9000);
        }
        int i = 1;
        while (i < 2) {
            Tools.addImage(280, x + 50 + 37 * i, y + 360 - 7, 0, 15 * i, 37, 15, 36, (byte)0, 9000);
            ++i;
        }
    }

    void free() {
        sprite = null;
        Tools.removeAllSinleImage(new int[0]);
        Tools.removeAllGroupImage(new int[0]);
        enemyTeam = null;
        this.battle.free();
        map.free();
        Script.free();
        Effect.EffectV.removeAllElements();
    }

    public boolean initGame() {
        switch (this.initIndex) {
            case 1: {
                this.free();
                System.gc();
                break;
            }
            case 10: {
                gameFinish = false;
                GameMap.setOff(0, 0);
                roleIndex = 0;
                isToPoint = false;
                Battle.canLose = false;
                GameMap.SCEEN_MOVE = (byte)10;
                Battle.canEscape = true;
                MyGameCanvas.gameTime = 0;
                spriteIndex = 0;
                isBattle = false;
                Battle.stopBattle = false;
                isShowGame = true;
                System.gc();
                break;
            }
            case 15: {
                System.gc();
                break;
            }
            case 20: {
                if (isChangMap) {
                    Script.loadScript(gameRank);
                    isChangMap = false;
                }
                System.gc();
                break;
            }
            case 25: {
                this.upDataRoleProperty();
                this.initSpirateXY();
                System.gc();
                break;
            }
            case 30: {
                map.initMap();
                SoundPlayerUtil.playmusic(GameEngine.map.music, -1);
                System.gc();
                break;
            }
            case 35: {
                this.initBomb();
                isChangMap = false;
                break;
            }
            case 40: {
                return Script.runInitEvent();
            }
        }
        ++this.initIndex;
        return false;
    }

    public void allInit() {
        playX = (short)-1;
        playY = (short)-1;
        playDir = (short)-1;
        gameRank = initRank;
        gameFinish = false;
        stopBomb = false;
        foodData = new byte[48][3];
        dishData = new byte[48][3];
        equipData = new byte[48][3];
        passiveData = new byte[48][3];
        bagMax = (byte)48;
        Script.scriptVar = new byte[300];
        Script.scriptPosVar = new short[10][3];
        money = 0;
        roleTeam = new byte[]{0};
        spriteIndex = roleTeam[0];
        Battle.stopBattle = false;
        GameData.roleVauleData = new byte[][]{{90, 30, 20, 16, 14, 18, 1, 60}, {86, 38, 18, 16, 15, 16, 1, 70}, {82, 42, 16, 15, 20, 18, 12, 40}, {82, 42, 16, 15, 20, 18, 12, 40}};
        int i = 0;
        while (i < role.length) {
            role[i].initRole((byte)i);
            this.upDateRolePav(role[i]);
            ++i;
        }
        dishMenuData = new byte[0];
        MyMessage.PPData[0] = 0;
        MyMessage.PPData[1] = 0;
    }

    public void drawShandow(int x, int y, int w, int h, int color, int drawLevel) {
        Tools.addARC((byte)2, x - w / 2, y - h / 2, w, h, 0, 360, true, 20, color, drawLevel);
    }

    void upDataRoleProperty() {
        int i = 0;
        while (i < 4) {
            role[i].upDateRoleProperty();
            this.upDateRolePav(role[i]);
            ++i;
        }
    }

    public void initBattle() {
        GameEngine.setPlayXY(GameEngine.sprite[GameEngine.spriteIndex].x, GameEngine.sprite[GameEngine.spriteIndex].y, GameEngine.sprite[GameEngine.spriteIndex].dir, GameEngine.sprite[GameEngine.spriteIndex].visible);
        Tools.removeAllSinleImage(new int[0]);
        map.initBattleMap();
        this.battle.initBattle(roleTeam, enemyTeam);
        Battle.wait = 0;
        Battle.index = 0;
        this.battle.setBattleST((byte)-1);
    }

    public static byte getEmpty(byte[][] data) {
        int i = 0;
        while (i < data.length) {
            if (data[i][0] == 0) {
                return (byte)i;
            }
            ++i;
        }
        return (byte)data.length;
    }

    public static void removeData(int index, byte[][] data) {
        if (index == data.length - 1) {
            int i = 0;
            while (i < data[i].length) {
                data[i][0] = 0;
                ++i;
            }
        } else {
            int i = index;
            while (i < data.length - 1) {
                int j = 0;
                while (j < data[i].length) {
                    data[i][j] = data[i + 1][j];
                    ++j;
                }
                ++i;
            }
            int i2 = 0;
            while (i2 < data[i2].length) {
                data[data.length - 1][i2] = 0;
                ++i2;
            }
        }
    }

    public static void cleanData(int index, byte[][] data) {
        int i = 0;
        while (i < data[index].length) {
            data[index][i] = 0;
            ++i;
        }
    }

    public static void replaceData(byte[][] a2, byte[][] b2, int aIndex, int bIndex) {
        byte[] temp = new byte[a2[aIndex].length];
        int i = 0;
        while (i < temp.length) {
            temp[i] = a2[aIndex][i];
            a2[aIndex][i] = b2[bIndex][i];
            b2[bIndex][i] = temp[i];
            ++i;
        }
    }

    public static void addNewItem(byte[] addData, byte[][] toData) {
        byte addIndex = GameEngine.getEmpty(toData);
        if (addIndex == toData.length || addIndex >= bagMax) {
            return;
        }
        int i = 0;
        while (i < toData[0].length) {
            toData[addIndex][i] = addData[i];
            ++i;
        }
    }

    public static void addItem(byte[] addData, byte[][] toData) {
        if (addData[0] == 0) {
            return;
        }
        if (GameEngine.getEmpty(toData) == bagMax) {
            return;
        }
        if (addData[1] == 0) {
            GameEngine.addNewItem(addData, toData);
        } else {
            int i = 0;
            while (i < addData[0]) {
                int j = 0;
                while (j < toData.length) {
                    if (addData[1] == toData[j][1] && addData[2] == toData[j][2] && toData[j][0] < 99 || toData[j][0] == 0) {
                        byte[] byArray = toData[j];
                        byArray[0] = (byte)(byArray[0] + 1);
                        toData[j][1] = addData[1];
                        toData[j][2] = addData[2];
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public static byte[][] addData2(byte[][] data, byte[] addData) {
        byte[][] temp = data;
        if (temp == null) {
            temp = new byte[1][addData.length];
            temp[0] = addData;
        } else {
            temp = new byte[data.length + 1][addData.length];
            int i = 0;
            while (i < temp.length) {
                temp[i] = i < data.length ? data[i] : addData;
                ++i;
            }
        }
        return temp;
    }

    public static byte[] addData1(byte[] data, byte id) {
        byte[] temp = data;
        if (temp == null) {
            temp = new byte[]{id};
        } else {
            temp = new byte[data.length + 1];
            int i = 0;
            while (i < temp.length) {
                temp[i] = i < data.length ? data[i] : id;
                ++i;
            }
        }
        return temp;
    }

    public boolean canAddData(byte[][] data) {
        return GameEngine.getEmpty(data) != bagMax;
    }

    public void removeFood(int itemIndex, int num, byte returnSt, boolean isReturn) {
        byte[] byArray = foodData[itemIndex];
        byArray[0] = (byte)(byArray[0] - num);
        if (foodData[itemIndex][0] <= 0) {
            GameEngine.removeData(itemIndex, foodData);
            if (isReturn) {
                MyGameCanvas.setST(returnSt);
            }
        }
    }

    public void removeEquip(int itemIndex, int num, byte returnSt, boolean isReturn) {
        byte[] byArray = equipData[itemIndex];
        byArray[0] = (byte)(byArray[0] - num);
        if (equipData[itemIndex][0] <= 0) {
            GameEngine.removeData(itemIndex, equipData);
            if (isReturn) {
                MyGameCanvas.setST(returnSt);
            }
        }
    }

    public void removeCookFood(byte type, int num) {
        int i = 0;
        while (i < foodData.length) {
            if (foodData[i][0] > 0 && foodData[i][2] == type) {
                byte[] byArray = foodData[i];
                byArray[0] = (byte)(byArray[0] - num);
                if (foodData[i][0] <= 0) {
                    GameEngine.removeData(i, foodData);
                }
            }
            ++i;
        }
    }

    public static void toBattle(boolean boss, boolean lost) {
        int len = vEnemys.size();
        enemyTeam = new byte[len];
        int i = 0;
        while (i < len) {
            byte[] dat = (byte[])vEnemys.elementAt(i);
            GameEngine.enemyTeam[i] = dat[0];
            ++i;
        }
        vEnemys.removeAllElements();
        Battle.canEscape = !boss;
        Battle.canLose = lost;
        MyGameCanvas.setST((byte)20);
    }

    public void initRole() {
        role = new Fighter[4];
        int i = 0;
        while (i < 4) {
            GameEngine.role[i] = new Fighter(this);
            role[i].initRole((byte)i);
            ++i;
        }
    }

    static void drawColorScreenBG(int color, int drawLevel) {
        Tools.addRect((byte)1, GameMap.setOffX, GameMap.setOffY, GameMap.screenWidth, GameMap.screenHeight, true, 20, 0, drawLevel);
    }

    public void drawSkillEft(int type, int isMir) {
        switch (type) {
            case 25: {
                this.skillFinshTime = (byte)21;
                this.skillEvent(1, isMir == 1 ? 80 : GameMap.screenWidth - 80, 150, 24, 0, 30);
                this.skillEvent(9, isMir == 1 ? 80 : GameMap.screenWidth - 80, 150, 25, 0, 350);
                break;
            }
            case 18: {
                this.skillFinshTime = (byte)23;
                GameEngine.drawColorScreenBG(0, 20);
                this.skillEvent(1, isMir == 1 ? GameMap.screenWidth - 80 : 80, 150, 27, isMir, 350);
                this.skillEvent(6, isMir == 1 ? GameMap.screenWidth - 16 : 16, 200, 27, isMir, 350);
                this.skillEvent(11, isMir == 1 ? GameMap.screenWidth - 90 : 90, 220, 27, isMir, 350);
                this.skillEvent(16, isMir == 1 ? GameMap.screenWidth - 25 : 25, 140, 29, 0, 170);
                this.skillEvent(16, isMir == 1 ? GameMap.screenWidth - 90 : 90, 140, 29, 0, 170);
                this.skillEvent(16, isMir == 1 ? GameMap.screenWidth - 25 : 25, 230, 29, 0, 260);
                this.skillEvent(16, isMir == 1 ? GameMap.screenWidth - 90 : 90, 230, 29, 0, 260);
                this.skillEvent(16, isMir == 1 ? GameMap.screenWidth - 58 : 58, 180, 29, 0, 210);
                break;
            }
            case 1: {
                this.skillFinshTime = (byte)42;
                GameEngine.drawColorScreenBG(0, 20);
                if (this.skillTime % 4 == 1 && this.skillTime < 30) {
                    this.skillEvent(this.skillTime, isMir == 1 ? GameMap.screenWidth - 55 : 55, 170, 10, 0, 21);
                }
                this.skillEvent(17, isMir == 1 ? GameMap.screenWidth - 40 : 40, 140, 6, 0, 350);
                this.skillEvent(21, isMir == 1 ? GameMap.screenWidth - 70 : 70, 195, 6, 0, 350);
                this.skillEvent(23, isMir == 1 ? GameMap.screenWidth - 55 : 55, 175, 6, 0, 350);
                this.skillEvent(24, isMir == 1 ? GameMap.screenWidth - 20 : 20, 200, 6, 0, 350);
                this.skillEvent(26, isMir == 1 ? GameMap.screenWidth - 60 : 60, 225, 6, 0, 350);
                this.skillEvent(30, isMir == 1 ? GameMap.screenWidth - 35 : 35, 95, 4, 0, 350);
                this.skillEvent(31, isMir == 1 ? GameMap.screenWidth - 50 : 50, 130, 4, 0, 350);
                this.skillEvent(32, isMir == 1 ? GameMap.screenWidth - 65 : 65, 165, 4, 0, 350);
                this.skillEvent(33, isMir == 1 ? GameMap.screenWidth - 38 : 38, 175, 4, 0, 350);
                this.skillEvent(34, isMir == 1 ? GameMap.screenWidth - 55 : 55, 208, 4, 0, 350);
                this.skillEvent(35, isMir == 1 ? GameMap.screenWidth - 25 : 25, 215, 4, 0, 350);
                break;
            }
            case 2: {
                this.skillFinshTime = (byte)43;
                if (this.skillTime >= 6) {
                    GameEngine.drawColorScreenBG(0, 20);
                }
                this.skillEvent(16, isMir == 1 ? GameMap.screenWidth - 80 : 80, 200, 18, 0, 350);
                this.skillEvent(16, isMir == 1 ? GameMap.screenWidth - 80 : 80, 170, 20, 0, 350);
                this.skillEvent(17, isMir == 1 ? GameMap.screenWidth - 40 : 40, 155, 18, 0, 350);
                this.skillEvent(17, isMir == 1 ? GameMap.screenWidth - 40 : 40, 125, 20, 0, 350);
                this.skillEvent(18, isMir == 1 ? GameMap.screenWidth - 60 : 60, 220, 18, 0, 350);
                this.skillEvent(18, isMir == 1 ? GameMap.screenWidth - 60 : 60, 190, 20, 0, 350);
                this.skillEvent(19, isMir == 1 ? GameMap.screenWidth - 20 : 20, 185, 18, 0, 350);
                this.skillEvent(19, isMir == 1 ? GameMap.screenWidth - 20 : 20, 155, 20, 0, 350);
                this.skillEvent(20, isMir == 1 ? GameMap.screenWidth - 80 : 80, 200, 18, 0, 350);
                this.skillEvent(20, isMir == 1 ? GameMap.screenWidth - 80 : 80, 170, 20, 0, 350);
                this.skillEvent(21, isMir == 1 ? GameMap.screenWidth - 40 : 40, 155, 18, 0, 350);
                this.skillEvent(21, isMir == 1 ? GameMap.screenWidth - 40 : 40, 125, 20, 0, 350);
                this.skillEvent(22, isMir == 1 ? GameMap.screenWidth - 60 : 60, 220, 18, 0, 350);
                this.skillEvent(22, isMir == 1 ? GameMap.screenWidth - 60 : 60, 190, 20, 0, 350);
                this.skillEvent(23, isMir == 1 ? GameMap.screenWidth - 20 : 20, 185, 18, 0, 350);
                this.skillEvent(23, isMir == 1 ? GameMap.screenWidth - 20 : 20, 155, 20, 0, 350);
                this.skillEvent(40, isMir == 1 ? GameMap.screenWidth - 80 : 80, 200, 4, 0, 350);
                this.skillEvent(40, isMir == 1 ? GameMap.screenWidth - 80 : 80, 170, 4, 0, 350);
                this.skillEvent(40, isMir == 1 ? GameMap.screenWidth - 40 : 40, 155, 4, 0, 350);
                this.skillEvent(40, isMir == 1 ? GameMap.screenWidth - 40 : 40, 125, 4, 0, 350);
                this.skillEvent(40, isMir == 1 ? GameMap.screenWidth - 60 : 60, 220, 4, 0, 350);
                this.skillEvent(40, isMir == 1 ? GameMap.screenWidth - 60 : 60, 190, 4, 0, 350);
                this.skillEvent(40, isMir == 1 ? GameMap.screenWidth - 20 : 20, 185, 4, 0, 350);
                this.skillEvent(40, isMir == 1 ? GameMap.screenWidth - 20 : 20, 155, 4, 0, 350);
                break;
            }
            case 6: {
                this.skillFinshTime = (byte)30;
                if (this.skillTime == 0) {
                    this.initSnowsData();
                } else {
                    GameEngine.drawColorScreenBG(0, 20);
                }
                this.skillEvent(10, isMir == 1 ? GameMap.screenWidth - 100 : 100, 152, 23, isMir, 233);
                this.skillEvent(11, isMir == 1 ? GameMap.screenWidth - 80 : 80, 90, 23, isMir, 171);
                this.skillEvent(11, isMir == 1 ? GameMap.screenWidth - 130 : 130, 120, 23, isMir, 201);
                this.skillEvent(12, isMir == 1 ? GameMap.screenWidth - 155 : 155, 160, 23, isMir, 241);
                this.skillEvent(13, isMir == 1 ? GameMap.screenWidth - 80 : 80, 135, 23, isMir, 216);
                this.skillEvent(13, isMir == 1 ? GameMap.screenWidth - 115 : 115, 110, 23, isMir, 191);
                this.skillEvent(14, isMir == 1 ? GameMap.screenWidth - 160 : 160, 78, 23, isMir, 159);
                this.skillEvent(14, isMir == 1 ? GameMap.screenWidth - 100 : 100, 78, 23, isMir, 159);
                this.skillEvent(15, isMir == 1 ? GameMap.screenWidth - 155 : 155, 128, 23, isMir, 209);
                this.skillEvent(15, isMir == 1 ? GameMap.screenWidth - 100 : 100, 135, 23, isMir, 216);
                this.skillEvent(16, isMir == 1 ? GameMap.screenWidth - 100 : 100, 152, 23, isMir, 233);
                this.skillEvent(17, isMir == 1 ? GameMap.screenWidth - 80 : 80, 90, 23, isMir, 171);
                this.skillEvent(17, isMir == 1 ? GameMap.screenWidth - 130 : 130, 120, 23, isMir, 201);
                this.skillEvent(18, isMir == 1 ? GameMap.screenWidth - 155 : 155, 160, 23, isMir, 241);
                this.skillEvent(19, isMir == 1 ? GameMap.screenWidth - 80 : 80, 135, 23, isMir, 216);
                this.skillEvent(19, isMir == 1 ? GameMap.screenWidth - 115 : 115, 110, 23, isMir, 191);
                this.skillEvent(20, isMir == 1 ? GameMap.screenWidth - 160 : 160, 78, 23, isMir, 159);
                this.skillEvent(20, isMir == 1 ? GameMap.screenWidth - 100 : 100, 78, 23, isMir, 159);
                this.skillEvent(21, isMir == 1 ? GameMap.screenWidth - 155 : 155, 128, 23, isMir, 209);
                this.skillEvent(21, isMir == 1 ? GameMap.screenWidth - 100 : 100, 135, 23, isMir, 216);
                this.skillEvent(13, 12);
            }
        }
        this.skillTime = (byte)(this.skillTime + 1);
        if (this.skillTime >= this.skillFinshTime) {
            this.skillFinshTime = 0;
            this.skillTime = 0;
            this.actionOver();
            return;
        }
    }

    public void drawSkillEft(int type, Fighter[] f, int isMir) {
        int i = 0;
        while (i < f.length) {
            switch (type) {
                case 17: {
                    this.skillFinshTime = (byte)9;
                    this.skillEvent(1, f[i].x, f[i].y - 15, 11, 0, f[i].y + 30 + 1);
                    break;
                }
                case 16: {
                    this.skillFinshTime = (byte)6;
                    this.skillEvent(1, f[i].x, f[i].y, 37, 0, f[i].y + 30 + 1);
                    break;
                }
                case 15: {
                    this.skillFinshTime = (byte)11;
                    this.skillEvent(1, f[i].x - 15, f[i].y - 10, 14, 0, f[i].y + 30 + 1);
                    this.skillEvent(4, f[i].x + 5, f[i].y - 5, 14, 0, f[i].y + 30 + 1);
                    this.skillEvent(6, f[i].x - 3, f[i].y + 2, 14, 0, f[i].y + 30 + 1);
                    break;
                }
                case 14: {
                    this.skillFinshTime = (byte)10;
                    this.skillEvent(1, f[i].x - 24, f[i].y, 12, 1, f[i].y + 30 + 1);
                    this.skillEvent(3, f[i].x, f[i].y, 12, 1, f[i].y + 30 + 1);
                    this.skillEvent(5, f[i].x + 24, f[i].y, 12, 1, f[i].y + 30 + 1);
                    this.skillEvent(1, 8);
                    break;
                }
                case 13: {
                    this.skillFinshTime = (byte)10;
                    this.skillEvent(1, f[i].x, f[i].y, 6, 0, f[i].y + 30 + 1);
                    this.skillEvent(6, f[i].x, f[i].y - 25, 4, 0, f[i].y + 30 + 1);
                    break;
                }
                case 12: {
                    this.skillFinshTime = (byte)40;
                    GameEngine.drawColorScreenBG(0, 20);
                    this.skillEvent(1, f[i].x - 70, f[i].y, 28, 1, f[i].y + 30 + 1);
                    this.skillEvent(21, f[i].x, f[i].y, 6, 0, f[i].y + 30 + 1);
                    this.skillEvent(27, f[i].x - 65 - 15, f[i].y - 40 + 8, 23, 1, f[i].y + 30 + 1);
                    this.skillEvent(28, f[i].x - 65, f[i].y - 40, 23, 1, f[i].y + 30 + 1);
                    this.skillEvent(29, f[i].x - 65 + 10, f[i].y - 40 - 5, 23, 1, f[i].y + 30 + 1);
                    this.skillEvent(33, f[i].x - 8, f[i].y - 30, 4, 0, f[i].y + 30 + 1);
                    this.skillEvent(34, f[i].x + 10, f[i].y - 20, 4, 0, f[i].y + 30 + 1);
                    this.skillEvent(35, f[i].x - 15, f[i].y - 10, 4, 0, f[i].y + 30 + 1);
                    break;
                }
                case 11: {
                    this.skillFinshTime = (byte)13;
                    this.skillEvent(1, f[i].x, f[i].y, 27, isMir, 30);
                    this.skillEvent(5, f[i].x, f[i].y, 27, isMir, 30);
                    this.skillEvent(4, f[i].x, f[i].y, 29, isMir, f[i].y + 30 + 1);
                    this.skillEvent(9, f[i].x, f[i].y, 27, isMir, 30);
                    this.skillEvent(4, 5);
                    break;
                }
                case 3: {
                    this.skillFinshTime = (byte)21;
                    this.skillEvent(1, f[i].x + (isMir == 1 ? -70 : 70), f[i].y, 28, isMir, f[i].y + 30 + 1);
                    this.skillEvent(7, f[i].x, f[i].y, 17, isMir, f[i].y + 30 + 1);
                    this.skillEvent(11, f[i].x, f[i].y, 17, isMir, f[i].y + 30 + 1);
                    this.skillEvent(15, f[i].x, f[i].y, 17, isMir, f[i].y + 30 + 1);
                    break;
                }
                case 4: {
                    this.skillFinshTime = (byte)65;
                    if (this.skillTime >= 1) {
                        GameEngine.drawColorScreenBG(0, 20);
                    }
                    if (this.skillTime == 1) {
                        this.ex = (short)(f[i].x + (isMir == 1 ? -55 : 55));
                        this.ey = (short)(f[i].y - 22);
                    }
                    this.skillEvent(28, 10);
                    this.skillEvent(28, f[i].x - 5, f[i].y - 40, 22, 0, f[i].y + 30 + 1);
                    this.skillEvent(30, f[i].x + 10, f[i].y - 30, 22, 0, f[i].y + 30 + 1);
                    this.skillEvent(32, f[i].x - 15, f[i].y - 20, 22, 0, f[i].y + 30 + 1);
                    this.skillEvent(34, f[i].x + 5, f[i].y - 10, 22, 0, f[i].y + 30 + 1);
                    this.skillEvent(34, f[i].x, f[i].y, 22, 0, f[i].y + 30 + 1);
                    this.skillEvent(54, this.ex, this.ey, 22, 0, 350);
                    break;
                }
                case 7: {
                    this.skillFinshTime = (byte)15;
                    this.skillEvent(1, f[i].x, f[i].y, 16, 0, f[i].y + 30 + 1);
                    break;
                }
                case 8: {
                    this.skillFinshTime = (byte)10;
                    this.skillEvent(1, f[i].x - 10, f[i].y - 25, 22, 0, f[i].y + 30 + 1);
                    this.skillEvent(1, f[i].x - 10, f[i].y - 25, 17, 1, f[i].y + 30 + 1);
                    this.skillEvent(4, f[i].x + 5, f[i].y - 15, 22, 0, f[i].y + 30 + 1);
                    this.skillEvent(4, f[i].x + 5, f[i].y - 15, 17, 1, f[i].y + 30 + 1);
                    this.skillEvent(6, f[i].x - 3, f[i].y - 5, 22, 0, f[i].y + 30 + 1);
                    this.skillEvent(6, f[i].x - 3, f[i].y - 5, 17, 1, f[i].y + 30 + 1);
                    break;
                }
                case 9: {
                    this.skillFinshTime = (byte)26;
                    GameEngine.drawColorScreenBG(0, 20);
                    this.skillEvent(1, 0, f[i].y - 17, 8, 0, f[i].y + 31);
                    this.skillEvent(1, 120, f[i].y - 17, 8, 0, f[i].y + 31);
                    this.skillEvent(1, f[i].x, f[i].y, 30, 0, f[i].y + 31);
                    this.skillEvent(4, f[i].x, f[i].y - 10, 17, 1, f[i].y + 30 + 1);
                    this.skillEvent(7, f[i].x, f[i].y - 10, 17, 1, f[i].y + 30 + 1);
                    this.skillEvent(10, f[i].x, f[i].y - 10, 17, 1, f[i].y + 30 + 1);
                    this.skillEvent(13, f[i].x, f[i].y - 10, 17, 1, f[i].y + 30 + 1);
                    this.skillEvent(16, f[i].x, f[i].y - 10, 17, 1, f[i].y + 30 + 1);
                    this.skillEvent(19, f[i].x, f[i].y - 10, 17, 1, f[i].y + 30 + 1);
                    this.skillEvent(22, f[i].x, f[i].y - 20, 22, 0, f[i].y + 30 + 1);
                    break;
                }
                case 10: {
                    this.skillFinshTime = (byte)19;
                    this.skillEvent(1, f[i].x - 5, f[i].y - 12, 30, 0, f[i].y + 31);
                    this.skillEvent(2, f[i].x, f[i].y, 30, 0, f[i].y + 31);
                    this.skillEvent(3, f[i].x + 5, f[i].y + 12, 30, 0, f[i].y + 31);
                    this.skillEvent(3, f[i].x, f[i].y - 10, 17, 1, f[i].y + 30 + 1);
                    this.skillEvent(7, f[i].x + 5, f[i].y - 12, 30, 1, f[i].y + 31);
                    this.skillEvent(8, f[i].x, f[i].y, 30, 1, f[i].y + 31);
                    this.skillEvent(9, f[i].x - 5, f[i].y + 12, 30, 1, f[i].y + 31);
                    this.skillEvent(9, f[i].x, f[i].y - 10, 17, 1, f[i].y + 30 + 1);
                    this.skillEvent(14, f[i].x, f[i].y - 12, 30, 0, f[i].y + 31);
                    this.skillEvent(14, f[i].x, f[i].y, 30, 0, f[i].y + 31);
                    this.skillEvent(14, f[i].x, f[i].y + 12, 30, 0, f[i].y + 31);
                    this.skillEvent(14, f[i].x, f[i].y - 12, 30, 1, f[i].y + 31);
                    this.skillEvent(14, f[i].x, f[i].y, 30, 1, f[i].y + 31);
                    this.skillEvent(14, f[i].x, f[i].y + 12, 30, 1, f[i].y + 31);
                    this.skillEvent(14, f[i].x, f[i].y - 10, 17, 1, f[i].y + 30 + 1);
                }
            }
            ++i;
        }
        this.skillTime = (byte)(this.skillTime + 1);
        if (this.skillTime >= this.skillFinshTime) {
            this.skillFinshTime = 0;
            this.skillTime = 0;
            this.actionOver();
            return;
        }
    }

    void skillEvent(int time, int x, int y, int type, int isMir, int drawLevel) {
        if (this.skillTime == time) {
            Effect.AddEffectList(x, y, type, isMir, drawLevel);
        }
    }

    void skillEvent(int time, int st) {
        if (this.skillTime == time) {
            shakeTime = (byte)st;
        }
    }

    public void drawWave(int x, int y, int rw, int rh) {
        Tools.addARC((byte)2, x - rw / 2 - 5 - 1, y - rh / 2 - 1, rw + 2, rh + 2, 0, 360, false, 20, 0xFFFFFF, 20);
    }

    public void initSnowsData() {
        int i = 0;
        while (i < this.snowData.length) {
            this.snowData[i][0] = (short)(GameMap.setOffX + GameEngine.nextInt(GameMap.screenWidth));
            this.snowData[i][1] = (short)(GameMap.setOffY + GameEngine.nextInt(GameMap.screenHeight));
            this.snowData[i][2] = (short)GameEngine.nextInt(2);
            ++i;
        }
    }

    void initLeafData(boolean isMir) {
        this.leafData = new short[10][3];
        int i = 0;
        while (i < this.leafData.length) {
            this.leafData[i][0] = (short)((isMir ? GameMap.screenWidth / 2 + 8 : 8) + i * GameEngine.nextInt(10, 14));
            this.leafData[i][1] = (short)(10 - GameEngine.nextInt(50));
            this.leafData[i][2] = (short)GameEngine.nextInt(7);
            ++i;
        }
    }

    void drawLeaf(boolean isMir) {
        int i = 0;
        while (i < this.leafData.length) {
            short[] sArray = this.leafData[i];
            sArray[0] = (short)(sArray[0] + GameEngine.nextInt(2) * (GameEngine.nextInt(1) == 0 ? -1 : 1));
            short[] sArray2 = this.leafData[i];
            sArray2[1] = (short)(sArray2[1] + GameEngine.nextInt(4, 7));
            Tools.addImage(31, this.leafData[i][0] - 6, this.leafData[i][1] + 6, this.leafData[i][2] * 13, 0, 13, 12, 36, (byte)0, 350);
            short[] sArray3 = this.leafData[i];
            sArray3[2] = (short)(sArray3[2] + 1);
            if (sArray3[2] >= 8) {
                this.leafData[i][2] = 0;
            }
            ++i;
        }
    }

    void addRoel1SDEft(int x, int y, int ex, int ey, int trans) {
        Vrsd.addElement(new int[]{x, y, ex, ey, trans, 0});
    }

    void drawRole0SD() {
        int i = 0;
        while (i < Vrsd.size()) {
            int wr;
            int[] temp = (int[])Vrsd.elementAt(i);
            int n = wr = temp[2] - temp[0] > 0 ? 4 : -4;
            int hr = temp[3] - temp[1] > 0 ? 3 : (temp[3] - temp[1] == 0 ? 0 : -3);
            int[][] addXY = new int[][]{{0, wr, wr * 2, wr * 3, temp[2] - temp[0] - wr * 3, temp[2] - temp[0] - wr * 2, temp[2] - temp[0] - wr, temp[2] - temp[0]}, {0, hr, hr * 2, hr * 3, temp[3] - temp[1] - hr * 3, temp[3] - temp[1] - hr * 2, temp[3] - temp[1] - hr, temp[3] - temp[1]}};
            Tools.addImage(41, temp[0] + addXY[0][temp[5]] + (temp[4] == 0 ? -49 : -20), temp[1] + addXY[1][temp[5]], 36, temp[4] == 0 ? (byte)0 : 1, temp[1] + addXY[1][temp[5]] + 30);
            temp[5] = temp[5] + 1;
            if (temp[5] >= addXY[0].length) {
                Vrsd.removeElementAt(i);
                --i;
            }
            ++i;
        }
    }

    void addBee(int x, int y, int sx, int sy, int ex, int ey, int wait, int trans) {
        VBee.addElement(new int[]{x, y, sx, sy, ex, ey, wait, trans, 0, 0, 0});
    }

    void drawBee() {
        byte[][] bee = new byte[][]{{-18, 14}, {-18, 13}, {-18, 15}};
        int i = 0;
        while (i < VBee.size()) {
            int sdy;
            int sdx;
            int[] temp = (int[])VBee.elementAt(i);
            int wait = temp[6];
            int[][] addXY = new int[][]{};
            if (temp[9] == 0) {
                temp[8] = temp[8] + 1;
                sdx = (temp[2] - temp[0]) / 4;
                sdy = (temp[3] - temp[1]) / 4;
                addXY = new int[][]{{sdx * 4, sdx * 3, sdx * 2, sdx, 0}, {sdy * 4, sdy * 3, sdy * 2, sdy, 0}};
                if (temp[8] >= addXY[0].length) {
                    temp[8] = 0;
                    temp[9] = 1;
                }
            } else if (temp[9] == 1) {
                temp[8] = temp[8] + 1;
                if (temp[8] >= wait) {
                    temp[8] = 0;
                    temp[9] = 2;
                }
            } else if (temp[9] == 2) {
                sdx = (temp[4] - temp[0]) / 4;
                sdy = (temp[5] - temp[1]) / 4;
                addXY = new int[][]{{0, sdx, sdx * 2, sdx * 3, sdx * 4, sdx * 5, sdx * 6}, {0, sdy, sdy * 2, sdy * 3, sdy * 4, sdy * 5, sdy * 6}};
                if (temp[8] == 4) {
                    Effect.AddEffectList(temp[0] + addXY[0][temp[8]] - 20, temp[1] + addXY[1][temp[8]] + 30, 30, temp[10] % 2 == 0 ? 0 : 1, 349);
                }
                if ((temp[8] = temp[8] + 1) >= addXY[0].length) {
                    VBee.removeElementAt(i);
                    --i;
                }
            }
            temp[10] = temp[10] + 1;
            ++i;
        }
    }

    void actionOver() {
        ++Battle.wait;
    }

    public static void addEnemy(int type) {
        vEnemys.addElement(new byte[]{(byte)type});
    }

    short getEveryLevel() {
        int level = 0;
        int i = 0;
        while (i < roleTeam.length) {
            level = (short)(level + GameEngine.role[GameEngine.roleTeam[i]].level);
            ++i;
        }
        return (short)(level / roleTeam.length);
    }

    public void initStar() {
        starPos = new short[20][2];
        starSpeed = new byte[20];
        int i = 0;
        while (i < 20) {
            GameEngine.starPos[i][0] = (short)(GameEngine.nextInt(9999) % 360 + GameMap.setOffX);
            GameEngine.starPos[i][1] = (short)(GameEngine.nextInt(9999) % 360 + GameMap.setOffY);
            GameEngine.starSpeed[i] = (byte)(GameEngine.nextInt(9999) % 3 + 1 + speedOfScroll);
            ++i;
        }
    }

    public void moveStar() {
        int i = 0;
        while (i < 20) {
            short[] sArray = starPos[i];
            sArray[0] = (short)(sArray[0] - (starSpeed[i] + speedOfScroll * 2));
            if (starPos[i][0] + starSpeed[i] < 0) {
                GameEngine.starPos[i][0] = (short)(360 + GameMap.setOffX);
                GameEngine.starPos[i][1] = (short)(GameEngine.nextInt(9999) % this.mapYPix + GameMap.setOffY);
                GameEngine.starSpeed[i] = (byte)(GameEngine.nextInt(9999) % 3 + 1);
            }
            ++i;
        }
    }

    public void drawStar(int x, int y, int drawLevel) {
        GameEngine.drawColorScreenBG(0, drawLevel);
        int offsetY = this.topScrollPos >> 1;
        int i = 0;
        while (i < 20) {
            int len = starSpeed[i] - 1 + speedOfScroll;
            Tools.addRect((byte)1, starPos[i][0], starPos[i][1] + offsetY, len, 1, true, 20, 33023, drawLevel);
            if (len > 0) {
                Tools.addRect((byte)1, starPos[i][0], starPos[i][1] + offsetY, (len >> 1) + (len >> 2), 1, true, 20, 0xFFFFFF, drawLevel);
            }
            ++i;
        }
    }

    static void fullHp() {
        int i = 0;
        while (i < role.length) {
            GameEngine.role[i].hp = 9999;
            GameEngine.role[i].mp = 9999;
            GameEngine.role[i].hp = Math.min(GameEngine.role[i].hp_max, 9999);
            GameEngine.role[i].mp = Math.min(GameEngine.role[i].mp_max, 9999);
            ++i;
        }
    }

    static void fullHp2(byte type) {
        GameEngine.role[type].hp = GameEngine.role[type].hp_max;
        GameEngine.role[type].mp = GameEngine.role[type].mp_max;
    }

    public static byte getIndex(byte id, byte[] data) {
        int i = 0;
        while (i < data.length) {
            if (id == data[i]) {
                return (byte)i;
            }
            ++i;
        }
        return -1;
    }

    public static short getImageIndex(String name) {
        int i = 0;
        while (i < Tools.FILESNAME.length) {
            if (name.equals(Tools.FILESNAME[i])) {
                return (short)i;
            }
            ++i;
        }
        return -1;
    }

    public void initImageData() {
        GameData.spriteClipData = new byte[47][][];
        GameData.spriteFrameData = new byte[47][][];
        GameData.spriteMotionData = new byte[47][][][];
        int i = 0;
        while (i < 47) {
            GameData.spriteClipData[i] = this.readClipData("/data/s" + i + "_c.bin");
            GameData.spriteFrameData[i] = this.readFrameData("/data/s" + i + "_f.bin");
            GameData.spriteMotionData[i] = this.readMotionData("/data/s" + i + "_m.bin");
            ++i;
        }
        GameData.fighterClipData = new byte[4][][];
        GameData.fighterFrameData = new byte[4][][];
        GameData.fighterAddjustData = new byte[4][][];
        int i2 = 0;
        while (i2 < 4) {
            GameData.fighterClipData[i2] = this.readClipData("/data/f" + i2 + "_c.bin");
            GameData.fighterFrameData[i2] = this.readFrameData("/data/f" + i2 + "_f.bin");
            ++i2;
        }
        int i3 = 0;
        while (i3 < GameData.fighterAddjustData.length) {
            GameData.fighterAddjustData[i3] = this.readClipData("/data/adjust" + i3 + ".bin");
            ++i3;
        }
        GameData.enemyClipData = new byte[33][][];
        GameData.enemyFrameData = new byte[33][][];
        GameData.enemyMotionData = new byte[33][][][];
        int i4 = 0;
        while (i4 < 33) {
            GameData.enemyClipData[i4] = this.readClipData("/data/d" + i4 + "_c.bin");
            GameData.enemyFrameData[i4] = this.readFrameData("/data/d" + i4 + "_f.bin");
            GameData.enemyMotionData[i4] = this.readMotionData("/data/d" + i4 + "_m.bin");
            ++i4;
        }
        GameData.effectClipData = new byte[40][][];
        GameData.effectFrameData = new byte[40][][];
        GameData.effectMotionData = new byte[40][][][];
        int i5 = 0;
        while (i5 < 40) {
            GameData.effectClipData[i5] = this.readClipData("/data/e" + i5 + "_c.bin");
            GameData.effectFrameData[i5] = this.readFrameData("/data/e" + i5 + "_f.bin");
            GameData.effectMotionData[i5] = this.readMotionData("/data/e" + i5 + "_m.bin");
            ++i5;
        }
    }

    public void initEquipment() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("equip.dat"));
        try {
            byte[] strBuff = null;
            short len = dis.readShort();
            equip = new Equipment[len];
            int i = 0;
            while (i < equip.length) {
                GameEngine.equip[i] = new Equipment(this);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.equip[i].name = new String(strBuff, "UTF-8");
                GameEngine.equip[i].type = dis.readByte();
                GameEngine.equip[i].level = dis.readByte();
                GameEngine.equip[i].property1 = dis.readShort();
                GameEngine.equip[i].property2 = dis.readShort();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String sp = new String(strBuff, "UTF-8");
                if (sp.equals("NULL")) {
                    GameEngine.equip[i].specialProperty = null;
                } else {
                    String[] params = Event.splitString(sp, ",");
                    GameEngine.equip[i].specialProperty = new short[params.length];
                    int j = 0;
                    while (j < params.length) {
                        GameEngine.equip[i].specialProperty[j] = (short)Event.sToi(params[j]);
                        ++j;
                    }
                }
                GameEngine.equip[i].price = dis.readShort();
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            System.out.println("equipment data error!");
            e.printStackTrace();
        }
    }

    boolean isGodEquip(int type) {
        return type == 6 || type == 13 || type == 25 || type == 32;
    }

    public void initPav() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("passive.dat"));
        try {
            byte[] strBuff = null;
            short len = dis.readShort();
            pav = new Passive[len];
            int i = 0;
            while (i < pav.length) {
                GameEngine.pav[i] = new Passive(this);
                GameEngine.pav[i].id = dis.readByte();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.pav[i].name = new String(strBuff, "UTF-8");
                GameEngine.pav[i].range = dis.readByte();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.pav[i].info = new String(strBuff, "UTF-8");
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            System.out.println("passive dat error!");
        }
    }

    public void initFood() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("food.dat"));
        try {
            byte[] strBuff = null;
            short len = dis.readShort();
            food = new Food[len];
            int i = 0;
            while (i < food.length) {
                GameEngine.food[i] = new Food();
                GameEngine.food[i].type = dis.readByte();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.food[i].name = new String(strBuff, "UTF-8");
                GameEngine.food[i].price = dis.readInt();
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            System.out.println("food dat error!");
        }
    }

    public void initDish() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("dish.dat"));
        try {
            byte[] strBuff = null;
            short len = dis.readShort();
            dish = new Dish[len];
            int i = 0;
            while (i < dish.length) {
                GameEngine.dish[i] = new Dish(this);
                GameEngine.dish[i].type = dis.readByte();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.dish[i].name = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.dish[i].info = new String(strBuff, "UTF-8");
                GameEngine.dish[i].range = dis.readByte();
                GameEngine.dish[i].useCondition = dis.readByte();
                GameEngine.dish[i].addHP = dis.readShort();
                GameEngine.dish[i].addMP = dis.readShort();
                GameEngine.dish[i].addHpMax = dis.readShort();
                GameEngine.dish[i].addMpMax = dis.readShort();
                GameEngine.dish[i].addStrength = dis.readShort();
                GameEngine.dish[i].addDefend = dis.readShort();
                GameEngine.dish[i].addFlash = dis.readShort();
                GameEngine.dish[i].addMiss = dis.readShort();
                GameEngine.dish[i].price = dis.readInt();
                ++i;
            }
            dis.close();
        }
        catch (Exception ex) {
            System.out.println("dish dat error!!");
        }
    }

    public void initFighterData() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("fighter.dat"));
        try {
            int len = dis.readShort();
            byte[] strBuff = null;
            GameData.fighterName = new String[len];
            GameData.fighterSkillData = new byte[len][];
            GameData.fighterVauleData = new int[len][12];
            int i = 0;
            while (i < len) {
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameData.fighterName[i] = new String(strBuff, "UTF-8");
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String skill = new String(strBuff, "UTF-8");
                if (skill.equals("NULL")) {
                    GameData.fighterSkillData[i] = null;
                } else {
                    String[] params = Event.splitString(skill, ",");
                    GameData.fighterSkillData[i] = new byte[params.length];
                    int j = 0;
                    while (j < params.length) {
                        GameData.fighterSkillData[i][j] = (byte)Event.sToi(params[j]);
                        ++j;
                    }
                }
                GameData.fighterVauleData[i][0] = dis.readByte();
                GameData.fighterVauleData[i][1] = dis.readByte();
                GameData.fighterVauleData[i][2] = dis.readInt();
                GameData.fighterVauleData[i][3] = dis.readShort();
                GameData.fighterVauleData[i][4] = dis.readShort();
                GameData.fighterVauleData[i][5] = dis.readShort();
                GameData.fighterVauleData[i][6] = dis.readByte();
                GameData.fighterVauleData[i][7] = dis.readByte();
                GameData.fighterVauleData[i][8] = dis.readByte();
                GameData.fighterVauleData[i][9] = dis.readByte();
                GameData.fighterVauleData[i][10] = dis.readByte();
                GameData.fighterVauleData[i][11] = dis.readByte();
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            System.out.println("fighter data error!");
        }
    }

    public boolean canUseSkill(Fighter r, Skill skill, boolean isBattle) {
        if (skill.useCondition != 0 && r.hp >= skill.lossHP / this.jn && r.mp >= skill.lossMP / this.jn) {
            if (skill.useCondition == 3) {
                return true;
            }
            return isBattle ? skill.useCondition == 2 : skill.useCondition == 1;
        }
        return false;
    }

    void skillReduce(Fighter r, Skill sk) {
        r.hp -= sk.lossHP / this.jn;
        r.mp -= sk.lossMP / this.jn;
        r.hp = Math.max(1, r.hp);
        r.mp = Math.max(0, r.mp);
    }

    void removeBuff(byte type, Fighter f) {
        switch (type) {
            case 1: {
                f.setStatus((byte)0);
                break;
            }
            case 6: {
                f.buff[4] = new short[2];
                f.buff[2] = new short[2];
                f.buff[3] = new short[2];
            }
        }
    }

    static byte getBagEmpty(byte[][] data) {
        byte a2 = 0;
        int i = 0;
        while (i < data.length) {
            if (data[i][0] == 0) {
                a2 = (byte)(a2 + 1);
            }
            ++i;
        }
        return a2;
    }

    int getFoodNum(byte kind) {
        int i = 0;
        while (i < foodData.length) {
            if (kind == foodData[i][2]) {
                return foodData[i][0];
            }
            ++i;
        }
        return 0;
    }

    public void initTask() {
        String[] lines = Event.splitString(Script.loadTxt("/task.txt"), "\n");
        GameData.taskInfo = new String[lines.length];
        int i = 0;
        while (i < GameData.taskInfo.length) {
            GameData.taskInfo[i] = Event.splitString(lines[i], " ")[1];
            ++i;
        }
    }

    public void initSkill() {
        DataInputStream dis = new DataInputStream(this.getClass().getResourceAsStream("skill.dat"));
        try {
            short len = dis.readShort();
            byte[] strBuff = null;
            sk = new Skill[len];
            int i = 0;
            while (i < sk.length) {
                String[] params;
                GameEngine.sk[i] = new Skill(this);
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                GameEngine.sk[i].name = new String(strBuff, "UTF-8");
                switch (i) {
                    case 1: {
                        GameEngine.sk[i].info = "\u5355\u4f53140%\u4f24\u5bb3";
                        break;
                    }
                    case 2: {
                        GameEngine.sk[i].info = "\u5355\u4f53400%\u4f24\u5bb3";
                        break;
                    }
                    case 3: {
                        GameEngine.sk[i].info = "\u5355\u4f53280%\u4f24\u5bb3";
                        break;
                    }
                    case 4: {
                        GameEngine.sk[i].info = "\u7fa4\u4f53160%\u4f24\u5bb3";
                        break;
                    }
                    case 6: {
                        GameEngine.sk[i].info = "\u5355\u4f53140%\u4f24\u5bb3";
                        break;
                    }
                    case 7: {
                        GameEngine.sk[i].info = "\u7fa4\u4f53400%\u4f24\u5bb3";
                        break;
                    }
                    case 8: {
                        GameEngine.sk[i].info = "\u5355\u4f53\u751f\u547d\u56de\u590d";
                        break;
                    }
                    case 9: {
                        GameEngine.sk[i].info = "\u7fa4\u4f53250%\u4f24\u5bb3";
                        break;
                    }
                    case 11: {
                        GameEngine.sk[i].info = "\u5355\u4f53130%\u4f24\u5bb3";
                        break;
                    }
                    case 12: {
                        GameEngine.sk[i].info = "\u7fa4\u4f53160%\u4f24\u5bb3";
                        break;
                    }
                    case 13: {
                        GameEngine.sk[i].info = "\u7fa4\u4f53\u751f\u547d\u56de\u590d";
                        break;
                    }
                    case 14: {
                        GameEngine.sk[i].info = "\u7fa4\u4f53300%\u4f24\u5bb3";
                        break;
                    }
                    case 17: {
                        GameEngine.sk[i].info = "\u590d\u6d3b\u6b7b\u4ea1\u540c\u4f34";
                        break;
                    }
                    case 18: {
                        GameEngine.sk[i].info = "4\u56de\u5408\u5185\u653b\u51fb\u500d\u589e";
                        break;
                    }
                    case 43: {
                        GameEngine.sk[i].info = "\u5355\u4f53160%\u4f24\u5bb3";
                        break;
                    }
                    case 44: {
                        GameEngine.sk[i].info = "\u5355\u4f53300%\u4f24\u5bb3";
                        break;
                    }
                    case 45: {
                        GameEngine.sk[i].info = "\u7fa4\u4f53180%\u4f24\u5bb3";
                        break;
                    }
                    case 46: {
                        GameEngine.sk[i].info = "\u7fa4\u4f53\u751f\u547d\u56de\u590d";
                        break;
                    }
                    case 47: {
                        GameEngine.sk[i].info = "\u7fa4\u4f53500%\u4f24\u5bb3";
                    }
                }
                GameEngine.sk[i].formula = dis.readByte();
                GameEngine.sk[i].useCondition = dis.readByte();
                GameEngine.sk[i].range = dis.readByte();
                GameEngine.sk[i].fashion = dis.readByte();
                GameEngine.sk[i].effectType = dis.readByte();
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String buff = new String(strBuff, "UTF-8");
                if (buff.equals("null")) {
                    GameEngine.sk[i].buff = null;
                } else {
                    params = Event.splitString(buff, ",");
                    GameEngine.sk[i].buff = new short[params.length];
                    int j = 0;
                    while (j < params.length) {
                        GameEngine.sk[i].buff[j] = (short)Event.sToi(params[j]);
                        ++j;
                    }
                }
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String hits = new String(strBuff, "UTF-8");
                if (hits.equals("null")) {
                    GameEngine.sk[i].hitIndex = null;
                } else {
                    params = Event.splitString(hits, ",");
                    GameEngine.sk[i].hitIndex = new byte[params.length];
                    int j = 0;
                    while (j < params.length) {
                        GameEngine.sk[i].hitIndex[j] = (byte)Event.sToi(params[j]);
                        ++j;
                    }
                }
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String perHurts = new String(strBuff, "UTF-8");
                if (perHurts.equals("null")) {
                    GameEngine.sk[i].perHurt = null;
                } else {
                    params = Event.splitString(perHurts, ",");
                    GameEngine.sk[i].perHurt = new short[params.length];
                    int j = 0;
                    while (j < params.length) {
                        GameEngine.sk[i].perHurt[j] = (short)Event.sToi(params[j]);
                        ++j;
                    }
                }
                strBuff = new byte[dis.readShort()];
                dis.read(strBuff);
                String numHurts = new String(strBuff, "UTF-8");
                if (numHurts.equals("null")) {
                    GameEngine.sk[i].numHurt = null;
                } else {
                    params = Event.splitString(numHurts, ",");
                    GameEngine.sk[i].numHurt = new int[params.length];
                    int j = 0;
                    while (j < params.length) {
                        GameEngine.sk[i].numHurt[j] = Event.sToi(params[j]);
                        ++j;
                    }
                }
                GameEngine.sk[i].removeBuff = dis.readByte();
                GameEngine.sk[i].lossHP = dis.readShort();
                GameEngine.sk[i].lossMP = dis.readShort();
                GameEngine.sk[i].lossEP = dis.readByte();
                GameEngine.sk[i].incureTime = dis.readByte();
                GameEngine.sk[i].skillIcon = dis.readByte();
                ++i;
            }
            dis.close();
        }
        catch (Exception e) {
            System.out.println("skill data error!");
        }
    }

    public void initBomb() {
        this.bombs = null;
        short[][] temp = this.readItemData("/data/b" + GameMap.mapID + ".bin");
        if (temp == null) {
            return;
        }
        this.bombs = new short[temp.length][8];
        int i = 0;
        while (i < this.bombs.length) {
            this.bombs[i][0] = temp[i][1];
            this.bombs[i][1] = temp[i][2];
            if (temp[i][3] == -1) {
                this.bombs[i][2] = 0;
                this.bombs[i][3] = 0;
            } else {
                this.bombs[i][2] = temp[i][3];
                switch (this.bombs[i][2]) {
                    case 0: {
                        this.bombs[i][2] = 3;
                        break;
                    }
                    case 1: {
                        this.bombs[i][2] = 0;
                        break;
                    }
                    case 3: {
                        this.bombs[i][2] = 1;
                    }
                }
                this.bombs[i][3] = 1;
                this.bombs[i][4] = (short)GameEngine.nextInt(12);
                switch (this.bombs[i][2]) {
                    case 0: {
                        short[] sArray = this.bombs[i];
                        sArray[0] = (short)(sArray[0] + this.bombs[i][4] * 4);
                        break;
                    }
                    case 2: {
                        short[] sArray = this.bombs[i];
                        sArray[1] = (short)(sArray[1] + this.bombs[i][4] * 4);
                    }
                }
            }
            this.bombs[i][5] = (short)GameEngine.nextInt(2);
            ++i;
        }
    }

    public static short[] getSpeed(int sx, int sy, int ex, int ey, int lot) {
        short[] values = new short[]{(short)((ex - sx) / lot), (short)((ey - sy) / lot)};
        if (values[0] == 0 && values[1] == 0) {
            values[0] = 1;
            values[1] = 1;
        }
        return values;
    }

    public void moveBomb() {
        if (this.bombs == null) {
            return;
        }
        if (!Script.isUserCtrl || Event.isChangeMap) {
            return;
        }
        int objX = GameEngine.sprite[GameEngine.spriteIndex].x + 8;
        int objY = GameEngine.sprite[GameEngine.spriteIndex].y - 8;
        int i = 0;
        while (i < this.bombs.length) {
            if (this.bombs[i][3] == 4) {
                short[] sArray = this.bombs[i];
                sArray[5] = (short)(sArray[5] + 1);
                if (sArray[5] > 250) {
                    this.bombs[i][3] = 1;
                    this.bombs[i][5] = 0;
                }
            } else {
                switch (this.bombs[i][3]) {
                    case 0: {
                        if (Math.abs(this.bombs[i][0] - objX) >= 31 || Math.abs(this.bombs[i][1] - objY) >= 31) break;
                        this.bombs[i][3] = 2;
                        this.bombs[i][6] = 10;
                        break;
                    }
                    case 1: {
                        int mx;
                        int n = this.bombs[i][2] == 0 ? 1 : (mx = this.bombs[i][2] == 1 ? -1 : 0);
                        int my = this.bombs[i][2] == 2 ? 1 : (this.bombs[i][2] == 3 ? -1 : 0);
                        short[] sArray = this.bombs[i];
                        sArray[0] = (short)(sArray[0] + 4 * mx);
                        short[] sArray2 = this.bombs[i];
                        sArray2[1] = (short)(sArray2[1] + 4 * my);
                        short[] sArray3 = this.bombs[i];
                        sArray3[4] = (short)(sArray3[4] + 1);
                        if (sArray3[4] > 12) {
                            this.bombs[i][4] = 0;
                            short[] sArray4 = this.bombs[i];
                            sArray4[2] = (short)(sArray4[2] ^ 1);
                        }
                        if (Math.abs(this.bombs[i][0] - objX) >= 31 || Math.abs(this.bombs[i][1] - objY) >= 31 || stopBomb) break;
                        this.bombs[i][3] = 2;
                        this.bombs[i][6] = 10;
                        break;
                    }
                    case 2: {
                        if (Math.abs(this.bombs[i][0] - objX) >= 31 || Math.abs(this.bombs[i][1] - objY) >= 31) {
                            this.bombs[i][3] = 0;
                            break;
                        }
                        short[] speed = GameEngine.getSpeed(this.bombs[i][0], this.bombs[i][1], objX, objY, this.bombs[i][6]);
                        if (this.bombs[i][6] > 1) {
                            short[] sArray = this.bombs[i];
                            sArray[6] = (short)(sArray[6] - 1);
                        }
                        short[] sArray = this.bombs[i];
                        sArray[0] = (short)(sArray[0] + speed[0]);
                        short[] sArray5 = this.bombs[i];
                        sArray5[1] = (short)(sArray5[1] + speed[1]);
                        if (Math.abs(this.bombs[i][0] - objX) >= 5 || Math.abs(this.bombs[i][1] - objY) >= 5 || MyGameCanvas.gameStatus != 7 || GameEngine.sprite[GameEngine.spriteIndex].x != GameEngine.sprite[GameEngine.spriteIndex].ax || GameEngine.sprite[GameEngine.spriteIndex].y != GameEngine.sprite[GameEngine.spriteIndex].ay + 1) break;
                        this.bombs[i][3] = 3;
                        this.bomb();
                        break;
                    }
                    case 3: {
                        this.bombs[i][3] = 4;
                    }
                }
                short[] sArray = this.bombs[i];
                sArray[5] = (short)(sArray[5] + 1);
                if (sArray[5] >= 3) {
                    this.bombs[i][5] = 0;
                }
            }
            ++i;
        }
    }

    public void drawBomb() {
        if (this.bombs == null || Script.curEvent != -1) {
            return;
        }
        int i = 0;
        while (i < this.bombs.length) {
            if (this.bombs[i][3] != 4) {
                this.drawShandow(this.bombs[i][0], this.bombs[i][1], 14, 6, 0, 30);
                Tools.addImage(6, this.bombs[i][0] - 8, this.bombs[i][1] - 4, 20 * this.bombs[i][5], 0, 20, 41, 36, (byte)0, this.bombs[i][1] + 30);
            }
            ++i;
        }
    }

    public short[][] readItemData(String name) {
        InputStream in = this.getClass().getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        DataInputStream is = new DataInputStream(in);
        short[][] dat = null;
        try {
            int len = is.readShort();
            dat = new short[len][];
            int i = 0;
            while (i < len) {
                int gLen = is.readByte();
                dat[i] = new short[gLen];
                int j = 0;
                while (j < gLen) {
                    dat[i][j] = is.readShort();
                    ++j;
                }
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dat;
    }

    public byte[][][] readMotionData(String name) {
        InputStream in = this.getClass().getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        DataInputStream is = new DataInputStream(in);
        byte[][][] motion = null;
        int motionLen = 0;
        try {
            motionLen = is.readByte();
            motion = new byte[15][][];
            int i = 0;
            while (i < motionLen) {
                byte st = is.readByte();
                int zs = is.readByte();
                motion[st] = new byte[zs][7];
                int j = 0;
                while (j < zs) {
                    int m = 0;
                    while (m < 7) {
                        motion[st][j][m] = is.readByte();
                        ++m;
                    }
                    ++j;
                }
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            System.out.println("not find file:" + name);
            e.printStackTrace();
        }
        return motion;
    }

    public byte[][] readClipData(String name) {
        InputStream in = this.getClass().getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        DataInputStream is = new DataInputStream(in);
        byte[][] clip = null;
        int clipLen = 0;
        try {
            clipLen = is.readShort();
            clip = new byte[clipLen][4];
            int i = 0;
            while (i < clipLen) {
                clip[i][0] = is.readByte();
                clip[i][1] = is.readByte();
                clip[i][2] = is.readByte();
                clip[i][3] = is.readByte();
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            System.out.println("not find file:" + name);
            e.printStackTrace();
        }
        return clip;
    }

    public byte[][] readFrameData(String name) {
        InputStream in = this.getClass().getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        DataInputStream is = new DataInputStream(in);
        byte[][] frame = null;
        try {
            int len = is.readByte();
            frame = new byte[len][];
            int i = 0;
            while (i < len) {
                int gLen = is.readByte() * 5;
                frame[i] = new byte[gLen];
                int j = 0;
                while (j < gLen) {
                    frame[i][j] = is.readByte();
                    ++j;
                }
                ++i;
            }
            is.close();
        }
        catch (Exception e) {
            System.out.println("not find file:" + name);
            e.printStackTrace();
        }
        return frame;
    }

    static void noStop() {
        int i = 0;
        while (i < sprite.length) {
            GameEngine.sprite[i].isStop = false;
            ++i;
        }
    }

    public static String[] getSpecialInfo(short[] dat) {
        String[] s = null;
        if (dat == null) {
            return null;
        }
        int len = dat.length / 2;
        s = new String[len];
        int i = 0;
        while (i < len) {
            short type = dat[i * 2];
            short vaule = dat[i * 2 + 1];
            s[i] = GameEngine.getSpecialInfo(type, vaule);
            ++i;
        }
        return s;
    }

    public static String getSpecialInfo(int type, int vaule) {
        switch (type) {
            case 1: {
                return "\u547d\u4e0a\u9650+" + vaule;
            }
            case 2: {
                return "\u7cbe\u4e0a\u9650+" + vaule;
            }
            case 3: {
                return "\u7206\u51fb+" + vaule;
            }
            case 4: {
                return "\u8eb2\u907f+" + vaule;
            }
            case 5: {
                return "\u6297\u6bd2+" + vaule;
            }
            case 6: {
                return "\u6297\u5c01+" + vaule;
            }
        }
        return "";
    }

    public short getExpmax(int level) {
        if (level >= 20) {
            return (short)((3 * (level + 1) + 4 * (level - 1) * level) * 5 / 2);
        }
        if (level >= 10) {
            return (short)((3 * (level + 1) + 4 * (level - 1) * level) * 9 / 4);
        }
        if (level >= 4) {
            return (short)((3 * (level + 1) + 4 * (level - 1) * level) * 7 / 4);
        }
        return (short)(3 * (level + 1) + 4 * (level - 1) * level);
    }

    int addHpFormula(int persent, int max, int base) {
        return base;
    }

    public static int commonFormula(Fighter role, Fighter enemy, Skill sk, int skIndex, boolean isPhurt, boolean isMiss) {
        if (!enemy.isHited && isMiss) {
            return 0;
        }
        short attack = isPhurt ? GameEngine.getStrength(role) : GameEngine.getMagic(role);
        short defend = isPhurt ? enemy.defend : enemy.resist;
        byte immPer = isPhurt ? enemy.pimm : enemy.mimm;
        short perHurt = sk.perHurt == null ? (short)0 : sk.perHurt[skIndex];
        int numHurt = sk.numHurt == null ? 0 : sk.numHurt[skIndex];
        return Math.max(((attack - defend / 2) * perHurt / 100 + numHurt) * (role.isFlash ? (int)role.flashHit : 200) / 100, 1) + GameEngine.nextInt(5) - GameEngine.nextInt(5);
    }

    public static int cureFormula(Fighter role, Fighter enemy, Skill sk, int skIndex) {
        if (!enemy.isHited) {
            return 0;
        }
        int hpMax = enemy.hp_max;
        short perHurt = sk.perHurt == null ? (short)0 : sk.perHurt[skIndex];
        int numHurt = sk.numHurt == null ? 0 : sk.numHurt[skIndex];
        return (hpMax * perHurt / 100 + numHurt) * (role.isFlash ? (int)role.flashHit : 200) / 100;
    }

    public static short getStrength(Fighter f) {
        return (short)(f.strength * (100 + f.buff[5][1] + f.patt) / 100 + GameEngine.nextInt(5) - GameEngine.nextInt(5));
    }

    public static short getMagic(Fighter f) {
        return (short)(f.magic * (100 + f.buff[5][1] + f.matt) / 100);
    }

    public static String getSkillInfo(Skill skill) {
        if (skill.fashion == 0) {
            return null;
        }
        return skill.info + "," + GameEngine.getReduce(skill);
    }

    static String getRange(Skill skill) {
        switch (skill.range) {
            case 3: {
                return "\u654c\u5355\u4f53";
            }
            case 4: {
                return "\u654c\u7fa4\u4f53";
            }
            case 1: {
                return "\u5df1\u5355\u4f53";
            }
            case 2: {
                return "\u5df1\u7fa4\u4f53";
            }
        }
        return "";
    }

    static String getStr(Skill skill) {
        int a2 = 0;
        int i = 0;
        while (i < skill.perHurt.length) {
            a2 += skill.perHurt[i];
            ++i;
        }
        return a2 + "%";
    }

    static String getFormula(Skill skill) {
        switch (skill.formula) {
            case 4: {
                if (skill.removeBuff == 6) {
                    return "\u79fb\u9664\u4e0d\u826f\u72b6\u6001";
                }
                if (skill.removeBuff == 1) {
                    return "\u590d\u6d3b";
                }
                if (skill.buff != null && skill.buff[0] == 5) {
                    return "\u653b\u51fb\u63d0\u5347";
                }
                if (skill.perHurt == null && skill.numHurt == null) break;
                return "\u56de\u590d\u751f\u547d";
            }
        }
        return "\u7269\u7406\u4f24\u5bb3";
    }

    static String getReduce(Skill skill) {
        if (skill.lossMP == 0 && skill.lossEP == 0) {
            return "";
        }
        return "\u9700" + (skill.lossMP != 0 ? skill.lossMP + "\u70b9\u7cbe" : skill.lossEP + "\u70b9\u6c14");
    }

    public static String getItemInfo(Item item) {
        return GameEngine.getItemRange(item) + GameEngine.getItemType(item) + GameEngine.getItemVaule(item);
    }

    static String getItemRange(Item item) {
        switch (item.range) {
            case 1: {
                return "\u5df1\u5355\u4f53";
            }
            case 2: {
                return "\u5df1\u7fa4\u4f53";
            }
            case 5: {
                return "\u5df1\u6b7b\u4ea1";
            }
        }
        return "";
    }

    static String getItemType(Item item) {
        switch (item.type) {
            case 0: 
            case 1: {
                return "\u56de\u590d";
            }
            case 2: {
                return "\u5f97\u5230";
            }
            case 3: {
                return "\u590d\u6d3b";
            }
        }
        return "";
    }

    static String getItemVaule(Item item) {
        switch (item.type) {
            case 0: {
                return item.property1 + "\u70b9\u547d";
            }
            case 1: {
                return item.property2 + "\u70b9\u7cbe";
            }
            case 2: {
                return GameEngine.sk[item.property3].name + "\u4e00\u672c";
            }
            case 3: {
                return item.property1 + "\u70b9\u547d";
            }
        }
        return "";
    }

    byte getRndGift() {
        byte num = (byte)GameEngine.nextInt(0, 9);
        int length = 0;
        if (num >= 3) {
            this.speed = GameEngine.isHavePav(8) > 0 ? (byte)2 : (byte)10;
            length = gift.length - 1;
            return (byte)GameEngine.nextInt(0, length);
        }
        this.speed = GameEngine.isHavePav(8) > 0 ? (byte)2 : (byte)10;
        length = this.goldGift.length - 1;
        return (byte)GameEngine.nextInt(0, length);
    }

    boolean roll(int odds) {
        int a2 = GameEngine.nextInt(0, 9);
        if (GameEngine.isHavePav(8) > 0) {
            a2 = 1;
        }
        return odds > a2;
    }

    int getSucceeOdds() {
        if (this.ballX == 54) {
            return 8;
        }
        if (this.ballX < 54 && this.ballX >= 51 || this.ballX <= 57 && this.ballX > 54) {
            return 6;
        }
        if (this.ballX < 51 && this.ballX > 48 || this.ballX < 60 && this.ballX > 57) {
            return 4;
        }
        return 0;
    }

    void drawFishRun(int x, int y) {
        if (this.times == 0) {
            this.isBeginFish = true;
        }
        Tools.addColorString((byte)4, "\u5782\u9493\u4e2d...   " + this.times + "/10", x + 5, y - 25, 20, 0, 0xFFFFFF, 10005);
        this.canvas.drawBar((short)255, this.canvas.bar1Data, x - 10, y - 40, 140, 60, 15062383, 10001, false);
        Tools.addImage(267, x, y, 20, (byte)1, 10002);
        Tools.addImage(267, x + 60, y, 20, (byte)0, 10002);
        Tools.addImage(254, x + this.ballX, y, 20, (byte)0, 10002);
        if (this.times >= 10) {
            MyGameCanvas.gameStatus = (byte)7;
            this.isBeginFish = false;
            this.times = 0;
        }
        this.ballRun();
    }

    void drawFishWin(int x, int y) {
        this.canvas.drawBar((short)255, this.canvas.bar1Data, x - 10, y - 40, 140, 60, 15062383, 10001, false);
        Tools.addImage(267, x, y, 20, (byte)1, 10002);
        Tools.addImage(267, x + 60, y, 20, (byte)0, 10002);
        Tools.addImage(254, x + this.ballX, y, 20, (byte)0, 10002);
        if (this.isSusseed) {
            Tools.addColorString((byte)4, "\u9493\u5230\u4e86 !", x + 20, y - 25, 20, 0, 0xFFFFFF, 10005);
            if (++this.fishTime > 10) {
                if (GameEngine.nextInt(10) % 2 == 0) {
                    GameEngine.getFood(gift[this.getRndGift()], 1);
                } else {
                    GameEngine.getFood(this.goldGift[this.getRndGift()], 1);
                }
                this.ballX = 0;
                this.isSusseed = false;
                this.fishTime = 0;
                FISHST = 0;
            }
        } else {
            Tools.addColorString((byte)4, "\u52a0\u6cb9 =\u3002=", x + 20, y - 25, 20, 0, 0xFFFFFF, 10005);
            if (++this.fishTime > 10) {
                MyGameCanvas.ToAside(new String[]{"\u9c7c\u8dd1\u6389\u4e86!!"});
                this.fishTime = 0;
                this.ballX = 0;
                this.choice = 0;
                FISHST = 0;
            }
        }
    }

    void drawReady(int x, int y) {
        this.times = 0;
        this.canvas.drawBar((short)255, this.canvas.bar1Data, x, y - 10, 120, 60, 15062383, 10001, false);
        Tools.addString((byte)4, "\u662f\u5426\u9493\u9c7c?", x + 20, y, 20, 4695761, 10003);
        Tools.addString((byte)4, "\u662f", x + 30, y + 30, 20, this.choice == 0 ? 0xFFFFFF : 4695761, 10003);
        Tools.addString((byte)4, "\u5426", x + 70, y + 30, 20, this.choice == 0 ? 4695761 : 0xFFFFFF, 10003);
        Tools.addImage(255, x + (this.choice == 0 ? 20 : 60), y + 25, 76, 50, 39, 24, 20, (byte)0, 10002);
        this.speed = GameEngine.isHavePav(8) > 0 ? (byte)2 : (byte)10;
    }

    void ballRun() {
        if (this.isTurnL) {
            if (this.ballX <= 0) {
                this.isTurnL = !this.isTurnL;
            } else {
                this.ballX -= this.speed;
            }
        } else if (this.ballX >= this.len - this.ballR) {
            this.isTurnL = !this.isTurnL;
        } else {
            this.ballX += this.speed;
        }
    }

    public void drawFish(Graphics g) {
        this.drawGame(g);
        switch (FISHST) {
            case 4: {
                this.drawReady(GameMap.setOffX + 60, GameMap.setOffY + 100);
                break;
            }
            case 3: {
                break;
            }
            case 1: {
                this.drawFishWin(GameMap.setOffX + 60, GameMap.setOffY + 100);
                break;
            }
            case 0: {
                this.drawFishRun(GameMap.setOffX + 60, GameMap.setOffY + 100);
            }
        }
    }

    public void ctrlFish(int keyCode) {
        block0 : switch (FISHST) {
            case 0: {
                switch (keyCode) {
                    case -5: 
                    case 53: {
                        this.isSusseed = false;
                        if (this.roll(this.getSucceeOdds())) {
                            this.isSusseed = true;
                        }
                        FISHST = 1;
                        this.times = (byte)(this.times + 1);
                    }
                }
                break;
            }
            case 4: {
                switch (keyCode) {
                    case -5: 
                    case 53: {
                        if (this.choice == 0) {
                            this.isBeginFish = true;
                            FISHST = 0;
                            break block0;
                        }
                        this.ballX = 0;
                        FISHST = (byte)4;
                        MyGameCanvas.setST((byte)7);
                        break block0;
                    }
                    case -3: 
                    case 52: {
                        this.choice = 0;
                        break block0;
                    }
                    case -4: 
                    case 54: {
                        this.choice = 1;
                    }
                }
            }
        }
    }

    public void upDateRolePav(Fighter f) {
        switch (f.type) {
            case 0: {
                GameEngine.role[0].flash = (byte)(GameEngine.role[0].flash + roleSP[0][0] * 3);
                GameEngine.role[0].strength = (short)(GameEngine.role[0].strength + roleSP[1][0] * 7);
                break;
            }
            case 1: {
                GameEngine.role[1].miss = (byte)(GameEngine.role[1].miss + roleSP[2][0] * 3);
                GameEngine.role[1].strength = (short)(GameEngine.role[1].strength + roleSP[3][0] * 7);
                break;
            }
            case 2: {
                GameEngine.role[2].hp_max = (short)(GameEngine.role[2].hp_max + roleSP[4][0] * 20);
                GameEngine.role[2].mp_max = (short)(GameEngine.role[2].mp_max + roleSP[5][0] * 10);
                break;
            }
            case 3: {
                GameEngine.role[3].miss = (byte)(GameEngine.role[3].miss + roleSP[6][0] * 3);
                GameEngine.role[3].mp_max = (short)(GameEngine.role[3].mp_max + roleSP[7][0] * 10);
            }
        }
    }

    static {
        rnd = new Random();
        gameRank = 0;
        gameFinish = false;
        bagMax = (byte)48;
        foodData = new byte[48][3];
        dishData = new byte[48][3];
        equipData = new byte[48][3];
        passiveData = new byte[48][3];
        dishMenuData = new byte[0];
        roleSP = new byte[][]{{0, 0}, {0, 0}, {1, 0}, {0, 0}, {1, 0}, {0, 0}, {1, 0}, {0, 0}};
        roleTeam = new byte[]{0};
        roleIndex = 0;
        isShowGame = true;
        taskLog = new Hashtable();
        playX = (short)-1;
        playY = (short)-1;
        playDir = (short)-1;
        dishType = (byte)-1;
        screenFlashTime = 0;
        screenFlashColor = 0;
        isToPoint = false;
        shakeWave = 2;
        initRank = 0;
        Vrsd = new Vector();
        VBee = new Vector();
        vEnemys = new Vector();
        speedOfScroll = 8;
        FISHST = 0;
    }
}

