/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GameMap {
    static int screenWidth;
    static int screenHeight;
    static byte tileWidth;
    static byte tileHight;
    static int[] mapSize;
    short[][] tileProperties = new short[2][];
    String[][] name = new String[2][];
    static int setOffX;
    static int setOffY;
    static byte[][] mapData;
    static GameEngine engine;
    static int index;
    public static final short L_ROLE = 0;
    public static final short L_TILE = 20;
    public static final short L_ROLESD = 30;
    public static final short L_HIGH = 2000;
    public static final short L_TALK = 5000;
    public static final short L_MAX = 9000;
    public static final short L_BBG = 10;
    public static final short L_OVERBBG = 20;
    public static final short L_BFLASH = 350;
    static byte mapID;
    String mapName;
    String fileName;
    int music;
    byte[] enemys;
    int enemyLevel;
    short battleBg;
    int openEffect;
    int closeEffect;
    public static final byte ITEM_TYPE = 0;
    public static final byte ITEM_X = 1;
    public static final byte ITEM_Y = 2;
    public static final byte ITEM_TR = 3;
    public static final byte OBJ_ID = 0;
    public static final byte OBJ_IMG = 1;
    public static final byte OBJ_ADDX = 2;
    public static final byte OBJ_ADDY = 3;
    public static final byte OBJ_W = 4;
    public static final byte OBJ_H = 5;
    public static final byte OBJ_DL = 6;
    short[][] objData = new short[][]{{1, 101, 0, 0, 48, 32, -1}, {2, 102, 0, 0, 64, 16, 0}, {3, 125, 0, 0, 0, 0, 0}, {4, 104, 0, 0, 16, 16, 0}, {5, 107, 0, 0, 0, 0, 0}, {6, 111, -3, 0, 32, 16, 0}, {7, 113, 0, 0, 0, 0, 0}, {8, 114, 0, 0, 0, 0, 1}, {9, 116, -6, 0, 16, 16, 0}, {10, 119, 0, 0, 16, 16, 0}, {11, 120, 0, 0, 22, 19, 0}, {12, 121, -5, 0, 16, 16, 0}, {13, 122, 0, 0, 0, 0, 1}, {14, 123, 0, 0, 0, 0, 0}, {15, 106, 0, 0, 48, 32, 0}, {16, 103, 0, 0, 64, 16, 0}, {17, 126, 0, 0, 16, 16, 0}, {18, 127, 0, 0, 16, 16, 0}, {19, 129, 0, 0, 32, 16, 0}, {20, 130, 0, 0, 32, 16, 0}, {21, 98, 0, 0, 0, 0, 0}, {22, 131, 0, 0, 32, 16, 0}, {23, 132, 0, 0, 0, 0, 0}, {24, 133, 0, 0, 0, 0, -1}, {25, 134, 0, 0, 0, 0, -1}, {26, 135, 0, 0, 0, 0, -1}, {27, 105, 0, 0, 0, 0, 0}, {28, 161, 0, 0, 16, 16, 0}, {29, 140, 0, 0, 0, 0, 1}, {30, 144, 0, 0, 32, 16, 0}, {31, 147, -4, 2, 16, 16, 0}, {32, 148, 0, 0, 48, 16, 0}, {33, 149, 0, 0, 16, 16, 0}, {34, 150, -16, 4, 32, 16, 0}, {35, 151, -38, 5, 16, 16, 0}, {36, 154, -4, 0, 32, 16, 0}, {37, 155, 0, 0, 32, 32, 0}, {38, 124, 0, 0, 0, 0, 0}, {39, 157, 0, 0, 0, 0, 1}, {40, 158, 0, 0, 0, 0, 1}, {41, 159, 0, 0, 0, 0, 0}, {42, 160, 0, 6, 48, 16, 0}, {43, 164, 0, 0, 16, 16, 0}, {44, 165, 0, 0, 48, 16, 0}, {45, 170, 0, 0, 32, 32, -1}, {46, 171, -26, 3, 32, 16, 0}, {47, 139, 0, 0, 0, 0, 1}, {48, 138, 0, 0, 0, 0, 1}, {49, 137, 0, 0, 16, 16, 0}, {50, 153, 0, 0, 0, 0, 0}, {51, 118, 0, 0, 0, 0, 0}, {52, 143, 0, 0, 16, 16, 0}, {53, 166, 0, 0, 0, 0, 0}, {54, 145, 0, 0, 32, 16, 0}, {55, 100, 0, 0, 48, 16, 0}, {56, 112, 0, 0, 16, 16, 0}, {57, 146, 0, 0, 0, 0, 0}, {58, 152, 0, 0, 0, 0, 0}, {59, 163, 0, 0, 0, 0, 0}, {60, 110, 0, 0, 72, 63, 0}, {61, 108, 0, 0, 0, 0, 0}, {62, 128, -2, 2, 32, 16, 0}, {63, 172, -8, 2, 16, 16, 0}, {64, 173, 0, 0, 16, 16, 0}, {65, 115, -6, 0, 16, 16, 0}, {66, 117, 0, 0, 0, 0, 0}, {67, 142, 0, 0, 16, 16, 0}, {68, 162, 0, 0, 16, 16, 0}, {69, 109, 0, 32, 112, 96, -1}, {70, 167, -30, 0, 16, 16, 0}, {72, 141, 0, 0, 0, 0, 1}, {73, 169, 0, 0, 0, 0, 1}, {74, 168, 0, 0, 0, 0, 1}};
    static short[][] decData;
    short[][] mapArrow;
    public static boolean isShowCG;
    public static byte CGId;
    public static String CGText;
    public static byte SCEEN_MOVE;
    int adjustX;
    int adjustY;
    static boolean isMoveScreen;
    Event event;
    String command;
    Image mapBuff;
    int buffWidth;
    int buffHeight;
    boolean isBuffNull;
    int lastStartX;
    int lastStartY;
    int lastEndX;
    int lastEndY;
    static int flagMap;
    static int flagX;
    static int flagY;
    static int flagImgIndex;
    static short[][] moveDecortion;
    public static final byte MD_JIGUAN = 2;
    public static final byte MD_MEN = 1;
    public static final byte MD_KAIGUAN = 0;
    public static final byte MD_DIBAN = 3;
    public static final byte MD_TYPE = 0;
    public static final byte MD_X = 1;
    public static final byte MD_Y = 2;
    public static final byte MD_TR = 3;
    public static final byte MD_ST = 4;
    public static final byte CLOSE = 0;
    public static final byte OPEN = 1;
    public static final byte READY = 2;
    public static final byte MID = 3;

    public GameMap(GameEngine en, int sw, int sh) {
        screenWidth = sw;
        screenHeight = sh;
        GameMap.setOff(0, 0);
        engine = en;
    }

    public void free() {
        mapData = new byte[2][];
        System.gc();
    }

    public void init(String dat) {
        String[] param = Event.splitString(dat, " ");
        if (param[0].equals("id")) {
            mapID = (byte)Event.sToi(param[1]);
        } else if (param[0].equals("name")) {
            this.mapName = param[1];
        } else if (param[0].equals("dat")) {
            this.fileName = param[1];
        } else if (!param[0].equals("weather")) {
            if (param[0].equals("BGM")) {
                this.music = Event.sToi(param[1]);
            } else if (param[0].equals("enemys")) {
                if (param[1].equals("null")) {
                    this.enemys = null;
                } else {
                    String[] s = Event.splitString(param[1], ",");
                    this.enemys = new byte[s.length];
                    int j = 0;
                    while (j < this.enemys.length) {
                        this.enemys[j] = (byte)Event.sToi(s[j]);
                        ++j;
                    }
                }
            } else if (param[0].equals("battleBg")) {
                this.battleBg = (short)Event.sToi(param[1]);
            }
        }
    }

    public static void setOff(int x, int y) {
        setOffX = x;
        setOffY = y;
    }

    public void drawDecorations() {
        if (decData == null) {
            return;
        }
        int i = 0;
        while (i < decData.length) {
            short type = decData[i][0];
            short x = decData[i][1];
            int y = decData[i][2];
            byte trans = (byte)decData[i][3];
            int id = this.getObjIndex(type);
            if (id != -1) {
                short addx = this.objData[id][2];
                short addy = this.objData[id][3];
                short img = this.objData[id][1];
                short dl = this.objData[id][6];
                int drawLevel = y;
                switch (dl) {
                    case -1: {
                        drawLevel = 20;
                        break;
                    }
                    case 0: {
                        drawLevel = (short)(y + 30 - 8);
                        break;
                    }
                    case 1: {
                        drawLevel = 2000;
                    }
                }
                switch (id) {
                    case 25: 
                    case 35: {
                        Tools.addImage(img, x + addx, y + addy, 36, (byte)0, drawLevel);
                        Tools.addImage(img, x + addx + Tools.getImage(img).getWidth(), y + addy, 36, (byte)1, drawLevel);
                        break;
                    }
                    case 12: {
                        Tools.addImage(img, x + addx, y + addy, MyGameCanvas.gameTime % 4 * 12, 0, 11, 32, 36, trans, drawLevel);
                        break;
                    }
                    case 71: {
                        if (y + addy + ++index > mapSize[0] * tileWidth + 164) {
                            y = -80;
                            index = 0;
                        }
                        Tools.addImage(img, x + addx + index, y + addy, 36, trans, drawLevel);
                        break;
                    }
                    case 72: {
                        int[][] array = new int[][]{{18, 1, 11, 15}, {0, 0, 17, 10}, {30, 0, 11, 15}, {23, 19, 12, 10}, {2, 10, 12, 8}, {0, 19, 22, 11}};
                        switch (index / 2) {
                            case 0: {
                                Tools.addImage((int)img, x + addx, y + addy, array[0], 36, trans, drawLevel);
                                Tools.addImage((int)img, x + addx, y + addy + 3, array[3], 36, trans, drawLevel);
                                engine.drawWave(x + addx, y + addy, 10, 5);
                                break;
                            }
                            case 1: {
                                Tools.addImage((int)img, x + addx - 14, y + addy - 5, array[1], 36, trans, drawLevel);
                                Tools.addImage((int)img, x + addx, y + addy + 3, array[4], 36, trans, drawLevel);
                                engine.drawWave(x + addx, y + addy, 14, 7);
                                break;
                            }
                            case 2: {
                                Tools.addImage((int)img, x + addx - 16, y + addy + 3, array[2], 36, trans, drawLevel);
                                Tools.addImage((int)img, x + addx - 22, y + addy + 3, array[5], 36, trans, drawLevel);
                                engine.drawWave(x + addx, y + addy, 18, 9);
                                break;
                            }
                            case 3: {
                                Tools.addImage((int)img, x + addx - 18, y + addy + 3, array[4], 36, trans, drawLevel);
                                engine.drawWave(x + addx, y + addy, 22, 11);
                                break;
                            }
                            case 4: {
                                engine.drawWave(x + addx, y + addy, 10, 5);
                                engine.drawWave(x + addx, y + addy, 26, 13);
                                break;
                            }
                            case 5: {
                                engine.drawWave(x + addx, y + addy, 14, 7);
                                engine.drawWave(x + addx, y + addy, 30, 15);
                                break;
                            }
                            case 6: {
                                engine.drawWave(x + addx, y + addy, 18, 9);
                                engine.drawWave(x + addx, y + addy, 32, 16);
                                break;
                            }
                            case 7: {
                                engine.drawWave(x + addx, y + addy, 22, 11);
                                break;
                            }
                            case 8: {
                                engine.drawWave(x + addx, y + addy, 26, 13);
                                break;
                            }
                            case 9: {
                                engine.drawWave(x + addx, y + addy, 30, 15);
                                break;
                            }
                            case 10: {
                                engine.drawWave(x + addx, y + addy, 32, 16);
                                break;
                            }
                        }
                        if (++index <= 40) break;
                        index = 0;
                        break;
                    }
                    default: {
                        Tools.addImage(img, x + addx, y + addy, 36, trans, drawLevel);
                    }
                }
            }
            ++i;
        }
    }

    void drawMapArrow() {
        if (this.mapArrow == null) {
            return;
        }
        int i = 0;
        while (i < this.mapArrow.length) {
            short x = this.mapArrow[i][1];
            short y = this.mapArrow[i][2];
            short trans = this.mapArrow[i][3];
            int mIndex = MyGameCanvas.gameTime % 3;
            switch (trans) {
                case 0: 
                case 2: {
                    Tools.addImage(177, x, y, mIndex * 17, 0, 17, 16, 36, trans == 0 ? (byte)0 : 2, trans == 0 ? y + 30 - 8 : 30);
                    break;
                }
                case 1: 
                case 3: {
                    Tools.addImage(176, x, y, mIndex * 16, 0, 16, 17, 36, trans == 3 ? (byte)0 : 1, 30);
                    break;
                }
            }
            ++i;
        }
    }

    void loadDecorationDat(String fName) {
        decData = null;
        this.mapArrow = null;
        decData = engine.readItemData("/data/map" + fName + ".bin");
        this.mapArrow = engine.readItemData("/data/y" + fName + ".bin");
    }

    void loadMapDat() {
        this.loadMap("/map/" + this.fileName + "b.dat", 0);
        Tools.createImage(this.name[0], 1);
        this.loadMap("/map/" + this.fileName + "a.dat", 1);
        Tools.createImage(this.name[1], 2);
    }

    public void initMap() {
        this.free();
        this.initMapBuff();
        decData = null;
        this.adjustX = screenWidth / 2;
        this.adjustY = screenHeight / 2 + 20;
        this.loadMapDat();
        this.loadDecorationDat("" + mapID);
        this.initMoveDecorationData("" + mapID);
    }

    public void drawMapBG(Graphics g) {
        g.setColor(0);
        g.fillRect(setOffX, setOffY, 360, 360);
    }

    public void drawMapFG() {
        this.drawDecorations();
        this.drawMoveDecoration();
        this.drawMapArrow();
    }

    void drawCG() {
        int CGImgIndex = -1;
        GameEngine.drawColorScreenBG(0, 2000);
        if (CGText != null && CGId == -1) {
            GameEngine.toBlackStatus(CGText);
        }
        if (CGId != -1 && CGId != 1) {
            Tools.addImage(CGImgIndex, setOffX + (screenWidth - 104) / 2, setOffY, 20, (byte)0, 2000);
        }
    }

    public void setMap(Graphics g) {
        int w = mapSize[0] * tileWidth;
        int h = mapSize[1] * tileHight;
        int tempw = (screenWidth - w) / 2;
        int temph = (screenHeight - h) / 2;
        if (tempw > 0) {
            Tools.addRect((byte)1, setOffX, setOffY, tempw, screenHeight, true, 20, 0, 1111);
            Tools.addRect((byte)1, setOffX + w + tempw, setOffY, tempw, screenHeight, true, 20, 0, 1111);
        }
        if (temph > 0) {
            Tools.addRect((byte)1, setOffX, setOffY, screenWidth, temph, true, 20, 0, 1111);
            Tools.addRect((byte)1, setOffX, setOffY + h + temph, screenWidth, temph, true, 20, 0, 1111);
        }
        switch (mapID) {
            case 74: {
                Tools.addImage(175, setOffX + 60, setOffY + 20, 20, (byte)0, 20);
            }
        }
        if (mapData != null) {
            if (isShowCG) {
                this.drawCG();
            } else {
                this.drawMap(g, setOffX, setOffY);
                this.drawMapFG();
                this.drawTaskFlag(5000);
            }
        }
    }

    public int getSetOffX(int x) {
        short dx = (short)(x - this.adjustX);
        dx = (short)Math.max(dx, 0);
        int w = mapSize[0] * tileWidth;
        dx = w >= screenWidth ? (short)Math.min(dx, mapSize[0] * tileWidth - screenWidth) : (short)((w - screenWidth) / 2);
        return dx;
    }

    public int getSetOffY(int y) {
        short dy = (short)(y - this.adjustY);
        dy = (short)Math.max(dy, 0);
        int h = mapSize[1] * tileHight;
        dy = h >= screenHeight ? (short)Math.min(dy, mapSize[1] * tileHight - screenHeight) : (short)((h - screenHeight) / 2);
        return dy;
    }

    public void AdjustSrceen(int x, int y) {
        setOffX = Math.abs(x - setOffX - this.adjustX) > SCEEN_MOVE ? (x - setOffX - this.adjustX >= SCEEN_MOVE ? (setOffX += SCEEN_MOVE) : (setOffX -= SCEEN_MOVE)) : (int)((short)(x - this.adjustX));
        setOffX = (short)Math.max(setOffX, 0);
        int w = mapSize[0] * tileWidth;
        setOffX = w >= screenWidth ? (int)((short)Math.min(setOffX, w - screenWidth)) : (w - screenWidth) / 2;
        setOffY = Math.abs(y - setOffY - this.adjustY) > SCEEN_MOVE ? (y - setOffY - this.adjustY >= SCEEN_MOVE ? (setOffY += SCEEN_MOVE) : (setOffY -= SCEEN_MOVE)) : (int)((short)(y - this.adjustY));
        setOffY = (short)Math.max(setOffY, 0);
        int h = mapSize[1] * tileHight;
        setOffY = h >= screenHeight ? (int)((short)Math.min(setOffY, h - screenHeight)) : (h - screenHeight) / 2;
        if (isMoveScreen && this.checkMoveScreen(x, y)) {
            isMoveScreen = false;
            this.finish();
        }
    }

    public boolean checkMoveScreen(int x, int y) {
        int tempx = x - this.adjustX;
        tempx = (short)Math.max(tempx, 0);
        int w = mapSize[0] * tileWidth;
        tempx = w >= screenWidth ? (int)Math.min(tempx, w - screenWidth) : (short)(w - screenWidth) / 2;
        int tempy = y - this.adjustY;
        tempy = (short)Math.max(tempy, 0);
        int h = mapSize[1] * tileHight;
        tempy = h > screenHeight ? (int)((short)Math.min(tempy, mapSize[1] * tileHight - screenHeight)) : (h - screenHeight) / 2;
        return setOffX == tempx && setOffY == tempy;
    }

    public void sender(Event event, String command) {
        this.event = event;
        this.command = command;
    }

    public void finish() {
        if (this.event != null) {
            this.event.setEnd(this.command);
            this.event = null;
            this.command = null;
        }
    }

    public boolean canRun(int x, int y) {
        if (mapData == null) {
            return true;
        }
        if (x < 0 || x > mapSize[0] * tileHight || y < 0 || y > mapSize[1] * tileHight) {
            return false;
        }
        if (GameMap.inMapData(x, y, 1) == -1) {
            return false;
        }
        if (Tools.getProperties(this.tileProperties[1][GameMap.getLow(GameMap.inMapData(x, y, 1))], (byte)15)) {
            if (GameMap.inMapData(x, y, 0) == -1) {
                return true;
            }
            if (Tools.getProperties(this.tileProperties[0][GameMap.getLow(GameMap.inMapData(x, y, 0))], (byte)15)) {
                return true;
            }
        }
        return false;
    }

    public static byte inMapData(int x, int y, int index) {
        int n = x / tileWidth * mapSize[1] + y / tileHight;
        if (n < 0 || n >= mapData[index].length) {
            return -1;
        }
        return mapData[index][n];
    }

    public static int getTrans(int v) {
        return v >> 6 & 3;
    }

    public static int get2nd(int v) {
        return v << 1 >> 7 & 1;
    }

    public static int getLow(int v) {
        return v & 0x3F;
    }

    static int bToi(byte byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i += 256;
        }
        return i;
    }

    public void initBattleMap() {
        switch (Battle.imgbattleBgImgs[this.battleBg]) {
            case 0: {
                Tools.getImage(0);
                break;
            }
            case 1: {
                Tools.getImage(1);
                break;
            }
            case 2: {
                Tools.getImage(2);
                break;
            }
            case 3: {
                Tools.getImage(3);
                break;
            }
            case 4: {
                Tools.getImage(4);
            }
        }
    }

    public static void drawFullScreenBG(int imgIndex, int height, int speed, int level) {
        int imgW = Tools.getImage(imgIndex).getWidth();
        int imgH = Tools.getImage(imgIndex).getHeight();
        int times = screenWidth / imgW + 2;
        int startPos = setOffX * speed * 10 / 1000;
        while (setOffX - startPos >= imgW) {
            startPos += imgW;
        }
        int i = 0;
        while (i < times) {
            Tools.addImage(imgIndex, startPos + i * imgW, height, 0, 0, imgW, imgH, 20, (byte)0, level);
            ++i;
        }
    }

    int getObjIndex(int id) {
        int i = 0;
        while (i < this.objData.length) {
            if (this.objData[i][0] == id) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int hitDecorations(int x, int y) {
        if (decData == null) {
            return -1;
        }
        int i = 0;
        while (i < decData.length) {
            short id = decData[i][0];
            int objIndex = this.getObjIndex(id);
            if (objIndex != -1) {
                short w = this.objData[objIndex][4];
                short h = this.objData[objIndex][5];
                if (w != 0 && h != 0 && x >= decData[i][1] && x < decData[i][1] + w && y < decData[i][2] && y > decData[i][2] - h) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int getIndex(int v) {
        return v & 0x3F;
    }

    public int getIndex(int x, int y, int index) {
        return GameMap.getIndex(GameMap.inMapData(x, y, index));
    }

    public void loadMap(String file, int index) {
        DataInputStream in = new DataInputStream(this.getClass().getResourceAsStream(file));
        try {
            GameMap.mapSize[0] = Tools.bToi(in.readByte());
            GameMap.mapSize[1] = Tools.bToi(in.readByte());
            tileWidth = in.readByte();
            tileHight = in.readByte();
            int size = mapSize[0] * mapSize[1];
            GameMap.mapData[index] = new byte[size];
            in.read(mapData[index]);
            int len = in.readShort();
            this.name[index] = new String[len];
            this.tileProperties[index] = new short[len];
            int i = 0;
            while (i < len) {
                byte nameLen = in.readByte();
                byte[] names = new byte[nameLen];
                in.read(names);
                this.name[index][i] = new String(names);
                this.tileProperties[index][i] = in.readShort();
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println("map error:" + index);
            ex.printStackTrace();
        }
    }

    public void setTile(Graphics g) {
        int n = setOffX / tileWidth * mapSize[1] + setOffY / tileHight;
        int nw = screenWidth / tileWidth + 2;
        int nh = screenHeight / tileHight + 2;
        int j = 0;
        while (j < nw) {
            int s;
            int i = s = n + j * mapSize[1];
            while (i < s + nh) {
                if (i < mapData[1].length && i >= 0) {
                    int dataTemp = GameMap.getLow(mapData[1][i]);
                    int x = i / mapSize[1] * tileHight;
                    int y = i % mapSize[1] * tileWidth;
                    if (mapData[1][i] == -1) {
                        g.setColor(0);
                        g.fillRect(x - setOffX, y - setOffY, (int)tileWidth, (int)tileHight);
                    } else {
                        Tools.drawClipImage(g, 600 + dataTemp, x - setOffX, y - setOffY, 0, 0, tileWidth, tileHight, 20, GameMap.getTrans(mapData[1][i]));
                    }
                }
                ++i;
            }
            int i2 = s;
            while (i2 < s + nh) {
                if (i2 < mapData[0].length && i2 >= 0 && mapData[0][i2] != -1) {
                    int dataTemp = GameMap.getLow(mapData[0][i2]);
                    int x = i2 / mapSize[1] * tileHight;
                    int y = i2 % mapSize[1] * tileWidth;
                    Tools.drawClipImage(g, 300 + dataTemp, x - setOffX, y - setOffY, 0, 0, tileWidth, tileHight, 20, GameMap.getTrans(mapData[0][i2]));
                }
                ++i2;
            }
            ++j;
        }
    }

    void initMapBuff() {
        this.mapBuff = null;
        this.isBuffNull = true;
        tileWidth = (byte)16;
        tileHight = (byte)16;
        this.buffWidth = screenWidth - screenWidth % tileWidth + tileWidth * 2;
        this.buffHeight = screenHeight - screenHeight % tileHight + tileHight * 2;
        this.mapBuff = Image.createImage((int)this.buffWidth, (int)this.buffHeight);
    }

    void drawBuff(Graphics g, int clipX, int clipY, int clipW, int clipH, int x, int y) {
        g.setClip(x, y, clipW, clipH);
        g.drawImage(this.mapBuff, x - clipX, y - clipY, 20);
        g.setClip(0, 0, screenWidth, screenHeight);
    }

    void drawMap(Graphics g, int setOffX, int setOffY) {
        Graphics g1 = this.mapBuff.getGraphics();
        int startX = setOffX / tileWidth;
        int endX = startX + screenWidth / tileWidth + 1;
        int startY = setOffY / tileHight;
        int endY = startY + screenHeight / tileHight + 1;
        if (this.isBuffNull) {
            this.isBuffNull = false;
            this.updateBuff(g1, startX, startY, endX, endY);
            this.lastStartX = startX;
            this.lastStartY = startY;
            this.lastEndX = endX;
            this.lastEndY = endY;
        }
        if (this.lastStartX != startX) {
            int tmp2;
            int tmp1;
            if (this.lastStartX < startX) {
                tmp1 = this.lastEndX + 1;
                tmp2 = endX;
            } else {
                tmp1 = startX;
                tmp2 = this.lastStartX - 1;
            }
            this.updateBuff(g1, tmp1, startY, tmp2, endY);
            this.lastStartX = startX;
            this.lastEndX = endX;
        }
        if (this.lastStartY != startY) {
            int tmp4;
            int tmp3;
            if (this.lastStartY < startY) {
                tmp3 = this.lastEndY + 1;
                tmp4 = endY;
            } else {
                tmp3 = startY;
                tmp4 = this.lastStartY - 1;
            }
            this.updateBuff(g1, startX, tmp3, endX, tmp4);
            this.lastStartY = startY;
            this.lastEndY = endY;
        }
        int t1 = setOffX % this.buffWidth;
        int t2 = setOffY % this.buffHeight;
        int t3 = (setOffX + screenWidth) % this.buffWidth;
        int t4 = (setOffY + screenHeight) % this.buffHeight;
        if (t3 > t1) {
            if (t4 > t2) {
                this.drawBuff(g, t1, t2, screenWidth, screenHeight, 0, 0);
            } else {
                this.drawBuff(g, t1, t2, screenWidth, screenHeight - t4, 0, 0);
                this.drawBuff(g, t1, 0, screenWidth, t4, 0, screenHeight - t4);
            }
        } else if (t4 > t2) {
            this.drawBuff(g, t1, t2, screenWidth - t3, screenHeight, 0, 0);
            this.drawBuff(g, 0, t2, t3, screenHeight, screenWidth - t3, 0);
        } else {
            this.drawBuff(g, t1, t2, screenWidth - t3, screenHeight - t4, 0, 0);
            this.drawBuff(g, t1, 0, screenWidth - t3, t4, 0, screenHeight - t4);
            this.drawBuff(g, 0, t2, t3, screenHeight - t4, screenWidth - t3, 0);
            this.drawBuff(g, 0, 0, t3, t4, screenWidth - t3, screenHeight - t4);
        }
    }

    void updateBuff(Graphics g, int startX, int startY, int endX, int endY) {
        int y = startY * tileHight % this.buffHeight;
        int i = startY;
        while (i <= endY) {
            int x = startX * tileWidth % this.buffWidth;
            int j = startX;
            while (j <= endX) {
                byte mapIndex2 = GameMap.inMapData(j * tileWidth, i * tileHight, 1);
                int dataTemp2 = GameMap.getIndex(mapIndex2);
                int transData2 = GameMap.getTrans(mapIndex2);
                if ((byte)mapIndex2 != -1) {
                    g.setClip(x, y, (int)tileWidth, (int)tileHight);
                    Tools.drawClipImage(g, 600 + dataTemp2, x, y, 0, 0, tileWidth, tileHight, 20, transData2);
                    if (transData2 == 2 || transData2 == 3) {
                        Tools.drawClipImage(g, 300 + dataTemp2, x, y, 0, tileHight - 1, tileWidth, 1, 20, 0);
                    }
                    g.setClip(setOffX, setOffY, 360, 390);
                } else {
                    g.setClip(x, y, (int)tileWidth, (int)tileHight);
                    g.setColor(0);
                    g.fillRect(x, y, (int)tileWidth, (int)tileHight);
                    g.setClip(setOffX, setOffY, 360, 390);
                }
                byte mapIndex1 = GameMap.inMapData(j * tileWidth, i * tileHight, 0);
                int dataTemp1 = GameMap.getIndex(mapIndex1);
                int transData = GameMap.getTrans(mapIndex1);
                if ((byte)mapIndex1 != -1) {
                    g.setClip(x, y, (int)tileWidth, (int)tileHight);
                    Tools.drawClipImage(g, 300 + dataTemp1, x, y, 0, 0, tileWidth, tileHight, 20, transData);
                    if (transData == 2 || transData == 3) {
                        Tools.drawClipImage(g, 300 + dataTemp1, x, y, 0, tileHight - 1, tileWidth, 1, 20, 0);
                    }
                    g.setClip(setOffX, setOffY, 360, 390);
                }
                if ((x += tileWidth) >= this.buffWidth) {
                    x -= this.buffWidth;
                }
                ++j;
            }
            if ((y += tileHight) >= this.buffHeight) {
                y -= this.buffHeight;
            }
            ++i;
        }
    }

    public void drawTaskFlag(int lev) {
        if (flagMap == -1 || GameEngine.gameRank != flagMap || GameEngine.isChangMap) {
            flagImgIndex = 0;
            return;
        }
        Tools.addImage(251, flagX + 1, flagY, 14 * (++flagImgIndex % 4 / 2), 0, 14, 35, 36, (byte)0, lev + flagY);
    }

    void initMoveDecorationData(String fileName) {
        moveDecortion = null;
        String txtName = "/data/md" + fileName + ".bin";
        moveDecortion = engine.readItemData(txtName);
    }

    void drawMoveDecoration() {
        if (moveDecortion == null) {
            return;
        }
        int i = 0;
        while (i < moveDecortion.length) {
            short x = moveDecortion[i][1];
            short y = moveDecortion[i][2];
            byte trans = (byte)moveDecortion[i][3];
            switch (moveDecortion[i][0]) {
                case 1: {
                    if (moveDecortion[i][4] == 1) {
                        Tools.addImage(179, x, y - 39, 0, 49, 38, 9, 36, trans, y + 30 - 8);
                        break;
                    }
                    if (moveDecortion[i][4] == 2) {
                        Tools.addImage(179, x, y - 10, 39, 0, 38, 37, 36, trans, y + 30 - 8);
                        GameMap.moveDecortion[i][4] = 3;
                        break;
                    }
                    if (moveDecortion[i][4] == 3) {
                        Tools.addImage(179, x, y - 25, 39, 38, 38, 23, 36, trans, y + 30 - 8);
                        GameMap.moveDecortion[i][4] = 1;
                        break;
                    }
                    if (moveDecortion[i][4] != 0) break;
                    Tools.addImage(179, x, y, 0, 0, 38, 47, 36, trans, y + 30 - 8);
                    break;
                }
                case 0: {
                    if (moveDecortion[i][4] == 1) {
                        Tools.addImage(178, x + 3, y + 12, 8, 0, 8, 27, 36, trans, y + 30 - 8);
                        break;
                    }
                    if (moveDecortion[i][4] != 0) break;
                    Tools.addImage(178, x + 3, y, 0, 0, 8, 27, 36, trans, y + 30 - 8);
                    break;
                }
                case 2: {
                    if (moveDecortion[i][4] == 1) {
                        Tools.addImage(180, x, y, 0, 0, 32, 32, 36, trans, 20);
                        break;
                    }
                    if (moveDecortion[i][4] != 0) break;
                    Tools.addImage(180, x, y, 32, 0, 32, 32, 36, trans, 20);
                    break;
                }
                case 3: {
                    if (moveDecortion[i][4] == 1) {
                        if (index < 32) {
                            ++index;
                        }
                        Tools.addImage(180, x + index, y, 32, 0, 32, 32, 36, trans, 20);
                        break;
                    }
                    if (moveDecortion[i][4] != 0) break;
                    if (index > 0) {
                        --index;
                    }
                    Tools.addImage(180, x + index, y, 32, 0, 32, 32, 36, trans, 20);
                }
            }
            ++i;
        }
    }

    byte hitMoveDectoration(int x, int y) {
        if (moveDecortion == null) {
            return -1;
        }
        int i = 0;
        while (i < moveDecortion.length) {
            short type = moveDecortion[i][0];
            short sx = moveDecortion[i][1];
            short sy = moveDecortion[i][2];
            short st = moveDecortion[i][4];
            int w = 0;
            int h = 0;
            switch (type) {
                case 1: {
                    if (st != 0) break;
                    w = 16;
                    h = 16;
                    break;
                }
                case 0: {
                    w = 16;
                    h = 16;
                }
            }
            if (w != 0 && h != 0 && x >= sx && x < sx + w && y < sy && y > sy - h) {
                return (byte)i;
            }
            ++i;
        }
        return -1;
    }

    static {
        mapSize = new int[2];
        mapData = new byte[2][];
        isShowCG = false;
        CGText = "";
        SCEEN_MOVE = (byte)10;
        flagMap = -1;
    }
}

