/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Lobby
extends LobbyH {
    public static final int[] cursorPos = new int[]{-38, -23, -8, -21, 17, -23, 37, -19, 44, 9, -7, 23, -56, 20, -56, 0};

    public Lobby(GameCanvas gameCanvas) {
        if (DC.LCD_HEIGHT > 240) {
            gameCanvas.isThrowHospital = false;
            gameCanvas.isResult = false;
            this.gameCanvas = gameCanvas;
            if (gameCanvas.eventRoom != 27 && gameCanvas.process_CheckEventSound() == 0) {
                gameCanvas.soundManager.tool_PlaySound("lobby", true);
            }
        } else {
            gameCanvas.isResult = false;
            gameCanvas.isThrowHospital = false;
            this.gameCanvas = gameCanvas;
            if (gameCanvas.eventRoom != 13) {
                gameCanvas.soundManager.tool_PlaySound("lobby", true);
            }
        }
    }

    public void process_PauseApp() {
    }

    public void process_ResumeApp() {
    }

    public void paint() {
        if (DM.DEBUG == 5) {
            System.out.println(" Lobby paint()");
        }
        if (this.gameCanvas.tutoOn) {
            this.SetSoftKey("", DM.STR[5]);
        } else if (this.popup > 0) {
            this.SetSoftKey(DM.STR[1], "");
        }
        this.paint2();
    }

    public void paint2() {
        this.process_NoticeWorkingDay();
        this.process_Run();
        this.process_SellyFrame();
        this.process_NoticeCured();
        this.paint_Lobby();
        this.paint_Character();
        this.paint_Door();
        if (this.gameCanvas.workingDay && this.gameCanvas.timeTodayHours < 18) {
            DC.DrawImage(GameMode.g, this.imgLobby[6], 310 + GameCanvas.mainFrame % 2 * 5 - this.objX, DC.LCD_HEIGHT - 97 - this.objY, 40);
            DC.DrawImage(GameMode.g, this.imgLobby[7], 299 + GameCanvas.mainFrame % 2 * 5 - this.objX, DC.LCD_HEIGHT - 105 - this.objY, 40);
        }
        if (this.stateOfLobby != this.STATE_TUTORIAL) {
            this.paint_QuestAlarm();
        }
        this.paint_Event();
        this.paint_MapUI();
        if (this.stateOfLobby == this.STATE_TUTORIAL) {
            this.gameCanvas.paint_TalkingBox(this.imgFace, this.strTutorial[0], this.cursorOfTalk);
        } else {
            this.paint_TextScroll();
            if (this.isManaged) {
                this.paint_ManagementOfHospital();
            }
            if (this.popup > 0) {
                this.paint_PopUp();
            } else if (this.talkingNPC > 0) {
                this.paint_DialogueBalloon();
            }
            if (this.stateOfLobby == this.STATE_HOTMENU) {
                this.hotmenu.paint();
            }
        }
        if (this.isMiniMapOn) {
            this.paint_MiniMap();
        }
        if (!this.gameCanvas.tutoOn && this.gameCanvas.isAlertDeCurePopup) {
            this.gameCanvas.paint_PopUp(DM.STR[102] + 5 * this.gameCanvas.dataReliability / 100, 128);
        }
        if (this.stateOfLobby == this.STATE_LOBBY && this.gameCanvas.isRelease) {
            for (int direct = 0; direct < 4; ++direct) {
                if (!this.isDirect[direct]) continue;
                this.isDirect[direct] = false;
                this.lobbyNPC[0].setFrame(4);
                this.gameCanvas.isRelease = false;
            }
        }
    }

    public void paint_QuestAlarm() {
        if (!this.gameCanvas.eventCheckOn) {
            return;
        }
        switch (this.gameCanvas.eventPlace[this.gameCanvas.nowEventNum]) {
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 25: {
                DC.DrawImage(GameMode.g, this.gameCanvas.imgNumber[3], 153 - this.objX, DC.LCD_HEIGHT - 294 + 328 - 35 - this.objY - GameCanvas.mainFrame % 2 * 2, 20);
                break;
            }
            case 17: {
                DC.DrawImage(GameMode.g, this.gameCanvas.imgNumber[3], 74 - this.objX, DC.LCD_HEIGHT - 294 + 100 - 35 - this.objY - GameCanvas.mainFrame % 2 * 2, 20);
                break;
            }
            case 19: {
                DC.DrawImage(GameMode.g, this.gameCanvas.imgNumber[3], 255 - this.objX, DC.LCD_HEIGHT - 294 + 102 - 35 - this.objY - GameCanvas.mainFrame % 2 * 2, 20);
                break;
            }
            case 18: {
                DC.DrawImage(GameMode.g, this.gameCanvas.imgNumber[3], 295 - this.objX, DC.LCD_HEIGHT - 294 + 120 - 35 - this.objY - GameCanvas.mainFrame % 2 * 2, 20);
                break;
            }
            case 23: {
                DC.DrawImage(GameMode.g, this.gameCanvas.imgNumber[3], 297 - this.objX, DC.LCD_HEIGHT - 294 + 197 - 35 - this.objY - GameCanvas.mainFrame % 2 * 2, 20);
                break;
            }
            case 20: {
                DC.DrawImage(GameMode.g, this.gameCanvas.imgNumber[3], 4 - this.objX, DC.LCD_HEIGHT - 294 + 260 - 35 - this.objY - GameCanvas.mainFrame % 2 * 2, 20);
                break;
            }
            case 21: {
                DC.DrawImage(GameMode.g, this.gameCanvas.imgNumber[3], 16 - this.objX, DC.LCD_HEIGHT - 294 + 337 - 35 - this.objY - GameCanvas.mainFrame % 2 * 2, 20);
            }
        }
    }

    public void paint_Tile() {
        switch (this.gameCanvas.dataNowLobby) {
            case 2: {
                DC.SetColor(GameMode.g, 16115684);
                break;
            }
            case 3: {
                DC.SetColor(GameMode.g, 16776680);
                break;
            }
            case 4: {
                DC.SetColor(GameMode.g, 16771037);
                break;
            }
            case 6: {
                DC.SetColor(GameMode.g, 0xEFEDDF);
                break;
            }
            default: {
                DC.SetColor(GameMode.g, 0xFFFFFF);
            }
        }
        DC.FillRect(GameMode.g, 0 - this.objX, 0, 160, DC.LCD_HEIGHT);
        switch (this.gameCanvas.dataNowLobby) {
            case 2: {
                DC.SetColor(GameMode.g, 13022640);
                break;
            }
            case 3: {
                DC.SetColor(GameMode.g, 15986106);
                break;
            }
            case 4: {
                DC.SetColor(GameMode.g, 16763834);
                break;
            }
            case 6: {
                DC.SetColor(GameMode.g, 14933704);
                break;
            }
            default: {
                DC.SetColor(GameMode.g, 0xDEDFDE);
            }
        }
        DC.FillRect(GameMode.g, 160 - this.objX, 0, 160, DC.LCD_HEIGHT);
        for (int y = 0; y < 50; ++y) {
            block18: for (int x = 0; x < 11; ++x) {
                this.mapX = 16 * (y % 2) + x * 32;
                this.mapY = DC.LCD_HEIGHT - 316 + y * 8;
                if (y % 2 == 1 && x == 10) continue;
                switch (this.gameCanvas.dataNowLobby) {
                    case 0: 
                    case 2: 
                    case 3: 
                    case 4: {
                        if (LobbyH.BASEMAP[y][x] >= 5) continue block18;
                        DC.DrawImage(GameMode.g, this.imgTile[LobbyH.THEMEMAP[y][x]], this.mapX - this.objX, this.mapY - this.objY, 33);
                        continue block18;
                    }
                    case 6: {
                        if (LobbyH.BASEMAP[y][x] >= 5) continue block18;
                        DC.DrawImage(GameMode.g, this.imgTile[LobbyH.BASEMAP[y][x]], this.mapX - this.objX, this.mapY - this.objY, 33);
                        continue block18;
                    }
                    case 1: 
                    case 5: {
                        DC.DrawImage(GameMode.g, this.imgTile[LobbyH.BASEMAP[y][x]], this.mapX - this.objX, this.mapY - this.objY, 33);
                    }
                }
            }
        }
    }

    public void paint_Lobby() {
        if (this.lobbyNPC[0].getPosX() * this.BLOCKSIZEX < DC.LCD_WIDTH / 2) {
            this.objX = 0;
            this.dispX = this.lobbyNPC[0].getPosX();
        } else if ((LobbyH.LOBBYMAP[0].length - this.lobbyNPC[0].getPosX() - 1) * this.BLOCKSIZEX <= DC.LCD_WIDTH / 2) {
            this.objX = (LobbyH.LOBBYMAP[0].length - DC.LCD_WIDTH / this.BLOCKSIZEX) * this.BLOCKSIZEX;
            this.dispX = this.lobbyNPC[0].getPosX() - (LobbyH.LOBBYMAP[0].length - DC.LCD_WIDTH / this.BLOCKSIZEX);
        } else {
            this.objX = (this.lobbyNPC[0].getPosX() - DC.LCD_WIDTH / 2 / this.BLOCKSIZEX) * this.BLOCKSIZEX;
            this.dispX = DC.LCD_WIDTH / 2 / this.BLOCKSIZEX;
        }
        if (this.lobbyNPC[0].getPosY() < 3) {
            this.objY = 0;
            this.dispY = this.lobbyNPC[0].getPosY();
        } else if (this.lobbyNPC[0].getPosY() > 24) {
            this.objY = (LobbyH.LOBBYMAP.length - 8) * this.BLOCKSIZEY;
            this.dispY = this.lobbyNPC[0].getPosY() - (LobbyH.LOBBYMAP.length - 8);
        } else {
            this.objY = (this.lobbyNPC[0].getPosY() - 3) * this.BLOCKSIZEY;
            this.dispY = 3;
        }
        this.objY -= 112;
        this.paint_Tile();
        DC.DrawImage(GameMode.g, this.imgLobby[10], 117 - this.objX, DC.LCD_HEIGHT - 259 - this.objY, 24);
        DC.DrawImage(GameMode.g, this.imgLobby[0], 299 - this.objX, DC.LCD_HEIGHT - 61 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgLobby[1], 113 - this.objX, DC.LCD_HEIGHT + 49 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgLobby[2], 253 - this.objX, DC.LCD_HEIGHT - 159 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgLobby[2], 289 - this.objX, DC.LCD_HEIGHT - 141 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgLobby[5], 0 - this.objX, DC.LCD_HEIGHT - 20 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgLobby[4], 0 - this.objX, DC.LCD_HEIGHT + 65 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgObject[6], 40 - this.objX, DC.LCD_HEIGHT - 159 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgObject[8], 9 - this.objX, DC.LCD_HEIGHT - 227 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgObject[7], 207 - this.objX, DC.LCD_HEIGHT - 254 - this.objY, 36);
        if (this.gameCanvas.dataNowLobby == 5) {
            DC.DrawImage(GameMode.g, this.imgObject[0], 127 - this.objX, DC.LCD_HEIGHT - 162 - this.objY, 36);
        } else {
            DC.DrawImage(GameMode.g, this.imgObject[0], 117 - this.objX, DC.LCD_HEIGHT - 157 - this.objY, 36);
        }
        DC.DrawImage(GameMode.g, this.imgObject[1], 198 - this.objX, DC.LCD_HEIGHT - 142 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgObject[2], 4 - this.objX, DC.LCD_HEIGHT - 128 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgObject[3], 64 - this.objX, DC.LCD_HEIGHT - 92 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgObject[3], 94 - this.objX, DC.LCD_HEIGHT - 78 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgObject[3], 124 - this.objX, DC.LCD_HEIGHT - 64 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgObject[4], -this.objX, DC.LCD_HEIGHT - 82 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgObject[5], 29 - this.objX, DC.LCD_HEIGHT - 46 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgLobby[8], 21 - this.objX, DC.LCD_HEIGHT - 159 - this.objY, 36);
        DC.DrawImage(GameMode.g, this.imgLobby[9], 133 - this.objX, DC.LCD_HEIGHT - 179 - this.objY, 36);
        if (LobbyH.LOBBYMAP[this.lobbyNPC[0].getPosY()][this.lobbyNPC[0].getPosX()] == 10) {
            DC.DrawImage(GameMode.g, this.imgLobby[3], 131 - this.objX, DC.LCD_HEIGHT - 177 - this.objY, 36);
        }
    }

    public void paint_WhereIs2(int x, int y) {
        this.paint_UIBox(x - 50, y - 5, 100);
        this.paint_YellowBox(x, y - 2, 90, 15);
    }

    public void paint_YellowBox(int x, int y, int width, int height) {
        DC.SetColor(GameMode.g, 255, 245, 216);
        DC.FillRect(GameMode.g, x - width / 2, y + 2, width, height - 4);
        DC.FillRect(GameMode.g, x - width / 2 + 1, y + 1, width - 2, height - 2);
        DC.FillRect(GameMode.g, x - width / 2 + 2, y, width - 4, height);
    }

    public void paint_Door() {
        ++this.frmDoorIcon;
        switch (LobbyH.LOBBYMAP[this.lobbyNPC[0].getPosY()][this.lobbyNPC[0].getPosX()]) {
            case 3: {
                DC.DrawImage(GameMode.g, this.imgLobby[11 + this.frmDoorIcon / 2 % 2], 153 - this.objX, DC.LCD_HEIGHT - 194 + 328 - 2 - 25 - 100 - this.objY, 20);
                break;
            }
            case 4: {
                DC.DrawImage(GameMode.g, this.imgLobby[11 + this.frmDoorIcon / 2 % 2], 74 - this.objX, DC.LCD_HEIGHT - 194 + 100 - 2 - 25 - 100 - this.objY, 20);
                break;
            }
            case 5: {
                DC.DrawImage(GameMode.g, this.imgLobby[11 + this.frmDoorIcon / 2 % 2], 255 - this.objX, DC.LCD_HEIGHT - 194 + 102 - 2 - 25 - 100 - this.objY, 20);
                break;
            }
            case 6: {
                DC.DrawImage(GameMode.g, this.imgLobby[11 + this.frmDoorIcon / 2 % 2], 295 - this.objX, DC.LCD_HEIGHT - 194 + 120 - 2 - 25 - 100 - this.objY, 20);
                break;
            }
            case 7: {
                DC.DrawImage(GameMode.g, this.imgLobby[11 + this.frmDoorIcon / 2 % 2], 297 - this.objX, DC.LCD_HEIGHT - 194 + 197 - 2 - 25 - 100 - this.objY, 20);
                break;
            }
            case 8: {
                DC.DrawImage(GameMode.g, this.imgLobby[11 + this.frmDoorIcon / 2 % 2], 4 - this.objX, DC.LCD_HEIGHT - 194 + 260 - 2 - 25 - 100 - this.objY, 20);
                break;
            }
            case 9: {
                DC.DrawImage(GameMode.g, this.imgLobby[11 + this.frmDoorIcon / 2 % 2], 16 - this.objX, DC.LCD_HEIGHT - 194 + 337 - 2 - 25 - 100 - this.objY, 20);
                break;
            }
            case 10: {
                DC.DrawImage(GameMode.g, this.imgLobby[13], 150 - this.objX, DC.LCD_HEIGHT - 194 + 77 - 2 - 30 - 100 - this.objY + this.frmDoorIcon / 2 % 2 * 2, 20);
            }
        }
    }

    public void paint_TextScroll() {
        this.process_Scroll();
        if ((this.cursorOfScroll == 2 || this.cursorOfScroll == 0) && GameCanvas.mainFrame % 4 < 2) {
            DC.SetColor(GameMode.g, 16769624);
            DC.FillRect(GameMode.g, DC.LCD_HCENTER - 12, DC.LCD_HEIGHT - 4, 92, 1);
            DC.SetColor(GameMode.g, 0xFFF18F);
            DC.FillRect(GameMode.g, DC.LCD_HCENTER - 12, DC.LCD_HEIGHT - 8, 92, 4);
            DC.SetColor(GameMode.g, 0xFFFEBE);
            DC.FillRect(GameMode.g, DC.LCD_HCENTER - 12, DC.LCD_HEIGHT - 18, 92, 10);
            DC.SetColor(GameMode.g, 0xFFFFFF);
            DC.FillRect(GameMode.g, DC.LCD_HCENTER - 12, DC.LCD_HEIGHT - 15, 92, 4);
        }
        this.gameCanvas.xFontB.tool_SetSpace(DC.LCD_HCENTER - 10, DC.LCD_HCENTER - 80);
        this.gameCanvas.xFontB.tool_DrawText3(GameMode.g, 0, DM.STR[396 + this.cursorOfScroll], DC.LCD_WIDTH - 42 - this.frameOfScroll * 1, DC.LCD_HEIGHT - 16);
        if (this.frameOfScroll * 1 > 100 + GameCanvas.tool_GetStrLen(DM.STR[396 + this.cursorOfScroll])) {
            this.frameOfScroll = 0;
        }
        ++this.frameOfScroll;
        this.gameCanvas.xFontB.tool_SetSpace(0, 0);
    }

    public void paint_Event() {
        switch (LobbyH.LOBBYMAP[this.lobbyNPC[0].getPosY()][this.lobbyNPC[0].getPosX()]) {
            case 3: {
                this.paint_WhereIs2(DC.LCD_HCENTER, 30);
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[103], DC.LCD_HCENTER, 30, 17);
                break;
            }
            case 4: {
                this.paint_WhereIs2(DC.LCD_HCENTER, 30);
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[104], DC.LCD_HCENTER, 30, 17);
                break;
            }
            case 5: {
                this.paint_WhereIs2(DC.LCD_HCENTER, 30);
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[105], DC.LCD_HCENTER, 30, 17);
                break;
            }
            case 6: {
                this.paint_WhereIs2(DC.LCD_HCENTER, 30);
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[106], DC.LCD_HCENTER, 30, 17);
                break;
            }
            case 7: {
                this.paint_WhereIs2(DC.LCD_HCENTER, 30);
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[107], DC.LCD_HCENTER, 30, 17);
                break;
            }
            case 8: {
                this.paint_WhereIs2(DC.LCD_HCENTER, 30);
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[108], DC.LCD_HCENTER, 30, 17);
                break;
            }
            case 9: {
                this.paint_WhereIs2(DC.LCD_HCENTER, 30);
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[109], DC.LCD_HCENTER, 30, 17);
                break;
            }
            case 10: {
                this.paint_WhereIs2(DC.LCD_HCENTER, 30);
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[110], DC.LCD_HCENTER, 30, 17);
            }
        }
    }

    public void paint_DialogueBalloon() {
        DC.SetColor(GameMode.g, 0xC2C2C2);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 88, 23, 176, 47);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 87, 22, 174, 49);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 86, 21, 172, 51);
        DC.SetColor(GameMode.g, 0x727272);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 87, 23, 174, 47);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 86, 22, 172, 49);
        DC.SetColor(GameMode.g, 0xFFFFFF);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 86, 24, 172, 45);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 85, 23, 170, 47);
        this.gameCanvas.xFontB.tool_SetSpace(DC.LCD_HCENTER - 84, DC.LCD_HCENTER - 84);
        if (GameCanvas.tool_GetStrLen(this.strNPCWords[0]) > 324) {
            this.gameCanvas.xFontB.tool_DrawText(GameMode.g, 0, this.strNPCWords[0], DC.LCD_HCENTER - 84, 26);
        } else if (GameCanvas.tool_GetStrLen(this.strNPCWords[0]) > 164) {
            this.gameCanvas.xFontB.tool_DrawText(GameMode.g, 0, this.strNPCWords[0], DC.LCD_HCENTER - 84, 34);
        } else {
            this.gameCanvas.xFontB.tool_DrawText(GameMode.g, 0, this.strNPCWords[0], DC.LCD_HCENTER - GameCanvas.tool_GetStrLen(this.strNPCWords[0]) / 2, 41);
        }
    }

    public void paint_Character() {
        int moveX = 0;
        int moveY = 0;
        this.process_SelectSort();
        for (int npc = 0; npc < this.numNPC; ++npc) {
            moveY = 0;
            moveX = 0;
            this.process_SellyMeetsNPC(this.arrIndex[npc]);
            if (this.arrIndex[npc] == 0) {
                this.gameCanvas.tool_DrawClippedImage(this.imgSelly[this.lobbyNPC[0].getViewDirect()], 8 + this.dispX * this.BLOCKSIZEX - this.imgSelly[this.lobbyNPC[0].getViewDirect()].getWidth() / 10, DC.LCD_HEIGHT - 195 - 12 - 21 + 151 + this.dispY * this.BLOCKSIZEY - this.imgSelly[this.lobbyNPC[0].getViewDirect()].getHeight(), this.imgSelly[this.lobbyNPC[0].getViewDirect()].getWidth() / 5 * this.lobbyNPC[0].getFrame(), 0, this.imgSelly[this.lobbyNPC[0].getViewDirect()].getWidth() / 5, this.imgSelly[this.lobbyNPC[0].getViewDirect()].getHeight());
                continue;
            }
            if (!(this.gameCanvas.isTimeStop || this.lobbyNPC[this.arrIndex[npc]].getIsGoal() || this.lobbyNPC[this.arrIndex[npc]].getIsDialogue())) {
                if (this.lobbyNPC[this.arrIndex[npc]].getPattern() == 1) {
                    this.process_DirectPattern1(this.arrIndex[npc]);
                } else if (this.lobbyNPC[this.arrIndex[npc]].getPattern() == 2) {
                    this.process_DirectPattern2(this.arrIndex[npc]);
                }
                int saveDirect = this.lobbyNPC[this.arrIndex[npc]].getViewDirect();
                if (this.lobbyNPC[this.arrIndex[npc]].getViewDirect() == 1) {
                    if (this.lobbyNPC[this.arrIndex[npc]].getYFrame() % 2 == 0) {
                        this.lobbyNPC[this.arrIndex[npc]].setFrame(this.lobbyNPC[this.arrIndex[npc]].getYFrame() / 2 % 4);
                        if (this.lobbyNPC[this.arrIndex[npc]].getFrame() % 2 == 1) {
                            this.process_SetCharDirect(this.arrIndex[npc], this.lobbyNPC[this.arrIndex[npc]].getKey());
                        } else if (this.lobbyNPC[this.arrIndex[npc]].getFrame() % 2 == 0) {
                            this.process_MoveChar(this.arrIndex[npc]);
                        }
                    }
                } else if (this.lobbyNPC[this.arrIndex[npc]].getViewDirect() == 0) {
                    if (this.lobbyNPC[this.arrIndex[npc]].getYFrame() % 2 == 0) {
                        this.lobbyNPC[this.arrIndex[npc]].setFrame(this.lobbyNPC[this.arrIndex[npc]].getYFrame() / 2 % 4);
                        if (this.lobbyNPC[this.arrIndex[npc]].getFrame() % 2 == 1) {
                            this.process_SetCharDirect(this.arrIndex[npc], this.lobbyNPC[this.arrIndex[npc]].getKey());
                        } else if (this.lobbyNPC[this.arrIndex[npc]].getFrame() % 2 == 0) {
                            this.process_MoveChar(this.arrIndex[npc]);
                        }
                    }
                    if (this.lobbyNPC[this.arrIndex[npc]].getFrame() == 0 || this.lobbyNPC[this.arrIndex[npc]].getFrame() == 2) {
                        moveY = 4;
                    }
                } else if (this.lobbyNPC[this.arrIndex[npc]].getViewDirect() == 3) {
                    if (this.lobbyNPC[this.arrIndex[npc]].getYFrame() % 2 == 0) {
                        this.lobbyNPC[this.arrIndex[npc]].setFrame(this.lobbyNPC[this.arrIndex[npc]].getYFrame() / 2 % 4);
                        if (this.lobbyNPC[this.arrIndex[npc]].getFrame() % 2 == 1) {
                            this.process_SetCharDirect(this.arrIndex[npc], this.lobbyNPC[this.arrIndex[npc]].getKey());
                        } else if (this.lobbyNPC[this.arrIndex[npc]].getFrame() % 2 == 0) {
                            this.process_MoveChar(this.arrIndex[npc]);
                        }
                    }
                    if (this.lobbyNPC[this.arrIndex[npc]].getFrame() == 0 || this.lobbyNPC[this.arrIndex[npc]].getFrame() == 2) {
                        moveX = -8;
                    }
                } else if (this.lobbyNPC[this.arrIndex[npc]].getViewDirect() == 2) {
                    if (this.lobbyNPC[this.arrIndex[npc]].getYFrame() % 2 == 0) {
                        this.lobbyNPC[this.arrIndex[npc]].setFrame(this.lobbyNPC[this.arrIndex[npc]].getYFrame() / 2 % 4);
                        if (this.lobbyNPC[this.arrIndex[npc]].getFrame() % 2 == 1) {
                            this.process_SetCharDirect(this.arrIndex[npc], this.lobbyNPC[this.arrIndex[npc]].getKey());
                        } else if (this.lobbyNPC[this.arrIndex[npc]].getFrame() % 2 == 0) {
                            this.process_MoveChar(this.arrIndex[npc]);
                        }
                    }
                    if (this.lobbyNPC[this.arrIndex[npc]].getFrame() == 0 || this.lobbyNPC[this.arrIndex[npc]].getFrame() == 2) {
                        moveX = 8;
                    }
                }
                this.lobbyNPC[this.arrIndex[npc]].setYFrame(this.lobbyNPC[this.arrIndex[npc]].getYFrame() + 1);
                if (saveDirect != this.lobbyNPC[this.arrIndex[npc]].getViewDirect()) {
                    this.process_InitImageNPC(this.arrIndex[npc]);
                }
            }
            this.gameCanvas.tool_DrawClippedImage(this.imgNPC[this.arrIndex[npc] - 1], 8 + moveX + this.lobbyNPC[this.arrIndex[npc]].getPosX() * this.BLOCKSIZEX - this.objX - this.imgNPC[this.arrIndex[npc] - 1].getWidth() / 8, DC.LCD_HEIGHT - 191 + moveY + this.lobbyNPC[this.arrIndex[npc]].getPosY() * this.BLOCKSIZEY - this.objY - this.imgNPC[this.arrIndex[npc] - 1].getHeight(), this.imgNPC[this.arrIndex[npc] - 1].getWidth() / 4 * this.lobbyNPC[this.arrIndex[npc]].getFrame(), 0, this.imgNPC[this.arrIndex[npc] - 1].getWidth() / 4, this.imgNPC[this.arrIndex[npc] - 1].getHeight());
        }
    }

    public void paint_PopUp() {
        if (this.popup == 1) {
            this.gameCanvas.paint_PopUp(DM.STR[111], 128);
        } else if (this.popup == 2) {
            this.gameCanvas.paint_PopUp(DM.STR[112], 128);
        } else if (this.popup == 3) {
            this.gameCanvas.paint_PopUp(DM.STR[113], 128);
        } else if (this.popup == 4) {
            this.gameCanvas.paint_PopUp(DM.STR[114], 128);
        } else if (this.popup == 5) {
            this.gameCanvas.paint_PopUp(DM.STR[115], 128, this.cursorOfPop);
        } else if (this.popup == 6) {
            this.gameCanvas.paint_PopUp(DM.STR[696 + this.cursorOfItem] + DM.STR[116], 128, this.cursorOfPop);
        } else if (this.popup == 7) {
            this.gameCanvas.paint_PopUp(this.cursorOfItem + 1 + DM.STR[117], 128, this.cursorOfPop);
        } else if (this.popup == 8) {
            if (this.cursorOfItem == 1 || this.cursorOfItem == 3 || this.cursorOfItem == 4) {
                this.gameCanvas.paint_PopUp(DM.STR[704 + this.cursorOfItem + 1] + DM.STR[118], 128, this.cursorOfPop);
            } else {
                this.gameCanvas.paint_PopUp(DM.STR[704 + this.cursorOfItem + 1] + DM.STR[119], 128, this.cursorOfPop);
            }
        } else if (this.popup == 9) {
            this.gameCanvas.paint_PopUp(DM.STR[120], 128);
        } else if (this.popup == 10) {
            if (this.cursorOfItem == 2 || this.cursorOfItem == 6 || this.cursorOfItem == 9) {
                this.gameCanvas.paint_PopUp(DM.STR[711 + this.cursorOfItem] + DM.STR[118], 128, this.cursorOfPop);
            } else {
                this.gameCanvas.paint_PopUp(DM.STR[711 + this.cursorOfItem] + DM.STR[119], 128, this.cursorOfPop);
            }
        } else if (this.popup == 11) {
            this.gameCanvas.paint_PopUp(DM.STR[121], 128);
        } else if (this.popup == 12) {
            this.gameCanvas.paint_PopUp(DM.STR[122], 128, this.cursorOfPop);
        } else if (this.popup == 13) {
            this.gameCanvas.paint_PopUp(DM.STR[123] + (this.gameCanvas.timeGap / 2 + 1) * this.gameCanvas.dataReliability / 100, 128, this.cursorOfPop);
        } else if (this.popup == 14) {
            this.gameCanvas.paint_PopUp(DM.STR[124], 128);
        } else if (this.popup == 15) {
            this.gameCanvas.paint_PopUp(DM.STR[51], 128, this.cursorOfPop);
        } else if (this.popup == 16) {
            this.gameCanvas.paint_PopUp(DM.STR[125], 128, this.cursorOfPop);
        } else if (this.popup == 17 && !this.gameCanvas.goHospital) {
            this.gameCanvas.paint_PopUp(DM.STR[126], 128, this.cursorOfPop);
        } else if (this.popup == 20) {
            this.gameCanvas.paint_PopUp(DM.STR[127], 128);
        } else if (this.popup == 21) {
            this.gameCanvas.paint_PopUp(DM.STR[128], 128);
        } else if (this.popup == 22) {
            this.gameCanvas.paint_PopUp(DM.STR[129], 128);
        } else if (this.popup == 23) {
            if (this.itemNum == 17) {
                this.gameCanvas.paint_PopUp(DM.STR[131] + DM.STR[589] + DM.STR[130], 128);
            } else {
                this.gameCanvas.paint_PopUp(DM.STR[131] + DM.STR[410 + this.itemNum] + DM.STR[130], 128);
            }
        } else if (this.popup == 24) {
            if (this.itemNum == 17) {
                this.gameCanvas.paint_PopUp(DM.STR[132] + DM.STR[589] + DM.STR[130], 128);
            } else {
                this.gameCanvas.paint_PopUp(DM.STR[132] + DM.STR[410 + this.itemNum] + DM.STR[130], 128);
            }
        } else if (this.popup == 25) {
            if (this.itemNum == 17) {
                this.gameCanvas.paint_PopUp(DM.STR[133] + DM.STR[589] + DM.STR[130], 128);
            } else {
                this.gameCanvas.paint_PopUp(DM.STR[133] + DM.STR[410 + this.itemNum] + DM.STR[130], 128);
            }
        } else if (this.popup == 26) {
            this.gameCanvas.paint_PopUp(DM.STR[134], 128);
        } else if (this.popup == 27) {
            this.gameCanvas.paint_PopUp(DM.STR[135], 128);
        } else if (this.popup == 28) {
            this.gameCanvas.paint_PopUp(DM.STR[136], 128);
        } else if (this.popup == 29) {
            this.gameCanvas.paint_PopUp(DM.STR[137], 128);
        } else if (this.popup == 30) {
            this.gameCanvas.paint_PopUp(DM.STR[138], 128);
        } else if (this.popup == 31) {
            this.gameCanvas.paint_PopUp(DM.STR[139], 128);
        } else if (this.popup == 32) {
            this.gameCanvas.paint_PopUp(DM.STR[291 + this.itemNum] + DM.STR[140], 128);
        } else if (this.popup == 33) {
            if (this.itemNum < 11) {
                this.gameCanvas.paint_PopUp(DM.STR[141] + DM.STR[247 + this.itemNum] + DM.STR[130], 128);
            } else if (this.itemNum < 21) {
                this.gameCanvas.paint_PopUp(DM.STR[141] + DM.STR[258 + this.itemNum - 11] + DM.STR[130], 128);
            } else {
                this.gameCanvas.paint_PopUp(DM.STR[141] + DM.STR[268 + this.itemNum - 21] + DM.STR[130], 128);
            }
        } else if (this.popup == 53) {
            this.gameCanvas.paint_PopUp(DM.STR[142], 128);
        } else if (this.popup == 54) {
            this.gameCanvas.paint_PopUp(DM.STR[143], 128);
        }
    }

    public void paint_UIBox(int x, int y, int width) {
        DC.SetColor(GameMode.g, 0xFFFFFF);
        DC.FillRect(GameMode.g, x, y, width, 21);
        DC.SetColor(GameMode.g, 81, 106, 147);
        DC.FillRect(GameMode.g, x + 1, y + 1, width - 2, 19);
        DC.SetColor(GameMode.g, 161, 189, 216);
        DC.FillRect(GameMode.g, x + 2, y + 2, width - 4, 17);
        DC.SetColor(GameMode.g, 184, 209, 234);
        DC.FillRect(GameMode.g, x + 2, y + 3, width - 4, 10);
        DC.SetColor(GameMode.g, 203, 235, 252);
        DC.FillRect(GameMode.g, x + 2, y + 6, width - 4, 4);
        DC.SetColor(GameMode.g, 126, 149, 186);
        DC.FillRect(GameMode.g, x + 2, y + 17, width - 4, 2);
    }

    public void paint_MapUI() {
        this.paint_UIBox(0, 0, 171);
        this.gameCanvas.paint_Watch(5, 3);
        DC.SetColor(GameMode.g, 0, 0, 0);
        DC.DrawString(GameMode.g, this.gameCanvas.timeTodayYear + DM.STR[144] + this.gameCanvas.timeTodayMonth + DM.STR[145] + this.gameCanvas.timeTodayDay + DM.STR[146] + DM.STR[461 + this.gameCanvas.timeTodayDay2] + DM.STR[147], 43, 5, 20);
        this.paint_UIBox(DC.LCD_HCENTER - 87, DC.LCD_HEIGHT - 21, 173);
        DC.DrawImage(GameMode.g, this.imgMapUI[7], DC.LCD_HCENTER - 85, DC.LCD_HEIGHT - 16, 20);
        DC.SetColor(GameMode.g, 13030115);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 10, DC.LCD_HEIGHT - 4, 92, 1);
        DC.SetColor(GameMode.g, 14214129);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 10, DC.LCD_HEIGHT - 8, 92, 4);
        DC.SetColor(GameMode.g, 14937336);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 10, DC.LCD_HEIGHT - 18, 92, 10);
        DC.SetColor(GameMode.g, 15398655);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 10, DC.LCD_HEIGHT - 15, 92, 4);
        DC.SetColor(GameMode.g, 234, 215, 160);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 53, DC.LCD_HEIGHT - 16, 40, 11);
        for (int i = 0; i < this.gameCanvas.statusOfSelly[8] * 36 / 100; ++i) {
            if (this.gameCanvas.statusOfSelly[8] < 50) {
                DC.DrawImage(GameMode.g, this.imgMapUI[2], DC.LCD_HCENTER - 51 + i, DC.LCD_HEIGHT - 14, 20);
                continue;
            }
            if (this.gameCanvas.statusOfSelly[8] < 80) {
                DC.DrawImage(GameMode.g, this.imgMapUI[3], DC.LCD_HCENTER - 51 + i, DC.LCD_HEIGHT - 14, 20);
                continue;
            }
            DC.DrawImage(GameMode.g, this.imgMapUI[4], DC.LCD_HCENTER - 51 + i, DC.LCD_HEIGHT - 14, 20);
        }
        if (DC.LCD_WIDTH < 240) {
            DC.DrawImage(GameMode.g, this.imgMapUI[0], 1, DC.LCD_HEIGHT - 24, 36);
            if (this.gameCanvas.eventCheckOn) {
                DC.DrawImage(GameMode.g, this.imgMapUI[6], DC.LCD_WIDTH - 1, DC.LCD_HEIGHT - 39 - GameCanvas.mainFrame % 2 * 2, 40);
                if (GameCanvas.mainFrame % 2 == 0) {
                    DC.DrawImage(GameMode.g, this.imgMapUI[1], DC.LCD_WIDTH - 1, DC.LCD_HEIGHT - 24, 40);
                }
            } else {
                DC.DrawImage(GameMode.g, this.imgMapUI[1], DC.LCD_WIDTH - 1, DC.LCD_HEIGHT - 24, 40);
            }
        } else {
            DC.DrawImage(GameMode.g, this.imgMapUI[0], 1, DC.LCD_HEIGHT - 4, 36);
            if (this.gameCanvas.eventCheckOn) {
                DC.DrawImage(GameMode.g, this.imgMapUI[6], DC.LCD_WIDTH - 1, DC.LCD_HEIGHT - 19 - GameCanvas.mainFrame % 2 * 2, 40);
                if (GameCanvas.mainFrame % 2 == 0) {
                    DC.DrawImage(GameMode.g, this.imgMapUI[1], DC.LCD_WIDTH - 1, DC.LCD_HEIGHT - 4, 40);
                }
            } else {
                DC.DrawImage(GameMode.g, this.imgMapUI[1], DC.LCD_WIDTH - 1, DC.LCD_HEIGHT - 4, 40);
            }
        }
    }

    public void paint_MiniMap() {
        DC.SetColor(GameMode.g, 255, 255, 255);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 64 - 10, DC.LCD_VCENTER - 68 + 1, 148, 134);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 64 + 1 - 10, DC.LCD_VCENTER - 68, 146, 136);
        DC.SetColor(GameMode.g, 0, 5, 196);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 64 + 1 - 10, DC.LCD_VCENTER - 68 + 2, 146, 132);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 64 + 2 - 10, DC.LCD_VCENTER - 68 + 1, 144, 134);
        DC.SetColor(GameMode.g, 221, 223, 255);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 64 + 2 - 10, DC.LCD_VCENTER - 68 + 3, 144, 130);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 64 + 3 - 10, DC.LCD_VCENTER - 68 + 2, 142, 132);
        DC.SetColor(GameMode.g, 129, 153, 255);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 64 + 3 - 10, DC.LCD_VCENTER - 68 + 4, 142, 128);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 64 + 4 - 10, DC.LCD_VCENTER - 68 + 3, 140, 130);
        DC.DrawImage(GameMode.g, this.imgMiniMapLobby[0], DC.LCD_HCENTER, DC.LCD_VCENTER - 60, 17);
        DC.DrawImage(GameMode.g, this.imgMiniMapSame[1], DC.LCD_HCENTER, DC.LCD_VCENTER + 61 + 3, 33);
        DC.SetColor(GameMode.g, 255, 255, 255);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 32, DC.LCD_VCENTER - 8 - 68 + 1, 64, 19);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 32 + 1, DC.LCD_VCENTER - 8 - 68, 62, 21);
        DC.SetColor(GameMode.g, 0, 5, 196);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 32 + 1, DC.LCD_VCENTER - 8 - 68 + 2, 62, 17);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 32 + 2, DC.LCD_VCENTER - 8 - 68 + 1, 60, 19);
        DC.SetColor(GameMode.g, 129, 153, 255);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 32 + 2, DC.LCD_VCENTER - 8 - 68 + 3, 60, 15);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 32 + 3, DC.LCD_VCENTER - 8 - 68 + 2, 58, 17);
        DC.SetColor(GameMode.g, 221, 223, 255);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 32 + 3, DC.LCD_VCENTER - 8 - 68 + 4, 58, 13);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 32 + 4, DC.LCD_VCENTER - 8 - 68 + 3, 56, 15);
        int cursorOfQuest = 0;
        if (this.gameCanvas.eventCheckOn) {
            switch (this.gameCanvas.eventPlace[this.gameCanvas.nowEventNum]) {
                case 17: {
                    cursorOfQuest = 0;
                    break;
                }
                case 18: {
                    cursorOfQuest = 3;
                    break;
                }
                case 19: {
                    cursorOfQuest = 2;
                    break;
                }
                case 21: {
                    cursorOfQuest = 6;
                    break;
                }
                case 20: {
                    cursorOfQuest = 7;
                    break;
                }
                case 23: {
                    cursorOfQuest = 4;
                    break;
                }
                case 5: 
                case 9: 
                case 10: 
                case 11: 
                case 25: {
                    cursorOfQuest = 5;
                }
            }
            DC.DrawImage(GameMode.g, this.imgMiniMapSame[3], DC.LCD_HCENTER + cursorPos[cursorOfQuest * 2] + 2, DC.LCD_VCENTER + cursorPos[cursorOfQuest * 2 + 1] - 30 - 5, 20);
        }
        DC.DrawImage(GameMode.g, this.imgMiniMapSame[2], DC.LCD_HCENTER + cursorPos[this.cursorOfMiniMap * 2] + 2, DC.LCD_VCENTER + cursorPos[this.cursorOfMiniMap * 2 + 1] - 30 + GameCanvas.mainFrame % 2, 20);
        DC.SetColor(GameMode.g, 70, 96, 205);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 55 - 10, DC.LCD_VCENTER + 15, 130, 35);
        DC.SetColor(GameMode.g, 101, 124, 221);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 54 - 10, DC.LCD_VCENTER + 16, 128, 33);
        DC.SetColor(GameMode.g, 154, 172, 251);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 53 - 10, DC.LCD_VCENTER + 17, 126, 31);
        DC.SetColor(GameMode.g, 197, 208, 255);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 52 - 10, DC.LCD_VCENTER + 18, 124, 29);
        int[] size = new int[]{0, 50, 100, 150, 200, 250, 300, 350, 400};
        this.gameCanvas.tool_DrawClippedImage(this.imgMiniMapLobby[1], DC.LCD_HCENTER - 52, DC.LCD_VCENTER - 3, size[this.cursorOfMiniMap], 0, size[this.cursorOfMiniMap + 1] - size[this.cursorOfMiniMap], 13);
        this.gameCanvas.xFontB.tool_SetSpace(DC.LCD_HCENTER - 50 - 10, DC.LCD_HCENTER - 50 - 10);
        this.gameCanvas.xFontB.tool_DrawText(GameMode.g, 0, DM.STR[94 + this.cursorOfMiniMap], DC.LCD_HCENTER - 50 - 10, DC.LCD_VCENTER + 20);
        this.gameCanvas.xFontB.tool_SetSpace(0, 0);
        DC.DrawImage(GameMode.g, this.imgMiniMapSame[0], DC.LCD_HCENTER, DC.LCD_VCENTER - 66, 3);
    }

    public void paint_RedBox(int x, int y, int width, int height) {
        DC.SetColor(GameMode.g, 196, 0, 42);
        DC.FillRect(GameMode.g, x, y + 1, width, height - 2);
        DC.FillRect(GameMode.g, x + 1, y, width - 2, height);
        DC.SetColor(GameMode.g, 255, 221, 228);
        DC.FillRect(GameMode.g, x + 1, y + 2, width - 2, height - 4);
        DC.FillRect(GameMode.g, x + 2, y + 1, width - 4, height - 2);
        DC.SetColor(GameMode.g, 255, 129, 156);
        DC.FillRect(GameMode.g, x + 2, y + 3, width - 4, height - 6);
        DC.FillRect(GameMode.g, x + 3, y + 2, width - 6, height - 4);
    }

    public void paint_ManagementOfHospital() {
        int i;
        this.paint_RedBox(DC.LCD_HCENTER - 88 - 10, DC.LCD_VCENTER - 110, 196, 220);
        for (i = 0; i < 4; ++i) {
            this.paint_RedBox(DC.LCD_HCENTER - 70 + 35 * i, DC.LCD_VCENTER - 105, 35, 20);
        }
        DC.SetColor(GameMode.g, 196, 0, 42);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 85 - 10, DC.LCD_VCENTER - 89 + 1, 190, 173);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 85 + 1 - 10, DC.LCD_VCENTER - 89, 188, 175);
        DC.SetColor(GameMode.g, 255, 188, 193);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 85 + 1 - 10, DC.LCD_VCENTER - 89 + 2, 188, 171);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 85 + 2 - 10, DC.LCD_VCENTER - 89 + 1, 186, 173);
        DC.SetColor(GameMode.g, 255, 154, 161);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 85 + 2 - 10, DC.LCD_VCENTER - 89 + 3, 186, 169);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 85 + 3 - 10, DC.LCD_VCENTER - 89 + 2, 184, 171);
        DC.SetColor(GameMode.g, 255, 188, 193);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 85 + 3 - 10, DC.LCD_VCENTER - 89 + 4, 184, 167);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 85 + 4 - 10, DC.LCD_VCENTER - 89 + 3, 182, 169);
        DC.SetColor(GameMode.g, 255, 188, 193);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 70 + 35 * this.cursorOfTab + 1, DC.LCD_VCENTER - 105 + 2, 33, 16);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 70 + 35 * this.cursorOfTab + 2, DC.LCD_VCENTER - 105 + 1, 31, 18);
        DC.SetColor(GameMode.g, 255, 154, 161);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 70 + 35 * this.cursorOfTab + 2, DC.LCD_VCENTER - 105 + 3, 31, 16);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 70 + 35 * this.cursorOfTab + 3, DC.LCD_VCENTER - 105 + 2, 29, 16);
        DC.SetColor(GameMode.g, 255, 188, 193);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 70 + 35 * this.cursorOfTab + 3, DC.LCD_VCENTER - 105 + 4, 29, 16);
        DC.FillRect(GameMode.g, DC.LCD_HCENTER - 70 + 35 * this.cursorOfTab + 4, DC.LCD_VCENTER - 105 + 3, 27, 16);
        for (i = 0; i < 4; ++i) {
            if (i == this.cursorOfTab) {
                this.gameCanvas.tool_DrawClippedImage(this.imgParts[5], DC.LCD_HCENTER - 65 + 35 * i, DC.LCD_VCENTER - 102, 100 + 25 * i, 0, 25, 13);
                continue;
            }
            this.gameCanvas.tool_DrawClippedImage(this.imgParts[5], DC.LCD_HCENTER - 65 + 35 * i, DC.LCD_VCENTER - 102, 25 * i, 0, 25, 13);
        }
        this.gameCanvas.paint_YellowBox(DC.LCD_VCENTER - 99 + 15, 128, 17);
        this.gameCanvas.paint_YellowBox(DC.LCD_VCENTER - 80 + 15, 180, 46);
        this.gameCanvas.paint_YellowBox(DC.LCD_VCENTER - 33 + 15, 180, 18);
        this.gameCanvas.paint_YellowBox(DC.LCD_VCENTER - 14 + 15, 180, 18);
        this.gameCanvas.paint_YellowBox(DC.LCD_VCENTER + 5 + 15, 180, 30);
        this.gameCanvas.paint_YellowBox(DC.LCD_VCENTER + 36 + 15, 180, 18);
        if (this.cursorOfTab == 0) {
            DC.SetColor(GameMode.g, 0, 0, 0);
            DC.DrawString(GameMode.g, DM.STR[696 + this.cursorOfItem], DC.LCD_HCENTER, DC.LCD_VCENTER - 81, 17);
            if (this.isKong) {
                this.gameCanvas.paint_ItemPrice(DC.LCD_HCENTER - 73 - 10, DC.LCD_VCENTER - 15, this.DOCTORSEXPENSE[this.cursorOfItem] / 1000, this.isKong);
            } else {
                this.gameCanvas.paint_ItemPrice(DC.LCD_HCENTER - 73 - 10, DC.LCD_VCENTER - 15, this.DOCTORSEXPENSE[this.cursorOfItem], this.isKong);
            }
            DC.DrawImage(GameMode.g, this.imgDoctorsIcon[2 + this.cursorOfItem], DC.LCD_HCENTER, DC.LCD_VCENTER - 42, 3);
            if (this.cursorOfItem % 2 == 0) {
                if (this.gameCanvas.verBestNurse > this.cursorOfItem / 2) {
                    DC.DrawImage(GameMode.g, this.imgParts[1], DC.LCD_HCENTER + 4, DC.LCD_VCENTER - 42, 3);
                }
            } else if (this.gameCanvas.verBestDoctor > (this.cursorOfItem - 1) / 2) {
                DC.DrawImage(GameMode.g, this.imgParts[1], DC.LCD_HCENTER + 4, DC.LCD_VCENTER - 42, 3);
            }
            DC.DrawString(GameMode.g, DM.STR[150], DC.LCD_HCENTER - 75 + 2 - 10, DC.LCD_VCENTER + 39 - 16, 20);
            if (this.cursorOfItem % 2 == 0) {
                DC.DrawString(GameMode.g, DM.STR[151], DC.LCD_HCENTER - 75 + 2 - 10, DC.LCD_VCENTER + 52 - 16, 20);
            } else {
                DC.DrawString(GameMode.g, DM.STR[152], DC.LCD_HCENTER - 75 + 2 - 10, DC.LCD_VCENTER + 52 - 16, 20);
            }
            if (this.gameCanvas.DOCTORSABILITY[2 + this.cursorOfItem] > 999) {
                this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 16 + 19, DC.LCD_VCENTER + 40 - 16, 0, 0, 7, 9);
            } else {
                this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 25 + 19, DC.LCD_VCENTER + 40 - 16, 0, 0, 7, 9);
            }
            this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 16, 14, 0, 7, 9);
            this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 8, this.gameCanvas.DOCTORSABILITY[2 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
            this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 28, 0, 3, 9);
            this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 12, this.gameCanvas.DOCTORSABILITY[12 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
            this.gameCanvas.xFontB.tool_SetSpace(DC.LCD_HCENTER - 75 - 10, DC.LCD_HCENTER - 75 - 10);
            this.gameCanvas.xFontB.tool_DrawText3(GameMode.g, 0, DM.STR[86 + this.cursorOfItem], DC.LCD_HCENTER - 75 - this.frameOfString * 1, DC.LCD_VCENTER + 4);
            if (this.frameOfString * 1 > GameCanvas.tool_GetStrLen(DM.STR[86 + this.cursorOfItem])) {
                this.frameOfString = -10;
            }
            DC.DrawImage(GameMode.g, this.imgParts[3], DC.LCD_HCENTER - 34, DC.LCD_VCENTER + 89, 20);
            DC.DrawImage(GameMode.g, this.imgParts[6], DC.LCD_HCENTER - 30 + this.imgParts[3].getWidth(), DC.LCD_VCENTER + 89, 20);
        } else if (this.cursorOfTab == 1) {
            DC.SetColor(GameMode.g, 0, 0, 0);
            DC.DrawString(GameMode.g, this.cursorOfItem + 1 + DM.STR[153], DC.LCD_HCENTER, DC.LCD_VCENTER - 81, 17);
            if (this.isKong) {
                this.gameCanvas.paint_ItemPrice(DC.LCD_HCENTER - 73 - 10, DC.LCD_VCENTER - 15, this.UPGRADEEXPENSE[this.cursorOfItem] / 1000, this.isKong);
            } else {
                this.gameCanvas.paint_ItemPrice(DC.LCD_HCENTER - 73 - 10, DC.LCD_VCENTER - 15, this.UPGRADEEXPENSE[this.cursorOfItem], this.isKong);
            }
            DC.DrawImage(GameMode.g, this.imgBuildingIcon[1 + this.cursorOfItem], DC.LCD_HCENTER, DC.LCD_VCENTER - 2 - 24, 33);
            if (this.gameCanvas.verBestHospital > this.cursorOfItem) {
                DC.DrawImage(GameMode.g, this.imgParts[1], DC.LCD_HCENTER + 4, DC.LCD_VCENTER - 18 - 24, 3);
            }
            DC.SetColor(GameMode.g, 0, 0, 0);
            if (this.scroll == 0) {
                DC.DrawString(GameMode.g, DM.STR[150], DC.LCD_HCENTER - 75 - 10, DC.LCD_VCENTER + 39 - 16, 20);
                DC.DrawString(GameMode.g, DM.STR[154], DC.LCD_HCENTER - 75 - 10, DC.LCD_VCENTER + 52 - 16, 20);
                this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 17 + 19, DC.LCD_VCENTER + 40 - 16, 0, 0, 7, 9);
                this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 16, 14, 0, 7, 9);
                this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 8, this.gameCanvas.UPGRADEABILITY[1 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 28, 0, 3, 9);
                this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 12, this.gameCanvas.UPGRADEABILITY[5 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
            } else if (this.scroll == 1) {
                DC.DrawString(GameMode.g, DM.STR[154], DC.LCD_HCENTER - 75 - 10, DC.LCD_VCENTER + 39 - 16, 20);
                DC.DrawString(GameMode.g, DM.STR[155], DC.LCD_HCENTER - 75 - 10, DC.LCD_VCENTER + 52 - 16, 20);
                this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 40 - 16, 14, 0, 7, 9);
                this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 16, 14, 0, 7, 9);
                this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 28, 0, 3, 9);
                this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 12, this.gameCanvas.UPGRADEABILITY[5 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 28, 0, 3, 9);
                this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 12, this.gameCanvas.UPGRADEABILITY[9 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
            } else {
                DC.DrawString(GameMode.g, DM.STR[155], DC.LCD_HCENTER - 75 - 10, DC.LCD_VCENTER + 39 - 16, 20);
                DC.DrawString(GameMode.g, DM.STR[150], DC.LCD_HCENTER - 75 - 10, DC.LCD_VCENTER + 52 - 16, 20);
                this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 40 - 16, 14, 0, 7, 9);
                this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 17 + 19, DC.LCD_VCENTER + 53 - 16, 0, 0, 7, 9);
                this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 28, 0, 3, 9);
                this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 12, this.gameCanvas.UPGRADEABILITY[9 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 8, this.gameCanvas.UPGRADEABILITY[1 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
            }
            this.gameCanvas.xFontB.tool_SetSpace(DC.LCD_HCENTER - 75 - 10, DC.LCD_HCENTER - 75 - 10);
            this.gameCanvas.xFontB.tool_DrawText3(GameMode.g, 0, DM.STR[83 + this.cursorOfItem], DC.LCD_HCENTER - 50 - this.frameOfString * 1, DC.LCD_VCENTER + 4);
            if (this.frameOfString * 1 > GameCanvas.tool_GetStrLen(DM.STR[83 + this.cursorOfItem])) {
                this.frameOfString = -10;
            }
            if (GameCanvas.mainFrame % 10 == 0) {
                ++this.scroll;
                this.scroll %= 6;
            }
            DC.DrawImage(GameMode.g, this.imgParts[3], DC.LCD_HCENTER - 34, DC.LCD_VCENTER + 89, 20);
            DC.DrawImage(GameMode.g, this.imgParts[6], DC.LCD_HCENTER - 30 + this.imgParts[3].getWidth(), DC.LCD_VCENTER + 89, 20);
        } else if (this.cursorOfTab == 2) {
            DC.SetColor(GameMode.g, 0, 0, 0);
            DC.DrawString(GameMode.g, DM.STR[704 + this.cursorOfItem + 1], DC.LCD_HCENTER, DC.LCD_VCENTER - 81, 17);
            if (this.isKong) {
                this.gameCanvas.paint_ItemPrice(DC.LCD_HCENTER - 73 - 10, DC.LCD_VCENTER - 15, this.LOBBYEXPENSE[this.cursorOfItem] / 1000, this.isKong);
            } else {
                this.gameCanvas.paint_ItemPrice(DC.LCD_HCENTER - 73 - 10, DC.LCD_VCENTER - 15, this.LOBBYEXPENSE[this.cursorOfItem], this.isKong);
            }
            DC.SetClip(GameMode.g, DC.LCD_HCENTER - 36, DC.LCD_VCENTER - 28 - 32, 72, 36);
            switch (this.cursorOfItem + 1) {
                case 2: {
                    DC.SetColor(GameMode.g, 16115684);
                    break;
                }
                case 3: {
                    DC.SetColor(GameMode.g, 16776680);
                    break;
                }
                case 4: {
                    DC.SetColor(GameMode.g, 16771037);
                    break;
                }
                case 6: {
                    DC.SetColor(GameMode.g, 0xEFEDDF);
                    break;
                }
                default: {
                    DC.SetColor(GameMode.g, 0xFFFFFF);
                }
            }
            DC.FillRect(GameMode.g, 0, 0, 160, DC.LCD_HEIGHT);
            switch (this.cursorOfItem + 1) {
                case 2: {
                    DC.SetColor(GameMode.g, 13022640);
                    break;
                }
                case 3: {
                    DC.SetColor(GameMode.g, 15986106);
                    break;
                }
                case 4: {
                    DC.SetColor(GameMode.g, 16763834);
                    break;
                }
                case 6: {
                    DC.SetColor(GameMode.g, 14933704);
                    break;
                }
                default: {
                    DC.SetColor(GameMode.g, 0xDEDFDE);
                }
            }
            DC.FillRect(GameMode.g, 160, 0, 160, DC.LCD_HEIGHT);
            for (int y = 0; y < 50; ++y) {
                block20: for (int x = 0; x < 11; ++x) {
                    this.mapX = 16 * (y % 2) + x * 32;
                    this.mapY = DC.LCD_HEIGHT - 316 + y * 8;
                    if (y % 2 == 1 && x == 10) continue;
                    switch (this.cursorOfItem + 1) {
                        case 0: 
                        case 2: 
                        case 3: 
                        case 4: {
                            if (LobbyH.BASEMAP[y][x] >= 5) continue block20;
                            DC.DrawImage(GameMode.g, this.imgLobbyIcon[LobbyH.THEMEMAP[y][x]], this.mapX - 40, this.mapY + 29, 33);
                            continue block20;
                        }
                        case 6: {
                            if (LobbyH.BASEMAP[y][x] >= 5) continue block20;
                            DC.DrawImage(GameMode.g, this.imgLobbyIcon[LobbyH.BASEMAP[y][x]], this.mapX - 40, this.mapY + 29, 33);
                            continue block20;
                        }
                        case 1: 
                        case 5: {
                            DC.DrawImage(GameMode.g, this.imgLobbyIcon[LobbyH.BASEMAP[y][x]], this.mapX - 40, this.mapY + 29, 33);
                        }
                    }
                }
            }
            DC.SetClip(GameMode.g, 0, 0, DC.LCD_WIDTH, DC.LCD_HEIGHT);
            if (this.gameCanvas.isOpenedLobby[this.cursorOfItem + 1]) {
                DC.DrawImage(GameMode.g, this.imgParts[1], DC.LCD_HCENTER + 4, DC.LCD_VCENTER - 18 - 24, 3);
            }
            if (this.scroll == 0) {
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[150], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 39 - 16, 20);
                DC.DrawString(GameMode.g, DM.STR[156], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 52 - 16, 20);
                if (this.gameCanvas.LOBBYABILITY[this.cursorOfItem + 1] == 0) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 7, 0, 7, 9);
                } else {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 17 + 19, DC.LCD_VCENTER + 40 - 16, 0, 0, 7, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 8, this.gameCanvas.LOBBYABILITY[this.cursorOfItem + 1], this.gameCanvas.imgNumber[0], false);
                }
                if (this.gameCanvas.LOBBYABILITY[8 + this.cursorOfItem] == 0) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 7, 0, 7, 9);
                } else if (this.gameCanvas.LOBBYABILITY[8 + this.cursorOfItem] == 5) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 37 + 19, DC.LCD_VCENTER + 53 - 16, 12, 0, this.gameCanvas.imgNumber[0], false);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 12, this.gameCanvas.LOBBYABILITY[8 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                } else {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 12, this.gameCanvas.LOBBYABILITY[8 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                }
            } else if (this.scroll == 1) {
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[156], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 39 - 16, 20);
                DC.DrawString(GameMode.g, DM.STR[154], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 52 - 16, 20);
                if (this.gameCanvas.LOBBYABILITY[8 + this.cursorOfItem] == 0) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 7, 0, 7, 9);
                } else if (this.gameCanvas.LOBBYABILITY[8 + this.cursorOfItem] == 5) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 40 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 37 + 19, DC.LCD_VCENTER + 40 - 16, 12, 0, this.gameCanvas.imgNumber[0], false);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 12, this.gameCanvas.LOBBYABILITY[8 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                } else {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 40 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 12, this.gameCanvas.LOBBYABILITY[8 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                }
                if (this.gameCanvas.LOBBYABILITY[15 + this.cursorOfItem] == 0) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 7, 0, 7, 9);
                } else if (this.gameCanvas.LOBBYABILITY[15 + this.cursorOfItem] == 5) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 37 + 19, DC.LCD_VCENTER + 53 - 16, 12, 0, this.gameCanvas.imgNumber[0], false);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 12, this.gameCanvas.LOBBYABILITY[15 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                } else {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 12, this.gameCanvas.LOBBYABILITY[15 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                }
            } else if (this.scroll == 2) {
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[154], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 39 - 16, 20);
                DC.DrawString(GameMode.g, DM.STR[152], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 52 - 16, 20);
                if (this.gameCanvas.LOBBYABILITY[15 + this.cursorOfItem] == 0) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 7, 0, 7, 9);
                } else if (this.gameCanvas.LOBBYABILITY[15 + this.cursorOfItem] == 5) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 40 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 37 + 19, DC.LCD_VCENTER + 40 - 16, 12, 0, this.gameCanvas.imgNumber[0], false);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 12, this.gameCanvas.LOBBYABILITY[15 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                } else {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 40 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 12, this.gameCanvas.LOBBYABILITY[15 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                }
                if (this.gameCanvas.LOBBYABILITY[22 + this.cursorOfItem] == 0) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 7, 0, 7, 9);
                } else if (this.gameCanvas.LOBBYABILITY[22 + this.cursorOfItem] == 5) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 37 + 19, DC.LCD_VCENTER + 53 - 16, 12, 0, this.gameCanvas.imgNumber[0], false);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 12, this.gameCanvas.LOBBYABILITY[22 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                } else {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 12, this.gameCanvas.LOBBYABILITY[22 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                }
            } else if (this.scroll == 3) {
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[152], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 39 - 16, 20);
                DC.DrawString(GameMode.g, DM.STR[151], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 52 - 16, 20);
                if (this.gameCanvas.LOBBYABILITY[22 + this.cursorOfItem] == 0) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 7, 0, 7, 9);
                } else if (this.gameCanvas.LOBBYABILITY[22 + this.cursorOfItem] == 5) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 40 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 37 + 19, DC.LCD_VCENTER + 40 - 16, 12, 0, this.gameCanvas.imgNumber[0], false);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 12, this.gameCanvas.LOBBYABILITY[22 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                } else {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 40 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 12, this.gameCanvas.LOBBYABILITY[22 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                }
                if (this.gameCanvas.LOBBYABILITY[29 + this.cursorOfItem] == 0) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 7, 0, 7, 9);
                } else if (this.gameCanvas.LOBBYABILITY[29 + this.cursorOfItem] == 5) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 37 + 19, DC.LCD_VCENTER + 53 - 16, 12, 0, this.gameCanvas.imgNumber[0], false);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 12, this.gameCanvas.LOBBYABILITY[29 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                } else {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 12, this.gameCanvas.LOBBYABILITY[29 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                }
            } else if (this.scroll == 4) {
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[151], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 39 - 16, 20);
                DC.DrawString(GameMode.g, DM.STR[155], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 52 - 16, 20);
                if (this.gameCanvas.LOBBYABILITY[29 + this.cursorOfItem] == 0) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 7, 0, 7, 9);
                } else if (this.gameCanvas.LOBBYABILITY[29 + this.cursorOfItem] == 5) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 40 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 37 + 19, DC.LCD_VCENTER + 40 - 16, 12, 0, this.gameCanvas.imgNumber[0], false);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 12, this.gameCanvas.LOBBYABILITY[29 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                } else {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 40 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 12, this.gameCanvas.LOBBYABILITY[29 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                }
                if (this.gameCanvas.LOBBYABILITY[36 + this.cursorOfItem] == 0) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 7, 0, 7, 9);
                } else if (this.gameCanvas.LOBBYABILITY[36 + this.cursorOfItem] == 5) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 37 + 19, DC.LCD_VCENTER + 53 - 16, 12, 0, this.gameCanvas.imgNumber[0], false);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 12, this.gameCanvas.LOBBYABILITY[36 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                } else {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 12, this.gameCanvas.LOBBYABILITY[36 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                }
            } else if (this.scroll == 5) {
                DC.SetColor(GameMode.g, 0, 0, 0);
                DC.DrawString(GameMode.g, DM.STR[155], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 39 - 16, 20);
                DC.DrawString(GameMode.g, DM.STR[150], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 52 - 16, 20);
                if (this.gameCanvas.LOBBYABILITY[36 + this.cursorOfItem] == 0) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 7, 0, 7, 9);
                } else if (this.gameCanvas.LOBBYABILITY[36 + this.cursorOfItem] == 5) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 40 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 37 + 19, DC.LCD_VCENTER + 40 - 16, 12, 0, this.gameCanvas.imgNumber[0], false);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 12, this.gameCanvas.LOBBYABILITY[36 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                } else {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 40 - 16, 14, 0, 7, 9);
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 40 - 16, 28, 0, 3, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 16, 12, this.gameCanvas.LOBBYABILITY[36 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
                }
                if (this.gameCanvas.LOBBYABILITY[this.cursorOfItem + 1] == 0) {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 16, 7, 0, 7, 9);
                } else {
                    this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 17 + 19, DC.LCD_VCENTER + 53 - 16, 0, 0, 7, 9);
                    this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 16, 8, this.gameCanvas.LOBBYABILITY[this.cursorOfItem + 1], this.gameCanvas.imgNumber[0], false);
                }
            }
            this.gameCanvas.xFontB.tool_SetSpace(DC.LCD_HCENTER - 75 - 10, DC.LCD_HCENTER - 75 - 10);
            this.gameCanvas.xFontB.tool_DrawText3(GameMode.g, 0, DM.STR[77 + this.cursorOfItem], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 4);
            DC.DrawImage(GameMode.g, this.imgParts[2], DC.LCD_HCENTER - 84 + 50, DC.LCD_VCENTER + 89, 20);
            DC.DrawImage(GameMode.g, this.imgParts[6], DC.LCD_HCENTER - 4 + this.imgParts[2].getWidth(), DC.LCD_VCENTER + 89, 20);
            if (GameCanvas.mainFrame % 10 == 0) {
                ++this.scroll;
                this.scroll %= 6;
            }
        } else if (this.cursorOfTab == 3) {
            DC.SetColor(GameMode.g, 0, 0, 0);
            DC.DrawString(GameMode.g, DM.STR[711 + this.cursorOfItem], DC.LCD_HCENTER, DC.LCD_VCENTER - 81, 17);
            if (this.isKong) {
                this.gameCanvas.paint_ItemPrice(DC.LCD_HCENTER - 73 - 10, DC.LCD_VCENTER - 15, this.OFFICEITEMEXPENSE[this.cursorOfItem] / 1000, this.isKong);
            } else {
                this.gameCanvas.paint_ItemPrice(DC.LCD_HCENTER - 73 - 10, DC.LCD_VCENTER - 15, this.OFFICEITEMEXPENSE[this.cursorOfItem], this.isKong);
            }
            DC.SetClip(GameMode.g, DC.LCD_HCENTER - 50, DC.LCD_VCENTER - 34 - 24, 100, 32);
            DC.DrawImage(GameMode.g, this.imgItemIcon[this.cursorOfItem], DC.LCD_HCENTER, DC.LCD_VCENTER - 18 - 24, 3);
            DC.SetClip(GameMode.g, 0, 0, DC.LCD_WIDTH, DC.LCD_HEIGHT);
            if (this.gameCanvas.officeDecoOn[this.cursorOfItem]) {
                DC.DrawImage(GameMode.g, this.imgParts[1], DC.LCD_HCENTER + 4, DC.LCD_VCENTER - 18 - 24, 3);
            }
            DC.SetColor(GameMode.g, 0, 0, 0);
            DC.DrawString(GameMode.g, DM.STR[150], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 39 - 17, 20);
            DC.DrawString(GameMode.g, DM.STR[155], DC.LCD_HCENTER - 54 - 19 - 10, DC.LCD_VCENTER + 52 - 17, 20);
            this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 40 - 17, 0, 0, 7, 9);
            this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 29 + 19, DC.LCD_VCENTER + 53 - 17, 14, 0, 7, 9);
            this.gameCanvas.tool_DrawClippedImage(this.gameCanvas.imgNumber[1], DC.LCD_HCENTER + 45 + 19, DC.LCD_VCENTER + 53 - 17, 28, 0, 3, 9);
            this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 40 - 17, 8, this.gameCanvas.OFFICEITEMABILITY[this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
            this.gameCanvas.tool_DrawNumber(DC.LCD_HCENTER + 49 + 19, DC.LCD_VCENTER + 53 - 17, 12, this.gameCanvas.OFFICEITEMABILITY[11 + this.cursorOfItem], this.gameCanvas.imgNumber[0], false);
            this.gameCanvas.xFontB.tool_SetSpace(DC.LCD_HCENTER - 75 - 10, DC.LCD_HCENTER - 75 - 10);
            this.gameCanvas.xFontB.tool_DrawText3(GameMode.g, 0, DM.STR[66 + this.cursorOfItem], DC.LCD_HCENTER - 50 - this.frameOfString * 1, DC.LCD_VCENTER + 4);
            if (this.frameOfString * 1 > GameCanvas.tool_GetStrLen(DM.STR[66 + this.cursorOfItem])) {
                this.frameOfString = -10;
            }
            DC.DrawImage(GameMode.g, this.imgParts[2], DC.LCD_HCENTER - 84 + 50, DC.LCD_VCENTER + 89, 20);
            DC.DrawImage(GameMode.g, this.imgParts[6], DC.LCD_HCENTER - 4 + this.imgParts[2].getWidth(), DC.LCD_VCENTER + 89, 20);
        }
        if (this.isSelected) {
            if (this.isArrowLeft) {
                this.gameCanvas.tool_DrawClippedImage(this.imgParts[0], DC.LCD_HCENTER - 70, DC.LCD_VCENTER - 48, 22, 0, 11, 12);
            } else {
                this.gameCanvas.tool_DrawClippedImage(this.imgParts[0], DC.LCD_HCENTER - 70, DC.LCD_VCENTER - 48, 0, 0, 11, 12);
            }
            if (this.isArrowRight) {
                this.gameCanvas.tool_DrawClippedImage(this.imgParts[0], DC.LCD_HCENTER + 59, DC.LCD_VCENTER - 48, 33, 0, 11, 12);
            } else {
                this.gameCanvas.tool_DrawClippedImage(this.imgParts[0], DC.LCD_HCENTER + 59, DC.LCD_VCENTER - 48, 11, 0, 11, 12);
            }
        }
        if (this.isKong) {
            this.gameCanvas.paint_MyMoney(DC.LCD_HCENTER - 73 - 10, DC.LCD_VCENTER + 54, this.gameCanvas.dataMyKong, this.isKong);
        } else {
            this.gameCanvas.paint_MyMoney(DC.LCD_HCENTER - 73 - 10, DC.LCD_VCENTER + 54, this.gameCanvas.dataMyMoney, this.isKong);
        }
        this.isArrowRight = false;
        this.isArrowLeft = false;
        ++this.frameOfString;
    }

    public void process_Run() {
        int npc;
        this.gameCanvas.isTimeStop = this.isManaged || this.stateOfLobby == this.STATE_HOTMENU || this.stateOfLobby == this.STATE_TUTORIAL || this.popup > 0 || this.isMiniMapOn;
        if (this.stateOfLobby == this.STATE_TUTORIAL) {
            this.numNPC = 1;
            return;
        }
        if (!this.gameCanvas.isTimeStop && GameCanvas.mainFrame % 20 == 0 && GameCanvas.rand(100) < 50) {
            for (npc = 1; npc < 5; ++npc) {
                if (this.lobbyNPC[npc].getIsLived()) continue;
                do {
                    this.lobbyNPC[npc] = new LobbyNPC(GameCanvas.rand(6), GameCanvas.rand(9));
                } while (!this.process_CheckNPC(npc));
                this.lobbyNPC[npc].setFrame(GameCanvas.rand(4));
                this.lobbyNPC[npc].setSpeech(this.process_SetLobbyNPCSpeech());
                this.process_InitImageNPC(npc);
                break;
            }
        }
        this.numNPC = 1;
        for (npc = 1; npc < 5; ++npc) {
            if (!this.lobbyNPC[npc].getIsLived()) continue;
            if (this.lobbyNPC[npc].getIsGoal()) {
                this.lobbyNPC[npc] = new LobbyNPC();
                this.imgNPC[npc - 1] = null;
                System.gc();
                continue;
            }
            ++this.numNPC;
        }
    }

    public void process_Scroll() {
        this.cursorOfScroll = this.gameCanvas.workingDay ? (this.gameCanvas.timeTodayHours < 9 ? 0 : (this.gameCanvas.timeTodayHours >= 18 ? 3 : 2)) : 1;
    }

    public void process_SelectSort() {
        int min = 0;
        int temp = 0;
        int count = 0;
        this.arrIndex = new int[this.numNPC];
        this.arrIndex[0] = 0;
        for (int npc = 0; npc < 5; ++npc) {
            if (!this.lobbyNPC[npc].getIsLived()) continue;
            this.arrIndex[count] = npc;
            ++count;
        }
        for (int num = 0; num < this.arrIndex.length - 1; ++num) {
            min = num;
            for (int _num = num + 1; _num < this.arrIndex.length; ++_num) {
                if (this.lobbyNPC[this.arrIndex[_num]].getPosY() > this.lobbyNPC[this.arrIndex[min]].getPosY()) continue;
                min = _num;
            }
            temp = this.arrIndex[min];
            this.arrIndex[min] = this.arrIndex[num];
            this.arrIndex[num] = temp;
        }
    }

    public void process_SellyFrame() {
        if (this.gameCanvas.isKeyMove && !this.isManaged && !this.isMiniMapOn && this.popup <= 0) {
            if (this.stateOfLobby == this.STATE_LOBBY) {
                this.lobbyNPC[0].setFrame((this.lobbyNPC[0].getFrame() + 1) % 4);
                this.process_SetCharDirect(0, this.lobbyNPC[0].getKey());
                this.process_MoveChar(0);
            }
        } else if (this.stateOfLobby == this.STATE_LOBBY) {
            this.lobbyNPC[0].setFrame(4);
        }
    }

    public int process_SetLobbyNPCSpeech() {
        int rand = GameCanvas.rand(6);
        int speech = 0;
        if (rand == 0) {
            speech = this.gameCanvas.verBestHospital < 1 || this.gameCanvas.dataNowLobby < 1 ? 0 : (this.gameCanvas.verBestHospital == 3 && this.gameCanvas.dataNowLobby == 6 ? 2 : 1);
        } else if (rand == 1) {
            speech = this.gameCanvas.verBestDoctor < 1 || this.gameCanvas.verBestNurse < 1 ? 3 : (this.gameCanvas.verBestDoctor == 4 && this.gameCanvas.verBestNurse == 4 ? 5 : 4);
        } else if (rand == 2) {
            speech = this.gameCanvas.nowDress == 0 ? 6 : (this.gameCanvas.nowDress == 9 || this.gameCanvas.nowDress == 10 ? 8 : 7);
        } else if (rand == 3) {
            speech = this.gameCanvas.nowCar == 0 ? 9 : (this.gameCanvas.nowCar == 9 || this.gameCanvas.nowCar == 10 ? 11 : 10);
        } else if (rand == 4) {
            int num = 0;
            for (int pet = 0; pet < 10; ++pet) {
                if (!this.gameCanvas.petOn2[pet]) continue;
                ++num;
            }
            speech = num == 0 ? 12 : 13;
        } else {
            speech = 14 + GameCanvas.rand(3);
        }
        return speech;
    }

    public void process_SettingTalk(int npc) {
        if (this.talkingNPC == 0) {
            String[] str = this.gameCanvas.tool_GetString("npc");
            this.strNPCWords[0] = str[17 * this.lobbyNPC[npc].getState() + this.lobbyNPC[npc].getSpeech()];
            str = null;
            System.gc();
            this.lobbyNPC[0].setIsDialogue(true);
            this.lobbyNPC[npc].setIsDialogue(true);
            this.talkingNPC = npc;
            this.petRand = GameCanvas.rand(10000);
            if (this.lobbyNPC[npc].getIsChance() && GameCanvas.rand(100) < 30 && (this.lobbyNPC[npc].getSpeech() == 12 && this.petRand == 0 || this.lobbyNPC[npc].getSpeech() < 14 && this.lobbyNPC[npc].getSpeech() != 12)) {
                this.isGetOn = true;
                for (int d = 0; d < 4; ++d) {
                    this.isDirect[d] = false;
                }
                LobbyH.isPass = false;
            }
            this.lobbyNPC[npc].setIsChance(false);
        }
    }

    public void process_GetItemFromNPC(int npc) {
        int rand = GameCanvas.rand(100);
        switch (this.lobbyNPC[npc].getSpeech()) {
            case 0: {
                this.popup = 20;
                this.gameCanvas.statusOfSelly[2] = this.gameCanvas.statusOfSelly[2] + 1;
                break;
            }
            case 1: {
                this.popup = 21;
                this.gameCanvas.statusOfSelly[2] = this.gameCanvas.statusOfSelly[2] + 3;
                break;
            }
            case 2: {
                this.popup = 22;
                this.gameCanvas.statusOfSelly[2] = this.gameCanvas.statusOfSelly[2] + 5;
                break;
            }
            case 3: {
                this.popup = 23;
                this.itemNum = rand = GameCanvas.rand(18);
                int n = rand;
                this.gameCanvas.martItem[n] = this.gameCanvas.martItem[n] + 5;
                if (this.gameCanvas.martItem[rand] > 99) {
                    this.gameCanvas.martItem[rand] = 99;
                }
                this.gameCanvas.statusOfSelly[1] = this.gameCanvas.statusOfSelly[1] + 1;
                break;
            }
            case 4: {
                this.popup = 24;
                this.itemNum = rand = GameCanvas.rand(18);
                int n = rand;
                this.gameCanvas.martItem[n] = this.gameCanvas.martItem[n] + 5;
                if (this.gameCanvas.martItem[rand] > 99) {
                    this.gameCanvas.martItem[rand] = 99;
                }
                this.gameCanvas.statusOfSelly[1] = this.gameCanvas.statusOfSelly[1] + 3;
                break;
            }
            case 5: {
                this.popup = 25;
                this.itemNum = rand = GameCanvas.rand(18);
                int n = rand;
                this.gameCanvas.martItem[n] = this.gameCanvas.martItem[n] + 5;
                if (this.gameCanvas.martItem[rand] > 99) {
                    this.gameCanvas.martItem[rand] = 99;
                }
                this.gameCanvas.statusOfSelly[1] = this.gameCanvas.statusOfSelly[1] + 5;
                break;
            }
            case 6: {
                this.popup = 26;
                this.gameCanvas.statusOfSelly[6] = this.gameCanvas.statusOfSelly[6] + 1;
                break;
            }
            case 7: {
                this.popup = 27;
                this.gameCanvas.statusOfSelly[6] = this.gameCanvas.statusOfSelly[6] + 3;
                break;
            }
            case 8: {
                this.popup = 28;
                this.gameCanvas.statusOfSelly[6] = this.gameCanvas.statusOfSelly[6] + 5;
                break;
            }
            case 9: {
                this.popup = 29;
                this.gameCanvas.statusOfSelly[7] = this.gameCanvas.statusOfSelly[7] + 1;
                break;
            }
            case 10: {
                this.popup = 30;
                this.gameCanvas.statusOfSelly[7] = this.gameCanvas.statusOfSelly[7] + 3;
                break;
            }
            case 11: {
                this.popup = 31;
                this.gameCanvas.statusOfSelly[7] = this.gameCanvas.statusOfSelly[7] + 5;
                break;
            }
            case 12: {
                this.popup = 32;
                rand = GameCanvas.rand(1000);
                rand = rand < 300 ? 0 : (rand < 600 ? 1 : (rand < 900 ? 2 : (rand < 920 ? 3 : (rand < 940 ? 4 : (rand < 960 ? 5 : (rand < 980 ? 6 : (rand < 990 ? 7 : (rand < 996 ? 8 : 9))))))));
                if (this.gameCanvas.petOn[rand] == null) {
                    this.petPossible = true;
                    this.itemNum = rand;
                }
                this.gameCanvas.process_PetInit(this.itemNum);
                break;
            }
            case 13: {
                this.popup = 33;
                this.itemNum = rand = GameCanvas.rand(24);
                if (rand < 11) {
                    int n = rand;
                    this.gameCanvas.petFoodItem[n] = this.gameCanvas.petFoodItem[n] + 5;
                    if (this.gameCanvas.petFoodItem[rand] > 99) {
                        this.gameCanvas.petFoodItem[rand] = 99;
                    }
                } else if (rand < 21) {
                    int n = rand - 11;
                    this.gameCanvas.petGiftItem[n] = this.gameCanvas.petGiftItem[n] + 5;
                    if (this.gameCanvas.petGiftItem[rand - 11] > 99) {
                        this.gameCanvas.petGiftItem[rand - 11] = 99;
                    }
                } else {
                    int n = rand - 21;
                    this.gameCanvas.petCureItem[n] = this.gameCanvas.petCureItem[n] + 5;
                    if (this.gameCanvas.petCureItem[rand - 21] > 99) {
                        this.gameCanvas.petCureItem[rand - 21] = 99;
                    }
                }
                this.gameCanvas.petOn[this.gameCanvas.nowPet].addFriendShip(10);
            }
        }
    }

    public void process_SellyMeetsNPC(int npc) {
        if (this.lobbyNPC[0].getPosX() == this.lobbyNPC[npc].getPosX() && this.lobbyNPC[0].getPosY() - 1 == this.lobbyNPC[npc].getPosY()) {
            this.process_SettingTalk(npc);
        } else if (this.lobbyNPC[0].getPosX() == this.lobbyNPC[npc].getPosX() && this.lobbyNPC[0].getPosY() + 1 == this.lobbyNPC[npc].getPosY()) {
            this.process_SettingTalk(npc);
        } else if (this.lobbyNPC[0].getPosY() == this.lobbyNPC[npc].getPosY() && this.lobbyNPC[0].getPosX() - 1 == this.lobbyNPC[npc].getPosX()) {
            this.process_SettingTalk(npc);
        } else if (this.lobbyNPC[0].getPosY() == this.lobbyNPC[npc].getPosY() && this.lobbyNPC[0].getPosX() + 1 == this.lobbyNPC[npc].getPosX()) {
            this.process_SettingTalk(npc);
        } else if (npc == this.talkingNPC) {
            this.lobbyNPC[0].setIsDialogue(false);
            this.lobbyNPC[this.talkingNPC].setIsDialogue(false);
            this.talkingNPC = 0;
        }
    }

    public void process_SetSellyDirect(int direct) {
        if (this.gameCanvas.isKeyMove && !this.isManaged && !this.isMiniMapOn && this.popup <= 0 && this.stateOfLobby == this.STATE_LOBBY) {
            for (int num = 0; num < 4; ++num) {
                this.isDirect[num] = false;
            }
            this.isDirect[direct] = true;
            this.lobbyNPC[0].setKey(direct);
        }
    }

    public void process_MoveChar(int npc) {
        switch (this.lobbyNPC[npc].getDirect()) {
            case 0: {
                if (this.lobbyNPC[npc].getPosY() <= 0) break;
                this.lobbyNPC[npc].setPosY(this.lobbyNPC[npc].getPosY() - 1);
                break;
            }
            case 1: {
                if (this.lobbyNPC[npc].getPosX() <= 0 || this.lobbyNPC[npc].getPosY() <= 0) break;
                this.lobbyNPC[npc].setPosX(this.lobbyNPC[npc].getPosX() - 1);
                this.lobbyNPC[npc].setPosY(this.lobbyNPC[npc].getPosY() - 1);
                break;
            }
            case 2: {
                if (this.lobbyNPC[npc].getPosX() >= LobbyH.LOBBYMAP[0].length - 1 || this.lobbyNPC[npc].getPosY() <= 0) break;
                this.lobbyNPC[npc].setPosX(this.lobbyNPC[npc].getPosX() + 1);
                this.lobbyNPC[npc].setPosY(this.lobbyNPC[npc].getPosY() - 1);
                break;
            }
            case 3: {
                if (this.lobbyNPC[npc].getPosX() <= 0) break;
                this.lobbyNPC[npc].setPosX(this.lobbyNPC[npc].getPosX() - 1);
                break;
            }
            case 4: {
                if (this.lobbyNPC[npc].getPosX() >= LobbyH.LOBBYMAP[0].length - 1) break;
                this.lobbyNPC[npc].setPosX(this.lobbyNPC[npc].getPosX() + 1);
                break;
            }
            case 5: {
                if (this.lobbyNPC[npc].getPosY() >= LobbyH.LOBBYMAP.length - 1) break;
                this.lobbyNPC[npc].setPosY(this.lobbyNPC[npc].getPosY() + 1);
                break;
            }
            case 6: {
                if (this.lobbyNPC[npc].getPosX() <= 0 || this.lobbyNPC[npc].getPosY() >= LobbyH.LOBBYMAP.length - 1) break;
                this.lobbyNPC[npc].setPosX(this.lobbyNPC[npc].getPosX() - 1);
                this.lobbyNPC[npc].setPosY(this.lobbyNPC[npc].getPosY() + 1);
                break;
            }
            case 7: {
                if (this.lobbyNPC[npc].getPosX() >= LobbyH.LOBBYMAP[0].length - 1 || this.lobbyNPC[npc].getPosY() >= LobbyH.LOBBYMAP.length - 1) break;
                this.lobbyNPC[npc].setPosX(this.lobbyNPC[npc].getPosX() + 1);
                this.lobbyNPC[npc].setPosY(this.lobbyNPC[npc].getPosY() + 1);
            }
        }
    }

    public void process_SetCharDirect(int npc, int key) {
        switch (key) {
            case 0: {
                if (this.lobbyNPC[npc].getPosY() > 0) {
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX()] != 1) {
                        this.lobbyNPC[npc].setViewDirect(0);
                        this.lobbyNPC[npc].setDirect(0);
                        break;
                    }
                    if (this.lobbyNPC[npc].getPosX() - 1 != -1) {
                        if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                            this.lobbyNPC[npc].setViewDirect(2);
                            this.lobbyNPC[npc].setDirect(1);
                            break;
                        }
                        if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX() + 1] != 1) {
                            this.lobbyNPC[npc].setViewDirect(3);
                            this.lobbyNPC[npc].setDirect(2);
                            break;
                        }
                        if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                            this.lobbyNPC[npc].setViewDirect(2);
                            this.lobbyNPC[npc].setDirect(3);
                            break;
                        }
                        if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() + 1] != 1) {
                            this.lobbyNPC[npc].setViewDirect(3);
                            this.lobbyNPC[npc].setDirect(4);
                            break;
                        }
                        this.lobbyNPC[npc].setDirect(8);
                        break;
                    }
                    this.lobbyNPC[npc].setDirect(8);
                    break;
                }
                this.lobbyNPC[npc].setDirect(8);
                break;
            }
            case 1: {
                if (this.lobbyNPC[npc].getPosY() < LobbyH.LOBBYMAP.length - 1) {
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX()] != 1) {
                        this.lobbyNPC[npc].setViewDirect(1);
                        this.lobbyNPC[npc].setDirect(5);
                        break;
                    }
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                        this.lobbyNPC[npc].setViewDirect(2);
                        this.lobbyNPC[npc].setDirect(6);
                        break;
                    }
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX() + 1] != 1) {
                        this.lobbyNPC[npc].setViewDirect(3);
                        this.lobbyNPC[npc].setDirect(7);
                        break;
                    }
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                        this.lobbyNPC[npc].setViewDirect(2);
                        this.lobbyNPC[npc].setDirect(3);
                        break;
                    }
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() + 1] != 1) {
                        this.lobbyNPC[npc].setViewDirect(3);
                        this.lobbyNPC[npc].setDirect(4);
                        break;
                    }
                    this.lobbyNPC[npc].setDirect(8);
                    break;
                }
                this.lobbyNPC[npc].setDirect(8);
                break;
            }
            case 2: {
                if (this.lobbyNPC[npc].getPosX() > 0) {
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                        this.lobbyNPC[npc].setViewDirect(2);
                        this.lobbyNPC[npc].setDirect(3);
                        break;
                    }
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                        this.lobbyNPC[npc].setViewDirect(2);
                        this.lobbyNPC[npc].setDirect(1);
                        break;
                    }
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                        this.lobbyNPC[npc].setViewDirect(2);
                        this.lobbyNPC[npc].setDirect(6);
                        break;
                    }
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX()] != 1) {
                        this.lobbyNPC[npc].setViewDirect(2);
                        this.lobbyNPC[npc].setDirect(0);
                        break;
                    }
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX()] != 1) {
                        this.lobbyNPC[npc].setViewDirect(2);
                        this.lobbyNPC[npc].setDirect(5);
                        break;
                    }
                    this.lobbyNPC[npc].setDirect(8);
                    break;
                }
                this.lobbyNPC[npc].setDirect(8);
                break;
            }
            case 3: {
                if (this.lobbyNPC[npc].getPosX() < LobbyH.LOBBYMAP[0].length - 1) {
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() + 1] != 1) {
                        this.lobbyNPC[npc].setViewDirect(3);
                        this.lobbyNPC[npc].setDirect(4);
                        break;
                    }
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX() + 1] != 1) {
                        this.lobbyNPC[npc].setViewDirect(3);
                        this.lobbyNPC[npc].setDirect(2);
                        break;
                    }
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX() + 1] != 1) {
                        this.lobbyNPC[npc].setViewDirect(3);
                        this.lobbyNPC[npc].setDirect(7);
                        break;
                    }
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX()] != 1) {
                        this.lobbyNPC[npc].setViewDirect(3);
                        this.lobbyNPC[npc].setDirect(0);
                        break;
                    }
                    if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX()] != 1) {
                        this.lobbyNPC[npc].setViewDirect(3);
                        this.lobbyNPC[npc].setDirect(5);
                        break;
                    }
                    this.lobbyNPC[npc].setDirect(8);
                    break;
                }
                this.lobbyNPC[npc].setDirect(8);
            }
        }
    }

    public void process_DirectCharacter(int npc, int direct) {
        switch (direct) {
            case 0: {
                if (this.lobbyNPC[npc].getPosY() <= 0) break;
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX()] != 1) {
                    this.lobbyNPC[npc].setViewDirect(0);
                    break;
                }
                if (this.lobbyNPC[npc].getPosX() - 1 == -1) break;
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                    this.lobbyNPC[npc].setViewDirect(2);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX() + 1] != 1) {
                    this.lobbyNPC[npc].setViewDirect(3);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                    this.lobbyNPC[npc].setViewDirect(2);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() + 1] == 1) break;
                this.lobbyNPC[npc].setViewDirect(3);
                break;
            }
            case 1: {
                if (this.lobbyNPC[npc].getPosY() >= LobbyH.LOBBYMAP.length - 1) break;
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX()] != 1) {
                    this.lobbyNPC[npc].setViewDirect(1);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                    this.lobbyNPC[npc].setViewDirect(2);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX() + 1] != 1) {
                    this.lobbyNPC[npc].setViewDirect(3);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                    this.lobbyNPC[npc].setViewDirect(2);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() + 1] == 1) break;
                this.lobbyNPC[npc].setViewDirect(3);
                break;
            }
            case 2: {
                if (this.lobbyNPC[npc].getPosX() <= 0) break;
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                    this.lobbyNPC[npc].setViewDirect(2);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                    this.lobbyNPC[npc].setViewDirect(2);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX() - 1] != 1) {
                    this.lobbyNPC[npc].setViewDirect(2);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX()] != 1) {
                    this.lobbyNPC[npc].setViewDirect(2);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX()] == 1) break;
                this.lobbyNPC[npc].setViewDirect(2);
                break;
            }
            case 3: {
                if (this.lobbyNPC[npc].getPosX() >= LobbyH.LOBBYMAP[0].length - 1) break;
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() + 1] != 1) {
                    this.lobbyNPC[npc].setViewDirect(3);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX() + 1] != 1) {
                    this.lobbyNPC[npc].setViewDirect(3);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX() + 1] != 1) {
                    this.lobbyNPC[npc].setViewDirect(3);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX()] != 1) {
                    this.lobbyNPC[npc].setViewDirect(3);
                    break;
                }
                if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX()] == 1) break;
                this.lobbyNPC[npc].setViewDirect(3);
            }
        }
    }

    public void process_DirectPattern1(int npc) {
        if (this.lobbyNPC[npc].getPosY() < this.lobbyNPC[npc].getEndY()) {
            if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX()] % 10 == 1) {
                if (this.lobbyNPC[npc].getPosX() < this.lobbyNPC[npc].getEndX() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() + 1] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(3);
                } else if (this.lobbyNPC[npc].getPosX() > this.lobbyNPC[npc].getEndX() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() - 1] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(2);
                }
            } else {
                this.lobbyNPC[npc].setKey(1);
            }
        } else if (this.lobbyNPC[npc].getPosY() > this.lobbyNPC[npc].getEndY()) {
            if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX()] % 10 == 1) {
                if (this.lobbyNPC[npc].getPosX() < this.lobbyNPC[npc].getEndX() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() + 1] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(3);
                } else if (this.lobbyNPC[npc].getPosX() > this.lobbyNPC[npc].getEndX() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() - 1] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(2);
                }
            } else {
                this.lobbyNPC[npc].setKey(0);
            }
        } else if (this.lobbyNPC[npc].getPosX() < this.lobbyNPC[npc].getEndX()) {
            if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() + 1] % 10 == 1) {
                if (this.lobbyNPC[npc].getPosY() < this.lobbyNPC[npc].getEndY() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX()] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(1);
                } else if (this.lobbyNPC[npc].getPosY() > this.lobbyNPC[npc].getEndY() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX()] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(0);
                }
            } else {
                this.lobbyNPC[npc].setKey(3);
            }
        } else if (this.lobbyNPC[npc].getPosX() > this.lobbyNPC[npc].getEndX()) {
            if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() - 1] % 10 == 1) {
                if (this.lobbyNPC[npc].getPosY() < this.lobbyNPC[npc].getEndY() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX()] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(1);
                } else if (this.lobbyNPC[npc].getPosY() > this.lobbyNPC[npc].getEndY() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX()] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(0);
                }
            } else {
                this.lobbyNPC[npc].setKey(2);
            }
        } else {
            this.lobbyNPC[npc].setFrame(0);
            this.lobbyNPC[npc].setIsGoal(true);
        }
    }

    public void process_DirectPattern2(int npc) {
        if (this.lobbyNPC[npc].getPosX() < this.lobbyNPC[npc].getEndX()) {
            if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() + 1] % 10 == 1) {
                if (this.lobbyNPC[npc].getPosY() < this.lobbyNPC[npc].getEndY() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX()] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(0);
                } else if (this.lobbyNPC[npc].getPosY() > this.lobbyNPC[npc].getEndY() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX()] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(1);
                }
            } else {
                this.lobbyNPC[npc].setKey(3);
            }
        } else if (this.lobbyNPC[npc].getPosX() > this.lobbyNPC[npc].getEndX()) {
            if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() - 1] % 10 == 1) {
                if (this.lobbyNPC[npc].getPosY() < this.lobbyNPC[npc].getEndY() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX()] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(0);
                } else if (this.lobbyNPC[npc].getPosY() > this.lobbyNPC[npc].getEndY() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX()] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(1);
                }
            } else {
                this.lobbyNPC[npc].setKey(2);
            }
        } else if (this.lobbyNPC[npc].getPosY() < this.lobbyNPC[npc].getEndY()) {
            if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() + 1][this.lobbyNPC[npc].getPosX()] % 10 == 1) {
                if (this.lobbyNPC[npc].getPosX() < this.lobbyNPC[npc].getEndX() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() + 1] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(3);
                } else if (this.lobbyNPC[npc].getPosX() > this.lobbyNPC[npc].getEndX() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() - 1] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(2);
                }
            } else {
                this.lobbyNPC[npc].setKey(1);
            }
        } else if (this.lobbyNPC[npc].getPosY() > this.lobbyNPC[npc].getEndY()) {
            if (LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY() - 1][this.lobbyNPC[npc].getPosX()] % 10 == 1) {
                if (this.lobbyNPC[npc].getPosX() < this.lobbyNPC[npc].getEndX() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() + 1] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(3);
                } else if (this.lobbyNPC[npc].getPosX() > this.lobbyNPC[npc].getEndX() && LobbyH.LOBBYMAP[this.lobbyNPC[npc].getPosY()][this.lobbyNPC[npc].getPosX() - 1] % 10 != 1) {
                    this.lobbyNPC[npc].setKey(2);
                }
            } else {
                this.lobbyNPC[npc].setKey(0);
            }
        } else {
            this.lobbyNPC[npc].setFrame(0);
            this.lobbyNPC[npc].setIsGoal(true);
        }
    }

    public void process_NoticeWorkingDay() {
        if (this.gameCanvas.workingDay && !this.gameCanvas.goHospital && this.gameCanvas.timeTodayHours >= 7 && this.gameCanvas.timeTodayHours < 9) {
            this.gameCanvas.isTimeStop = true;
            this.popup = 17;
        }
    }

    public void process_NoticeCured() {
        if (this.gameCanvas.workingDay && this.gameCanvas.timeTodayHours >= 18) {
            if (!this.gameCanvas.isCured && !this.gameCanvas.isShowedDeCurePopup) {
                this.gameCanvas.isAlertDeCurePopup = true;
            }
        } else {
            this.gameCanvas.isCured = false;
            this.gameCanvas.isShowedDeCurePopup = false;
        }
    }

    public void process_InitImageNPC(int num) {
        this.imgNPC[num - 1] = null;
        System.gc();
        this.imgNPC[num - 1] = this.imgNPC_ALL[4 * this.lobbyNPC[num].getState() + this.lobbyNPC[num].getViewDirect()];
    }

    public boolean process_CheckNPC(int npc) {
        boolean check = true;
        for (int _npc = 1; _npc < 5; ++_npc) {
            if (npc == _npc || this.lobbyNPC[npc].getState() != this.lobbyNPC[_npc].getState()) continue;
            check = false;
            break;
        }
        return check;
    }

    public void keyPressed(int keyCode) {
        if (DM.DEBUG != 0) {
            System.out.println("isKeyMove : " + this.gameCanvas.isKeyMove);
        }
        if (DM.DEBUG != 0) {
            System.out.print(">>>>> GAME_LOBBY ");
        }
        if (this.isGetOn) {
            LobbyH.isPass = false;
            this.process_GetItemFromNPC(this.talkingNPC);
            this.isGetOn = false;
            this.petPossible = false;
            if (DM.DEBUG == 88) {
                System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 30");
            }
            this.gameCanvas.process_Save();
            return;
        }
        if (this.stateOfLobby == this.STATE_TUTORIAL) {
            switch (keyCode) {
                case -5: 
                case 53: {
                    if (this.cursorOfTalk * 3 + 2 >= this.gameCanvas.xFontB.tool_DrawText2(GameMode.g, 0, this.strTutorial[0], 10, DC.LCD_HEIGHT - 46, this.cursorOfTalk * 3, 3)) {
                        this.gameCanvas.nHospitalTutorial = 1;
                        this.gameCanvas.isNewGame = true;
                        this.gameCanvas.setState(3);
                        break;
                    }
                    ++this.cursorOfTalk;
                }
            }
            return;
        }
        if (this.stateOfLobby == this.STATE_HOTMENU) {
            LobbyH.isPass = false;
            if (this.hotmenu.stateOfHotmenu == 99 && (keyCode == -7 && Hotmenu.popUp == 0 || this.hotmenu.cursorOfHotmenu == 0 && keyCode == -5)) {
                this.hotmenu.process_ReleaseImage();
                this.hotmenu.process_ReleaseValue();
                this.hotmenu = null;
                System.gc();
                this.stateOfLobby = this.STATE_LOBBY;
                if (GameCanvas.optionVolume == 0) {
                    this.gameCanvas.soundManager.StopSound();
                } else {
                    this.gameCanvas.soundManager.tool_PlaySound("lobby", true);
                }
            } else {
                this.hotmenu.keyPressed(keyCode);
            }
            return;
        }
        if (this.isMiniMapOn) {
            switch (keyCode) {
                case -4: 
                case 54: {
                    this.cursorOfMiniMap = (this.cursorOfMiniMap + 1) % 8;
                    break;
                }
                case -3: 
                case 52: {
                    this.cursorOfMiniMap = (this.cursorOfMiniMap + 7) % 8;
                    break;
                }
                case -7: 
                case 35: {
                    this.isMiniMapOn = !this.isMiniMapOn;
                    this.gameCanvas.isTimeStop = false;
                    LobbyH.isPass = false;
                    this.imgMiniMapSame = null;
                    this.imgMiniMapLobby = null;
                    System.gc();
                }
            }
            return;
        }
        if (this.gameCanvas.isAlertDeCurePopup) {
            if (keyCode == -5 || keyCode == -7 || keyCode == 53) {
                this.gameCanvas.isAlertDeCurePopup = false;
                this.gameCanvas.isShowedDeCurePopup = true;
                LobbyH.isPass = false;
                if (this.gameCanvas.dataReliability < 0) {
                    this.gameCanvas.dataReliability = 0;
                }
                this.gameCanvas.dataReliability -= 5 * this.gameCanvas.dataReliability / 100;
                if (this.gameCanvas.dataReliability < 0) {
                    this.gameCanvas.dataReliability = 0;
                }
            }
            return;
        }
        if (this.popup > 0) {
            this.keyPressedMessage(keyCode);
        } else if (this.isManaged) {
            this.keyPressedManagement(keyCode);
        } else {
            this.keyPressedLobby(keyCode);
        }
    }

    public void keyPressedLobby(int keyCode) {
        switch (keyCode) {
            case 35: {
                if (!this.isMiniMapOn) {
                    for (int i = 0; i < 4; ++i) {
                        if (!this.isDirect[i]) continue;
                        this.isDirect[i] = false;
                    }
                    this.gameCanvas.isTimeStop = true;
                    this.imgMiniMapSame = this.gameCanvas.tool_ImageLoad_Dat("minimapsame", 4);
                    this.imgMiniMapLobby = this.gameCanvas.tool_ImageLoad_Dat("lobbyminimap", 2);
                    this.isMiniMapOn = true;
                    break;
                }
                this.gameCanvas.isTimeStop = false;
                this.imgMiniMapSame = null;
                this.imgMiniMapLobby = null;
                System.gc();
                break;
            }
            case -4: 
            case 54: {
                this.process_SetSellyDirect(3);
                break;
            }
            case -3: 
            case 52: {
                this.process_SetSellyDirect(2);
                break;
            }
            case -1: 
            case 50: {
                this.process_SetSellyDirect(0);
                break;
            }
            case -2: 
            case 56: {
                this.process_SetSellyDirect(1);
                break;
            }
            case -6: {
                this.stateOfLobby = this.STATE_HOTMENU;
                this.hotmenu = new Hotmenu(this.gameCanvas);
                break;
            }
            case 42: {
                LobbyH.isPass = false;
                this.gameCanvas.stateBeforeMyInfo = 16;
                this.gameCanvas.process_InitLobbyNPC();
                for (int save = 0; save < 5; ++save) {
                    this.gameCanvas.saveLobbyNPC[save] = this.lobbyNPC[save];
                }
                this.gameCanvas.setState(27);
                break;
            }
            case -5: 
            case 53: {
                LobbyH.isPass = false;
                if (LobbyH.LOBBYMAP[this.lobbyNPC[0].getPosY()][this.lobbyNPC[0].getPosX()] % 11 == 0) break;
                switch (LobbyH.LOBBYMAP[this.lobbyNPC[0].getPosY()][this.lobbyNPC[0].getPosX()]) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        this.gameCanvas.pointCharacterX = 9;
                        this.gameCanvas.pointCharacterY = 31;
                        this.gameCanvas.setState(2);
                        if (DM.DEBUG == 88) {
                            System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 31");
                        }
                        this.gameCanvas.process_Save();
                        break;
                    }
                    case 4: {
                        if (this.gameCanvas.placeOn[12]) {
                            this.gameCanvas.placeOnPopUp = true;
                            break;
                        }
                        if (this.gameCanvas.statusOfSelly[8] == 100) {
                            this.popup = 53;
                            break;
                        }
                        this.gameCanvas.setState(17);
                        break;
                    }
                    case 5: {
                        if (this.gameCanvas.placeOn[14]) {
                            this.gameCanvas.placeOnPopUp = true;
                            break;
                        }
                        if (this.gameCanvas.statusOfSelly[8] == 100) {
                            this.popup = 53;
                            break;
                        }
                        this.gameCanvas.setState(19);
                        break;
                    }
                    case 6: {
                        if (this.gameCanvas.placeOn[13]) {
                            this.gameCanvas.placeOnPopUp = true;
                            break;
                        }
                        if (this.gameCanvas.statusOfSelly[8] == 100) {
                            this.popup = 53;
                            break;
                        }
                        this.gameCanvas.setState(18);
                        break;
                    }
                    case 7: {
                        if (this.gameCanvas.statusOfSelly[8] == 100) {
                            this.popup = 53;
                            break;
                        }
                        if (this.gameCanvas.eventPlace[this.gameCanvas.nowEventNum] == 23 && this.gameCanvas.eventCheckOn) {
                            this.gameCanvas.soundManager.tool_StopSound();
                            this.gameCanvas.setState(23);
                            break;
                        }
                        this.gameCanvas.isThrowHospital = true;
                        if (this.gameCanvas.workingDay && this.gameCanvas.timeTodayHours > 9 && this.gameCanvas.timeTodayHours < 18) {
                            this.popup = 13;
                            this.gameCanvas.timeGap = this.gameCanvas.timeTodayHours - 9;
                            this.gameCanvas.isViewPop = true;
                            break;
                        }
                        if (this.gameCanvas.workingDay && this.gameCanvas.timeTodayHours == 9) {
                            this.popup = 5;
                            this.gameCanvas.isViewPop = true;
                            break;
                        }
                        this.popup = 12;
                        if (this.gameCanvas.workingDay && this.gameCanvas.timeTodayHours >= 18) {
                            this.gameCanvas.isViewPop = true;
                            break;
                        }
                        if (this.gameCanvas.workingDay) break;
                        this.gameCanvas.isViewPop = true;
                        break;
                    }
                    case 8: {
                        if (this.gameCanvas.placeOn[15]) {
                            this.gameCanvas.placeOnPopUp = true;
                            break;
                        }
                        if (this.gameCanvas.statusOfSelly[8] == 100) {
                            this.popup = 53;
                            break;
                        }
                        this.gameCanvas.setState(20);
                        break;
                    }
                    case 9: {
                        if (this.gameCanvas.placeOn[16]) {
                            this.gameCanvas.placeOnPopUp = true;
                            break;
                        }
                        if (this.gameCanvas.statusOfSelly[8] == 100) {
                            this.popup = 53;
                            break;
                        }
                        this.gameCanvas.setState(21);
                        break;
                    }
                    case 10: {
                        LobbyH.isPass = false;
                        this.frameOfString = 50;
                        this.scroll = 0;
                        this.process_InitImageManage();
                        this.isManaged = true;
                    }
                }
                break;
            }
            default: {
                LobbyH.isPass = false;
            }
        }
    }

    public void keyPressedMessage(int keyCode) {
        switch (keyCode) {
            case -4: 
            case -3: 
            case 52: 
            case 54: {
                this.cursorOfPop = (this.cursorOfPop + 1) % 2;
                break;
            }
            case 49: {
                this.cursorOfPop = 0;
            }
            case -5: 
            case 53: {
                if (this.cursorOfPop == 0) {
                    switch (this.popup) {
                        case 54: {
                            break;
                        }
                        case 5: 
                        case 12: 
                        case 13: 
                        case 17: {
                            if (this.popup == 17) {
                                this.gameCanvas.isViewPop = true;
                            }
                            this.gameCanvas.isThrowHospital = true;
                            this.gameCanvas.isNewGame = true;
                            this.gameCanvas.setState(3);
                            if (DM.DEBUG == 88) {
                                System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 33");
                            }
                            this.gameCanvas.process_Save();
                            break;
                        }
                        case 6: {
                            this.gameCanvas.dataMyMoney -= this.DOCTORSEXPENSE[this.cursorOfItem];
                            if (this.cursorOfItem % 2 == 0) {
                                this.gameCanvas.verNowNurse = this.cursorOfItem / 2 + 1;
                                ++this.gameCanvas.verBestNurse;
                            } else {
                                this.gameCanvas.verNowDoctor = this.cursorOfItem / 2 + 1;
                                ++this.gameCanvas.verBestDoctor;
                            }
                            if (this.gameCanvas.dataReliability < 0) {
                                this.gameCanvas.dataReliability = 0;
                            }
                            this.gameCanvas.dataReliability += this.gameCanvas.DOCTORSABILITY[this.cursorOfItem + 2];
                            if (this.gameCanvas.dataReliability < 0) {
                                this.gameCanvas.dataReliability = 0;
                            }
                            if (DM.DEBUG == 88) {
                                System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 34");
                            }
                            this.gameCanvas.process_Save();
                            break;
                        }
                        case 7: {
                            this.gameCanvas.dataMyMoney -= this.UPGRADEEXPENSE[this.cursorOfItem];
                            this.gameCanvas.verNowHospital = this.cursorOfItem + 1;
                            ++this.gameCanvas.verBestHospital;
                            if (this.gameCanvas.dataReliability < 0) {
                                this.gameCanvas.dataReliability = 0;
                            }
                            this.gameCanvas.dataReliability += this.gameCanvas.UPGRADEABILITY[this.cursorOfItem + 1];
                            if (this.gameCanvas.dataReliability < 0) {
                                this.gameCanvas.dataReliability = 0;
                            }
                            if (DM.DEBUG == 88) {
                                System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 35");
                            }
                            this.gameCanvas.process_Save();
                            break;
                        }
                        case 8: {
                            this.gameCanvas.dataMyMoney -= this.LOBBYEXPENSE[this.cursorOfItem];
                            this.gameCanvas.isOpenedLobby[this.cursorOfItem + 1] = true;
                            if (this.gameCanvas.dataReliability < 0) {
                                this.gameCanvas.dataReliability = 0;
                            }
                            this.gameCanvas.dataReliability += this.gameCanvas.LOBBYABILITY[this.cursorOfItem + 1];
                            if (this.gameCanvas.dataReliability < 0) {
                                this.gameCanvas.dataReliability = 0;
                            }
                            if (this.cursorOfItem + 1 > this.gameCanvas.dataBestLobby) {
                                this.gameCanvas.dataBestLobby = this.cursorOfItem + 1;
                            }
                            this.gameCanvas.dataNowLobby = this.cursorOfItem + 1;
                            this.imgTile = null;
                            this.imgObject = null;
                            System.gc();
                            this.imgTile = this.gameCanvas.tool_ImageLoad_RoomTile(this.gameCanvas.dataNowLobby);
                            this.imgObject = this.gameCanvas.tool_ImageLoad_Dat("theme_" + this.gameCanvas.dataNowLobby, 9);
                            if (DM.DEBUG == 88) {
                                System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 36");
                            }
                            this.gameCanvas.process_Save();
                            break;
                        }
                        case 10: {
                            this.gameCanvas.dataMyMoney -= this.OFFICEITEMEXPENSE[this.cursorOfItem];
                            if (this.gameCanvas.dataReliability < 0) {
                                this.gameCanvas.dataReliability = 0;
                            }
                            this.gameCanvas.dataReliability += this.gameCanvas.OFFICEITEMABILITY[this.cursorOfItem];
                            if (this.gameCanvas.dataReliability < 0) {
                                this.gameCanvas.dataReliability = 0;
                            }
                            this.gameCanvas.officeDecoOn[this.cursorOfItem] = true;
                            if (DM.DEBUG == 88) {
                                System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 37");
                            }
                            this.gameCanvas.process_Save();
                            break;
                        }
                        case 15: {
                            this.isKong = true;
                            break;
                        }
                        case 16: {
                            switch (this.cursorOfTab) {
                                case 0: {
                                    this.gameCanvas.dataMyKong -= this.DOCTORSEXPENSE[this.cursorOfItem] / 1000;
                                    if (this.cursorOfItem % 2 == 0) {
                                        ++this.gameCanvas.verBestNurse;
                                        this.gameCanvas.verNowNurse = this.cursorOfItem / 2 + 1;
                                    } else {
                                        ++this.gameCanvas.verBestDoctor;
                                        this.gameCanvas.verNowDoctor = this.cursorOfItem / 2 + 1;
                                    }
                                    if (this.gameCanvas.dataReliability < 0) {
                                        this.gameCanvas.dataReliability = 0;
                                    }
                                    this.gameCanvas.dataReliability += this.gameCanvas.DOCTORSABILITY[this.cursorOfItem + 2];
                                    if (this.gameCanvas.dataReliability >= 0) break;
                                    this.gameCanvas.dataReliability = 0;
                                    break;
                                }
                                case 1: {
                                    this.gameCanvas.dataMyKong -= this.UPGRADEEXPENSE[this.cursorOfItem] / 1000;
                                    this.gameCanvas.verNowHospital = this.cursorOfItem + 1;
                                    ++this.gameCanvas.verBestHospital;
                                    if (this.gameCanvas.dataReliability < 0) {
                                        this.gameCanvas.dataReliability = 0;
                                    }
                                    this.gameCanvas.dataReliability += this.gameCanvas.UPGRADEABILITY[this.cursorOfItem];
                                    if (this.gameCanvas.dataReliability >= 0) break;
                                    this.gameCanvas.dataReliability = 0;
                                    break;
                                }
                                case 2: {
                                    this.gameCanvas.dataMyKong -= this.LOBBYEXPENSE[this.cursorOfItem] / 1000;
                                    this.gameCanvas.isOpenedLobby[this.cursorOfItem + 1] = true;
                                    if (this.gameCanvas.dataReliability < 0) {
                                        this.gameCanvas.dataReliability = 0;
                                    }
                                    this.gameCanvas.dataReliability += this.gameCanvas.LOBBYABILITY[this.cursorOfItem + 1];
                                    if (this.gameCanvas.dataReliability < 0) {
                                        this.gameCanvas.dataReliability = 0;
                                    }
                                    if (this.cursorOfItem + 1 > this.gameCanvas.dataBestLobby) {
                                        this.gameCanvas.dataBestLobby = this.cursorOfItem + 1;
                                    }
                                    this.gameCanvas.dataNowLobby = this.cursorOfItem + 1;
                                    this.imgTile = null;
                                    this.imgObject = null;
                                    System.gc();
                                    this.imgTile = this.gameCanvas.tool_ImageLoad_RoomTile(this.gameCanvas.dataNowLobby);
                                    this.imgObject = this.gameCanvas.tool_ImageLoad_Dat("theme_" + this.gameCanvas.dataNowLobby, 9);
                                    break;
                                }
                                case 3: {
                                    this.gameCanvas.dataMyKong -= this.OFFICEITEMEXPENSE[this.cursorOfItem] / 1000;
                                    if (this.gameCanvas.dataReliability < 0) {
                                        this.gameCanvas.dataReliability = 0;
                                    }
                                    this.gameCanvas.dataReliability += this.gameCanvas.OFFICEITEMABILITY[this.cursorOfItem];
                                    if (this.gameCanvas.dataReliability < 0) {
                                        this.gameCanvas.dataReliability = 0;
                                    }
                                    this.gameCanvas.officeDecoOn[this.cursorOfItem] = true;
                                }
                            }
                            if (DM.DEBUG == 88) {
                                System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 38");
                            }
                            this.gameCanvas.process_Save();
                        }
                    }
                    if (this.popup == 17) {
                        this.gameCanvas.goHospital = true;
                    }
                    this.popup = 0;
                    this.cursorOfPop = 0;
                    LobbyH.isPass = false;
                    return;
                }
            }
            case -7: 
            case 50: {
                this.gameCanvas.isThrowHospital = false;
                if (this.popup == 17) {
                    this.gameCanvas.goHospital = true;
                }
                this.popup = 0;
                this.cursorOfPop = 0;
                LobbyH.isPass = false;
            }
        }
    }

    public void keyPressedManagement(int keyCode) {
        switch (this.cursorOfTab) {
            case 0: {
                this.numItem = 8;
                break;
            }
            case 1: {
                this.numItem = 3;
                break;
            }
            case 2: {
                this.numItem = 6;
                break;
            }
            case 3: {
                this.numItem = 11;
            }
        }
        switch (keyCode) {
            case 35: {
                break;
            }
            case -2: 
            case -1: {
                this.isSelected = !this.isSelected;
                break;
            }
            case -3: {
                if (this.isSelected) {
                    this.cursorOfItem = (this.cursorOfItem + (this.numItem - 1)) % this.numItem;
                    if (this.cursorOfTab == 2) {
                        System.out.println("(cursorOfItem + 1)===" + (this.cursorOfItem + 1));
                        this.imgLobbyIcon = this.gameCanvas.tool_ImageLoad_RoomTile(this.cursorOfItem + 1);
                    }
                    this.isArrowLeft = true;
                } else {
                    this.cursorOfTab = (this.cursorOfTab + 3) % 4;
                    this.cursorOfItem = 0;
                    if (this.cursorOfTab == 2) {
                        this.imgLobbyIcon = this.gameCanvas.tool_ImageLoad_RoomTile(1);
                    }
                }
                this.frameOfString = 50;
                this.scroll = 0;
                break;
            }
            case -4: {
                if (this.isSelected) {
                    this.cursorOfItem = (this.cursorOfItem + 1) % this.numItem;
                    if (this.cursorOfTab == 2) {
                        this.imgLobbyIcon = this.gameCanvas.tool_ImageLoad_RoomTile(this.cursorOfItem + 1);
                    }
                    this.isArrowRight = true;
                } else {
                    this.cursorOfTab = (this.cursorOfTab + 1) % 4;
                    this.cursorOfItem = 0;
                    if (this.cursorOfTab == 2) {
                        this.imgLobbyIcon = this.gameCanvas.tool_ImageLoad_RoomTile(1);
                    }
                }
                this.frameOfString = 50;
                this.scroll = 0;
                break;
            }
            case -5: {
                if (this.isSelected) {
                    switch (this.cursorOfTab) {
                        case 0: {
                            if (this.cursorOfItem % 2 == 1 && this.cursorOfItem <= (this.gameCanvas.verBestDoctor - 1) * 2 + 1 || this.cursorOfItem % 2 == 0 && this.cursorOfItem <= (this.gameCanvas.verBestNurse - 1) * 2) {
                                this.popup = 3;
                                break;
                            }
                            if (this.cursorOfItem % 2 == 1 && this.cursorOfItem > this.gameCanvas.verBestDoctor * 2 + 1 || this.cursorOfItem % 2 == 0 && this.cursorOfItem > this.gameCanvas.verBestNurse * 2) {
                                this.popup = 4;
                                break;
                            }
                            if (!this.isKong && this.gameCanvas.dataMyMoney < this.DOCTORSEXPENSE[this.cursorOfItem]) {
                                if (this.gameCanvas.dataMyKong < this.DOCTORSEXPENSE[this.cursorOfItem] / 1000) {
                                    this.popup = 1;
                                    break;
                                }
                                this.popup = 1;
                                break;
                            }
                            if (this.isKong) {
                                this.popup = 16;
                                break;
                            }
                            this.popup = 6;
                            break;
                        }
                        case 1: {
                            if (this.gameCanvas.verBestHospital >= this.cursorOfItem + 1) {
                                this.popup = 3;
                                break;
                            }
                            if (this.gameCanvas.verBestHospital < this.cursorOfItem) {
                                this.popup = 4;
                                break;
                            }
                            if (this.isKong && this.gameCanvas.dataMyKong < this.UPGRADEEXPENSE[this.cursorOfItem] / 1000) {
                                this.popup = 1;
                                break;
                            }
                            if (!this.isKong && this.gameCanvas.dataMyMoney < this.UPGRADEEXPENSE[this.cursorOfItem]) {
                                if (this.gameCanvas.dataMyKong < this.UPGRADEEXPENSE[this.cursorOfItem] / 1000) {
                                    this.popup = 1;
                                    break;
                                }
                                this.popup = 15;
                                break;
                            }
                            if (this.isKong) {
                                this.popup = 16;
                                break;
                            }
                            this.popup = 7;
                            break;
                        }
                        case 2: {
                            if (this.gameCanvas.isOpenedLobby[this.cursorOfItem + 1]) {
                                if (this.gameCanvas.dataNowLobby == this.cursorOfItem + 1) {
                                    this.popup = 11;
                                    break;
                                }
                                this.popup = 9;
                                break;
                            }
                            if (!this.isKong && this.gameCanvas.dataMyMoney < this.LOBBYEXPENSE[this.cursorOfItem]) {
                                if (this.gameCanvas.dataMyKong < this.LOBBYEXPENSE[this.cursorOfItem] / 1000) {
                                    this.popup = 1;
                                    break;
                                }
                                this.popup = 1;
                                break;
                            }
                            if (this.isKong) {
                                this.popup = 16;
                                break;
                            }
                            this.popup = 8;
                            break;
                        }
                        case 3: {
                            if (this.gameCanvas.officeDecoOn[this.cursorOfItem]) {
                                this.popup = 2;
                                break;
                            }
                            if (this.isKong && this.gameCanvas.dataMyKong < this.OFFICEITEMEXPENSE[this.cursorOfItem] / 1000) {
                                this.popup = 1;
                                break;
                            }
                            if (!this.isKong && this.gameCanvas.dataMyMoney < this.OFFICEITEMEXPENSE[this.cursorOfItem]) {
                                if (this.gameCanvas.dataMyKong < this.OFFICEITEMEXPENSE[this.cursorOfItem] / 1000) {
                                    this.popup = 1;
                                    break;
                                }
                                this.popup = 1;
                                break;
                            }
                            this.popup = this.isKong ? 16 : 10;
                        }
                    }
                    break;
                }
                this.isSelected = true;
                break;
            }
            case -7: {
                if (this.isSelected) {
                    this.isSelected = false;
                    break;
                }
                LobbyH.isPass = false;
                this.isManaged = false;
                this.cursorOfTab = 0;
                this.cursorOfItem = 0;
                this.process_ReleaseImageManage();
                if (DM.DEBUG == 88) {
                    System.out.println(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 32");
                }
                this.gameCanvas.process_Save();
            }
        }
    }

    public void keyReleased(int keyCode) {
        if (DM.DEBUG != 0) {
            System.out.println("isKeyMove : " + this.gameCanvas.isKeyMove);
        }
        if (!LobbyH.isPass) {
            LobbyH.isPass = true;
        }
    }

    public void process_InitValue() {
        LobbyH.isPass = false;
        this.lobbyNPC = new LobbyNPC[5];
        this.strNPCWords = new String[1];
        this.isDirect = new boolean[4];
        for (int npc = 1; npc < 5; ++npc) {
            this.lobbyNPC[npc] = new LobbyNPC();
        }
        switch (this.gameCanvas.eventRoom) {
            case 2: {
                this.lobbyNPC[0] = new LobbyNPC(6, 10, 29);
                this.lobbyNPC[0].setViewDirect(0);
                break;
            }
            case 17: {
                this.lobbyNPC[0] = new LobbyNPC(6, 6, 1);
                this.lobbyNPC[0].setViewDirect(1);
                break;
            }
            case 19: {
                this.lobbyNPC[0] = new LobbyNPC(6, 16, 5);
                this.lobbyNPC[0].setViewDirect(2);
                break;
            }
            case 18: {
                this.lobbyNPC[0] = new LobbyNPC(6, 18, 6);
                this.lobbyNPC[0].setViewDirect(2);
                break;
            }
            case 20: {
                this.lobbyNPC[0] = new LobbyNPC(6, 0, 19);
                this.lobbyNPC[0].setViewDirect(3);
                break;
            }
            case 21: {
                this.lobbyNPC[0] = new LobbyNPC(6, 0, 29);
                this.lobbyNPC[0].setViewDirect(3);
                break;
            }
            case 3: {
                this.lobbyNPC[0] = new LobbyNPC(6, 19, 12);
                this.lobbyNPC[0].setViewDirect(2);
                break;
            }
            case 27: {
                for (int save = 0; save < 5; ++save) {
                    if (!this.gameCanvas.saveLobbyNPC[save].isLived) continue;
                    this.lobbyNPC[save] = this.gameCanvas.saveLobbyNPC[save];
                }
                this.gameCanvas.process_ReleaseLobbyNPC();
                break;
            }
            default: {
                this.lobbyNPC[0] = new LobbyNPC(6, 10, 29);
                this.lobbyNPC[0].setViewDirect(0);
            }
        }
        this.lobbyNPC[0].setFrame(4);
        this.gameCanvas.eventRoom = 16;
        if (this.gameCanvas.tutoOn) {
            this.stateOfLobby = this.STATE_TUTORIAL;
            this.lobbyNPC[0] = new LobbyNPC(6, 10, 29);
            this.lobbyNPC[0].setViewDirect(0);
            this.strTutorial = this.gameCanvas.tool_GetString("event0");
            return;
        }
    }

    public void process_ReleaseValue() {
        this.lobbyNPC = null;
        this.strNPCWords = null;
        this.isDirect = null;
        this.arrIndex = null;
        this.hotmenu = null;
        this.strTutorial = null;
    }

    public void process_InitImage() {
        Image[] temp = this.gameCanvas.tool_ImageLoad_Dat("face", 13);
        this.imgFace = new Image[5];
        this.imgFace[0] = temp[0];
        this.imgFace[1] = temp[1];
        this.imgFace[2] = temp[2];
        this.imgFace[3] = temp[3];
        this.imgFace[4] = temp[4];
        temp = null;
        System.gc();
        this.imgObject = this.gameCanvas.tool_ImageLoad_Dat("theme_" + this.gameCanvas.dataNowLobby, 9);
        this.imgTile = this.gameCanvas.tool_ImageLoad_RoomTile(this.gameCanvas.dataNowLobby);
        this.imgSelly = this.gameCanvas.tool_ImageLoad_Dat("selly", 4);
        this.imgLobby = this.gameCanvas.tool_ImageLoad_Dat("lobby", 15);
        this.imgMapUI = this.gameCanvas.tool_ImageLoad_Dat("mapui", 8);
        if (this.imgNPC_ALL == null) {
            this.imgNPC_ALL = this.gameCanvas.tool_ImageLoad_Dat("movedNPC", 24);
        }
        this.imgNPC = new Image[4];
        for (int npc = 1; npc < 5; ++npc) {
            if (!this.lobbyNPC[npc].getIsLived()) continue;
            this.process_InitImageNPC(npc);
        }
    }

    public void process_InitImageManage() {
        this.imgParts = this.gameCanvas.tool_ImageLoad_Dat("managecommon", 7);
        this.imgDoctorsIcon = this.gameCanvas.tool_ImageLoad_Dat("doctorsicon", 10);
        this.imgBuildingIcon = this.gameCanvas.tool_ImageLoad_Dat("buildingicon", 4);
        this.imgLobbyIcon = this.gameCanvas.tool_ImageLoad_RoomTile(1);
        this.imgItemIcon = this.gameCanvas.tool_ImageLoad_Dat("medicalitem", 11);
    }

    public void process_ReleaseImage() {
        this.imgMiniMapSame = null;
        this.imgMiniMapLobby = null;
        this.imgFace = null;
        this.imgMapUI = null;
        this.imgLobby = null;
        this.imgTile = null;
        this.imgObject = null;
        this.imgSelly = null;
        this.imgNPC = null;
        this.imgParts = null;
        this.imgDoctorsIcon = null;
        this.imgBuildingIcon = null;
        this.imgLobbyIcon = null;
        this.imgItemIcon = null;
    }

    public void process_ReleaseImageManage() {
        this.imgParts = null;
        this.imgDoctorsIcon = null;
        this.imgBuildingIcon = null;
        this.imgLobbyIcon = null;
        this.imgItemIcon = null;
        System.gc();
    }

    protected void paint(Graphics graphics) {
    }

    public void pointerReleased(int x, int y) {
    }

    public void pointerPressed(int x, int y) {
        if (this.stateOfLobby == this.STATE_HOTMENU) {
            this.hotmenu.pointerPressed(x, y);
            if (this.hotmenu.stateOfHotmenu == 99 && x > 88 && y > 112 && x < 150 && y < 130) {
                this.hotmenu.process_ReleaseImage();
                this.hotmenu.process_ReleaseValue();
                this.hotmenu = null;
                System.gc();
                this.stateOfLobby = this.STATE_LOBBY;
                if (GameCanvas.optionVolume == 0) {
                    this.gameCanvas.soundManager.StopSound();
                } else {
                    this.gameCanvas.soundManager.tool_PlaySound("lobby", true);
                }
            }
        }
    }
}

