/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class MCD_Reader {
    public static MCD_Reader mcd_R;
    private int engCharW = 6;
    private int charWidth = 12;
    private int charHeight = 12;
    private int[] MCD_MatrixData;
    private int bed;
    Graphics g;
    private String searchStr = "";

    public void loadMCD(String MCD_Name) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/" + MCD_Name + ".mcd");
        int length_1 = is.read();
        int length_2 = is.read();
        int length_3 = is.read();
        int length_4 = is.read();
        int length = length_1 << 24 | length_2 << 16 | length_3 << 8 | length_4;
        this.charWidth = this.bed = is.read();
        this.charHeight = this.bed;
        this.engCharW = this.bed >> 1;
        int unicode_1 = 0;
        int unicode_2 = 0;
        for (int i = 0; i < length; ++i) {
            unicode_1 = is.read();
            unicode_2 = is.read();
            this.searchStr = this.searchStr + "" + (char)(unicode_1 << 8 | unicode_2);
        }
        this.MCD_MatrixData = new int[length * this.bed];
        for (int i = 0; i < this.MCD_MatrixData.length; ++i) {
            int MMD_3;
            int MMD_2;
            int MMD_1;
            if (this.bed <= 16) {
                MMD_1 = is.read();
                MMD_2 = is.read();
                this.MCD_MatrixData[i] = MMD_1 << 8 | MMD_2;
                continue;
            }
            if (this.bed > 16 && this.bed <= 24) {
                MMD_1 = is.read();
                MMD_2 = is.read();
                MMD_3 = is.read();
                this.MCD_MatrixData[i] = MMD_1 << 16 | MMD_2 << 8 | MMD_3;
                continue;
            }
            if (this.bed <= 24 || this.bed > 32) continue;
            MMD_1 = is.read();
            MMD_2 = is.read();
            MMD_3 = is.read();
            int MMD_4 = is.read();
            this.MCD_MatrixData[i] = MMD_1 << 24 | MMD_2 << 16 | MMD_3 << 8 | MMD_4;
        }
        is.close();
    }

    public void drawString(String str, int x, int y, int anchor) {
        switch (anchor) {
            case 20: {
                this.drawStr(str, x, y);
                break;
            }
            case 24: {
                this.drawStr(str, x - this.stringWidth(str), y);
                break;
            }
            case 36: {
                this.drawStr(str, x, y - this.charHeight);
                break;
            }
            case 40: {
                this.drawStr(str, x - this.stringWidth(str), y - this.charHeight);
                break;
            }
            case 6: {
                this.drawStr(str, x, y - (this.charHeight >> 1));
                break;
            }
            case 10: {
                this.drawStr(str, x - this.stringWidth(str), y - (this.charHeight >> 1));
                break;
            }
            case 17: {
                this.drawStr(str, x - (this.stringWidth(str) >> 1), y);
                break;
            }
            case 33: {
                this.drawStr(str, x - (this.stringWidth(str) >> 1), y - this.charHeight);
                break;
            }
            case 3: {
                this.drawStr(str, x - (this.stringWidth(str) >> 1), y - (this.charHeight >> 1));
                break;
            }
            default: {
                this.drawStr(str, x, y);
            }
        }
    }

    public int charWidth(char c) {
        int w = 0;
        w = c < '\u007f' ? this.engCharW : this.charWidth;
        return w;
    }

    public int getHeight() {
        return this.charHeight;
    }

    public int stringWidth(String str) {
        int w = 0;
        if (str.equals("")) {
            return 0;
        }
        char[] c = str.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] < '\u007f') {
                w += this.engCharW;
                continue;
            }
            w += this.charWidth;
        }
        return w;
    }

    public int charsWidth(char[] c) {
        int w = 0;
        if (c == null) {
            return 0;
        }
        for (int i = 0; i < c.length; ++i) {
            if (c[i] < '\u007f') {
                w += this.engCharW;
                continue;
            }
            w += this.charWidth;
        }
        return w;
    }

    private void drawStr(String str, int x, int y) {
        int useStrW = 0;
        char[] myChar = str.toCharArray();
        int[] data = new int[this.charWidth];
        boolean isNull = true;
        for (int i = 0; i < myChar.length; ++i) {
            isNull = true;
            int index = this.searchStr.indexOf(myChar[i]);
            if (index != -1) {
                System.arraycopy(this.MCD_MatrixData, index * this.charWidth, data, 0, this.charWidth);
                isNull = false;
            }
            for (int k = 0; k < this.charWidth * this.charHeight; ++k) {
                int q = data[k / this.charWidth];
                q &= 1 << this.charWidth - 1 - k % this.charWidth;
                if (isNull) {
                    GameMode.g.drawLine(x + useStrW + k % this.charWidth, y + k / this.charWidth, x + useStrW + k % this.charWidth, y + k / this.charWidth);
                    continue;
                }
                if (q == 0) continue;
                GameMode.g.drawLine(x + useStrW + k % this.charWidth, y + k / this.charWidth, x + useStrW + k % this.charWidth, y + k / this.charWidth);
            }
            if (myChar[i] < '\u007f') {
                useStrW += this.charWidth >> 1;
                continue;
            }
            useStrW += this.charWidth;
        }
    }

    public void drawChars(char[] charArray, int start, int end, int x, int y, int anchor) {
        char[] myChar = new char[end - start];
        System.arraycopy(charArray, start, myChar, 0, end);
        String str = String.valueOf(myChar);
        str.trim();
        myChar = null;
        myChar = str.toCharArray();
        switch (anchor) {
            case 20: {
                this.drawCha(myChar, x, y);
                break;
            }
            case 24: {
                this.drawCha(myChar, x - this.charsWidth(myChar), y);
                break;
            }
            case 36: {
                this.drawCha(myChar, x, y - this.charHeight);
                break;
            }
            case 40: {
                this.drawCha(myChar, x - this.charsWidth(myChar), y - this.charHeight);
                break;
            }
            case 6: {
                this.drawCha(myChar, x, y - (this.charHeight >> 1));
                break;
            }
            case 10: {
                this.drawCha(myChar, x - this.charsWidth(myChar), y - (this.charHeight >> 1));
                break;
            }
            case 17: {
                this.drawCha(myChar, x - (this.charsWidth(myChar) >> 1), y);
                break;
            }
            case 33: {
                this.drawCha(myChar, x - (this.charsWidth(myChar) >> 1), y - this.charHeight);
                break;
            }
            case 3: {
                this.drawCha(myChar, x - (this.charsWidth(myChar) >> 1), y - (this.charHeight >> 1));
                break;
            }
            default: {
                this.drawCha(myChar, x, y);
            }
        }
    }

    private void drawCha(char[] myChar, int x, int y) {
        int useStrW = 0;
        int[] data = new int[this.charWidth];
        boolean isNull = true;
        for (int i = 0; i < myChar.length; ++i) {
            isNull = true;
            if (myChar[i] == '\u0000') {
                return;
            }
            int index = this.searchStr.indexOf(myChar[i]);
            data = null;
            data = new int[this.charWidth];
            if (index != -1) {
                System.arraycopy(this.MCD_MatrixData, index * this.charWidth, data, 0, this.charWidth);
                isNull = false;
            }
            for (int k = 0; k < this.charWidth * this.charHeight; ++k) {
                int q = data[k / this.charWidth];
                q &= 1 << this.charWidth - 1 - k % this.charWidth;
                if (isNull) {
                    GameMode.g.drawLine(x + useStrW + k % this.charWidth, y + k / this.charWidth, x + useStrW + k % this.charWidth, y + k / this.charWidth);
                    continue;
                }
                if (q == 0) continue;
                GameMode.g.drawLine(x + useStrW + k % this.charWidth, y + k / this.charWidth, x + useStrW + k % this.charWidth, y + k / this.charWidth);
            }
            if (myChar[i] < '\u007f') {
                useStrW += this.charWidth >> 1;
                continue;
            }
            useStrW += this.charWidth;
        }
    }
}

