/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import lakoo.MainIntro;

public class CtrlList
extends CtrlBase {
    static final int RGB_HIGHLIGHT = 0xBBBCCF;
    static final int RGB_SHADOW = 3684686;
    static final int RGB_BASE = 5132140;
    boolean bVScrollBar = false;
    int nScrollPos = 0;
    int nLastScrollPos = -1;
    int nSelect;
    int nLastSelect = -1;
    int nTotalLine;
    int nLinePerPage;
    int _FilePos;
    int VY;
    int nCellHeight = 12;
    Image imgLinked;
    int nWidthImage;
    Vector line;
    static int nLastMenu = 0;
    int nHScroll = 0;
    boolean bHScroll = false;
    long nLastScrollTime = 0L;

    CtrlList(int nCellHeight, int nInitialSize) {
        this.nCellHeight = nCellHeight;
        this.line = new Vector(nInitialSize);
        this.VY = 0;
        this.nSelect = nLastMenu;
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.nLinePerPage = h / (this.nCellHeight + 2);
        this.getScrollInfo();
    }

    public void setImageList(Image imgLinked, int w) {
        this.imgLinked = imgLinked;
        this.nWidthImage = w;
    }

    public int getImageIndex(int nIndex) {
        return ((RowElement)this.line.elementAt((int)nIndex)).nImgIndex;
    }

    public void removeLine(int nIndex) {
        Object var2_2 = null;
        if (MainIntro._a0()) {
            return;
        }
        this.line.removeElementAt(nIndex);
        this.getScrollInfo();
    }

    public void addLine(Image img, String strLine) {
        this.line.addElement(new RowElement(img, strLine));
        this.getScrollInfo();
    }

    public void addLine(int nImgIndex, String strLine) {
        this.line.addElement(new RowElement(nImgIndex, strLine));
        this.getScrollInfo();
    }

    public void addLines(String strFormatList) {
        int e;
        int s = 0;
        while ((e = strFormatList.indexOf(47, s)) != -1) {
            int i = s != e ? Integer.parseInt(strFormatList.substring(s, e)) : -1;
            s = e + 1;
            e = strFormatList.indexOf(47, s);
            this.line.addElement(new RowElement(i, s != e ? strFormatList.substring(s, e) : ""));
            s = e + 1;
        }
        this.getScrollInfo();
    }

    public void setLineImage(int nIndex, int nImageIndex) {
        ((RowElement)this.line.elementAt((int)nIndex)).nImgIndex = nImageIndex;
    }

    public void removeAll() {
        Object var1_1 = null;
        if (MainIntro._a0()) {
            return;
        }
        this.line.removeAllElements();
    }

    void getScrollInfo() {
        this.nTotalLine = this.line.size();
        this.bVScrollBar = this.nTotalLine * (this.nCellHeight + 2) > this.height;
    }

    int _paintLine(Graphics g, PNGList png, int i, int x1, int y1) {
        int lw;
        int e;
        int n = this.nScrollPos;
        int dx = 0;
        int dy = 0;
        dy = 4;
        int w1 = this.width - (this.bVScrollBar ? 5 : 0) - 2;
        RowElement row = (RowElement)this.line.elementAt(i + n);
        if (row.img != null) {
            g.drawImage(row.img, x1, y1, 20);
            dx = row.img.getWidth();
        }
        if (this.imgLinked != null && row.nImgIndex >= 0) {
            png.drawSubFrame(g, this.imgLinked, row.nImgIndex, x1, y1, this.nWidthImage, this.nCellHeight);
            dx = this.nWidthImage;
        }
        int sx = dx;
        png.reserveClip(g);
        int s = 0;
        ++dy;
        int nMaxWidth = 0;
        g.setClip(x1 + dx, y1, w1 - dx, this.nCellHeight);
        if (i + n == this.nSelect) {
            g.setColor(5132140);
            png.drawHFlow(g, x1 + this.nWidthImage, y1, w1 - this.nWidthImage, this.nCellHeight, 5132140, 0xBBBCCF);
        }
        png.setFontFgColor(0xFFFFFF);
        if (this.bHScroll) {
            dx -= this.nHScroll;
        }
        while ((e = row.str.indexOf(10, s)) != -1) {
            lw = png.drawString(g, row.str.substring(s, e), x1 + dx, y1 + dy, 20);
            if (!this.bHScroll && lw > nMaxWidth) {
                nMaxWidth = lw;
            }
            s = e + 1;
            dy += 15;
        }
        lw = png.drawString(g, row.str.substring(s), x1 + dx, y1 + dy, 20);
        if (lw > nMaxWidth) {
            nMaxWidth = lw;
        }
        png.recoverClip(g);
        if (i + n == this.nSelect && !this.bHScroll && nMaxWidth > w1 - dx + 1) {
            this.nHScroll = nMaxWidth - (w1 - dx);
        }
        g.setColor(3684686);
        g.drawLine(x1, y1 += this.nCellHeight, x1 + w1, y1);
        g.setColor(0xBBBCCF);
        g.drawLine(x1, y1 + 1, x1 + w1, y1 + 1);
        return y1 += 2;
    }

    public void paint(Graphics g, PNGList png) {
        this.nSelect += this.VY;
        this.VY = 0;
        if (this.nSelect >= this.nTotalLine) {
            this.nSelect = 0;
        }
        if (this.nSelect < 0) {
            this.nSelect = this.nTotalLine - 1;
        }
        if (this.nSelect < this.nScrollPos) {
            this.nScrollPos = this.nSelect;
        }
        if (this.nSelect >= this.nScrollPos + this.nLinePerPage) {
            this.nScrollPos = this.nSelect - this.nLinePerPage + 1;
        }
        g.setClip(this.x, this.y, this.width, this.height);
        if (!this.bRedraw && this.nSelect == this.nLastSelect) {
            if (this.nSelect == this.nLastSelect) {
                if (this.nHScroll > 0 && this.nLastScrollTime + 1000L < System.currentTimeMillis()) {
                    this.nLastScrollTime = System.currentTimeMillis();
                    this.bHScroll = !this.bHScroll;
                }
                this._paintLine(g, png, this.nSelect - this.nScrollPos, this.x + 1, this.y + 1 + (this.nSelect - this.nScrollPos) * (this.nCellHeight + 2));
            }
            g.setColor(0);
            g.drawRect(this.x - 1, this.y - 1, this.width + 1, this.height + 1);
            return;
        }
        int width = this.width - (this.bVScrollBar ? 4 : 0);
        this.nHScroll = 0;
        this.bHScroll = false;
        int x1 = this.x;
        int y1 = this.y;
        ++x1;
        ++y1;
        if (this.nLastScrollPos == this.nScrollPos && !this.bRedraw) {
            g.setColor(5132140);
            g.fillRect(this.x + 1, this.y + 1 + (this.nLastSelect - this.nScrollPos) * (this.nCellHeight + 2), width - 2, this.nCellHeight + 2);
            this._paintLine(g, png, this.nLastSelect - this.nScrollPos, this.x + 1, this.y + 1 + (this.nLastSelect - this.nScrollPos) * (this.nCellHeight + 2));
            this._paintLine(g, png, this.nSelect - this.nScrollPos, this.x + 1, this.y + 1 + (this.nSelect - this.nScrollPos) * (this.nCellHeight + 2));
        } else {
            g.setColor(0xBBBCCF);
            g.drawRect(this.x, this.y, width - 1, this.height - 1);
            g.setColor(3684686);
            g.drawRect(this.x + 1, this.y + 1, width - 2, this.height - 2);
            g.setColor(5132140);
            g.fillRect(this.x + 1, this.y + 1, width - 2, this.height - 2);
            for (int i = 0; i < this.nLinePerPage && i + this.nScrollPos < this.nTotalLine; ++i) {
                y1 = this._paintLine(g, png, i, x1, y1);
            }
        }
        this.nLastSelect = this.nSelect;
        this.nLastScrollPos = this.nScrollPos;
        if (this.bVScrollBar) {
            width = this.width;
            g.setColor(0);
            g.fillRect(this.x + width - 5, this.y, 5, this.height);
            int sx = this.x + width - 4;
            int s = (this.height - 3) * this.nScrollPos / this.nTotalLine;
            int l = (this.height - 2) * this.nLinePerPage / this.nTotalLine;
            if (s > this.height - l - 3) {
                s = this.height - l - 3;
            }
            s += this.y + 1;
            if (l < 2) {
                l = 2;
            }
            g.setColor(0xFFFFFF);
            g.drawRect(sx, s, 2, l);
            g.setColor(0x808080);
            g.fillRect(sx + 1, s + 1, 2, l);
            g.setColor(13947080);
            g.fillRect(sx + 1, s + 1, 1, l - 1);
        }
        g.setColor(0);
        g.drawRect(this.x - 1, this.y - 1, width + 1, this.height + 1);
        this.bRedraw = false;
    }

    public boolean keyPressed(int keyCode) {
        switch (keyCode) {
            case 1: {
                this.VY = -1;
                return true;
            }
            case 6: {
                this.VY = 1;
                return true;
            }
            case 8: 
            case 11: {
                nLastMenu = this.nSelect;
                this.codeNotify = 1;
                return true;
            }
            case 10: 
            case 12: {
                this.codeNotify = 32768;
                nLastMenu = 0;
                return true;
            }
        }
        return false;
    }

    class RowElement {
        int nImgIndex;
        Image img;
        String str;

        RowElement(Image img, String str) {
            this.img = img;
            this.str = str;
            this.nImgIndex = -1;
        }

        RowElement(int nImageIndex, String str) {
            this.img = null;
            this.nImgIndex = nImageIndex;
            this.str = str;
        }
    }
}

