/*
 * Decompiled with CFR 0.152.
 */
import java.util.Calendar;
import javax.microedition.lcdui.Graphics;

public class CtrlRichTextBox
extends CtrlBase {
    boolean bVScrollBar;
    boolean bAutoLineFeed;
    boolean bMenuRotate;
    int nScrollPos;
    int nLastScrollPos;
    int nTotalLine;
    int nLinePerPage;
    int _FilePos;
    int VY;
    boolean m_ShowLine;
    TextFile txt;
    int nScene;
    static String gameVersion = "1.0.0";
    boolean[] bMenuEnabled = new boolean[9];
    static final int LINE_HEIGHT = 18;
    static final int[] registerdColor = new int[]{0, 127, 32512, 0x7F0000, 0x7F7F00, 32639, 0x7F007F, 0x3F3F3F, 0x7F7F7F, 255, 65280, 0xFF0000, 0xFFFF00, 65535, 0xFF00FF, 0xFFFFFF};
    int nSelect = 0;
    int nLastSelect = 0;
    int mx;
    int my;
    int mw;
    int nMaxMenu;
    boolean bSelectMenuInSight = false;
    boolean bMenuVisible = false;
    int fliker;

    CtrlRichTextBox(TextFile txt, int nScene, int x, int y, int w, int h, boolean bAutoLineFeed) {
        this.bFocusAcceptable = false;
        this.bForcedControl = true;
        this.bVScrollBar = false;
        this.bMenuRotate = false;
        this.nLastScrollPos = -1;
        this.nScrollPos = 0;
        this.bAutoLineFeed = bAutoLineFeed;
        this.setBounds(x, y, w, h);
        this.nLinePerPage = h / 18;
        this.setNewText(txt, nScene);
        this.VY = 0;
        this.m_ShowLine = true;
        this.bSelectMenuInSight = false;
        this.bMenuVisible = false;
    }

    CtrlRichTextBox(int x, int y, int w, int h, boolean bAutoLineFeed) {
        this.bFocusAcceptable = false;
        this.bForcedControl = true;
        this.bVScrollBar = false;
        this.bMenuRotate = false;
        this.nLastScrollPos = -1;
        this.nScrollPos = 0;
        this.m_ShowLine = true;
        this.bAutoLineFeed = bAutoLineFeed;
        this.setBounds(x, y, w, h);
        this.nLinePerPage = h / 18;
        this.VY = 0;
        this.bSelectMenuInSight = false;
        this.bMenuVisible = false;
    }

    public int getTotalHeight() {
        return this.nTotalLine * 18;
    }

    public void enforceRepaint() {
        this.nLastScrollPos = -1;
    }

    public void setNewText(TextFile txt, int nScene) {
        this.txt = txt;
        this.setScene(nScene, true);
    }

    public void return2Top() {
        this.nScrollPos = 0;
        this.VY = 0;
        this.nSelect = 0;
        this.bRedraw = true;
    }

    public void setScene(int nScene, boolean bReSeek) {
        this.nScene = nScene;
        if (bReSeek) {
            this.txt.readScene(nScene);
        }
        this._FilePos = this.txt.nFilePos;
        if (this.bAutoLineFeed) {
            int n = this.txt.doAutoLineFeed(this.width, 15, 6, false, true) + 1;
            this.txt.doAutoLineFeed(this.width - (this.height < n * 18 ? 5 : 0), 15, 6, true, true);
        }
        this.txt.nFilePos = this._FilePos;
        this.nTotalLine = this.txt.countLine();
        this.bVScrollBar = this.height < this.nTotalLine * 18;
        this.nScrollPos = 0;
        this.VY = 0;
        this.nSelect = 0;
        for (int i = 0; i < this.bMenuEnabled.length; ++i) {
            this.bMenuEnabled[i] = true;
        }
        this.nMaxMenu = this.countMenu(true);
        this.bRedraw = true;
    }

    public void setNewText(TextFile txt, int nScene, int[] argc, String[] args) {
        this.txt = txt;
        txt.readScene(nScene);
        int fromPos = txt.nFilePos;
        String strScene = txt.readWholeSceneText();
        int endPos = txt.nFilePos;
        txt.replace(CtrlRichTextBox.makeString(strScene, argc, args), fromPos, endPos);
        txt.nFilePos = fromPos;
        this.setScene(nScene, false);
    }

    public static String makeString(String strLine, int[] argc, String[] args) {
        int nLen = strLine.length();
        String strRtn = "";
        block7: for (int i = 0; i < nLen; ++i) {
            char c = strLine.charAt(i);
            if (c == '%') {
                c = strLine.charAt(i + 1);
                switch (c) {
                    case '%': {
                        strRtn = strRtn + '%';
                        break;
                    }
                    case 'd': {
                        int j = CtrlRichTextBox.pickNumber(strLine, i + 2);
                        if (argc == null || argc.length <= j) break;
                        strRtn = strRtn + argc[j];
                        break;
                    }
                    case 's': {
                        int j = CtrlRichTextBox.pickNumber(strLine, i + 2);
                        if (args == null || args.length <= j || args[j] == null) break;
                        strRtn = strRtn + args[j];
                        break;
                    }
                    case 'V': {
                        strRtn = strRtn + gameVersion;
                        break;
                    }
                    case 'T': {
                        Calendar cal = Calendar.getInstance();
                        int d = cal.get(10);
                        StringBuffer stringBuffer = new StringBuffer().append(strRtn).append(cal.get(9) == 0 ? "A.M." : "P.M.").append(" ").append(d < 10 ? "0" : "").append(d).append(":");
                        d = cal.get(12);
                        strRtn = stringBuffer.append(d < 10 ? "0" : "").append(d).toString();
                        break;
                    }
                    default: {
                        strRtn = strRtn + '%';
                        continue block7;
                    }
                }
                i = strLine.indexOf(37, i + 1);
                continue;
            }
            strRtn = strRtn + c;
        }
        return strRtn;
    }

    public static int pickNumber(String strText, int nPos) {
        int nNumber = 0;
        try {
            char c;
            while ((c = strText.charAt(nPos++)) >= '0' && c <= '9') {
                nNumber *= 10;
                nNumber += c - 48;
            }
            return nNumber;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return nNumber;
        }
    }

    int countMenu(boolean bTotal) {
        int nMenu = -1;
        int nEndPos = bTotal ? this.txt.nTotalChar : this.txt.nFilePos;
        for (int i = this._FilePos; i < nEndPos; ++i) {
            if (this.txt.szData[i] == 38 && this.txt.szData[i + 1] == 109) {
                ++nMenu;
            }
            if (this.txt.szData[i] == 60) break;
        }
        return nMenu;
    }

    public void paint(Graphics g, PNGList png) {
        int s;
        int align = 20;
        int dx = 0;
        int nLastSelect = this.nSelect;
        boolean bColorEnabled = true;
        g.setClip(this.x, this.y, this.width, this.height);
        this.nScrollPos += this.VY;
        if (this.nScrollPos >= this.nTotalLine - this.nLinePerPage) {
            this.nScrollPos = this.nTotalLine - this.nLinePerPage;
            this.bSelectMenuInSight = true;
        }
        if (this.nScrollPos < 0) {
            this.nScrollPos = 0;
        }
        if (!this.bRedraw && this.nScrollPos == this.nLastScrollPos && this.m_ShowLine) {
            if (this.nScrollPos == this.nLastScrollPos && this.bSelectMenuInSight) {
                if (this.bMenuEnabled[this.nSelect]) {
                    png.drawHFlow(g, this.mx, this.my + 16, this.mw, 0, 0, 0xFFFFFF);
                } else {
                    g.setColor(0x404040);
                    g.drawLine(this.mx, this.my + 11, this.mx + this.mw, this.my + 11);
                }
            }
            return;
        }
        this.nLastScrollPos = this.nScrollPos;
        png.reserveClip(g);
        g.setClip(this.x, this.y, this.width - (this.bVScrollBar ? 5 : 0), this.height);
        this.txt.nFilePos = this._FilePos;
        this.txt.locate(this.nScrollPos);
        int nLastFGColor = png.nfntColor;
        int nLastBGColor = png.nfntBgColor;
        if (png.nfntBgColor != -1) {
            g.setColor(png.nfntBgColor);
            g.fillRect(this.x, this.y, this.width, this.height);
        }
        int y1 = this.y;
        this.bMenuVisible = false;
        this.bSelectMenuInSight = false;
        int nMax = 0;
        int nMin = 65535;
        for (int i = 0; i < this.nLinePerPage; ++i) {
            dx = 0;
            s = 0;
            int e = 0;
            dx = 0;
            align = 20;
            y1 = this.y + 18 * i;
            String strLine = this.txt.readNextLine();
            if (strLine == null) break;
            while ((s = strLine.indexOf(38, s)) != -1) {
                if (s > 0) {
                    dx += png.drawString(g, strLine.substring(e, s), this.x + dx + 5, y1, align);
                }
                switch (strLine.charAt(s + 1)) {
                    case '&': {
                        break;
                    }
                    case 'l': {
                        png.drawGradientVLine(g, this.x + this.width / 2, y1 + 5, this.width / 2, 0, 0xFFFFFF, 0, 3);
                        break;
                    }
                    case 'c': {
                        align = 17;
                        dx += this.width / 2;
                        break;
                    }
                    case 'F': {
                        if (!bColorEnabled) break;
                        int nC = CtrlRichTextBox.pickNumber(strLine, s + 2);
                        if (nC > 15) {
                            png.setFontFgColor(nLastFGColor);
                            break;
                        }
                        png.setFontFgColor(registerdColor[nC]);
                        break;
                    }
                    case 'B': {
                        if (!bColorEnabled) break;
                        int nC = CtrlRichTextBox.pickNumber(strLine, s + 2);
                        if (nC > 15) {
                            png.setFontBgColor(nLastBGColor);
                            break;
                        }
                        png.setFontBgColor(registerdColor[nC]);
                        break;
                    }
                    case 'N': {
                        int data = this.fliker++ % Integer.MAX_VALUE % 4;
                        if (data == 0 || data == 1) {
                            for (int j = 7; j >= 0; --j) {
                                png.drawLineCus(g, 200 - j, 300 - j, 200 + j, 300 - j, 0xFFFFFF);
                            }
                        }
                        this.m_ShowLine = false;
                        break;
                    }
                    case 'm': {
                        this.m_ShowLine = true;
                        this.bMenuVisible = true;
                        int nMenu = this.countMenu(false);
                        bColorEnabled = this.bMenuEnabled[nMenu];
                        if (bColorEnabled) {
                            png.setFontColor(nLastFGColor, nLastBGColor);
                        } else {
                            png.setFontBgColor(registerdColor[8]);
                            png.setFontColor(0, registerdColor[8]);
                        }
                        if (nMin > nMenu) {
                            nMin = nMenu;
                        }
                        if (nMax < nMenu) {
                            nMax = nMenu;
                        }
                        if (nMenu != this.nSelect) break;
                        this.bSelectMenuInSight = true;
                        this.mx = this.x + dx;
                        this.my = y1;
                        this.mw = PNGList.getHanPixelLength(strLine) - 18;
                    }
                }
                e = s = strLine.indexOf(38, s + 1) + 1;
            }
            if (e == 0) {
                png.drawString(g, strLine, this.x + dx + 5, y1, align);
                continue;
            }
            png.drawString(g, strLine.substring(e), this.x + dx + 5, y1, align);
        }
        if (!this.bSelectMenuInSight) {
            this.nSelect = nLastSelect;
        }
        this.bSelectMenuInSight = this.nSelect >= nMin && this.nSelect <= nMax;
        png.recoverClip(g);
        png.setFontColor(nLastFGColor, nLastBGColor);
        if (this.bVScrollBar) {
            g.setColor(0);
            g.fillRect(this.x + this.width - 5, this.y, 5, this.height);
            int sx = this.x + this.width - 4;
            s = (this.height - 3) * this.nScrollPos / this.nTotalLine;
            int l = (this.height - 2) * this.nLinePerPage / this.nTotalLine;
            if (s > this.height - l - 3) {
                s = this.height - l - 3;
            }
            s += this.y + 1;
            if (l < 2) {
                l = 2;
            }
            g.setColor(16303921);
            g.drawRect(sx, s, 2, l);
            g.setColor(4858128);
            g.fillRect(sx + 1, s + 1, 2, l);
            g.setColor(0xFFFFA6);
            g.fillRect(sx + 1, s + 1, 1, l - 1);
        } else {
            this.bSelectMenuInSight = true;
        }
        if (nMin == nMax) {
            this.nSelect = nMin;
            if (nLastSelect != this.nSelect) {
                return;
            }
        }
        this.bRedraw = false;
    }

    public boolean canbeDone() {
        return this.bMenuEnabled[this.nSelect] && this.bSelectMenuInSight;
    }

    public boolean keyPressed(int keyCode) {
        switch (keyCode) {
            case 1: {
                if (this.bMenuVisible) {
                    if (this.nSelect > 0) {
                        --this.nSelect;
                        this.bRedraw = true;
                    } else if (this.bMenuRotate) {
                        this.nSelect = this.nMaxMenu;
                        this.bRedraw = true;
                    }
                }
                if (!this.bVScrollBar) break;
                --this.nScrollPos;
                return true;
            }
            case 6: {
                if (this.bMenuVisible) {
                    if (this.nSelect < this.nMaxMenu) {
                        ++this.nSelect;
                        this.bRedraw = true;
                    } else if (this.bMenuRotate) {
                        this.nSelect = 0;
                        this.bRedraw = true;
                    }
                }
                if (!this.bVScrollBar) break;
                ++this.nScrollPos;
                return true;
            }
            case 8: 
            case 11: 
            case 53: {
                if (!this.canbeDone()) break;
                this.codeNotify = 1;
                return !this.bForcedControl;
            }
            case 10: 
            case 12: {
                this.codeNotify = 32768;
                return !this.bForcedControl;
            }
            default: {
                if (keyCode < 49 || keyCode > 49 + this.nMaxMenu) break;
                this.nSelect = keyCode - 49;
                if (!this.canbeDone()) break;
                this.codeNotify = 1;
                return !this.bForcedControl;
            }
        }
        return false;
    }

    public void keyRepeated(int keyCode) {
        if (this.bVScrollBar) {
            switch (keyCode) {
                case 1: {
                    --this.VY;
                    break;
                }
                case 6: {
                    ++this.VY;
                }
            }
        }
    }

    public void keyReleased(int keyCode) {
        this.VY = 0;
    }
}

