/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class MovIntro
extends MovBase {
    int cx;
    int cy;
    int nScene;
    int nLastScene;
    int keyRGB = 16767232;
    boolean bArt = false;

    MovIntro(TOB3 App) {
        super(App);
    }

    void drawLeadLine(Graphics g, int deg, int a2, int cx, int cy, int rx, int ry) {
        int x = MathExt.cos(deg) * rx >> 10;
        int y = MathExt.sin(deg) * ry >> 10;
        for (int i = 0; i < a2; ++i) {
            int x1 = MathExt.cos(deg += 4) * rx >> 10;
            int y1 = MathExt.sin(deg) * ry >> 10;
            g.setColor(this.png.getRGB(i * 100 / a2, 0, this.keyRGB));
            g.drawLine(x + cx, y + cy, x1 + cx, y1 + cy);
            x = x1;
            y = y1;
        }
    }

    public static void drawCircle(Graphics g, int cx, int cy, int r, int deg) {
        int x = MathExt.cos(deg) * r >> 10;
        int y = MathExt.sin(deg) * r >> 10;
        for (int i = 0; i < 4; ++i) {
            int x1 = MathExt.cos(deg += 90) * r >> 10;
            int y1 = MathExt.sin(deg) * r >> 10;
            g.drawLine(x + cx, y + cy, x1 + cx, y1 + cy);
            x = x1;
            y = y1;
        }
    }

    boolean dispatch(Graphics g) {
        int t = this.getRealTime();
        int cx = this._x + this._w / 2;
        int cy = this._y + this._h / 2;
        if (this.bArt) {
            int deg = t >> 3;
            int r = this._w / 2;
            g.setColor(this.png.getRGB(Math.abs(MathExt.sin(deg) >> 3), 0, this.keyRGB));
            MovIntro.drawCircle(g, cx, cy, r * 3 / 5, deg);
            g.setColor(this.png.getRGB(Math.abs(MathExt.cos(deg) >> 3), 0, this.keyRGB));
            MovIntro.drawCircle(g, cx, cy, r * 9 / 10, -deg);
        } else {
            for (int i = 0; i < 3; ++i) {
                this.drawLeadLine(g, t / this.nFPS + i * 120, 8, cx, cy, this._w / 2 - 1, this._h / 2 - 1);
            }
        }
        if (this.nScene != this.nLastScene) {
            this.syncAnimation(30);
            this.nLastScene = this.nScene;
        }
        switch (this.nScene) {
            case 0: {
                this.openDoor(g);
                break;
            }
            case 1: {
                this.wait4Battle(g);
                break;
            }
            case 2: {
                this.run2Door(g);
                break;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    void openDoor(Graphics g) {
        int t = this.getTick();
        if (t <= 10) {
            return;
        }
        if ((t -= 10) > 32) {
            t = 32;
        }
        int w = this._h / 20 * t / 32;
        int d = 2 * this._h / 5;
        int y = this.cy + this._h / 10;
        for (int i = 0; i < d; ++i) {
            int wi = w + i * 2 * w / d;
            ++y;
        }
        this.nScene += 4;
    }

    void wait4Battle(Graphics g) {
        int t = this.getTick();
        this.App.clear(g, 0);
        int a2 = t * t;
        int y = this.cy + (MathExt.sin(t * t) * t >> 11);
        this._drawDoor(g, this._h, this.cx, y);
        if (t > 25) {
            ++this.nScene;
        }
    }

    void _drawDoor(Graphics g, int s, int cx, int cy) {
        int w = s / 20;
        g.setColor(0xFFFFFF);
        int d = 2 * s / 5;
        int y = cy + s / 10;
        for (int i = 0; i < d && y < this._h; ++y, ++i) {
            int wi = w + i * 2 * w / d;
            g.setColor(this.png.getRGB(i * 100 / d, 0xFFFFFF, 0));
        }
    }

    void run2Door(Graphics g) {
        int t = this.getRealTime();
        int s = this._h * t * t / 20000 + this._h;
        g.setColor(0);
        g.fillRect(this._x, this._y, this._w, this._h);
        this._drawDoor(g, s, this.cx, this.cy);
        if (this.cx <= s / 20) {
            ++this.nScene;
        }
    }

    void prepare(Graphics g, int x, int y, int w, int h) {
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        this.nScene = 0;
        this.nLastScene = 0;
        this.cx = this._x + this._w / 2;
        this.cy = this._y + this._h / 2;
    }
}

