/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MovManastorm
extends MovBase {
    int cx;
    int cy;
    int keyRGB;
    int nLevel;
    int nSeed;
    int nScene = 0;
    Random rnd;
    int s = 0;
    int v = 0;
    int frame;

    MovManastorm(TOB3 App) {
        super(App);
        int[] RGB = new int[]{0, 32768, 65280, 32896, 255, 65535};
        this.nLevel = App.MainDungeon.nBerserkLevel[2];
        this.keyRGB = RGB[this.nLevel];
        this.nSeed = App.getRnd(0xFFFFFF);
        this.rnd = new Random(this.nSeed);
        try {
            for (int i = 0; i < 4; ++i) {
                this.effectImage[i] = Image.createImage((String)("/res/Ecffet/ecffet" + i + ".png"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void prepare(Graphics g, int x, int y, int w, int h) {
        this.cx = x + w / 2;
        this.cy = y + h - 16;
        this.syncAnimation(20);
    }

    boolean dispatch(Graphics g) {
        int t = this.getRealTime();
        switch (this.nScene) {
            case 0: {
                int d = t / 30;
                this.frame = (this.frame + 1) % 4;
                g.drawImage(this.effectImage[this.frame], this.cx - 15, this.cy - 5, 0);
                this.App.MainDungeon._drawTempMob(g);
                if (t <= 800) break;
                ++this.nScene;
                this.syncAnimation(20);
                this.App.doVibration();
                break;
            }
            case 1: {
                this.drawSunLine(g, t >>= 2, t);
                this.App.MainDungeon._drawTempMob(g);
                if (t <= 160) break;
                return true;
            }
        }
        return false;
    }

    void drawSunLine(Graphics g, int deg, int r) {
        int k = 10 - this.nLevel;
        int d = 10;
        for (int i = 0; i < 360; i += k) {
            int x = MathExt.cos(deg) * r >> 10;
            int y = MathExt.sin(deg) * r >> 11;
            d = this.rnd.nextInt() & 7;
            this.drawMarkLine(g, deg, x + this.cx, y + this.cy, d, this.png.getRGB(d * 14, 0xFFFFFF, this.keyRGB));
            deg += k;
        }
    }

    void drawMarkLine(Graphics g, int deg, int x, int y, int d, int sRGB) {
        int dy = 0;
        int dx = 0;
        int nLen = 0;
        for (int i = 0; i < 4; ++i) {
            g.setColor(this.png.getRGB(i * 25, sRGB, 0));
            int dx1 = MathExt.cos(deg + 180) * (nLen += d) >> 10;
            int dy1 = MathExt.sin(deg + 180) * nLen >> 11;
            g.drawLine(x + dx, y + dy, x + dx1, y + dy1);
            dx = dx1;
            dy = dy1;
        }
    }
}

