/*
 * Decompiled with CFR 0.152.
 */
public class Quest {
    int nTriggerIndex;
    int nQuestType;
    boolean bDone;
    int[] nParam1 = new int[3];
    int[] nParam2 = new int[3];
    int[] nParam3 = new int[3];
    int[] nCParam = new int[3];
    String[] sParam = null;
    String[] sCParam = null;
    String strTitle;
    int nRewardGold;
    int nRewardItem;
    int nRewardItemCount;
    static final int QST_KILL = 1;
    static final int QST_HUNT = 2;
    static final int QST_DROP = 3;
    static final int QST_DHL = 4;
    static final int QST_TRG = 5;
    Dungeon dg;

    Quest(Dungeon dg, int nIndex) {
        this.dg = dg;
        this.bDone = false;
        this.loadQuest(nIndex);
    }

    Quest(Dungeon dg, RMS rms) {
        this.dg = dg;
        this.bDone = false;
        this._load(rms);
    }

    void save(RMS rms) {
        rms.writeInt(this.nTriggerIndex);
        rms.writeIntArray(this.nCParam);
        rms.writeBool(this.bDone);
    }

    void _load(RMS rms) {
        this.nTriggerIndex = rms.readInt();
        this.loadQuest(this.nTriggerIndex);
        rms.readIntArray(this.nCParam);
        this.bDone = rms.readBool();
    }

    void loadQuest(int nIndex) {
        int i;
        this.nTriggerIndex = nIndex;
        TextFile qst = new TextFile();
        qst.read(4, nIndex);
        qst.readScene(0);
        this.nQuestType = qst.getIntArg(0);
        this.nRewardGold = qst.getIntArg(1);
        this.nRewardItem = qst.getIntArg(2);
        this.nRewardItemCount = qst.getIntArg(3);
        this.strTitle = qst.readNextLine();
        qst.readScene(this.nQuestType == 1 ? 1 : 2);
        for (i = 0; i < 3; ++i) {
            this.nParam1[i] = qst.getIntArg(i * 2);
            this.nParam2[i] = qst.getIntArg(i * 2 + 1);
            this.nCParam[i] = 0;
        }
        if (this.nQuestType == 3 || this.nQuestType == 5) {
            qst.readScene(this.nQuestType);
            for (i = 0; i < 3; ++i) {
                this.nParam3[i] = qst.getIntArg(i);
            }
            if (this.nQuestType == 5) {
                this.sParam = new String[3];
                this.sCParam = new String[3];
                for (i = 0; i < 3; ++i) {
                    if (!qst.readScene(20 + i)) continue;
                    this.sParam[i] = qst.readNextLine();
                    this.sCParam[i] = this.dg.isTriggered(this.nParam3[i]) ? this.sParam[i] : "---";
                }
            }
        }
        if (this.nQuestType != 1) {
            if (this.nQuestType == 4) {
                for (i = 0; i < 3; ++i) {
                    if (this.dg.iBag.countItemLeft(this.nParam1[i]) >= this.nParam2[i]) continue;
                    this.dg.iBag._addItem(this.nParam1[i], this.nParam2[i]);
                }
            }
            for (i = 0; i < 3; ++i) {
                if (this.nCParam[i] >= this.nParam2[i]) continue;
                this.nCParam[i] = this.dg.iBag.countItemLeft(this.nParam1[i]);
                if (this.nCParam[i] <= this.nParam2[i]) continue;
                this.nCParam[i] = this.nParam2[i];
            }
            this._isDone();
        }
        qst = null;
    }

    boolean _isDone() {
        for (int i = 0; i < 3; ++i) {
            if (!(this.nQuestType == 5 ? !this.dg.isTriggered(this.nParam3[i]) : this.nCParam[i] < this.nParam2[i])) continue;
            return false;
        }
        this.dg.setTrigger(this.nTriggerIndex + 100, true);
        this.bDone = true;
        return true;
    }

    void Done_Kill(obj2D mob) {
        if (this.bDone) {
            return;
        }
        System.out.println("\u4efb\u52a1\u7684\u5b8c\u6210Quest.Done_kill---------------nQuestType=" + this.nQuestType);
        switch (this.nQuestType) {
            case 1: {
                for (int i = 0; i < 3; ++i) {
                    if (mob.nObjType != this.nParam1[i] || this.nCParam[i] >= this.nParam2[i]) continue;
                    int n = i;
                    this.nCParam[n] = this.nCParam[n] + 1;
                    this.dg.movQuest.addLine(mob.strName + " " + this.nCParam[i] + "/" + this.nParam2[i]);
                    this._isDone();
                    return;
                }
                break;
            }
        }
    }

    void Done_AddItemTable(ItemTable iTable) {
        switch (this.nQuestType) {
            case 3: {
                if (iTable.nMobType != this.nParam3[0]) break;
                iTable.addTable(this.nParam3[0], this.nParam3[1], this.nParam3[2]);
            }
        }
    }

    void Done_Trigger() {
        if (this.nQuestType == 5) {
            for (int i = 0; i < 3; ++i) {
                this.sCParam[i] = this.dg.isTriggered(this.nParam3[i]) ? this.sParam[i] : "---";
            }
            this._isDone();
        }
    }

    void Done_GetItem(int nItem) {
        if (this.bDone) {
            return;
        }
        nItem &= 0xFFF;
        switch (this.nQuestType) {
            case 2: 
            case 3: 
            case 4: {
                for (int i = 0; i < 3; ++i) {
                    if (nItem != this.nParam1[i] || this.nCParam[i] >= this.nParam2[i]) continue;
                    this.nCParam[i] = this.dg.iBag.countItemLeft(nItem);
                    if (this.nCParam[i] > this.nParam2[i]) {
                        this.nCParam[i] = this.nParam2[i];
                    }
                    if (this.dg.movQuest != null) {
                        dtBag cfr_ignored_0 = this.dg.iBag;
                        this.dg.movQuest.addLine(dtBag.getItemName(nItem) + " " + this.nCParam[i] + "/" + this.nParam2[i]);
                    }
                    this._isDone();
                    return;
                }
                break;
            }
        }
    }

    void Done_SellItem(int nItem) {
        nItem &= 0xFFF;
        switch (this.nQuestType) {
            case 2: 
            case 3: {
                for (int i = 0; i < 3; ++i) {
                    if (nItem != this.nParam1[i]) continue;
                    int nLeft = this.dg.iBag.countItemLeft(nItem);
                    if (this.nCParam[i] > nLeft) {
                        this.nCParam[i] = nLeft;
                        this.dg.setTrigger(this.nTriggerIndex + 100, false);
                        this.bDone = false;
                    }
                    return;
                }
                break;
            }
        }
    }

    void Done_Reward() {
        this.nTriggerIndex = -1;
        this.dg.nGold += this.nRewardGold;
        if (this.nRewardItemCount > 0) {
            if (this.nRewardItem == 200 || this.nRewardItem == 201 || this.nRewardItem == 202) {
                this.dg.nBerserkLevel[this.nRewardItem % 200] = 1;
            }
            this.dg.addItem(this.nRewardItem, this.nRewardItemCount);
        }
        switch (this.nQuestType) {
            case 2: 
            case 3: 
            case 4: {
                for (int i = 0; i < 3; ++i) {
                    this.dg.removeItem(this.nParam1[i], this.nParam2[i]);
                }
                break;
            }
        }
    }
}

