/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class RMS {
    private RecordStore rs = null;
    private int nPosition = 0;
    private boolean bWriteMode = false;
    byte[] iobuffer = null;

    public boolean open(String strKey, boolean bWrite) {
        this.nPosition = 0;
        this.bWriteMode = bWrite;
        try {
            this.rs = RecordStore.openRecordStore((String)strKey, (boolean)bWrite);
        }
        catch (RecordStoreException e) {
            return false;
        }
        if (bWrite) {
            this.iobuffer = new byte[1024];
        } else {
            try {
                this.iobuffer = this.rs.getRecord(1);
            }
            catch (RecordStoreException recordStoreException) {
                // empty catch block
            }
        }
        return true;
    }

    public void close() {
        try {
            if (this.bWriteMode) {
                if (this.rs.getNumRecords() == 1) {
                    this.rs.setRecord(1, this.iobuffer, 0, this.nPosition);
                } else {
                    this.rs.addRecord(this.iobuffer, 0, this.nPosition);
                }
            }
            this.rs.closeRecordStore();
            this.rs = null;
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        this.iobuffer = null;
    }

    public void skip(int n) {
        this.nPosition += n;
    }

    public boolean readBool() {
        return this.readInt() == 1;
    }

    public int readInt() {
        int nRtn = this.readInt(this.iobuffer, this.nPosition);
        this.nPosition += 4;
        return nRtn;
    }

    public void readIntArray(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readInt();
        }
    }

    public int readInt(byte[] buffer, int offset) {
        int nW = 0;
        nW = (buffer[offset] & 0xFF) << 24;
        nW += (buffer[offset + 1] & 0xFF) << 16;
        nW += (buffer[offset + 2] & 0xFF) << 8;
        return nW += buffer[offset + 3] & 0xFF;
    }

    public void readByteArray(byte[] buffer) {
        System.arraycopy(this.iobuffer, this.nPosition, buffer, 0, buffer.length);
        this.nPosition += buffer.length;
    }

    public String readString(int nSize) {
        byte[] buffer = new byte[nSize];
        this.readByteArray(buffer);
        return new String(buffer).trim();
    }

    public void writeBool(boolean b2) {
        this.writeInt(b2 ? 1 : 0);
    }

    public void writeInt(int n) {
        this.writeInt(this.iobuffer, this.nPosition, n);
        this.nPosition += 4;
    }

    public void writeInt(byte[] buffer, int offset, int n) {
        buffer[offset + 3] = (byte)(n & 0xFF);
        buffer[offset + 2] = (byte)(n >> 8 & 0xFF);
        buffer[offset + 1] = (byte)(n >> 16 & 0xFF);
        buffer[offset + 0] = (byte)(n >> 24 & 0xFF);
    }

    public void writeIntArray(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            this.writeInt(array[i]);
        }
    }

    public void writeByteArray(byte[] buffer) {
        System.arraycopy(buffer, 0, this.iobuffer, this.nPosition, buffer.length);
        this.nPosition += buffer.length;
    }

    public void writeString(String strData, int nMAX) {
        byte[] buffer = new byte[nMAX];
        System.arraycopy(strData.getBytes(), 0, buffer, 0, strData.getBytes().length);
        this.writeByteArray(buffer);
    }
}

