/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Renderer
implements Runnable {
    Maze map;
    TOB3 App;
    PNGList png;
    static final int TILE_ROCK = 1;
    static final byte T_BLACK = 0;
    static final byte T_BASE = 1;
    static final byte T_LEFT = 6;
    static final byte T_RIGHT = 21;
    static final byte T_LTOP = 36;
    static final byte T_RTOP = 41;
    static final byte T_DOWN = 46;
    static final byte T_UP = 49;
    static final byte T_TOWN = 52;
    int nTileType = 99;
    Image[] imgTile = new Image[55];
    Image imgMask = null;
    Image imgMaskR = null;
    Image imgTmp = null;
    byte[] _RM = null;
    int _nCount;
    int nProgress;
    byte[] _r_tile = new byte[]{0, 1, 0, 2, 0, 1, 4, 0, 0, 0, 1, 0, 0, 2, 3, 0};
    Graphics g1;

    Renderer(TOB3 App, Maze map) {
        this.App = App;
        this.map = map;
        this.png = App.png;
    }

    void releaseTile() {
        for (int i = 0; i < this.imgTile.length; ++i) {
            this.imgTile[i] = null;
        }
        this.nTileType = 99;
        System.gc();
    }

    boolean loadTileSet(int nNewTile) {
        if (nNewTile > 2) {
            nNewTile = 0;
        }
        if (this.nTileType >= 0) {
            if (nNewTile == this.nTileType) {
                return true;
            }
            if (this.imgMask == null) {
                try {
                    this.imgMask = Image.createImage((String)"/res/UI/6.png");
                    this.imgMaskR = Image.createImage((String)"/res/UI/7.png");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.nTileType = -1;
            this._nCount = 0;
        }
        if (nNewTile == 0) {
            try {
                this.imgTile[this._nCount] = Image.createImage((String)("/res/imgTile0/" + this._nCount + ".png"));
                if (this._nCount < this.imgTile.length) {
                    ++this._nCount;
                }
            }
            catch (Exception e) {
                System.out.println("\u52a0\u8f7d\u5730\u56fe\u8d44\u6e90\u51fa\u9519");
            }
        } else {
            try {
                this.imgTile[this._nCount] = Image.createImage((String)("/res/imgTile" + nNewTile + "/" + this._nCount++ + ".png"));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this._nCount == 55) {
            this.nTileType = nNewTile;
        }
        return this.nTileType == nNewTile;
    }

    public void run() {
        this.nProgress = 2;
        this.map.build2DMaze();
        this.App.MainDungeon.postMazeBuild();
        if (this._RM == null) {
            this._RM = new byte[65536];
        }
        for (int i = 0; i < 256; ++i) {
            System.arraycopy(this._RM, 0, this._RM, i << 8, 256);
        }
        while (this.nProgress < 120) {
            this.makeRM(this.nProgress);
            ++this.nProgress;
        }
        this.makeRM4Building();
    }

    boolean _isSpace(int y, int x) {
        return Maze.maze[(x >>= 1) + ((y >>= 1) << 6)] == 3;
    }

    void makeRM(int y) {
        int x;
        int pos = x - y + 119 + (x + y - 2 << 8);
        for (x = 2; x < 120; ++x) {
            if (this._isSpace(y, x)) {
                if (this._isSpace(y, x - 1)) {
                    this._setTile(pos, (byte)1);
                } else {
                    this._setSTile(pos, (byte)21, this._RM[pos - 256] >= 36);
                }
                if (this._isSpace(y - 1, x)) {
                    this._setTile(pos + 1, (byte)1);
                } else {
                    this._setSTile(pos + 1, (byte)6, this._RM[pos - 255] >= 36);
                }
            } else {
                if (this._isSpace(y, x - 1)) {
                    this._setTile(pos, (byte)36);
                    this._RM[pos + 256] = 0;
                }
                if (this._isSpace(y - 1, x)) {
                    this._setTile(pos + 1, (byte)41);
                    this._RM[pos + 257] = 0;
                }
            }
            pos += 257;
        }
    }

    void makeRM4Building() {
        for (int i = 0; i < 3; ++i) {
            if (this.map.building[i] <= 0) continue;
            this._setBSTile(this.map.building[i] & 0xFF, this.map.building[i] >> 8, 46 + i * 3);
        }
    }

    void _setBSTile(int x, int y, int nType) {
        int ix = x - y + (nType == 46 ? 119 : 120);
        int iy = x + y - 1;
        for (int i = 0; i < 3; ++i) {
            this._RM[ix + (iy + i << 8)] = (byte)(nType + i);
        }
    }

    void _setSTile(int pos, byte nType, boolean bTransparent) {
        nType = (byte)(nType + this.App.getRnd(5) * 3);
        if (bTransparent) {
            nType = -nType;
            int i = 0;
            while (i < 3) {
                this._RM[pos] = nType;
                ++i;
                pos += 256;
                nType = (byte)(nType - 1);
            }
        } else {
            int i = 0;
            while (i < 3) {
                this._RM[pos] = nType;
                ++i;
                pos += 256;
                nType = (byte)(nType + 1);
            }
        }
    }

    void _setTile(int pos, byte nType) {
        if (nType == 1) {
            if (this._RM[pos] != 0) {
                return;
            }
            nType = (byte)(nType + this._r_tile[this.App.getRnd(15)]);
        } else {
            nType = (byte)(nType + this.App.getRnd(5));
        }
        this._RM[pos] = nType;
    }

    void draw3D_BG(Graphics g, int xReal, int yReal, int w, int h) {
        int ix = xReal >> 5;
        int iy = yReal >> 4;
        int y = -(yReal & 0xF);
        for (int i = 0; i < h; ++i) {
            int x = -(xReal & 0x1F);
            int pos = ix + (iy + i << 8);
            int j = 0;
            while (j < w) {
                byte c = this._RM[pos];
                if (c >= 36 && c < 46) {
                    byte c1 = this._RM[pos - 256];
                    if (6 <= c1 && c1 % 3 == 0) {
                        g.drawImage(this.imgTile[c1 + 1], x, y, 20);
                    } else {
                        g.drawImage(this.imgTile[1], x, y, 20);
                    }
                    if (this.App.bWallEffect) {
                        g.drawImage(this.imgTile[c], x, y, 20);
                    }
                } else {
                    if (c > 0 && this.imgTile[c] != null) {
                        g.drawImage(this.imgTile[c], x, y, 20);
                    }
                    if (this.App.bWallEffect) {
                        if (c == 0) {
                            g.setColor(0);
                            g.fillRect(x, y, 32, 16);
                        }
                        if (c < 0) {
                            g.drawImage(this.imgTile[-c], x, y, 20);
                        }
                    }
                }
                ++j;
                x += 32;
                ++pos;
            }
            y += 16;
        }
    }

    void draw3D_LayeredFG(Graphics g, int xReal, int yReal, int w, int hLo, int hHi) {
        if (this.App.bWallEffect) {
            this.draw3D_LayeredFGx(g, xReal, yReal, w, hLo, hHi);
            return;
        }
        int ix = xReal >> 5;
        int iy = yReal >> 4;
        int y = -(yReal & 0xF) + (hLo << 4);
        for (int i = hLo; i <= hHi; ++i) {
            int x = -(xReal & 0x1F);
            int j = 0;
            while (j < w) {
                int pos = ix + j + (iy + i << 8);
                byte c = this._RM[pos];
                if (c < 0 && c % 3 == -2) {
                    g.drawImage(this.imgTile[-c], x, y, 20);
                }
                if ((c = this._RM[pos - 256]) < 0 && c % 3 == -1) {
                    g.drawImage(this.imgTile[-c], x, y - 16, 20);
                }
                if ((c = this._RM[pos - 512]) < 0 && c % 3 == 0) {
                    g.drawImage(this.imgTile[-c], x, y - 32, 20);
                }
                if ((c = this._RM[pos - 768]) >= 36 && c < 46) {
                    g.drawImage(this.imgTile[c], x, y - 48, 20);
                }
                if (c == 0) {
                    g.setColor(0);
                    g.fillRect(x, y - 48, 32, 16);
                }
                ++j;
                x += 32;
            }
            y += 16;
        }
    }

    void draw3D_LayeredFGx(Graphics g, int xReal, int yReal, int w, int hLo, int hHi) {
        int ix = xReal >> 5;
        int iy = yReal >> 4;
        int y = -(yReal & 0xF) + (hLo << 4);
        for (int i = hLo; i <= hHi; ++i) {
            int x = -(xReal & 0x1F);
            int j = 0;
            while (j < w) {
                byte c2;
                byte c1;
                int pos = ix + j + (iy + i << 8);
                byte c = this._RM[pos];
                if (c < 0 && c % 3 == -2) {
                    g.drawImage(this.imgTile[-c], x, y, 20);
                }
                if ((c = this._RM[pos - 256]) < 0 && c % 3 == -1) {
                    g.drawImage(this.imgTile[-c], x, y - 16, 20);
                }
                if ((c1 = this._RM[pos - 512]) < 0 && c1 % 3 == 0) {
                    g.drawImage(this.imgTile[-c1], x, y - 32, 20);
                }
                if ((c2 = this._RM[pos - 768]) >= 36 && c2 < 46) {
                    this.png.drawSubFrame(g, this.imgTile[0], c2 - 36, x, y - 48, 32, 16);
                    if (c1 == 0) {
                        g.drawImage(this.imgMaskR, x, y - 32, 20);
                    }
                    if (c == 0) {
                        g.drawImage(this.imgMaskR, x, y - 16, 20);
                    }
                }
                ++j;
                x += 32;
            }
            y += 16;
        }
    }

    void drawShadowImage(Graphics g, Image img, int x, int y) {
        if (this.imgTmp == null) {
            this.imgTmp = Image.createImage((int)32, (int)16);
            this.g1 = this.imgTmp.getGraphics();
        }
        this.g1.drawImage(img, 0, 0, 20);
        this.g1.drawImage(this.imgMask, 0, 0, 20);
        g.drawImage(this.imgMaskR, x, y, 20);
        g.setColor(0);
    }
}

