/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class GameMap {
    public int[][] trapData;
    public static GameEngine engine;
    static int SCREEN_WIDTH;
    static int SCREEN_HEIGHT;
    static byte tileWidth;
    static byte tileHight;
    static int[] mapSize;
    short[] tileProperties;
    String[] name;
    static int setOffX;
    static int setOffY;
    byte[] mapData;
    byte gameRank;
    int maxState;
    public static final byte DT_HUATAN = 0;
    public static final byte DT_CAOCONG = 1;
    public static final byte DT_CHUANSONGMEN_GUAN = 2;
    public static final byte DT_CHUANSONGMEN_KAI = 3;
    public static final byte DT_XIANGZI = 4;
    public static final byte DT_CAOCONG2 = 5;
    public static final byte DT_SHUZHUANG = 6;
    public static final byte DT_HUA = 7;
    public static final byte DT_HONGMOGU = 8;
    public static final byte DT_LANMOGU = 9;
    public static final byte DT_BINGKUAI = 10;
    public static final byte DT_LINGDANG = 11;
    public static final byte DT_SHENGDANSHU = 12;
    public static final byte DT_BAOXIANG = 13;
    public static final byte DT_DACAODUO = 14;
    public static final byte DT_FUWENSHI = 15;
    public static final byte DT_MUXIANG = 16;
    public static final byte DT_SHADI = 17;
    public static final byte DT_TAOGUAN = 18;
    public static final byte DT_XIAOCAODUO = 19;
    public static final byte DT_YIJI = 20;
    public static final byte DT_DAANNIU = 21;
    public static final byte DT_GONGCHANGDENG = 22;
    public static final byte DT_JINGSHIZHU = 23;
    public static final byte DT_GONGCHANG1 = 24;
    public static final byte DT_GONGCHANG2 = 25;
    public static final byte DT_CHONGDONG = 26;
    public static final byte DT_HEISECHONGDONG = 27;
    public static final byte DT_YUZHOUBAOSHI = 28;
    public static final byte DT_YUZHOU = 29;
    int[][] cilpData_xiangzi = new int[][]{{0, 13, 34, 38}, {36, 13, 43, 38}, {82, 9, 34, 42}, {120, 5, 34, 46}, {157, 21, 42, 30}, {202, 7, 30, 44}, {235, 0, 48, 51}, {288, 0, 49, 51}, {342, 21, 59, 30}};
    int[][] indent_xiangzi = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}};
    static int[][] dexData;
    int[][] dexData0 = new int[][]{{0, 0, 0, 0, 0, 0, 0}};
    int index = 0;
    public byte[] motion;
    public boolean isMir = false;
    int doorLayer = 0;
    public static final byte D_TYPE = 0;
    public static final byte D_X = 1;
    public static final byte D_Y = 2;
    public static final byte D_W = 4;
    public static final byte D_H = 5;
    public static final byte D_ST = 6;
    int time = 0;
    int[][] array_tip = new int[][]{{0, 0, 12, 14}, {12, 0, 12, 14}, {24, 0, 12, 14}, {36, 0, 12, 14}, {48, 0, 12, 14}};
    short tipIndex = 0;
    public static final byte SCEEN_MOVE = 17;
    int posX;
    int posY;
    public static final byte ROLE = 0;
    public static final byte ENEMY = 1;
    public static final byte FIRE = 2;
    static byte[][] mData;
    static short[][] mProperties;
    static String[][] mName;
    static int layer;
    Image mapBuffer;
    int bufferWidth;
    int bufferHeight;
    Graphics bufferG;
    boolean isBufferNull;
    int lastStartX;
    int lastStartY;
    int lastEndX;
    int lastEndY;

    public void free() {
        this.mapBuffer = null;
        mData = null;
        mProperties = null;
        mName = null;
        this.mapBuffer = null;
        System.gc();
    }

    public GameMap(int sw, int sh) {
        SCREEN_WIDTH = sw;
        SCREEN_HEIGHT = sh;
        GameMap.setOff(0, 0);
    }

    public static void setOff(int x, int y) {
        setOffX = x;
        setOffY = y;
    }

    public void createMap(String mapDat) {
        this.createMapBuff();
        this.posX = SCREEN_WIDTH / 2;
        this.posY = SCREEN_HEIGHT / 2 + tileHight;
        this.loadMapDat(mapDat);
    }

    void loadMapDat(String mapDat) {
        this.loadMap(mapDat);
        Tools.createImage(mName);
    }

    public void init(int GameRank, int maxDestroyTime) {
        this.gameRank = (byte)GameRank;
        this.maxState = maxDestroyTime + 1;
    }

    public void setTile() {
        int n = setOffX / tileWidth * mapSize[1] + setOffY / tileHight;
        int nw = SCREEN_WIDTH / tileWidth + 2;
        int nh = SCREEN_HEIGHT / tileHight + 2;
        int j = 0;
        while (j < nw) {
            int s;
            int i = s = n + j * mapSize[1];
            while (i < s + nh) {
                if (i < this.mapData.length && i >= 0 && this.mapData[i] != -1) {
                    int dataTemp = GameMap.getIndex(this.mapData[i]);
                    int x = i / mapSize[1] * tileHight;
                    int y = i % mapSize[1] * tileWidth;
                    Tools.addImage(300 + dataTemp, x, y, 0, 0, tileWidth, tileHight, 20, (byte)GameMap.getTrans(this.mapData[i]), Tools.getProperties(this.tileProperties[dataTemp], (byte)1) ? 30 : 20);
                }
                ++i;
            }
            ++j;
        }
    }

    public int[][] getNewDexData(int[][] dexData, int[] newData) {
        int length = dexData.length;
        int[][] newDexData = new int[length + 1][7];
        int i = 0;
        while (i < length) {
            newDexData[i][0] = dexData[i][0];
            newDexData[i][1] = dexData[i][1];
            newDexData[i][2] = dexData[i][2];
            newDexData[i][3] = dexData[i][3];
            newDexData[i][4] = dexData[i][4];
            newDexData[i][5] = dexData[i][5];
            newDexData[i][6] = dexData[i][6];
            ++i;
        }
        newDexData[length][0] = newData[0];
        newDexData[length][1] = newData[1];
        newDexData[length][2] = newData[2];
        newDexData[length][3] = newData[3];
        newDexData[length][4] = newData[4];
        newDexData[length][5] = newData[5];
        newDexData[length][6] = newData[6];
        return newDexData;
    }

    public void drawDEC() {
        if (dexData == null) {
            return;
        }
        int length = dexData.length;
        int i = 0;
        while (i < dexData.length) {
            switch (dexData[i][0]) {
                case 0: {
                    Tools.addImage(4, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 1: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(0, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 5: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(42, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 6: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(44, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 7: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(43, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 8: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(45, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 9: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(46, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 10: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(104, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 11: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(105, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 12: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(106, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 13: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(108, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 14: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(109, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 15: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(110, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 16: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(111, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 17: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(112, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 18: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(113, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 19: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(114, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 20: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(30, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 21: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(127, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 22: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(128, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 23: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(129, dexData[i][1] + 5, dexData[i][2] - 6 + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 24: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(125, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 25: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(126, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 26: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(130, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 27: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(131, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 28: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(132, dexData[i][1] + 3, dexData[i][2] - 2 + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 29: {
                    if (dexData[i][6] != 0) break;
                    Tools.addImage(133, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 36, (byte)0, dexData[i][2]);
                    break;
                }
                case 2: {
                    if (this.doorLayer == -1) break;
                    Tools.addImage(2, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 48, 0, 24, 24, 36, (byte)0, -1);
                    break;
                }
                case 3: {
                    if (this.doorLayer == -1) break;
                    if (dexData[i][6] == 0) {
                        Tools.addImage(2, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 0, 0, 24, 24, 36, (byte)0, -1);
                    }
                    if (dexData[i][6] == 1) {
                        Tools.addImage(2, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 24, 0, 24, 24, 36, (byte)0, -1);
                    }
                    if (dexData[i][6] == 2) {
                        Tools.addImage(2, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 0, 0, 24, 24, 36, (byte)0, -1);
                    }
                    if (dexData[i][6] != 3) break;
                    Tools.addImage(2, dexData[i][1], dexData[i][2] + GameEngine.topHeight, 48, 0, 24, 24, 36, (byte)0, -1);
                }
            }
            ++i;
        }
    }

    public void setMap(Graphics g) {
        if (mData != null) {
            this.drawMapBuffer(g, setOffX, setOffY);
        }
        if (this.gameRank == 17 && this.dexData0 != null) {
            dexData = this.dexData0;
        }
        if (this.gameRank == 44 && this.dexData0 != null) {
            dexData = this.dexData0;
        }
        this.hideDoor();
        this.drawDEC();
        this.drawTip();
    }

    public void drawTip() {
        int[][][] tipLocXY = new int[][][]{new int[][]{{144, 96}}, new int[][]{{144, 168}, {48, 264}, {240, 264}}, new int[][]{{48, 96}, {144, 144}, {240, 192}, {48, 216}}, new int[][]{{144, 264}}, new int[][]{{144, 120}, {96, 264}, {192, 264}}, new int[][]{{144, 264}}, new int[][]{{144, 96}}, new int[][]{{48, 96}, {240, 96}, {48, 264}, {240, 264}}};
        if (this.gameRank > 8) {
            if (this.gameRank < 17) {
                int gIndex = this.gameRank - 9;
                int[][] tips = tipLocXY[gIndex];
                int i = 0;
                while (i < tips.length) {
                    Tools.addImage(52, tips[i][0] + 6, tips[i][1], this.array_tip[this.tipIndex % 5], 36, (byte)0, tips[i][1] + 5);
                    ++i;
                }
                this.tipIndex = (short)(this.tipIndex + 1);
                if (this.tipIndex > 100) {
                    this.tipIndex = 1;
                }
            }
        }
    }

    public boolean hideDoor() {
        int doorIndex = this.getDoorIndex();
        if (doorIndex == -1) {
            doorIndex = this.getDoorOpenIndex();
        }
        int i = 0;
        while (i < dexData.length) {
            if ((dexData[i][0] == 1 || dexData[i][0] == 5 || dexData[i][0] == 6 || dexData[i][0] == 7 || dexData[i][0] == 8 || dexData[i][0] == 9 || dexData[i][0] == 4 || dexData[i][0] == 10 || dexData[i][0] == 11 || dexData[i][0] == 12 || dexData[i][0] == 13 || dexData[i][0] == 14 || dexData[i][0] == 15 || dexData[i][0] == 16 || dexData[i][0] == 17 || dexData[i][0] == 18 || dexData[i][0] == 19 || dexData[i][0] == 21 || dexData[i][0] == 22 || dexData[i][0] == 23 || dexData[i][0] == 26 || dexData[i][0] == 27 || dexData[i][0] == 28) && dexData[i][6] < this.maxState && dexData[i][1] == dexData[doorIndex][1] && dexData[i][2] == dexData[doorIndex][2]) {
                this.doorLayer = -1;
                return false;
            }
            ++i;
        }
        this.doorLayer = 0;
        return true;
    }

    public int getDoorIndex() {
        int index = -1;
        if (dexData == null) {
            return -1;
        }
        int i = 0;
        while (i < dexData.length) {
            if (dexData[i][0] == 2) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public int getDoorOpenIndex() {
        int index = -1;
        if (dexData == null) {
            return -1;
        }
        int i = 0;
        while (i < dexData.length) {
            if (dexData[i][0] == 3) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    public int getBoxIndex() {
        int index = 0;
        if (dexData == null) {
            return -1;
        }
        int i = 0;
        while (i < dexData.length) {
            if (dexData[i][0] == 4 && dexData[i][6] >= this.maxState) {
                index = i;
            }
            ++i;
        }
        return index;
    }

    int checkDEC(int x, int y) {
        if (dexData == null) {
            return -1;
        }
        int i = 0;
        while (i < dexData.length) {
            if (dexData[i][0] != 0 && (dexData[i][0] != 1 && dexData[i][0] != 5 && dexData[i][0] != 6 && dexData[i][0] != 7 && dexData[i][0] != 8 && dexData[i][0] != 9 && dexData[i][0] != 4 && dexData[i][0] != 10 && dexData[i][0] != 11 && dexData[i][0] != 12 && dexData[i][0] != 13 && dexData[i][0] != 14 && dexData[i][0] != 15 && dexData[i][0] != 16 && dexData[i][0] != 17 && dexData[i][0] != 18 && dexData[i][0] != 19 && dexData[i][0] != 21 && dexData[i][0] != 22 && dexData[i][0] != 23 && dexData[i][0] != 26 && dexData[i][0] != 27 && dexData[i][0] != 28 || dexData[i][6] < this.maxState) && dexData[i][0] != 3 && dexData[i][0] != 2 && x >= dexData[i][1] && x <= dexData[i][1] + dexData[i][4] && y <= dexData[i][2] && y >= dexData[i][2] - dexData[i][5]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void AdjustSrceen(int x, int y) {
        setOffX = Math.abs(x - setOffX - this.posX) > 17 ? (x - setOffX >= this.posX ? (setOffX += 17) : (setOffX -= 17)) : (int)((short)(x - this.posX));
        setOffX = (short)Math.max(setOffX, 0);
        int w = mapSize[0] * tileWidth;
        setOffX = w >= SCREEN_WIDTH ? (int)((short)Math.min(setOffX, w - SCREEN_WIDTH)) : (w - SCREEN_WIDTH) / 2;
        setOffY = Math.abs(y - setOffY - this.posY) > 17 ? (y - setOffY >= this.posY ? (setOffY += 17) : (setOffY -= 17)) : (int)((short)(y - this.posY));
        setOffY = (short)Math.max(setOffY, 0);
        int h = mapSize[1] * tileWidth;
        setOffY = h >= SCREEN_HEIGHT ? (int)((short)Math.min(setOffY, h - SCREEN_HEIGHT)) : (h - SCREEN_HEIGHT) / 2;
    }

    public boolean canMove(int x, int y) {
        if (x < 0 || x >= tileWidth * mapSize[0] || y < 0 || y >= tileHight * mapSize[1]) {
            return false;
        }
        int i = 0;
        while (i < layer) {
            if (GameMap.inMapData(x, y, i) == -1 ? i == 0 : !this.canMove(x, y, i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean canMove(int x, int y, int i) {
        if (GameMap.inMapData(x, y, i) == -1) {
            return false;
        }
        if (this.canUpAndDown(x, y, layer - 1)) {
            return true;
        }
        return Tools.getProperties(mProperties[i][GameMap.getLow(GameMap.inMapData(x, y, i))], (byte)15);
    }

    public boolean canUpAndDown(int x, int y, int lay) {
        if (GameMap.inMapData(x, y, lay) == -1) {
            return false;
        }
        return Tools.getProperties(mProperties[lay][GameMap.getLow(GameMap.inMapData(x, y, lay))], (byte)13);
    }

    public boolean canContinue(int x, int y, int sx, int sy, int type) {
        int lay = 0;
        if (this.canUpAndDown(x, y, layer - 1) && type == 0) {
            return true;
        }
        if (this.canUpAndDown(sx, sy, layer - 1) && type == 0) {
            return true;
        }
        if (this.beLayTwo(x, y, 1)) {
            lay = 1;
        }
        if (lay == 1) {
            return this.beLayTwo(sx, sy, lay);
        }
        if (lay == 0) {
            return !this.beLayTwo(sx, sy, lay);
        }
        return true;
    }

    public boolean beLayTwo(int x, int y, int lay) {
        if (GameMap.inMapData(x, y, lay) == -1) {
            return false;
        }
        return Tools.getProperties(mProperties[lay][GameMap.getLow(GameMap.inMapData(x, y, lay))], (byte)14);
    }

    public static byte inMapData(int x, int y, int index) {
        int n = x / tileWidth * mapSize[1] + y / tileHight;
        if (n < 0 || n >= mData[index].length) {
            return -1;
        }
        return mData[index][n];
    }

    public static void setMapData(int x, int y, int index) {
        int n = x / tileWidth * mapSize[1] + y / tileHight;
        GameMap.mData[index][n] = -1;
    }

    public static int getTrans(int v) {
        return v >> 6 & 3;
    }

    public static int get2nd(int v) {
        return v << 1 >> 7 & 1;
    }

    public static int getLow(int v) {
        return v & 0x3F;
    }

    static int bToi(byte byte0) {
        int i = byte0;
        if (byte0 < 0) {
            i += 256;
        }
        return i;
    }

    public static int getIndex(int v) {
        return v & 0x3F;
    }

    public int getIndex(int x, int y, int index) {
        return GameMap.getIndex(GameMap.inMapData(x, y, index));
    }

    public static void drawFullScreenBG(int imgIndex, int height, int speed, int level) {
        Tools.addRect((byte)1, 100, 100, 200, 200, true, 20, 0, 0);
    }

    public void loadMap(String file) {
        DataInputStream dis = Tools.openFile("/dat/map.pak");
        int fileLen = Tools.searchFile(dis, file);
        try {
            if (fileLen == -1) {
                System.out.println("/dat/map.pak\u6587\u4ef6\u4e0d\u5728~~~~");
                dis.close();
                return;
            }
            layer = GameMap.bToi(dis.readByte());
            mData = new byte[layer][];
            mProperties = new short[layer][];
            mName = new String[layer][];
            int i = 0;
            while (i < layer) {
                GameMap.mapSize[0] = GameMap.bToi(dis.readByte());
                GameMap.mapSize[1] = GameMap.bToi(dis.readByte());
                tileWidth = dis.readByte();
                tileHight = dis.readByte();
                int size = mapSize[0] * mapSize[1];
                GameMap.mData[i] = new byte[size];
                dis.read(mData[i]);
                int len = dis.readShort();
                GameMap.mName[i] = new String[len];
                GameMap.mProperties[i] = new short[len];
                int j = 0;
                while (j < len) {
                    byte nameLen = dis.readByte();
                    byte[] names = new byte[nameLen];
                    dis.read(names);
                    GameMap.mName[i][j] = new String(names);
                    GameMap.mProperties[i][j] = dis.readShort();
                    ++j;
                }
                ++i;
            }
            dis.close();
        }
        catch (IOException ex) {
            System.out.println("************* Read Map Error !!! ******************");
        }
    }

    void createMapBuff() {
        this.isBufferNull = true;
        if (this.mapBuffer == null) {
            tileWidth = (byte)24;
            tileHight = (byte)24;
            this.bufferWidth = ((SCREEN_WIDTH + tileWidth - 1) / tileWidth + 1) * tileWidth;
            this.bufferHeight = ((SCREEN_HEIGHT + tileHight - 1) / tileHight + 1) * tileHight;
            this.mapBuffer = Image.createImage((int)this.bufferWidth, (int)this.bufferHeight);
            this.bufferG = this.mapBuffer.getGraphics();
        }
    }

    void drawBuffer(Graphics g, int clipX, int clipY, int clipW, int clipH, int x, int y) {
        if (this.mapBuffer != null) {
            g.setClip(x, y, clipW, clipH);
            g.drawImage(this.mapBuffer, x - clipX, y - clipY, 20);
            g.setClip(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
        } else {
            g.setClip(0, 0, SCREEN_WIDTH, SCREEN_HEIGHT);
        }
    }

    void drawMapBuffer(Graphics g, int setOffX, int setOffY) {
        int startX = setOffX / tileWidth;
        int endX = startX + (SCREEN_WIDTH + tileWidth - 1) / tileWidth;
        int startY = setOffY / tileHight;
        int endY = startY + (SCREEN_HEIGHT + tileHight - 1) / tileHight;
        if (this.isBufferNull) {
            this.isBufferNull = false;
            this.updateBuffer(this.bufferG, startX, startY, endX, endY);
            this.lastStartX = startX;
            this.lastStartY = startY;
            this.lastEndX = endX;
            this.lastEndY = endY;
        }
        if (this.lastStartX != startX) {
            int tmp2;
            int tmp1;
            if (this.lastStartX < startX) {
                tmp1 = this.lastEndX + 1;
                tmp2 = endX;
            } else {
                tmp1 = startX;
                tmp2 = this.lastStartX - 1;
            }
            this.updateBuffer(this.bufferG, tmp1, startY, tmp2, endY);
            this.lastStartX = startX;
            this.lastEndX = endX;
        }
        if (this.lastStartY != startY) {
            int tmp4;
            int tmp3;
            if (this.lastStartY < startY) {
                tmp3 = this.lastEndY + 1;
                tmp4 = endY;
            } else {
                tmp3 = startY;
                tmp4 = this.lastStartY - 1;
            }
            this.updateBuffer(this.bufferG, startX, tmp3, endX, tmp4);
            this.lastStartY = startY;
            this.lastEndY = endY;
        }
        int t1 = setOffX % this.bufferWidth;
        int t2 = setOffY % this.bufferHeight;
        int t3 = (setOffX + SCREEN_WIDTH) % this.bufferWidth;
        int t4 = (setOffY + SCREEN_HEIGHT) % this.bufferHeight;
        if (t3 > t1) {
            if (t4 > t2) {
                this.drawBuffer(g, t1, t2, SCREEN_WIDTH, SCREEN_HEIGHT, 0, 0);
            } else {
                this.drawBuffer(g, t1, t2, SCREEN_WIDTH, SCREEN_HEIGHT - t4, 0, 0);
                this.drawBuffer(g, t1, 0, SCREEN_WIDTH, t4, 0, SCREEN_HEIGHT - t4);
            }
        } else if (t4 > t2) {
            this.drawBuffer(g, t1, t2, SCREEN_WIDTH - t3, SCREEN_HEIGHT, 0, 0);
            this.drawBuffer(g, 0, t2, t3, SCREEN_HEIGHT, SCREEN_WIDTH - t3, 0);
        } else {
            this.drawBuffer(g, t1, t2, SCREEN_WIDTH - t3, SCREEN_HEIGHT - t4, 0, 0);
            this.drawBuffer(g, t1, 0, SCREEN_WIDTH - t3, t4, 0, SCREEN_HEIGHT - t4);
            this.drawBuffer(g, 0, t2, t3, SCREEN_HEIGHT - t4, SCREEN_WIDTH - t3, 0);
            this.drawBuffer(g, 0, 0, t3, t4, SCREEN_WIDTH - t3, SCREEN_HEIGHT - t4);
        }
    }

    void updateBuffer(Graphics g, int startX, int startY, int endX, int endY) {
        int y = startY * tileHight % this.bufferHeight;
        int i = startY;
        while (i <= endY) {
            int x = startX * tileWidth % this.bufferWidth;
            int j = startX;
            while (j <= endX) {
                int k = 0;
                while (k < layer) {
                    byte mapIndex = GameMap.inMapData(j * tileWidth, i * tileHight, k);
                    int dataTemp = GameMap.getIndex(mapIndex);
                    int transData = GameMap.getTrans(mapIndex);
                    if ((byte)mapIndex != -1) {
                        g.setClip(x, y, (int)tileWidth, (int)tileHight);
                        Tools.drawClipImage(g, (k + 1) * 300 + dataTemp, x, y, 0, 0, tileWidth, tileHight, 20, transData);
                        g.setClip(0, 0, this.bufferWidth, this.bufferHeight);
                    } else if (k == 0) {
                        g.setClip(x, y, (int)tileWidth, (int)tileHight);
                        g.setColor(0);
                        g.fillRect(x, y, (int)tileWidth, (int)tileHight);
                        g.setClip(0, 0, this.bufferWidth, this.bufferHeight);
                    }
                    ++k;
                }
                if ((x += tileWidth) >= this.bufferWidth) {
                    x -= this.bufferWidth;
                }
                ++j;
            }
            if ((y += tileHight) >= this.bufferHeight) {
                y -= this.bufferHeight;
            }
            ++i;
        }
    }

    static {
        mapSize = new int[2];
    }
}

