/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class EnemyBossEgePlane
extends BasicPlane {
    Sprite hitSprite = null;
    Random rn = new Random();
    private long start1 = 0L;
    private long start2 = 0L;
    private long start3 = 0L;
    private long start4 = 0L;
    private long end = 0L;
    int state = 0;

    public EnemyBossEgePlane(Sprite sprite, int x, int y) {
        try {
            this.sprite = sprite;
            this.x = x;
            this.y = y;
            this.w = sprite.getWidth();
            this.h = sprite.getHeight();
            this.life = 1000;
            this.attach = 2;
            this.dx = 1;
            this.dy = 1;
            this.currentFrame = 0;
            this.endFrame = sprite.getRawFrameCount() - 1;
            this.bulletType = 7;
            this.start2 = System.currentTimeMillis();
            Image img = null;
            try {
                img = Image.createImage((String)"/boss_00.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.hitSprite = new Sprite(img, img.getWidth(), img.getHeight());
        }
        catch (Exception e) {
            Util.debug("EnemyBossEgePlane---------------init die!");
        }
    }

    public int getBossType() {
        return 1;
    }

    public boolean canDestroySelf() {
        return false;
    }

    public boolean canSendBullet() {
        this.end = System.currentTimeMillis();
        if (this.end - this.start1 > 350L) {
            this.start1 = this.end;
            return true;
        }
        return false;
    }

    private void fromUpToDownMove() {
        long timeOver = this.end - this.start2;
        if (timeOver < 5000L) {
            if (this.getLeftTopY() > 5) {
                return;
            }
            this.moveTo(0, this.getDY());
        } else {
            ++this.state;
        }
    }

    private void fromMiddleToLeftMove() {
        long timeOver = this.end - this.start2;
        if (timeOver > 5000L && timeOver < 8000L) {
            if (this.getLeftTopX() < 0) {
                return;
            }
            this.moveTo(-this.getDX(), 0);
        } else {
            ++this.state;
            this.start2 = this.end;
        }
    }

    private void fromLeftToRightMove() {
        long timeOver = this.end - this.start2;
        if (timeOver < 6000L) {
            if (this.getRightBottomX() > Util.screenWidth) {
                return;
            }
            this.moveTo(this.getDX(), 0);
        } else {
            ++this.state;
            this.start2 = this.end;
        }
    }

    private void fromRightToLeftMove() {
        long timeOver = this.end - this.start2;
        if (timeOver < 6000L) {
            if (this.getLeftTopX() < 0) {
                return;
            }
            this.moveTo(-this.getDX(), 0);
        } else {
            --this.state;
            this.start2 = this.end;
        }
    }

    public void move() {
        if (!this.canMove(25L)) {
            return;
        }
        switch (this.state) {
            case 0: {
                this.fromUpToDownMove();
                break;
            }
            case 1: {
                this.fromMiddleToLeftMove();
                break;
            }
            case 2: {
                this.fromLeftToRightMove();
                break;
            }
            case 3: {
                this.fromRightToLeftMove();
            }
        }
    }

    public void setNeedDrawShadow(boolean isNeedDrawShadow) {
        long end = System.currentTimeMillis();
        if (end - this.start4 < 1000L) {
            return;
        }
        this.start4 = end;
        super.setNeedDrawShadow(isNeedDrawShadow);
    }

    public void draw(Graphics g) {
        if (this.getNeedDrawShadow()) {
            if (this.start3 == 0L) {
                this.start3 = System.currentTimeMillis();
            }
            if (System.currentTimeMillis() - this.start3 > 50L) {
                super.setNeedDrawShadow(false);
                this.start3 = 0L;
            }
            this.hitSprite.setPosition(this.getX() - this.hitSprite.getWidth() / 2, this.getY() - this.hitSprite.getHeight() / 2);
            this.hitSprite.paint(g);
        } else {
            this.sprite.setFrame(this.getCurrentFrame());
            this.sprite.setPosition(this.getLeftTopX(), this.getLeftTopY());
            this.sprite.paint(g);
        }
    }
}

